/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.xprocessing;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XType;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import javax.lang.model.SourceVersion;
import javax.lang.model.type.TypeKind;

public final class XProcessingEnvs {
    public static boolean isPreJava8SourceVersion(XProcessingEnv processingEnv) {
        Optional<SourceVersion> javaSourceVersion = XProcessingEnvs.javaSourceVersion(processingEnv);
        return javaSourceVersion.isPresent() && javaSourceVersion.get().compareTo(SourceVersion.RELEASE_8) < 0;
    }

    private static Optional<SourceVersion> javaSourceVersion(XProcessingEnv processingEnv) {
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return Optional.of(XConverters.toJavac(processingEnv).getSourceVersion());
            }
            case KSP: {
                return Optional.empty();
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static boolean javacOverrides(XMethodElement overrider, XMethodElement overridden, XTypeElement type2) {
        XProcessingEnv processingEnv = XConverters.getProcessingEnv(type2);
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toJavac(processingEnv).getElementUtils().overrides(XConverters.toJavac(overrider), XConverters.toJavac(overridden), XConverters.toJavac(type2));
            }
            case KSP: {
                return overrider.overrides(overridden, type2);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static XType getUnboundedWildcardType(XProcessingEnv processingEnv) {
        switch (processingEnv.getBackend()) {
            case JAVAC: {
                return XConverters.toXProcessing(XConverters.toJavac(processingEnv).getTypeUtils().getWildcardType(null, null), processingEnv);
            }
            case KSP: {
                return XConverters.toXProcessing(XConverters.toKS(processingEnv.requireType("java.util.List")).starProjection(), processingEnv).getTypeArguments().get(0);
            }
        }
        throw new AssertionError((Object)("Unexpected backend: " + (Object)((Object)processingEnv.getBackend())));
    }

    public static XType unwrapType(XType type2) {
        XType unwrapped = XProcessingEnvs.unwrapTypeOrDefault(type2, null);
        Preconditions.checkArgument((unwrapped != null ? 1 : 0) != 0, (String)"%s is a raw type", (Object)type2);
        return unwrapped;
    }

    public static XType unwrapTypeOrObject(XType type2, XProcessingEnv processingEnv) {
        return XProcessingEnvs.unwrapTypeOrDefault(type2, processingEnv.requireType((TypeName)TypeName.OBJECT));
    }

    private static XType unwrapTypeOrDefault(XType type2, XType defaultType) {
        XTypeElement typeElement2 = type2.getTypeElement();
        Preconditions.checkArgument((!typeElement2.getType().getTypeArguments().isEmpty() ? 1 : 0) != 0, (String)"%s does not have a type parameter", (Object)typeElement2.getQualifiedName());
        return (XType)Iterables.getOnlyElement(type2.getTypeArguments(), (Object)defaultType);
    }

    public static XType rewrapType(XType type2, ClassName wrappingClassName, XProcessingEnv processingEnv) {
        XTypeElement wrappingType = processingEnv.requireTypeElement(wrappingClassName.canonicalName());
        switch (type2.getTypeArguments().size()) {
            case 0: {
                return processingEnv.getDeclaredType(wrappingType, new XType[0]);
            }
            case 1: {
                return processingEnv.getDeclaredType(wrappingType, (XType)Iterables.getOnlyElement(type2.getTypeArguments()));
            }
        }
        throw new IllegalArgumentException(type2 + " has more than 1 type argument");
    }

    public static XType erasure(XType type2, XProcessingEnv processingEnv) {
        return XConverters.toXProcessing(XConverters.toJavac(processingEnv).getTypeUtils().erasure(XConverters.toJavac(type2)), processingEnv);
    }

    public static XType getPrimitiveIntType(XProcessingEnv processingEnv) {
        return XConverters.toXProcessing(XConverters.toJavac(processingEnv).getTypeUtils().getPrimitiveType(TypeKind.INT), processingEnv);
    }

    public static XType wrapType(ClassName wrapper, XType type2, XProcessingEnv processingEnv) {
        return processingEnv.getDeclaredType(processingEnv.requireTypeElement((TypeName)wrapper), type2);
    }

    private XProcessingEnvs() {
    }
}

