/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal.codegen.extension;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class DaggerStreams {
    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf);
    }

    public static <T> Collector<T, ?, ImmutableSet<T>> toImmutableSet() {
        return Collectors.collectingAndThen(Collectors.toList(), ImmutableSet::copyOf);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, K> keyMapper, Function<? super T, V> valueMapper) {
        return Collectors.mapping(value2 -> Maps.immutableEntry(keyMapper.apply(value2), valueMapper.apply(value2)), Collector.of(ImmutableMap::builder, (builder, entry) -> builder.put(entry), (left, right) -> left.putAll((Map)right.build()), ImmutableMap.Builder::build, new Collector.Characteristics[0]));
    }

    public static <T, K, V> Collector<T, ?, ImmutableSetMultimap<K, V>> toImmutableSetMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collectors.mapping(value2 -> Maps.immutableEntry(keyMapper.apply(value2), valueMapper.apply(value2)), Collector.of(ImmutableSetMultimap::builder, (builder, entry) -> builder.put(entry), (left, right) -> left.putAll((Multimap)right.build()), ImmutableSetMultimap.Builder::build, new Collector.Characteristics[0]));
    }

    public static <T> Function<Object, Stream<T>> instancesOf(Class<T> to) {
        return f -> to.isInstance(f) ? Stream.of(to.cast(f)) : Stream.empty();
    }

    public static <E extends Enum<E>> Stream<E> valuesOf(Class<E> enumType) {
        return EnumSet.allOf(enumType).stream();
    }

    public static <T> Function<Optional<T>, Stream<T>> presentValues() {
        return optional -> optional.map(Stream::of).orElse(Stream.empty());
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return iterable instanceof Collection ? ((Collection)iterable).stream() : StreamSupport.stream(iterable.spliterator(), false);
    }

    private DaggerStreams() {
    }
}

