/*
 * Decompiled with CFR 0.152.
 */
package dagger.model;

import com.google.auto.value.AutoValue;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.squareup.javapoet.ClassName;
import dagger.model.AutoValue_Scope;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.auto.common.MoreTypes;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class Scope {
    private static final ClassName PRODUCTION_SCOPE = ClassName.get((String)"dagger.producers", (String)"ProductionScope", (String[])new String[0]);
    private static final ClassName SINGLETON = ClassName.get((String)"jakarta.inject", (String)"Singleton", (String[])new String[0]);
    private static final ClassName SINGLETON_JAVAX = ClassName.get((String)"javax.inject", (String)"Singleton", (String[])new String[0]);
    private static final ClassName REUSABLE = ClassName.get((String)"dagger", (String)"Reusable", (String[])new String[0]);
    private static final ClassName SCOPE = ClassName.get((String)"jakarta.inject", (String)"Scope", (String[])new String[0]);
    private static final ClassName SCOPE_JAVAX = ClassName.get((String)"javax.inject", (String)"Scope", (String[])new String[0]);

    abstract Equivalence.Wrapper<AnnotationMirror> wrappedScopeAnnotation();

    public final AnnotationMirror scopeAnnotation() {
        return (AnnotationMirror)this.wrappedScopeAnnotation().get();
    }

    public final TypeElement scopeAnnotationElement() {
        return MoreTypes.asTypeElement(this.scopeAnnotation().getAnnotationType());
    }

    public static Scope scope(AnnotationMirror scopeAnnotation) {
        Preconditions.checkArgument((boolean)Scope.isScope(scopeAnnotation));
        return new AutoValue_Scope((Equivalence.Wrapper<AnnotationMirror>)AnnotationMirrors.equivalence().wrap((Object)scopeAnnotation));
    }

    public static boolean isScope(AnnotationMirror scopeAnnotation) {
        return Scope.isScope(MoreElements.asType(scopeAnnotation.getAnnotationType().asElement()));
    }

    public static boolean isScope(TypeElement scopeAnnotationType) {
        return MoreElements.isAnnotationPresent((Element)scopeAnnotationType, SCOPE.canonicalName()) || MoreElements.isAnnotationPresent((Element)scopeAnnotationType, SCOPE_JAVAX.canonicalName());
    }

    public final boolean isSingleton() {
        return this.isScope(SINGLETON) || this.isScope(SINGLETON_JAVAX);
    }

    public final boolean isReusable() {
        return this.isScope(REUSABLE);
    }

    public final boolean isProductionScope() {
        return this.isScope(PRODUCTION_SCOPE);
    }

    private boolean isScope(ClassName className2) {
        return this.scopeAnnotationElement().getQualifiedName().contentEquals(className2.canonicalName());
    }

    public final String toString() {
        return this.scopeAnnotation().toString();
    }
}

