/*
 * Decompiled with CFR 0.152.
 */
package dagger.spi.model;

import com.google.auto.value.AutoValue;
import com.google.devtools.ksp.symbol.KSClassDeclaration;
import com.google.devtools.ksp.symbol.KSDeclaration;
import dagger.spi.model.AutoValue_DaggerTypeElement;
import dagger.spi.model.DaggerProcessingEnv;
import dagger.spi.model.KspUtilsKt;
import dagger.spi.shaded.auto.common.MoreElements;
import javax.annotation.Nullable;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoValue
public abstract class DaggerTypeElement {
    public static DaggerTypeElement fromJavac(@Nullable TypeElement element) {
        return new AutoValue_DaggerTypeElement(element, null);
    }

    public static DaggerTypeElement fromKsp(@Nullable KSClassDeclaration declaration) {
        return new AutoValue_DaggerTypeElement(null, declaration);
    }

    @Nullable
    public abstract TypeElement java();

    @Nullable
    public abstract KSClassDeclaration ksp();

    public final boolean hasAnnotation(String annotationName) {
        switch (this.backend()) {
            case JAVAC: {
                return MoreElements.isAnnotationPresent((Element)this.java(), annotationName);
            }
            case KSP: {
                return KspUtilsKt.hasAnnotation(this.ksp(), annotationName);
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", new Object[]{this.backend()}));
    }

    public String packageName() {
        switch (this.backend()) {
            case JAVAC: {
                return MoreElements.getPackage(this.java()).getQualifiedName().toString();
            }
            case KSP: {
                return KspUtilsKt.getNormalizedPackageName((KSDeclaration)this.ksp());
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", new Object[]{this.backend()}));
    }

    public String qualifiedName() {
        switch (this.backend()) {
            case JAVAC: {
                return this.java().getQualifiedName().toString();
            }
            case KSP: {
                return this.ksp().getQualifiedName().asString();
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", new Object[]{this.backend()}));
    }

    public DaggerProcessingEnv.Backend backend() {
        if (this.java() != null) {
            return DaggerProcessingEnv.Backend.JAVAC;
        }
        if (this.ksp() != null) {
            return DaggerProcessingEnv.Backend.KSP;
        }
        throw new AssertionError((Object)"Unexpected backend");
    }

    public final String toString() {
        switch (this.backend()) {
            case JAVAC: {
                return this.java().toString();
            }
            case KSP: {
                return this.ksp().toString();
            }
        }
        throw new IllegalStateException(String.format("Backend %s not supported yet.", new Object[]{this.backend()}));
    }
}

