/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerCollectors;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;

final class Generators {
    static void addGeneratedBaseClassJavadoc(TypeSpec.Builder builder, ClassName annotation) {
        builder.addJavadoc("A generated base class to be extended by the @$T annotated class. If using the Gradle plugin, this is swapped as the base class via bytecode transformation.", new Object[]{annotation});
    }

    static void copyConstructors(TypeElement baseClass, TypeSpec.Builder builder) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(baseClass.getEnclosedElements()).stream().filter(constructor -> !constructor.getModifiers().contains((Object)Modifier.PRIVATE)).collect(Collectors.toList());
        if (constructors.size() == 1 && ((ExecutableElement)Iterables.getOnlyElement(constructors)).getParameters().isEmpty()) {
            return;
        }
        constructors.forEach(constructor -> builder.addMethod(Generators.copyConstructor(constructor)));
    }

    private static Optional<AnnotationSpec> getNullableAnnotationSpec(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals("Nullable")) continue;
            AnnotationSpec annotationSpec = AnnotationSpec.get((AnnotationMirror)annotationMirror);
            return AndroidClassNames.NULLABLE_INTERNAL.equals((Object)annotationSpec.type) ? Optional.of(AnnotationSpec.builder((ClassName)AndroidClassNames.NULLABLE).build()) : Optional.of(annotationSpec);
        }
        return Optional.empty();
    }

    private static ParameterSpec getParameterSpecWithNullable(VariableElement parameter) {
        ParameterSpec.Builder builder = ParameterSpec.get((VariableElement)parameter).toBuilder();
        Generators.getNullableAnnotationSpec(parameter).ifPresent(arg_0 -> ((ParameterSpec.Builder)builder).addAnnotation(arg_0));
        return builder.build();
    }

    static MethodSpec copyConstructor(ExecutableElement constructor) {
        List params = constructor.getParameters().stream().map(parameter -> Generators.getParameterSpecWithNullable(parameter)).collect(Collectors.toList());
        MethodSpec.Builder builder = MethodSpec.constructorBuilder().addParameters(params).addStatement("super($L)", new Object[]{params.stream().map(param -> param.name).collect(Collectors.joining(", "))});
        ((Optional)constructor.getAnnotationMirrors().stream().filter(a -> Processors.hasAnnotation(a, AndroidClassNames.TARGET_API)).collect(DaggerCollectors.toOptional())).map(AnnotationSpec::get).ifPresent(arg_0 -> ((MethodSpec.Builder)builder).addAnnotation(arg_0));
        return builder.build();
    }

    static void copyLintAnnotations(Element element, TypeSpec.Builder builder) {
        if (Processors.hasAnnotation(element, AndroidClassNames.TARGET_API)) {
            builder.addAnnotation(AnnotationSpec.get((AnnotationMirror)Processors.getAnnotationMirror(element, AndroidClassNames.TARGET_API)));
        }
    }

    static void addComponentOverride(AndroidEntryPointMetadata metadata, TypeSpec.Builder builder) {
        if (metadata.overridesAndroidEntryPointClass()) {
            return;
        }
        builder.addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)ClassNames.COMPONENT_MANAGER, (TypeName[])new TypeName[]{TypeName.OBJECT})).addMethod(MethodSpec.methodBuilder((String)"generatedComponent").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).returns((TypeName)TypeName.OBJECT).addStatement("return componentManager().generatedComponent()", new Object[0]).build());
    }

    static void addInjectionMethods(AndroidEntryPointMetadata metadata, TypeSpec.Builder builder) {
        switch (metadata.androidType()) {
            case ACTIVITY: 
            case FRAGMENT: 
            case VIEW: 
            case SERVICE: {
                Generators.addComponentManagerMethods(metadata, builder);
            }
            case BROADCAST_RECEIVER: {
                Generators.addInjectMethod(metadata, builder);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private static void addComponentManagerMethods(AndroidEntryPointMetadata metadata, TypeSpec.Builder typeSpecBuilder) {
        if (metadata.overridesAndroidEntryPointClass()) {
            return;
        }
        ParameterSpec managerParam = metadata.componentManagerParam();
        typeSpecBuilder.addField(Generators.componentManagerField(metadata));
        typeSpecBuilder.addMethod(Generators.createComponentManagerMethod(metadata));
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"componentManager").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.FINAL}).returns(managerParam.type).beginControlFlow("if ($N == null)", new Object[]{managerParam});
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            typeSpecBuilder.addField(Generators.componentManagerLockField());
            methodSpecBuilder.beginControlFlow("synchronized (componentManagerLock)", new Object[0]).beginControlFlow("if ($N == null)", new Object[]{managerParam});
        }
        methodSpecBuilder.addStatement("$N = createComponentManager()", new Object[]{managerParam}).endControlFlow();
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            methodSpecBuilder.endControlFlow().endControlFlow();
        }
        methodSpecBuilder.addStatement("return $N", new Object[]{managerParam});
        typeSpecBuilder.addMethod(methodSpecBuilder.build());
    }

    private static MethodSpec createComponentManagerMethod(AndroidEntryPointMetadata metadata) {
        Preconditions.checkState((boolean)metadata.componentManagerInitArgs().isPresent(), (Object)"This method should not have been called for metadata where the init args are not present.");
        return MethodSpec.methodBuilder((String)"createComponentManager").addModifiers(new Modifier[]{Modifier.PROTECTED}).returns(metadata.componentManager()).addStatement("return new $T($L)", new Object[]{metadata.componentManager(), metadata.componentManagerInitArgs().get()}).build();
    }

    private static FieldSpec componentManagerField(AndroidEntryPointMetadata metadata) {
        ParameterSpec managerParam = metadata.componentManagerParam();
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)managerParam.type, (String)managerParam.name, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            builder.addModifiers(new Modifier[]{Modifier.VOLATILE});
        }
        return builder.build();
    }

    private static FieldSpec componentManagerLockField() {
        return FieldSpec.builder((TypeName)TypeName.get(Object.class), (String)"componentManagerLock", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new Object()", new Object[0]).build();
    }

    private static void addInjectMethod(AndroidEntryPointMetadata metadata, TypeSpec.Builder typeSpecBuilder) {
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"inject").addModifiers(new Modifier[]{Modifier.PROTECTED});
        if (metadata.allowsOptionalInjection()) {
            methodSpecBuilder.addStatement("$T parent = $L", new Object[]{ClassNames.OBJECT, Generators.getParentCodeBlock(metadata)}).beginControlFlow("if (!(parent instanceof $T) || ((parent instanceof $T) && !(($T) parent).wasInjectedByHilt()))", new Object[]{ClassNames.COMPONENT_MANAGER, AndroidClassNames.INJECTED_BY_HILT, AndroidClassNames.INJECTED_BY_HILT}).addStatement("return", new Object[0]).endControlFlow();
        }
        switch (metadata.androidType()) {
            case ACTIVITY: 
            case FRAGMENT: 
            case VIEW: 
            case SERVICE: {
                if (metadata.overridesAndroidEntryPointClass()) {
                    typeSpecBuilder.addField(Generators.injectedField(metadata));
                    methodSpecBuilder.addAnnotation(Override.class).beginControlFlow("if (!injected)", new Object[0]).addStatement("injected = true", new Object[0]);
                } else if (metadata.allowsOptionalInjection()) {
                    typeSpecBuilder.addField(Generators.injectedField(metadata));
                    methodSpecBuilder.addStatement("injected = true", new Object[0]);
                }
                methodSpecBuilder.addStatement("(($T) generatedComponent()).$L($T.<$T>unsafeCast(this))", new Object[]{metadata.injectorClassName(), metadata.injectMethodName(), ClassNames.UNSAFE_CASTS, metadata.elementClassName()});
                if (!metadata.overridesAndroidEntryPointClass()) break;
                methodSpecBuilder.endControlFlow();
                break;
            }
            case BROADCAST_RECEIVER: {
                typeSpecBuilder.addField(Generators.injectedLockField());
                typeSpecBuilder.addField(Generators.injectedField(metadata));
                methodSpecBuilder.addParameter(ParameterSpec.builder((TypeName)AndroidClassNames.CONTEXT, (String)"context", (Modifier[])new Modifier[0]).build()).beginControlFlow("if (!injected)", new Object[0]).beginControlFlow("synchronized (injectedLock)", new Object[0]).beginControlFlow("if (!injected)", new Object[0]).addStatement("(($T) $T.generatedComponent(context)).$L($T.<$T>unsafeCast(this))", new Object[]{metadata.injectorClassName(), metadata.componentManager(), metadata.injectMethodName(), ClassNames.UNSAFE_CASTS, metadata.elementClassName()}).addStatement("injected = true", new Object[0]).endControlFlow().endControlFlow().endControlFlow();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        if (metadata.allowsOptionalInjection() || metadata.baseAllowsOptionalInjection()) {
            typeSpecBuilder.addMethod(MethodSpec.methodBuilder((String)"wasInjectedByHilt").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(Boolean.TYPE).addStatement("return injected", new Object[0]).build());
            if (metadata.allowsOptionalInjection()) {
                typeSpecBuilder.addSuperinterface((TypeName)AndroidClassNames.INJECTED_BY_HILT);
            }
        }
        typeSpecBuilder.addMethod(methodSpecBuilder.build());
    }

    private static CodeBlock getParentCodeBlock(AndroidEntryPointMetadata metadata) {
        switch (metadata.androidType()) {
            case ACTIVITY: 
            case SERVICE: {
                return CodeBlock.of((String)"getApplicationContext()", (Object[])new Object[0]);
            }
            case FRAGMENT: {
                return CodeBlock.of((String)"getHost()", (Object[])new Object[0]);
            }
            case VIEW: {
                return CodeBlock.of((String)"componentManager().maybeGetParentComponentManager()", (Object[])new Object[]{metadata.componentManagerParam()});
            }
            case BROADCAST_RECEIVER: {
                return CodeBlock.of((String)"context.getApplicationContext()", (Object[])new Object[0]);
            }
        }
        throw new AssertionError();
    }

    private static FieldSpec injectedField(AndroidEntryPointMetadata metadata) {
        FieldSpec.Builder builder = FieldSpec.builder((TypeName)TypeName.BOOLEAN, (String)"injected", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE});
        if (metadata.androidType() == AndroidEntryPointMetadata.AndroidType.BROADCAST_RECEIVER) {
            builder.addModifiers(new Modifier[]{Modifier.VOLATILE});
        }
        if (metadata.androidType() != AndroidEntryPointMetadata.AndroidType.VIEW) {
            builder.initializer("false", new Object[0]);
        }
        return builder.build();
    }

    private static FieldSpec injectedLockField() {
        return FieldSpec.builder((TypeName)TypeName.OBJECT, (String)"injectedLock", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T()", new Object[]{TypeName.OBJECT}).build();
    }

    private Generators() {
    }
}

