/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.testroot;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;

public final class InternalTestRootGenerator {
    private final ProcessingEnvironment processingEnv;
    private final TypeElement testElement;
    private final ClassName testName;
    private final ClassName baseApplicationName;
    private final ClassName rootName;

    public InternalTestRootGenerator(ProcessingEnvironment processingEnv, TypeElement testElement, ClassName baseApplicationName) {
        this.processingEnv = processingEnv;
        this.testElement = testElement;
        this.testName = ClassName.get((TypeElement)testElement);
        this.baseApplicationName = baseApplicationName;
        this.rootName = Processors.append(this.testName, "_Root");
    }

    public void generate() throws IOException {
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)this.rootName).addOriginatingElement((Element)this.testElement).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.INTERNAL_TEST_ROOT).addMember("testClass", "$T.class", new Object[]{this.testName}).addMember("applicationBaseClass", "$T.class", new Object[]{this.baseApplicationName}).build());
        Processors.addGeneratedAnnotation(builder, this.processingEnv, this.getClass());
        JavaFile.builder((String)this.rootName.packageName(), (TypeSpec)builder.build()).build().writeTo(this.processingEnv.getFiler());
    }
}

