/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.AnnotationValueVisitor;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleAnnotationValueVisitor8;

public final class AnnotationValues {
    private static final AnnotationValueVisitor<ImmutableList<AnnotationValue>, String> AS_ANNOTATION_VALUES = new SimpleAnnotationValueVisitor8<ImmutableList<AnnotationValue>, String>(){

        @Override
        public ImmutableList<AnnotationValue> visitArray(List<? extends AnnotationValue> vals, String elementName) {
            return ImmutableList.copyOf(vals);
        }

        @Override
        protected ImmutableList<AnnotationValue> defaultAction(Object o, String elementName) {
            throw new IllegalArgumentException(elementName + " is not an array: " + o);
        }
    };

    private AnnotationValues() {
    }

    public static DeclaredType getTypeMirror(AnnotationValue value) {
        return (DeclaredType)TypeMirrorVisitor.INSTANCE.visit(value);
    }

    public static VariableElement getEnum(AnnotationValue value) {
        return (VariableElement)EnumVisitor.INSTANCE.visit(value);
    }

    public static String getString(AnnotationValue value) {
        return AnnotationValues.valueOfType(value, String.class);
    }

    private static <T> T valueOfType(AnnotationValue annotationValue, Class<T> type) {
        Object value = annotationValue.getValue();
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException("Expected " + type.getSimpleName() + ", got instead: " + value);
        }
        return type.cast(value);
    }

    public static int getIntValue(AnnotationMirror annotation, String valueName) {
        return (Integer)AnnotationMirrors.getAnnotationValue(annotation, valueName).getValue();
    }

    public static Optional<Integer> getOptionalIntValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.isValuePresent(annotation, valueName) ? Optional.of(AnnotationValues.getIntValue(annotation, valueName)) : Optional.empty();
    }

    public static String getStringValue(AnnotationMirror annotation, String valueName) {
        return (String)AnnotationMirrors.getAnnotationValue(annotation, valueName).getValue();
    }

    public static Optional<String> getOptionalStringValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.isValuePresent(annotation, valueName) ? Optional.of(AnnotationValues.getStringValue(annotation, valueName)) : Optional.empty();
    }

    public static int[] getIntArrayValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().mapToInt(it -> (Integer)it.getValue()).toArray();
    }

    public static String[] getStringArrayValue(AnnotationMirror annotation, String valueName) {
        return (String[])AnnotationValues.asAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().map(it -> (String)it.getValue()).toArray(String[]::new);
    }

    private static boolean isValuePresent(AnnotationMirror annotation, String valueName) {
        return AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).keySet().stream().anyMatch(member -> member.getSimpleName().contentEquals(valueName));
    }

    private static ImmutableList<AnnotationValue> asAnnotationValues(AnnotationValue annotationValue) {
        return annotationValue.accept(AS_ANNOTATION_VALUES, null);
    }

    private static final class EnumVisitor
    extends DefaultVisitor<VariableElement> {
        static final EnumVisitor INSTANCE = new EnumVisitor();

        EnumVisitor() {
            super(VariableElement.class);
        }

        @Override
        public VariableElement visitEnumConstant(VariableElement value, Void unused) {
            return value;
        }
    }

    private static final class TypeMirrorVisitor
    extends DefaultVisitor<DeclaredType> {
        static final TypeMirrorVisitor INSTANCE = new TypeMirrorVisitor();

        TypeMirrorVisitor() {
            super(DeclaredType.class);
        }

        @Override
        public DeclaredType visitType(TypeMirror value, Void unused) {
            return MoreTypes.asDeclared(value);
        }
    }

    private static class DefaultVisitor<T>
    extends SimpleAnnotationValueVisitor8<T, Void> {
        final Class<T> clazz;

        DefaultVisitor(Class<T> clazz) {
            this.clazz = (Class)Preconditions.checkNotNull(clazz);
        }

        @Override
        public T defaultAction(Object o, Void unused) {
            throw new IllegalArgumentException("Expected a " + this.clazz.getSimpleName() + ", got instead: " + o);
        }
    }
}

