/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.DefineComponents;
import dagger.internal.codegen.extension.DaggerStreams;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class Components {
    public static ImmutableSet<ComponentDescriptor> getComponentDescriptors(Elements elements, Element element) {
        if (!Processors.hasAnnotation(element, ClassNames.INSTALL_IN)) {
            if (Processors.hasErrorTypeAnnotation(element)) {
                throw new BadInputException("Error annotation found on element " + element + ". Look above for compilation errors", element);
            }
            throw new BadInputException(String.format("An @InstallIn annotation is required for: %s.", element), element);
        }
        ImmutableSet<ComponentDescriptor> componentDescriptors = Components.getInstallInComponentDescriptors(elements, element);
        return componentDescriptors;
    }

    public static AnnotationSpec getInstallInAnnotationSpec(ImmutableSet<ClassName> components) {
        Preconditions.checkArgument((!components.isEmpty() ? 1 : 0) != 0);
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassNames.INSTALL_IN);
        components.forEach(component -> builder.addMember("value", "$T.class", new Object[]{component}));
        return builder.build();
    }

    private static ImmutableSet<ComponentDescriptor> getInstallInComponentDescriptors(Elements elements, Element element) {
        AnnotationMirror hiltInstallIn = Processors.getAnnotationMirror(element, ClassNames.INSTALL_IN);
        ImmutableList<TypeElement> generatedComponents = Processors.getAnnotationClassValues(elements, hiltInstallIn, "value");
        return (ImmutableSet)generatedComponents.stream().map(DefineComponents::componentDescriptor).collect(DaggerStreams.toImmutableSet());
    }

    private Components() {
    }
}

