/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Throwables;
import dagger.hilt.processor.internal.AutoValue_ProcessorErrorHandler_HiltError;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ErrorTypeException;
import dagger.shaded.auto.common.MoreElements;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

final class ProcessorErrorHandler {
    private static final String FAILURE_PREFIX = "[Hilt]\n";
    private static final String FAILURE_SUFFIX = "\n\u001b[1;31m[Hilt] Processing did not complete. See error above for details.\u001b[0m";
    private final Messager messager;
    private final Elements elements;
    private final List<HiltError> hiltErrors;

    ProcessorErrorHandler(ProcessingEnvironment env) {
        this.messager = env.getMessager();
        this.elements = env.getElementUtils();
        this.hiltErrors = new ArrayList<HiltError>();
    }

    void recordError(Throwable t) {
        if (t instanceof BadInputException) {
            BadInputException badInput = (BadInputException)t;
            for (Element element : badInput.getBadElements()) {
                this.hiltErrors.add(HiltError.of(badInput.getMessage(), element));
            }
        } else if (t instanceof ErrorTypeException) {
            ErrorTypeException badInput = (ErrorTypeException)t;
            this.hiltErrors.add(HiltError.of(badInput.getMessage(), badInput.getBadElement()));
        } else if (t.getMessage() != null) {
            this.hiltErrors.add(HiltError.of(t.getMessage() + ": " + Throwables.getStackTraceAsString((Throwable)t)));
        } else {
            this.hiltErrors.add(HiltError.of(t.getClass() + ": " + Throwables.getStackTraceAsString((Throwable)t)));
        }
    }

    void checkErrors() {
        if (!this.hiltErrors.isEmpty()) {
            this.hiltErrors.forEach(hiltError -> {
                if (hiltError.element().isPresent()) {
                    Element element = hiltError.element().get();
                    if (MoreElements.isType(element)) {
                        element = this.elements.getTypeElement(MoreElements.asType(element).getQualifiedName().toString());
                    }
                    this.messager.printMessage(Diagnostic.Kind.ERROR, hiltError.message(), element);
                } else {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, hiltError.message());
                }
            });
            this.hiltErrors.clear();
        }
    }

    @AutoValue
    static abstract class HiltError {
        HiltError() {
        }

        static HiltError of(String message) {
            return HiltError.of(message, Optional.empty());
        }

        static HiltError of(String message, Element element) {
            return HiltError.of(message, Optional.of(element));
        }

        private static HiltError of(String message, Optional<Element> element) {
            return new AutoValue_ProcessorErrorHandler_HiltError(ProcessorErrorHandler.FAILURE_PREFIX + message + ProcessorErrorHandler.FAILURE_SUFFIX, element);
        }

        abstract String message();

        abstract Optional<Element> element();
    }
}

