/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.value.AutoValue;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.AutoValue_DefineComponentBuilderMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponentMetadata;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.List;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;

@AutoValue
abstract class DefineComponentBuilderMetadata {
    DefineComponentBuilderMetadata() {
    }

    static DefineComponentBuilderMetadata from(Element element) {
        ProcessorErrors.checkState(Processors.hasAnnotation(element, ClassNames.DEFINE_COMPONENT_BUILDER), element, "%s, expected to be annotated with @DefineComponent.Builder. Found: %s", element, element.getAnnotationMirrors());
        ProcessorErrors.checkState(element.getKind().equals((Object)ElementKind.INTERFACE), element, "@DefineComponent.Builder is only allowed on interfaces. Found: %s", element);
        TypeElement builder = MoreElements.asType(element);
        ProcessorErrors.checkState(builder.getInterfaces().isEmpty(), builder, "@DefineComponent.Builder %s, cannot extend a super class or interface. Found: %s", builder, builder.getInterfaces());
        ProcessorErrors.checkState(builder.getTypeParameters().isEmpty(), builder, "@DefineComponent.Builder %s, cannot have type parameters.", builder.asType());
        List nonStaticFields = ElementFilter.fieldsIn(builder.getEnclosedElements()).stream().filter(method -> !method.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
        ProcessorErrors.checkState(nonStaticFields.isEmpty(), builder, "@DefineComponent.Builder %s, cannot have non-static fields. Found: %s", builder, nonStaticFields);
        List buildMethods = ElementFilter.methodsIn(builder.getEnclosedElements()).stream().filter(method -> !method.getModifiers().contains((Object)Modifier.STATIC)).filter(method -> method.getParameters().isEmpty()).collect(Collectors.toList());
        ProcessorErrors.checkState(buildMethods.size() == 1, builder, "@DefineComponent.Builder %s, must have exactly 1 build method that takes no parameters. Found: %s", builder, buildMethods);
        ExecutableElement buildMethod = (ExecutableElement)buildMethods.get(0);
        TypeMirror component = buildMethod.getReturnType();
        ProcessorErrors.checkState(buildMethod.getReturnType().getKind().equals((Object)TypeKind.DECLARED) && Processors.hasAnnotation((Element)MoreTypes.asTypeElement(component), ClassNames.DEFINE_COMPONENT), builder, "@DefineComponent.Builder method, %s#%s, must return a @DefineComponent type. Found: %s", builder, buildMethod, component);
        List nonStaticNonBuilderMethods = ElementFilter.methodsIn(builder.getEnclosedElements()).stream().filter(method -> !method.getModifiers().contains((Object)Modifier.STATIC)).filter(method -> !method.equals(buildMethod)).filter(method -> !TypeName.get((TypeMirror)method.getReturnType()).equals((Object)ClassName.get((TypeElement)builder))).collect(Collectors.toList());
        ProcessorErrors.checkState(nonStaticNonBuilderMethods.isEmpty(), nonStaticNonBuilderMethods, "@DefineComponent.Builder %s, all non-static methods must return %s or %s. Found: %s", builder, builder, component, nonStaticNonBuilderMethods);
        return new AutoValue_DefineComponentBuilderMetadata(builder, buildMethod, DefineComponentMetadata.from(MoreTypes.asTypeElement(component)));
    }

    abstract TypeElement builder();

    abstract ExecutableElement buildMethod();

    abstract DefineComponentMetadata componentMetadata();
}

