/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.AutoValue_DefineComponentMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import dagger.shaded.auto.common.MoreTypes;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

@AutoValue
abstract class DefineComponentMetadata {
    private static final Map<Element, DefineComponentMetadata> processed = new HashMap<Element, DefineComponentMetadata>();

    DefineComponentMetadata() {
    }

    static DefineComponentMetadata from(Element element) {
        return DefineComponentMetadata.from(element, new LinkedHashSet<Element>());
    }

    private static DefineComponentMetadata from(Element element, LinkedHashSet<Element> childPath) {
        if (!processed.containsKey(element)) {
            processed.put(element, DefineComponentMetadata.fromUncached(element, childPath));
        }
        return processed.get(element);
    }

    private static DefineComponentMetadata fromUncached(Element element, LinkedHashSet<Element> childPath) {
        ProcessorErrors.checkState(childPath.add(element), element, "@DefineComponent cycle: %s -> %s", childPath.stream().map(Object::toString).collect(Collectors.joining(" -> ")), element);
        ProcessorErrors.checkState(Processors.hasAnnotation(element, ClassNames.DEFINE_COMPONENT), element, "%s, expected to be annotated with @DefineComponent. Found: %s", element, element.getAnnotationMirrors());
        ProcessorErrors.checkState(element.getKind().equals((Object)ElementKind.INTERFACE), element, "@DefineComponent is only allowed on interfaces. Found: %s", element);
        TypeElement component = MoreElements.asType(element);
        ProcessorErrors.checkState(component.getInterfaces().isEmpty(), component, "@DefineComponent %s, cannot extend a super class or interface. Found: %s", component, component.getInterfaces());
        ProcessorErrors.checkState(component.getTypeParameters().isEmpty(), component, "@DefineComponent %s, cannot have type parameters.", component.asType());
        List nonStaticMethods = ElementFilter.methodsIn(component.getEnclosedElements()).stream().filter(method -> !method.getModifiers().contains((Object)Modifier.STATIC)).collect(Collectors.toList());
        ProcessorErrors.checkState(nonStaticMethods.isEmpty(), component, "@DefineComponent %s, cannot have non-static methods. Found: %s", component, nonStaticMethods);
        ImmutableList scopes = (ImmutableList)Processors.getScopeAnnotations(component).stream().map(AnnotationMirror::getAnnotationType).map(MoreTypes::asTypeElement).collect(DaggerStreams.toImmutableList());
        ImmutableList<AnnotationMirror> aliasScopes = Processors.getAnnotationsAnnotatedWith(component, ClassNames.ALIAS_OF);
        ProcessorErrors.checkState(aliasScopes.isEmpty(), component, "@DefineComponent %s, references invalid scope(s) annotated with @AliasOf. @DefineComponent scopes cannot be aliases of other scopes: %s", component, aliasScopes);
        AnnotationMirror mirror = Processors.getAnnotationMirror((Element)component, ClassNames.DEFINE_COMPONENT);
        AnnotationValue parentValue = AnnotationMirrors.getAnnotationElementAndValue(mirror, "parent").getValue();
        ProcessorErrors.checkState(!"<error>".contentEquals(parentValue.getValue().toString()), component, "@DefineComponent %s, references an invalid type: %s", component, mirror);
        TypeElement parent = MoreTypes.asTypeElement(AnnotationValues.getTypeMirror(parentValue));
        Optional<DefineComponentMetadata> parentComponent = ClassName.get((TypeElement)parent).equals((Object)ClassNames.DEFINE_COMPONENT_NO_PARENT) ? Optional.empty() : Optional.of(DefineComponentMetadata.from(parent, childPath));
        ProcessorErrors.checkState(parentComponent.isPresent() || ClassName.get((TypeElement)component).equals((Object)ClassNames.APPLICATION_COMPONENT), component, "@DefineComponent %s is missing a parent declaration.\nPlease declare the parent, for example: @DefineComponent(parent = ApplicationComponent.class)", component);
        return new AutoValue_DefineComponentMetadata(component, (ImmutableList<TypeElement>)scopes, parentComponent);
    }

    abstract TypeElement component();

    abstract ImmutableList<TypeElement> scopes();

    abstract Optional<DefineComponentMetadata> parentMetadata();

    boolean isRoot() {
        return !this.parentMetadata().isPresent();
    }
}

