/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ListMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.AutoValue_DefineComponents_AggregatedMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponentBuilderMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponentMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.shaded.auto.common.AnnotationMirrors;
import dagger.shaded.auto.common.MoreElements;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class DefineComponents {
    static final String AGGREGATING_PACKAGE = DefineComponents.class.getPackage().getName() + ".codegen";

    public static ComponentDescriptor componentDescriptor(Element element) {
        DefineComponentMetadata metadata = DefineComponentMetadata.from(element);
        ComponentDescriptor.Builder builder = ComponentDescriptor.builder().component(ClassName.get((TypeElement)metadata.component())).scopes((ImmutableSet<ClassName>)((ImmutableSet)metadata.scopes().stream().map(ClassName::get).collect(DaggerStreams.toImmutableSet())));
        metadata.parentMetadata().map(DefineComponentMetadata::component).map(DefineComponents::componentDescriptor).ifPresent(builder::parent);
        return builder.build();
    }

    public static ImmutableList<ComponentDescriptor> componentDescriptors(Elements elements) {
        AggregatedMetadata aggregatedMetadata = AggregatedMetadata.from(elements);
        ArrayListMultimap builderMultimap = ArrayListMultimap.create();
        aggregatedMetadata.builders().forEach(arg_0 -> DefineComponents.lambda$componentDescriptors$0((ListMultimap)builderMultimap, arg_0));
        for (DefineComponentMetadata componentMetadata2 : builderMultimap.keySet()) {
            TypeElement component = componentMetadata2.component();
            ProcessorErrors.checkState(builderMultimap.get((Object)componentMetadata2).size() <= 1, component, "Multiple @%s declarations are not allowed for @%s type, %s. Found: %s", ClassNames.DEFINE_COMPONENT_BUILDER, ClassNames.DEFINE_COMPONENT, component, builderMultimap.get((Object)componentMetadata2).stream().map(DefineComponentBuilderMetadata::builder).map(Object::toString).sorted().collect(DaggerStreams.toImmutableList()));
        }
        LinkedHashMap builderMap = new LinkedHashMap();
        builderMultimap.entries().forEach(e -> builderMap.put((DefineComponentMetadata)e.getKey(), (DefineComponentBuilderMetadata)e.getValue()));
        for (DefineComponentMetadata componentMetadata3 : aggregatedMetadata.components()) {
            ProcessorErrors.checkState(builderMap.containsKey(componentMetadata3) || componentMetadata3.isRoot(), componentMetadata3.component(), "Missing @%s declaration for @%s type, %s", ClassNames.DEFINE_COMPONENT_BUILDER, ClassNames.DEFINE_COMPONENT, componentMetadata3.component());
        }
        return (ImmutableList)aggregatedMetadata.components().stream().map(componentMetadata -> DefineComponents.toComponentDescriptor(componentMetadata, builderMap)).collect(DaggerStreams.toImmutableList());
    }

    private static ComponentDescriptor toComponentDescriptor(DefineComponentMetadata componentMetadata, Map<DefineComponentMetadata, DefineComponentBuilderMetadata> builderMap) {
        ComponentDescriptor.Builder builder = ComponentDescriptor.builder().component(ClassName.get((TypeElement)componentMetadata.component())).scopes((ImmutableSet<ClassName>)((ImmutableSet)componentMetadata.scopes().stream().map(ClassName::get).collect(DaggerStreams.toImmutableSet())));
        if (builderMap.containsKey(componentMetadata)) {
            builder.creator(ClassName.get((TypeElement)builderMap.get(componentMetadata).builder()));
        }
        componentMetadata.parentMetadata().map(parent -> DefineComponents.toComponentDescriptor(parent, builderMap)).ifPresent(builder::parent);
        return builder.build();
    }

    private DefineComponents() {
    }

    private static /* synthetic */ void lambda$componentDescriptors$0(ListMultimap builderMultimap, DefineComponentBuilderMetadata builder) {
        builderMultimap.put((Object)builder.componentMetadata(), (Object)builder);
    }

    @AutoValue
    static abstract class AggregatedMetadata {
        AggregatedMetadata() {
        }

        abstract ImmutableList<DefineComponentMetadata> components();

        abstract ImmutableList<DefineComponentBuilderMetadata> builders();

        static AggregatedMetadata from(Elements elements) {
            PackageElement packageElement = elements.getPackageElement(AGGREGATING_PACKAGE);
            if (packageElement == null) {
                return new AutoValue_DefineComponents_AggregatedMetadata((ImmutableList<DefineComponentMetadata>)ImmutableList.of(), (ImmutableList<DefineComponentBuilderMetadata>)ImmutableList.of());
            }
            ImmutableList.Builder components = ImmutableList.builder();
            ImmutableList.Builder builders = ImmutableList.builder();
            for (Element element : packageElement.getEnclosedElements()) {
                ProcessorErrors.checkState(MoreElements.isType(element), element, "Only types may be in package %s. Did you add custom code in the package?", packageElement);
                TypeElement typeElement = MoreElements.asType(element);
                ProcessorErrors.checkState(Processors.hasAnnotation((Element)typeElement, ClassNames.DEFINE_COMPONENT_CLASSES), typeElement, "Class, %s, must be annotated with @%s. Found: %s.", typeElement, ClassNames.DEFINE_COMPONENT_CLASSES.simpleName(), typeElement.getAnnotationMirrors());
                Optional<TypeElement> component = AggregatedMetadata.defineComponentClass(elements, typeElement, "component");
                Optional<TypeElement> builder = AggregatedMetadata.defineComponentClass(elements, typeElement, "builder");
                ProcessorErrors.checkState(component.isPresent() || builder.isPresent(), typeElement, (Object)"@DefineComponentClasses missing both `component` and `builder` members.");
                component.map(DefineComponentMetadata::from).ifPresent(arg_0 -> ((ImmutableList.Builder)components).add(arg_0));
                builder.map(DefineComponentBuilderMetadata::from).ifPresent(arg_0 -> ((ImmutableList.Builder)builders).add(arg_0));
            }
            return new AutoValue_DefineComponents_AggregatedMetadata((ImmutableList<DefineComponentMetadata>)components.build(), (ImmutableList<DefineComponentBuilderMetadata>)builders.build());
        }

        private static Optional<TypeElement> defineComponentClass(Elements elements, Element element, String annotationMember) {
            AnnotationMirror mirror = Processors.getAnnotationMirror(element, ClassNames.DEFINE_COMPONENT_CLASSES);
            AnnotationValue value = AnnotationMirrors.getAnnotationElementAndValue(mirror, annotationMember).getValue();
            String className = AnnotationValues.getString(value);
            if (className.isEmpty()) {
                return Optional.empty();
            }
            TypeElement type = elements.getTypeElement(className);
            ProcessorErrors.checkState(type != null, element, "%s.%s(), has invalid value: `%s`.", ClassNames.DEFINE_COMPONENT_CLASSES.simpleName(), annotationMember, className);
            return Optional.of(type);
        }
    }
}

