/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ComponentTree;
import dagger.hilt.processor.internal.KotlinMetadata;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.ComponentDependencies;
import dagger.hilt.processor.internal.aliasof.AliasOfs;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.TestRootMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;

public final class RootMetadata {
    private static final ClassName APPLICATION_CONTEXT_MODULE = ClassName.get((String)"dagger.hilt.android.internal.modules", (String)"ApplicationContextModule", (String[])new String[0]);
    private final Root root;
    private final ProcessingEnvironment env;
    private final Elements elements;
    private final ComponentTree componentTree;
    private final ComponentDependencies deps;
    private final Supplier<ImmutableSetMultimap<ClassName, ClassName>> scopesByComponent = Suppliers.memoize(this::getScopesByComponentUncached);
    private final Supplier<TestRootMetadata> testRootMetadata = Suppliers.memoize(this::testRootMetadataUncached);

    static RootMetadata create(Root root, ComponentTree componentTree, ComponentDependencies deps, ProcessingEnvironment env) {
        RootMetadata metadata = new RootMetadata(root, componentTree, deps, env);
        metadata.validate();
        return metadata;
    }

    private RootMetadata(Root root, ComponentTree componentTree, ComponentDependencies deps, ProcessingEnvironment env) {
        this.root = root;
        this.env = env;
        this.elements = env.getElementUtils();
        this.componentTree = componentTree;
        this.deps = deps;
    }

    public Root root() {
        return this.root;
    }

    public ComponentTree componentTree() {
        return this.componentTree;
    }

    public ComponentDependencies deps() {
        return this.deps;
    }

    public ImmutableSet<TypeElement> modules(ClassName componentName) {
        return this.deps.getModules(componentName, this.root.classname());
    }

    public ImmutableSet<TypeName> entryPoints(ClassName componentName) {
        return ImmutableSet.builder().addAll(this.getUserDefinedEntryPoints(componentName)).add((Object)componentName).build();
    }

    public ImmutableSet<ClassName> scopes(ClassName componentName) {
        return ((ImmutableSetMultimap)this.scopesByComponent.get()).get((Object)componentName);
    }

    public ImmutableSet<TypeElement> modulesThatDaggerCannotConstruct(ClassName componentName) {
        return (ImmutableSet)this.modules(componentName).stream().filter(module -> !RootMetadata.daggerCanConstruct(module)).filter(module -> !APPLICATION_CONTEXT_MODULE.equals((Object)ClassName.get((TypeElement)module))).collect(DaggerStreams.toImmutableSet());
    }

    public TestRootMetadata testRootMetadata() {
        return (TestRootMetadata)this.testRootMetadata.get();
    }

    public boolean waitForBindValue() {
        return false;
    }

    private TestRootMetadata testRootMetadataUncached() {
        return TestRootMetadata.of(this.env, this.root().element());
    }

    private void validate() {
        for (ComponentDescriptor componentDescriptor : this.componentTree.getComponentDescriptors()) {
            ClassName componentName = componentDescriptor.component();
            for (TypeElement extraModule : this.modulesThatDaggerCannotConstruct(componentName)) {
                if (this.root.type().isTestRoot() && !componentName.equals((Object)ClassNames.APPLICATION_COMPONENT)) {
                    this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Hilt] All test modules (unless installed in ApplicationComponent) must use static provision methods or have a visible, no-arg constructor. Found: " + extraModule.getQualifiedName(), this.root.element());
                    continue;
                }
                if (this.root.type().isTestRoot()) continue;
                this.env.getMessager().printMessage(Diagnostic.Kind.ERROR, "[Hilt] All modules must be static and use static provision methods or have a visible, no-arg constructor. Found: " + extraModule.getQualifiedName(), this.root.element());
            }
        }
    }

    private ImmutableSet<TypeName> getUserDefinedEntryPoints(ClassName componentName) {
        ImmutableSet.Builder entryPointSet = ImmutableSet.builder();
        entryPointSet.add((Object)ClassNames.GENERATED_COMPONENT);
        for (TypeElement element : this.deps.getEntryPoints(componentName, this.root.classname())) {
            entryPointSet.add((Object)ClassName.get((TypeElement)element));
        }
        return entryPointSet.build();
    }

    private ImmutableSetMultimap<ClassName, ClassName> getScopesByComponentUncached() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        ImmutableSet defineComponentScopes = (ImmutableSet)this.componentTree.getComponentDescriptors().stream().flatMap(descriptor -> descriptor.scopes().stream()).collect(DaggerStreams.toImmutableSet());
        AliasOfs aliasOfs = new AliasOfs(this.env, (ImmutableSet<ClassName>)defineComponentScopes);
        for (ComponentDescriptor componentDescriptor : this.componentTree.getComponentDescriptors()) {
            for (ClassName scope : componentDescriptor.scopes()) {
                builder.put((Object)componentDescriptor.component(), (Object)scope);
                builder.putAll((Object)componentDescriptor.component(), aliasOfs.getAliasesFor(scope));
            }
        }
        return builder.build();
    }

    private static boolean daggerCanConstruct(TypeElement type) {
        Optional<KotlinMetadata> kotlinMetadata = KotlinMetadata.of(type);
        boolean isKotlinObject = kotlinMetadata.map(metadata -> metadata.isObjectClass() || metadata.isCompanionObjectClass()).orElse(false);
        if (isKotlinObject) {
            return true;
        }
        return !RootMetadata.isInnerClass(type) && !RootMetadata.hasNonDaggerAbstractMethod(type) && (RootMetadata.hasOnlyStaticProvides(type) || RootMetadata.hasVisibleEmptyConstructor(type));
    }

    private static boolean isInnerClass(TypeElement type) {
        return type.getNestingKind().isNested() && !type.getModifiers().contains((Object)Modifier.STATIC);
    }

    private static boolean hasNonDaggerAbstractMethod(TypeElement type) {
        return ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> method.getModifiers().contains((Object)Modifier.ABSTRACT)).anyMatch(method -> !Processors.hasDaggerAbstractMethodAnnotation(method));
    }

    private static boolean hasOnlyStaticProvides(TypeElement type) {
        return ElementFilter.methodsIn(type.getEnclosedElements()).stream().filter(method -> Processors.hasAnnotation((Element)method, ClassNames.PROVIDES)).allMatch(method -> method.getModifiers().contains((Object)Modifier.STATIC));
    }

    private static boolean hasVisibleEmptyConstructor(TypeElement type) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        return constructors.isEmpty() || constructors.stream().filter(constructor -> constructor.getParameters().isEmpty()).anyMatch(constructor -> !constructor.getModifiers().contains((Object)Modifier.PRIVATE));
    }
}

