/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.RootMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;

public final class TestComponentDataGenerator {
    private final ProcessingEnvironment processingEnv;
    private final RootMetadata rootMetadata;
    private final ClassName name;

    public TestComponentDataGenerator(ProcessingEnvironment processingEnv, RootMetadata rootMetadata) {
        this.processingEnv = processingEnv;
        this.rootMetadata = rootMetadata;
        this.name = Processors.append(Processors.getEnclosedClassName(rootMetadata.testRootMetadata().testName()), "_ComponentDataHolder");
    }

    public void generate() throws IOException {
        TypeSpec.Builder generator = TypeSpec.classBuilder((ClassName)this.name).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build()).addMethod(this.getMethod()).addMethod(this.getTestInjectInternalMethod());
        Processors.addGeneratedAnnotation(generator, this.processingEnv, ClassNames.ROOT_PROCESSOR.toString());
        JavaFile.builder((String)this.rootMetadata.testRootMetadata().testName().packageName(), (TypeSpec)generator.build()).build().writeTo(this.processingEnv.getFiler());
    }

    private MethodSpec getMethod() {
        TypeElement testElement = this.rootMetadata.testRootMetadata().testElement();
        ClassName component = ComponentNames.generatedComponent(ClassName.get((TypeElement)testElement), ClassNames.APPLICATION_COMPONENT);
        ImmutableSet<TypeElement> daggerRequiredModules = this.rootMetadata.modulesThatDaggerCannotConstruct(ClassNames.APPLICATION_COMPONENT);
        ImmutableSet hiltRequiredModules = (ImmutableSet)daggerRequiredModules.stream().filter(module -> !TestComponentDataGenerator.canBeConstructedByHilt(module, testElement)).collect(DaggerStreams.toImmutableSet());
        return MethodSpec.methodBuilder((String)"get").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)ClassNames.TEST_COMPONENT_DATA).addStatement("return new $T($L, $L, $L, $L, $L)", new Object[]{ClassNames.TEST_COMPONENT_DATA, this.rootMetadata.waitForBindValue(), CodeBlock.of((String)"testInstance -> injectInternal(($1T) testInstance)", (Object[])new Object[]{testElement}), TestComponentDataGenerator.getElementsListed(daggerRequiredModules), TestComponentDataGenerator.getElementsListed((ImmutableSet<TypeElement>)hiltRequiredModules), CodeBlock.of((String)"(modules, testInstance, autoAddModuleEnabled) -> $T.builder()\n.applicationContextModule(new $T($T.getApplicationContext()))\n$L.build()", (Object[])new Object[]{Processors.prepend(Processors.getEnclosedClassName(component), "Dagger"), ClassNames.APPLICATION_CONTEXT_MODULE, ClassNames.APPLICATION_PROVIDER, daggerRequiredModules.stream().map(module -> TestComponentDataGenerator.getAddModuleStatement(module, testElement)).collect(Collectors.joining("\n"))})}).build();
    }

    private static String getAddModuleStatement(TypeElement module, TypeElement testElement) {
        ClassName className = ClassName.get((TypeElement)module);
        return TestComponentDataGenerator.canBeConstructedByHilt(module, testElement) ? CodeBlock.of((String)".$1L(autoAddModuleEnabled\n    ? (($3T) testInstance).new $4L()\n    : ($2T) modules.get($2T.class))", (Object[])new Object[]{Processors.upperToLowerCamel(className.simpleName()), className, className.enclosingClassName(), className.simpleName()}).toString() : CodeBlock.of((String)".$1L(($2T) modules.get($2T.class))", (Object[])new Object[]{Processors.upperToLowerCamel(className.simpleName()), className}).toString();
    }

    private static boolean canBeConstructedByHilt(TypeElement module, TypeElement testElement) {
        return TestComponentDataGenerator.hasOnlyAccessibleNoArgConstructor(module) && module.getEnclosingElement().equals(testElement);
    }

    private static boolean hasOnlyAccessibleNoArgConstructor(TypeElement module) {
        List<ExecutableElement> declaredConstructors = ElementFilter.constructorsIn(module.getEnclosedElements());
        return declaredConstructors.isEmpty() || declaredConstructors.size() == 1 && !declaredConstructors.get(0).getModifiers().contains((Object)Modifier.PRIVATE) && declaredConstructors.get(0).getParameters().isEmpty();
    }

    private static CodeBlock getElementsListed(ImmutableSet<TypeElement> modules) {
        return modules.isEmpty() ? CodeBlock.of((String)"$T.emptySet()", (Object[])new Object[]{ClassNames.COLLECTIONS}) : CodeBlock.of((String)"new $T<>($T.asList($L))", (Object[])new Object[]{ClassNames.HASH_SET, ClassNames.ARRAYS, modules.stream().map(module -> CodeBlock.of((String)"$T.class", (Object[])new Object[]{module}).toString()).collect(Collectors.joining(","))});
    }

    private MethodSpec getTestInjectInternalMethod() {
        TypeElement testElement = this.rootMetadata.testRootMetadata().testElement();
        ClassName testName = ClassName.get((TypeElement)testElement);
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)"injectInternal").addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addParameter((TypeName)testName, "testInstance", new Modifier[0]).addAnnotation(AnnotationSpec.builder(SuppressWarnings.class).addMember("value", "$S", new Object[]{"unchecked"}).build());
        return builder.addStatement("(($T) (($T) $T.getApplicationContext()).generatedComponent()).injectTest(testInstance)", new Object[]{ParameterizedTypeName.get((ClassName)ClassNames.TEST_INJECTOR, (TypeName[])new TypeName[]{this.rootMetadata.testRootMetadata().testName()}), ClassNames.GENERATED_COMPONENT_MANAGER, ClassNames.APPLICATION_PROVIDER}).build();
    }
}

