/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.WildcardTypeName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.RootMetadata;
import java.io.IOException;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Modifier;

public final class TestComponentDataSupplierGenerator {
    private static final ClassName TEST_COMPONENT_DATA_SUPPLIER_IMPL = ClassName.get((String)"dagger.hilt.android.internal.testing", (String)"TestComponentDataSupplierImpl", (String[])new String[0]);
    private static final ParameterizedTypeName CLASS_TYPE = ParameterizedTypeName.get((ClassName)ClassNames.CLASS, (TypeName[])new TypeName[]{WildcardTypeName.subtypeOf((TypeName)TypeName.OBJECT)});
    private static final ParameterizedTypeName TEST_COMPONENT_DATA_MAP_TYPE = ParameterizedTypeName.get((ClassName)ClassNames.MAP, (TypeName[])new TypeName[]{CLASS_TYPE, ClassNames.TEST_COMPONENT_DATA});
    private final ProcessingEnvironment processingEnv;
    private final ImmutableList<RootMetadata> rootMetadatas;

    public TestComponentDataSupplierGenerator(ProcessingEnvironment processingEnv, ImmutableList<RootMetadata> rootMetadatas) {
        this.processingEnv = processingEnv;
        this.rootMetadatas = rootMetadatas;
    }

    public void generate() throws IOException {
        TypeSpec.Builder generator = TypeSpec.classBuilder((ClassName)TEST_COMPONENT_DATA_SUPPLIER_IMPL).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).superclass((TypeName)ClassNames.TEST_COMPONENT_DATA_SUPPLIER).addField(FieldSpec.builder((TypeName)TEST_COMPONENT_DATA_MAP_TYPE, (String)"testComponentDataMap", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).initializer("new $T<>($L)", new Object[]{ClassNames.HASH_MAP, this.rootMetadatas.size()}).build()).addMethod(this.constructor()).addMethod(this.getMethod());
        Processors.addGeneratedAnnotation(generator, this.processingEnv, ClassNames.ROOT_PROCESSOR.toString());
        JavaFile.builder((String)TEST_COMPONENT_DATA_SUPPLIER_IMPL.packageName(), (TypeSpec)generator.build()).build().writeTo(this.processingEnv.getFiler());
    }

    private MethodSpec constructor() {
        MethodSpec.Builder constructor = MethodSpec.constructorBuilder();
        for (RootMetadata rootMetadata : this.rootMetadatas) {
            ClassName testName = rootMetadata.testRootMetadata().testName();
            ClassName testComponentDataHolderName = Processors.append(Processors.getEnclosedClassName(testName), "_ComponentDataHolder");
            constructor.addStatement("testComponentDataMap.put($T.class, $T.get())", new Object[]{testName, testComponentDataHolderName});
        }
        return constructor.build();
    }

    private MethodSpec getMethod() {
        return MethodSpec.methodBuilder((String)"get").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PROTECTED}).returns((TypeName)TEST_COMPONENT_DATA_MAP_TYPE).addStatement("return testComponentDataMap", new Object[0]).build();
    }
}

