/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.common.base.CaseFormat;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.android.shaded.auto.common.AnnotationMirrors;
import dagger.hilt.android.shaded.auto.common.GeneratedAnnotations;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.android.shaded.auto.common.MoreTypes;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.KotlinMetadataUtils;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.kotlin.KotlinMetadataUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.inject.Qualifier;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleAnnotationValueVisitor7;
import javax.lang.model.util.SimpleTypeVisitor7;

public final class Processors {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_INITIALIZER_NAME = "<clinit>";
    private static final String JAVA_CLASS = "java.lang.Class";
    private static final SimpleAnnotationValueVisitor7<ImmutableSet<VariableElement>, Void> ENUM_ANNOTATION_VALUE_VISITOR = new SimpleAnnotationValueVisitor7<ImmutableSet<VariableElement>, Void>(){

        @Override
        public ImmutableSet<VariableElement> defaultAction(Object o, Void unused) {
            throw new IllegalStateException("Expected an Enum or an Enum array, got instead: " + o);
        }

        @Override
        public ImmutableSet<VariableElement> visitArray(List<? extends AnnotationValue> values, Void unused) {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            for (AnnotationValue annotationValue : values) {
                builder.addAll((Iterable)annotationValue.accept(this, null));
            }
            return builder.build();
        }

        @Override
        public ImmutableSet<VariableElement> visitEnumConstant(VariableElement value, Void unused) {
            return ImmutableSet.of((Object)value);
        }
    };

    public static void generateAggregatingClass(String aggregatingPackage, AnnotationSpec aggregatingAnnotation, TypeElement element, Class<?> generatedAnnotationClass, ProcessingEnvironment env) throws IOException {
        ClassName name = ClassName.get((String)aggregatingPackage, (String)("_" + Processors.getFullEnclosedName(element)), (String[])new String[0]);
        TypeSpec.Builder builder = TypeSpec.classBuilder((ClassName)name).addModifiers(new Modifier[]{Modifier.PUBLIC}).addOriginatingElement((Element)element).addAnnotation(aggregatingAnnotation).addJavadoc("This class should only be referenced by generated code! ", new Object[0]).addJavadoc("This class aggregates information across multiple compilations.\n", new Object[0]);
        Processors.addGeneratedAnnotation(builder, env, generatedAnnotationClass);
        JavaFile.builder((String)name.packageName(), (TypeSpec)builder.build()).build().writeTo(env.getFiler());
    }

    public static ImmutableMap<String, AnnotationValue> getAnnotationValues(Elements elements, AnnotationMirror annotation) {
        ImmutableMap.Builder annotationMembers = ImmutableMap.builder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : elements.getElementValuesWithDefaults(annotation).entrySet()) {
            annotationMembers.put((Object)e.getKey().getSimpleName().toString(), (Object)e.getValue());
        }
        return annotationMembers.build();
    }

    public static Multimap<String, AnnotationMirror> getAnnotationAnnotationArrayValues(Elements elements, AnnotationMirror annotation) {
        LinkedHashMultimap annotationMembers = LinkedHashMultimap.create();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : elements.getElementValuesWithDefaults(annotation).entrySet()) {
            String attribute = e.getKey().getSimpleName().toString();
            LinkedHashSet annotationMirrors = new LinkedHashSet();
            e.getValue().accept(new AnnotationMirrorAnnotationValueVisitor(), annotationMirrors);
            annotationMembers.putAll((Object)attribute, annotationMirrors);
        }
        return annotationMembers;
    }

    public static TypeElement getAnnotationClassValue(Elements elements, AnnotationMirror annotation, String key) {
        return (TypeElement)Iterables.getOnlyElement(Processors.getAnnotationClassValues(elements, annotation, key));
    }

    public static ImmutableList<TypeElement> getAnnotationClassValues(Elements elements, AnnotationMirror annotation, String key) {
        ImmutableList<TypeElement> values = Processors.getOptionalAnnotationClassValues(elements, annotation, key);
        ProcessorErrors.checkState(values.size() >= 1, annotation.getAnnotationType().asElement(), "@%s, '%s' class is invalid or missing: %s", annotation.getAnnotationType().asElement().getSimpleName(), key, annotation);
        return values;
    }

    private static Multimap<String, DeclaredType> getAnnotationClassValues(Elements elements, AnnotationMirror annotation) {
        TypeElement javaClass = elements.getTypeElement(JAVA_CLASS);
        LinkedHashMultimap annotationMembers = LinkedHashMultimap.create();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : elements.getElementValuesWithDefaults(annotation).entrySet()) {
            Optional<DeclaredType> returnType = Processors.getOptionalDeclaredType(e.getKey().getReturnType());
            if (!returnType.isPresent() || !returnType.get().asElement().equals(javaClass)) continue;
            String attribute = e.getKey().getSimpleName().toString();
            LinkedHashSet declaredTypes = new LinkedHashSet();
            e.getValue().accept(new DeclaredTypeAnnotationValueVisitor(), declaredTypes);
            annotationMembers.putAll((Object)attribute, declaredTypes);
        }
        return annotationMembers;
    }

    public static Optional<TypeElement> getOptionalAnnotationClassValue(Elements elements, AnnotationMirror annotation, String key) {
        return (Optional)Processors.getAnnotationClassValues(elements, annotation).get((Object)key).stream().map(MoreTypes::asTypeElement).collect(DaggerCollectors.toOptional());
    }

    public static ImmutableList<TypeElement> getOptionalAnnotationClassValues(Elements elements, AnnotationMirror annotation, String key) {
        return ImmutableList.copyOf((Collection)Processors.getAnnotationClassValues(elements, annotation).get((Object)key).stream().map(MoreTypes::asTypeElement).collect(Collectors.toList()));
    }

    public static PrimitiveType getPrimitiveType(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor7<PrimitiveType, Void>(){

            @Override
            public PrimitiveType visitArray(ArrayType type, Void unused) {
                return Processors.getPrimitiveType(type.getComponentType());
            }

            @Override
            public PrimitiveType visitPrimitive(PrimitiveType type, Void unused) {
                return type;
            }

            @Override
            public PrimitiveType defaultAction(TypeMirror type, Void unused) {
                throw new IllegalStateException("Unhandled type: " + type);
            }
        }, null);
    }

    public static Optional<DeclaredType> getOptionalDeclaredType(TypeMirror type) {
        return Optional.ofNullable(type.accept(new SimpleTypeVisitor7<DeclaredType, Void>(null){

            @Override
            public DeclaredType visitArray(ArrayType type, Void unused) {
                return MoreTypes.asDeclared(type.getComponentType());
            }

            @Override
            public DeclaredType visitDeclared(DeclaredType type, Void unused) {
                return type;
            }

            @Override
            public DeclaredType visitError(ErrorType type, Void unused) {
                return type;
            }
        }, null));
    }

    public static DeclaredType getDeclaredType(TypeMirror type) {
        return Processors.getOptionalDeclaredType(type).orElseThrow(() -> new IllegalStateException("Not a declared type: " + type));
    }

    public static ImmutableList<String> getStringArrayAnnotationValue(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor7<ImmutableList<String>, Void>(){

            @Override
            public ImmutableList<String> defaultAction(Object o, Void unused) {
                throw new IllegalStateException("Expected an array, got instead: " + o);
            }

            @Override
            public ImmutableList<String> visitArray(List<? extends AnnotationValue> values, Void unused) {
                ImmutableList.Builder builder = ImmutableList.builder();
                for (AnnotationValue annotationValue : values) {
                    builder.add((Object)Processors.getStringAnnotationValue(annotationValue));
                }
                return builder.build();
            }
        }, null);
    }

    public static Boolean getBooleanAnnotationValue(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor7<Boolean, Void>(){

            @Override
            public Boolean defaultAction(Object o, Void unused) {
                throw new IllegalStateException("Expected a boolean, got instead: " + o);
            }

            @Override
            public Boolean visitBoolean(boolean value, Void unused) {
                return value;
            }
        }, null);
    }

    public static Integer getIntAnnotationValue(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor7<Integer, Void>(){

            @Override
            public Integer defaultAction(Object o, Void unused) {
                throw new IllegalStateException("Expected an int, got instead: " + o);
            }

            @Override
            public Integer visitInt(int value, Void unused) {
                return value;
            }
        }, null);
    }

    public static Long getLongAnnotationValue(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor7<Long, Void>(){

            @Override
            public Long defaultAction(Object o, Void unused) {
                throw new IllegalStateException("Expected an int, got instead: " + o);
            }

            @Override
            public Long visitLong(long value, Void unused) {
                return value;
            }
        }, null);
    }

    public static String getStringAnnotationValue(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor7<String, Void>(){

            @Override
            public String defaultAction(Object o, Void unused) {
                throw new IllegalStateException("Expected a string, got instead: " + o);
            }

            @Override
            public String visitString(String value, Void unused) {
                return value;
            }
        }, null);
    }

    public static DeclaredType getDeclaredTypeAnnotationValue(AnnotationValue value) {
        return value.accept(new SimpleAnnotationValueVisitor7<DeclaredType, Void>(){

            @Override
            public DeclaredType defaultAction(Object o, Void unused) {
                throw new IllegalStateException("Expected a TypeMirror, got instead: " + o);
            }

            @Override
            public DeclaredType visitType(TypeMirror typeMirror, Void unused) {
                return MoreTypes.asDeclared(typeMirror);
            }
        }, null);
    }

    public static ImmutableSet<VariableElement> getEnumArrayAnnotationValue(AnnotationValue value) {
        return value.accept(ENUM_ANNOTATION_VALUE_VISITOR, null);
    }

    public static ImmutableMap<String, AnnotationValue> convertToAttributeNameMap(Map<? extends ExecutableElement, ? extends AnnotationValue> annotationValues) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> e : annotationValues.entrySet()) {
            String attribute = e.getKey().getSimpleName().toString();
            builder.put((Object)attribute, (Object)e.getValue());
        }
        return builder.build();
    }

    public static PackageElement getPackageElement(Element originalElement) {
        Preconditions.checkNotNull((Object)originalElement);
        for (Element e = originalElement; e != null; e = e.getEnclosingElement()) {
            if (!(e instanceof PackageElement)) continue;
            return (PackageElement)e;
        }
        throw new IllegalStateException("Cannot find a package for " + originalElement);
    }

    public static TypeElement getTopLevelType(Element originalElement) {
        Preconditions.checkNotNull((Object)originalElement);
        for (Element e = originalElement; e != null; e = e.getEnclosingElement()) {
            if (!Processors.isTopLevel(e)) continue;
            return MoreElements.asType(e);
        }
        throw new IllegalStateException("Cannot find a top-level type for " + originalElement);
    }

    public static boolean isTopLevel(Element element) {
        return element.getEnclosingElement().getKind() == ElementKind.PACKAGE;
    }

    public static boolean hasAnnotation(Element element, Class<? extends Annotation> annotation) {
        return element.getAnnotation(annotation) != null;
    }

    public static boolean hasAnnotation(Element element, ClassName className) {
        return Processors.getAnnotationMirrorOptional(element, className).isPresent();
    }

    public static boolean hasAnnotation(AnnotationMirror mirror, ClassName className) {
        return Processors.hasAnnotation(mirror.getAnnotationType().asElement(), className);
    }

    public static boolean hasAnnotation(AnnotationMirror mirror, Class<? extends Annotation> annotation) {
        return Processors.hasAnnotation(mirror.getAnnotationType().asElement(), annotation);
    }

    public static boolean hasErrorTypeAnnotation(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (annotationMirror.getAnnotationType().getKind() != TypeKind.ERROR) continue;
            return true;
        }
        return false;
    }

    @SafeVarargs
    public static ImmutableSet<Element> getElementsAnnotatedWith(RoundEnvironment roundEnv, Class<? extends Annotation> ... annotations) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (Class<? extends Annotation> annotation : annotations) {
            builder.addAll(roundEnv.getElementsAnnotatedWith(annotation));
        }
        return builder.build();
    }

    public static String getEnclosedName(ClassName name) {
        return Joiner.on((char)'_').join((Iterable)name.simpleNames());
    }

    public static String getEnclosedName(TypeElement element) {
        return Processors.getEnclosedName(ClassName.get((TypeElement)element));
    }

    public static ClassName getEnclosedClassName(ClassName className) {
        return ClassName.get((String)className.packageName(), (String)Processors.getEnclosedName(className), (String[])new String[0]);
    }

    public static ClassName getEnclosedClassName(TypeElement typeElement) {
        return Processors.getEnclosedClassName(ClassName.get((TypeElement)typeElement));
    }

    public static String getFullyQualifiedEnclosedClassName(ClassName className) {
        return className.packageName().replace('.', '_') + Processors.getEnclosedName(className);
    }

    public static String getFullEnclosedName(Element element) {
        Preconditions.checkNotNull((Object)element);
        String qualifiedName = "";
        while (element != null) {
            if (element.getKind().equals((Object)ElementKind.PACKAGE)) {
                qualifiedName = MoreElements.asPackage(element).getQualifiedName() + qualifiedName;
            } else if (!element.getSimpleName().toString().isEmpty()) {
                qualifiedName = "." + element.getSimpleName() + qualifiedName;
            }
            element = element.getEnclosingElement();
        }
        return qualifiedName.replace('.', '_');
    }

    public static ClassName append(ClassName name, String suffix) {
        return name.peerClass(name.simpleName() + suffix);
    }

    public static ClassName prepend(ClassName name, String prefix) {
        return name.peerClass(prefix + name.simpleName());
    }

    public static ClassName removeNameSuffix(TypeElement type, String suffix) {
        ClassName originalName = ClassName.get((TypeElement)type);
        String originalSimpleName = originalName.simpleName();
        ProcessorErrors.checkState(originalSimpleName.endsWith(suffix), type, "Name of type %s must end with '%s'", originalName, suffix);
        String withoutSuffix = originalSimpleName.substring(0, originalSimpleName.length() - suffix.length());
        return originalName.peerClass(withoutSuffix);
    }

    public static AnnotationMirror getAnnotationMirror(Element element, Class<? extends Annotation> annotationClass) {
        return Processors.getAnnotationMirror(element, ClassName.get(annotationClass));
    }

    public static AnnotationMirror getAnnotationMirror(Element element, String annotationClassName) {
        return Processors.getAnnotationMirror(element, ClassName.bestGuess((String)annotationClassName));
    }

    public static AnnotationMirror getAnnotationMirror(Element element, ClassName className) {
        Optional<AnnotationMirror> annotationMirror = Processors.getAnnotationMirrorOptional(element, className);
        if (annotationMirror.isPresent()) {
            return annotationMirror.get();
        }
        throw new IllegalStateException(String.format("Couldn't find annotation %s on element %s. Found annotations: %s", className, element.getSimpleName(), element.getAnnotationMirrors()));
    }

    static Optional<AnnotationMirror> getAnnotationMirrorOptional(Element element, ClassName className) {
        return (Optional)element.getAnnotationMirrors().stream().filter(mirror -> ClassName.get((TypeMirror)mirror.getAnnotationType()).equals((Object)className)).collect(DaggerCollectors.toOptional());
    }

    public static boolean isAssignableFrom(TypeElement element, ClassName className) {
        return Processors.isAssignableFromAnyOf(element, (ImmutableSet<ClassName>)ImmutableSet.of((Object)className));
    }

    public static boolean isAssignableFromAnyOf(TypeElement element, ImmutableSet<ClassName> classNames) {
        for (ClassName className : classNames) {
            if (!ClassName.get((TypeElement)element).equals((Object)className)) continue;
            return true;
        }
        TypeMirror superClass = element.getSuperclass();
        if (superClass.getKind() != TypeKind.NONE && superClass.getKind() != TypeKind.ERROR) {
            Preconditions.checkState((superClass.getKind() == TypeKind.DECLARED ? 1 : 0) != 0);
            if (Processors.isAssignableFromAnyOf(MoreTypes.asTypeElement(superClass), classNames)) {
                return true;
            }
        }
        for (TypeMirror iface : element.getInterfaces()) {
            if (iface.getKind() == TypeKind.ERROR) continue;
            Preconditions.checkState((iface.getKind() == TypeKind.DECLARED ? 1 : 0) != 0, (String)"Interface type is %s", (Object)((Object)iface.getKind()));
            if (!Processors.isAssignableFromAnyOf(MoreTypes.asTypeElement(iface), classNames)) continue;
            return true;
        }
        return false;
    }

    public static ImmutableList<ExecutableElement> getMethods(TypeElement element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element2 : element.getEnclosedElements()) {
            ExecutableElement method;
            if (!(element2 instanceof ExecutableElement) || (method = (ExecutableElement)element2).getSimpleName().contentEquals(CONSTRUCTOR_NAME) || method.getSimpleName().contentEquals(STATIC_INITIALIZER_NAME)) continue;
            builder.add((Object)method);
        }
        return builder.build();
    }

    public static ImmutableList<ExecutableElement> getConstructors(TypeElement element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element2 : element.getEnclosedElements()) {
            ExecutableElement method;
            if (!(element2 instanceof ExecutableElement) || !(method = (ExecutableElement)element2).getSimpleName().contentEquals(CONSTRUCTOR_NAME)) continue;
            builder.add((Object)method);
        }
        return builder.build();
    }

    public static ImmutableList<ExecutableElement> getAllMethods(TypeElement element) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Iterables.filter(Processors.getMethods(element), method -> !Processors.isObjectMethod(method)));
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind() != TypeKind.NONE) {
            TypeElement superclassElement = MoreTypes.asTypeElement(superclass);
            builder.addAll(Processors.getAllMethods(superclassElement));
        }
        for (TypeMirror typeMirror : element.getInterfaces()) {
            builder.addAll(Processors.getAllMethods(MoreTypes.asTypeElement(typeMirror)));
        }
        return builder.build();
    }

    public static void checkForCompilationError(TypeElement e) {
        ProcessorErrors.checkState(e.asType().getKind() != TypeKind.ERROR, e, "Unable to resolve the type %s. Look for compilation errors above related to this type.", e);
    }

    private static void addInterfaceMethods(TypeElement type, ImmutableList.Builder<ExecutableElement> interfaceMethods) {
        for (TypeMirror typeMirror : type.getInterfaces()) {
            TypeElement interfaceElement = MoreTypes.asTypeElement(typeMirror);
            interfaceMethods.addAll(Processors.getMethods(interfaceElement));
            Processors.addInterfaceMethods(interfaceElement, interfaceMethods);
        }
    }

    public static ImmutableList<ExecutableElement> methodsOnInterfaces(TypeElement type) {
        ImmutableList.Builder interfaceMethods = new ImmutableList.Builder();
        Processors.addInterfaceMethods(type, (ImmutableList.Builder<ExecutableElement>)interfaceMethods);
        return interfaceMethods.build();
    }

    public static ImmutableList<AnnotationMirror> getMapKeyAnnotations(Element element) {
        return Processors.getAnnotationsAnnotatedWith(element, ClassName.get((String)"dagger", (String)"MapKey", (String[])new String[0]));
    }

    public static ImmutableList<AnnotationMirror> getQualifierAnnotations(Element element) {
        ImmutableSet<? extends AnnotationMirror> qualifiers = AnnotationMirrors.getAnnotatedAnnotations(element, Qualifier.class);
        KotlinMetadataUtil metadataUtil = KotlinMetadataUtils.getMetadataUtil();
        if (element.getKind() == ElementKind.FIELD && !element.getModifiers().contains((Object)Modifier.STATIC) && metadataUtil.hasMetadata(element)) {
            VariableElement fieldElement = MoreElements.asVariable(element);
            return (ImmutableList)Stream.concat(qualifiers.stream(), metadataUtil.isMissingSyntheticPropertyForAnnotations(fieldElement) ? Stream.empty() : metadataUtil.getSyntheticPropertyAnnotations(fieldElement, Qualifier.class).stream()).map(arg_0 -> AnnotationMirrors.equivalence().wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).collect(DaggerStreams.toImmutableList());
        }
        return ImmutableList.copyOf(qualifiers);
    }

    public static ImmutableList<AnnotationMirror> getScopeAnnotations(Element element) {
        return Processors.getAnnotationsAnnotatedWith(element, ClassNames.SCOPE);
    }

    public static ImmutableList<AnnotationMirror> getAnnotationsAnnotatedWith(Element element, ClassName subAnnotation) {
        ImmutableList.Builder builder = ImmutableList.builder();
        element.getAnnotationMirrors().stream().filter(annotation -> Processors.hasAnnotation(annotation, subAnnotation)).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    public static boolean hasAnnotationsAnnotatedWith(Element element, ClassName subAnnotation) {
        return !Processors.getAnnotationsAnnotatedWith(element, subAnnotation).isEmpty();
    }

    public static boolean isObjectMethod(ExecutableElement method) {
        Element enclosingElement = method.getEnclosingElement();
        if (enclosingElement.getKind() == ElementKind.CLASS && TypeName.get((TypeMirror)enclosingElement.asType()).equals((Object)TypeName.OBJECT)) {
            return true;
        }
        if (method.getModifiers().contains((Object)Modifier.STATIC)) {
            return false;
        }
        switch (method.getSimpleName().toString()) {
            case "equals": {
                return method.getParameters().size() == 1 && method.getParameters().get(0).asType().toString().equals("java.lang.Object");
            }
            case "hashCode": 
            case "toString": 
            case "clone": 
            case "getClass": 
            case "notify": 
            case "notifyAll": 
            case "finalize": {
                return method.getParameters().isEmpty();
            }
            case "wait": {
                if (method.getParameters().isEmpty()) {
                    return true;
                }
                if (method.getParameters().size() == 1 && method.getParameters().get(0).asType().toString().equals("long")) {
                    return true;
                }
                return method.getParameters().size() == 2 && method.getParameters().get(0).asType().toString().equals("long") && method.getParameters().get(1).asType().toString().equals("int");
            }
        }
        return false;
    }

    public static ParameterSpec parameterSpecFromVariableElement(VariableElement element) {
        return ParameterSpec.builder((TypeName)ClassName.get((TypeMirror)element.asType()), (String)Processors.upperToLowerCamel(element.getSimpleName().toString()), (Modifier[])new Modifier[0]).build();
    }

    public static String upperToLowerCamel(String upperCamel) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, upperCamel);
    }

    public static MethodSpec.Builder copyMethodSpecWithoutBody(MethodSpec methodSpec) {
        MethodSpec.Builder builder = methodSpec.isConstructor() ? MethodSpec.constructorBuilder() : MethodSpec.methodBuilder((String)methodSpec.name).returns(methodSpec.returnType);
        return builder.addAnnotations((Iterable)methodSpec.annotations).addModifiers((Iterable)methodSpec.modifiers).addParameters((Iterable)methodSpec.parameters).addExceptions((Iterable)methodSpec.exceptions).addJavadoc(methodSpec.javadoc.toString(), new Object[0]).addTypeVariables((Iterable)methodSpec.typeVariables);
    }

    public static MethodSpec privateEmptyConstructor() {
        return MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
    }

    public static boolean hasDaggerAbstractMethodAnnotation(ExecutableElement method) {
        return Processors.hasAnnotation((Element)method, ClassNames.BINDS) || Processors.hasAnnotation((Element)method, ClassNames.BINDS_OPTIONAL_OF) || Processors.hasAnnotation((Element)method, ClassNames.MULTIBINDS) || Processors.hasAnnotation((Element)method, ClassNames.CONTRIBUTES_ANDROID_INJECTOR);
    }

    public static ImmutableSet<TypeElement> toTypeElements(Elements elements, String[] classes) {
        return FluentIterable.from((Object[])classes).transform(elements::getTypeElement).toSet();
    }

    public static ImmutableSet<ClassName> toClassNames(Iterable<TypeElement> elements) {
        return FluentIterable.from(elements).transform(ClassName::get).toSet();
    }

    public static boolean requiresModuleInstance(Elements elements, TypeElement module) {
        return ElementFilter.methodsIn(elements.getAllMembers(module)).stream().filter(Processors::isBindingMethod).map(Element::getModifiers).anyMatch(modifiers -> !modifiers.contains((Object)Modifier.ABSTRACT) && !modifiers.contains((Object)Modifier.STATIC)) && !KotlinMetadataUtils.getMetadataUtil().isObjectOrCompanionObjectClass(module);
    }

    public static boolean hasVisibleEmptyConstructor(TypeElement type) {
        List<ExecutableElement> constructors = ElementFilter.constructorsIn(type.getEnclosedElements());
        return constructors.isEmpty() || constructors.stream().filter(constructor -> constructor.getParameters().isEmpty()).anyMatch(constructor -> !constructor.getModifiers().contains((Object)Modifier.PRIVATE));
    }

    private static boolean isBindingMethod(ExecutableElement method) {
        return Processors.hasAnnotation((Element)method, ClassNames.PROVIDES) || Processors.hasAnnotation((Element)method, ClassNames.BINDS) || Processors.hasAnnotation((Element)method, ClassNames.BINDS_OPTIONAL_OF) || Processors.hasAnnotation((Element)method, ClassNames.MULTIBINDS);
    }

    public static void addGeneratedAnnotation(TypeSpec.Builder typeSpecBuilder, ProcessingEnvironment env, Class<?> generatorClass) {
        Processors.addGeneratedAnnotation(typeSpecBuilder, env, generatorClass.getName());
    }

    public static void addGeneratedAnnotation(TypeSpec.Builder typeSpecBuilder, ProcessingEnvironment env, String generatorClass) {
        GeneratedAnnotations.generatedAnnotation(env.getElementUtils(), env.getSourceVersion()).ifPresent(annotation -> typeSpecBuilder.addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((TypeElement)annotation)).addMember("value", "$S", new Object[]{generatorClass}).build()));
    }

    public static AnnotationSpec getOriginatingElementAnnotation(TypeElement element) {
        TypeName rawType = Processors.rawTypeName((TypeName)ClassName.get((TypeElement)Processors.getTopLevelType(element)));
        return AnnotationSpec.builder((ClassName)ClassNames.ORIGINATING_ELEMENT).addMember("topLevelClass", "$T.class", new Object[]{rawType}).build();
    }

    public static TypeName rawTypeName(TypeName typeName) {
        return typeName instanceof ParameterizedTypeName ? ((ParameterizedTypeName)typeName).rawType : typeName;
    }

    public static Optional<TypeElement> getOriginatingTestElement(Element element, Elements elements) {
        TypeElement topLevelType = Processors.getOriginatingTopLevelType(element, elements);
        return Processors.hasAnnotation((Element)topLevelType, ClassNames.HILT_ANDROID_TEST) ? Optional.of(MoreElements.asType(topLevelType)) : Optional.empty();
    }

    private static TypeElement getOriginatingTopLevelType(Element element, Elements elements) {
        TypeElement topLevelType = Processors.getTopLevelType(element);
        if (Processors.hasAnnotation((Element)topLevelType, ClassNames.ORIGINATING_ELEMENT)) {
            return Processors.getOriginatingTopLevelType(Processors.getAnnotationClassValue(elements, Processors.getAnnotationMirror((Element)topLevelType, ClassNames.ORIGINATING_ELEMENT), "topLevelClass"), elements);
        }
        return topLevelType;
    }

    private Processors() {
    }

    private static final class DeclaredTypeAnnotationValueVisitor
    extends SimpleAnnotationValueVisitor7<Void, Set<DeclaredType>> {
        private DeclaredTypeAnnotationValueVisitor() {
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Set<DeclaredType> types) {
            for (AnnotationValue annotationValue : vals) {
                annotationValue.accept(this, types);
            }
            return null;
        }

        @Override
        public Void visitType(TypeMirror t, Set<DeclaredType> types) {
            DeclaredType declared = MoreTypes.asDeclared(t);
            Preconditions.checkNotNull((Object)declared);
            types.add(declared);
            return null;
        }
    }

    private static final class AnnotationMirrorAnnotationValueVisitor
    extends SimpleAnnotationValueVisitor7<Void, Set<AnnotationMirror>> {
        private AnnotationMirrorAnnotationValueVisitor() {
        }

        @Override
        public Void visitArray(List<? extends AnnotationValue> vals, Set<AnnotationMirror> types) {
            for (AnnotationValue annotationValue : vals) {
                annotationValue.accept(this, types);
            }
            return null;
        }

        @Override
        public Void visitAnnotation(AnnotationMirror a, Set<AnnotationMirror> annotationMirrors) {
            annotationMirrors.add(a);
            return null;
        }
    }
}

