/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.kotlin;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.shaded.auto.common.AnnotationMirrors;
import dagger.hilt.android.shaded.auto.common.AnnotationValues;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ElementDescriptors;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_ClassMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_FunctionMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_MethodForAnnotations;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_PropertyMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_ValueParameterMetadata;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlinx.metadata.Flag;
import kotlinx.metadata.KmClassVisitor;
import kotlinx.metadata.KmConstructorExtensionVisitor;
import kotlinx.metadata.KmConstructorVisitor;
import kotlinx.metadata.KmExtensionType;
import kotlinx.metadata.KmFunctionExtensionVisitor;
import kotlinx.metadata.KmFunctionVisitor;
import kotlinx.metadata.KmPropertyExtensionVisitor;
import kotlinx.metadata.KmPropertyVisitor;
import kotlinx.metadata.KmValueParameterVisitor;
import kotlinx.metadata.jvm.JvmConstructorExtensionVisitor;
import kotlinx.metadata.jvm.JvmFieldSignature;
import kotlinx.metadata.jvm.JvmFunctionExtensionVisitor;
import kotlinx.metadata.jvm.JvmMethodSignature;
import kotlinx.metadata.jvm.JvmPropertyExtensionVisitor;
import kotlinx.metadata.jvm.KotlinClassHeader;
import kotlinx.metadata.jvm.KotlinClassMetadata;

@AutoValue
abstract class KotlinMetadata {
    private static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    private final Map<VariableElement, Optional<MethodForAnnotations>> elementFieldAnnotationMethodMap = new HashMap<VariableElement, Optional<MethodForAnnotations>>();
    private final Map<VariableElement, Optional<ExecutableElement>> elementFieldGetterMethodMap = new HashMap<VariableElement, Optional<ExecutableElement>>();

    KotlinMetadata() {
    }

    abstract TypeElement typeElement();

    abstract ClassMetadata classMetadata();

    @Memoized
    ImmutableMap<String, ExecutableElement> methodDescriptors() {
        return (ImmutableMap)ElementFilter.methodsIn(this.typeElement().getEnclosedElements()).stream().collect(DaggerStreams.toImmutableMap(ElementDescriptors::getMethodDescriptor, Function.identity()));
    }

    @Memoized
    boolean containsConstructorWithDefaultParam() {
        return this.classMetadata().constructors().stream().flatMap(constructor -> constructor.parameters().stream()).anyMatch(parameter -> parameter.flags(Flag.ValueParameter.DECLARES_DEFAULT_VALUE));
    }

    Optional<ExecutableElement> getSyntheticAnnotationMethod(VariableElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> {
            if (methodForAnnotations == MethodForAnnotations.MISSING) {
                throw new IllegalStateException("Method for annotations is missing for " + fieldElement);
            }
            return methodForAnnotations.method();
        });
    }

    boolean isMissingSyntheticAnnotationMethod(VariableElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> methodForAnnotations == MethodForAnnotations.MISSING).orElse(false);
    }

    private Optional<MethodForAnnotations> getAnnotationMethod(VariableElement fieldElement) {
        return this.elementFieldAnnotationMethodMap.computeIfAbsent(fieldElement, this::getAnnotationMethodUncached);
    }

    private Optional<MethodForAnnotations> getAnnotationMethodUncached(VariableElement fieldElement) {
        return this.findProperty(fieldElement).methodForAnnotationsSignature().map(signature -> Optional.ofNullable((ExecutableElement)this.methodDescriptors().get(signature)).map(MethodForAnnotations::create).orElse(MethodForAnnotations.MISSING));
    }

    Optional<ExecutableElement> getPropertyGetter(VariableElement fieldElement) {
        return this.elementFieldGetterMethodMap.computeIfAbsent(fieldElement, this::getPropertyGetterUncached);
    }

    private Optional<ExecutableElement> getPropertyGetterUncached(VariableElement fieldElement) {
        return this.findProperty(fieldElement).getterSignature().flatMap(signature -> Optional.ofNullable((ExecutableElement)this.methodDescriptors().get(signature)));
    }

    private PropertyMetadata findProperty(VariableElement field) {
        String fieldDescriptor = ElementDescriptors.getFieldDescriptor(field);
        if (this.classMetadata().propertiesByFieldSignature().containsKey((Object)fieldDescriptor)) {
            return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().get((Object)fieldDescriptor);
        }
        String propertyName = KotlinMetadata.getPropertyNameFromField(field);
        return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().values().stream().filter(property -> propertyName.contentEquals(property.name())).collect(DaggerCollectors.onlyElement());
    }

    private static String getPropertyNameFromField(VariableElement field) {
        String name = field.getSimpleName().toString();
        if (name.endsWith(DELEGATED_PROPERTY_NAME_SUFFIX)) {
            return name.substring(0, name.length() - DELEGATED_PROPERTY_NAME_SUFFIX.length());
        }
        return name;
    }

    FunctionMetadata getFunctionMetadata(ExecutableElement method) {
        return (FunctionMetadata)this.classMetadata().functionsBySignature().get((Object)ElementDescriptors.getMethodDescriptor(method));
    }

    static KotlinMetadata from(TypeElement typeElement) {
        return new AutoValue_KotlinMetadata(typeElement, ClassVisitor.createClassMetadata(KotlinMetadata.metadataOf(typeElement)));
    }

    private static KotlinClassMetadata.Class metadataOf(TypeElement typeElement) {
        AnnotationMirror metadataAnnotation = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)typeElement, ClassNames.KOTLIN_METADATA.canonicalName()).get();
        KotlinClassHeader header = new KotlinClassHeader(Integer.valueOf(KotlinMetadata.getIntValue(metadataAnnotation, "k")), KotlinMetadata.getIntArrayValue(metadataAnnotation, "mv"), KotlinMetadata.getStringArrayValue(metadataAnnotation, "d1"), KotlinMetadata.getStringArrayValue(metadataAnnotation, "d2"), KotlinMetadata.getStringValue(metadataAnnotation, "xs"), (String)KotlinMetadata.getOptionalStringValue(metadataAnnotation, "pn").orElse(null), (Integer)KotlinMetadata.getOptionalIntValue(metadataAnnotation, "xi").orElse(null));
        KotlinClassMetadata metadata = KotlinClassMetadata.read((KotlinClassHeader)header);
        if (metadata == null) {
            throw new IllegalStateException("Unsupported metadata version. Check that your Kotlin version is >= 1.0");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    private static int getIntValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.getInt(AnnotationMirrors.getAnnotationValue(annotation, valueName));
    }

    private static Optional<Integer> getOptionalIntValue(AnnotationMirror annotation, String valueName) {
        return KotlinMetadata.isValuePresent(annotation, valueName) ? Optional.of(KotlinMetadata.getIntValue(annotation, valueName)) : Optional.empty();
    }

    private static int[] getIntArrayValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.getAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().mapToInt(AnnotationValues::getInt).toArray();
    }

    private static String getStringValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.getString(AnnotationMirrors.getAnnotationValue(annotation, valueName));
    }

    private static Optional<String> getOptionalStringValue(AnnotationMirror annotation, String valueName) {
        return KotlinMetadata.isValuePresent(annotation, valueName) ? Optional.of(KotlinMetadata.getStringValue(annotation, valueName)) : Optional.empty();
    }

    private static String[] getStringArrayValue(AnnotationMirror annotation, String valueName) {
        return (String[])AnnotationValues.getAnnotationValues(AnnotationMirrors.getAnnotationValue(annotation, valueName)).stream().map(AnnotationValues::getString).toArray(String[]::new);
    }

    private static boolean isValuePresent(AnnotationMirror annotation, String valueName) {
        return AnnotationMirrors.getAnnotationValuesWithDefaults(annotation).keySet().stream().anyMatch(member -> member.getSimpleName().contentEquals(valueName));
    }

    @AutoValue
    static abstract class MethodForAnnotations {
        static final MethodForAnnotations MISSING = MethodForAnnotations.create(null);

        MethodForAnnotations() {
        }

        static MethodForAnnotations create(ExecutableElement method) {
            return new AutoValue_KotlinMetadata_MethodForAnnotations(method);
        }

        @Nullable
        abstract ExecutableElement method();
    }

    static abstract class BaseMetadata {
        BaseMetadata() {
        }

        abstract int flags();

        boolean flags(Flag flag) {
            return flag.invoke(this.flags());
        }

        abstract String name();

        static interface Builder<BuilderT> {
            public BuilderT flags(int var1);

            public BuilderT name(String var1);
        }
    }

    @AutoValue
    static abstract class ValueParameterMetadata
    extends BaseMetadata {
        ValueParameterMetadata() {
        }

        private static ValueParameterMetadata create(int flags, String name) {
            return new AutoValue_KotlinMetadata_ValueParameterMetadata(flags, name);
        }
    }

    @AutoValue
    static abstract class PropertyMetadata
    extends BaseMetadata {
        PropertyMetadata() {
        }

        abstract Optional<String> fieldSignature();

        abstract Optional<String> getterSignature();

        abstract Optional<String> methodForAnnotationsSignature();

        static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_PropertyMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static interface Builder
        extends BaseMetadata.Builder<Builder> {
            public Builder fieldSignature(Optional<String> var1);

            public Builder getterSignature(Optional<String> var1);

            public Builder methodForAnnotationsSignature(Optional<String> var1);

            public PropertyMetadata build();
        }
    }

    @AutoValue
    static abstract class FunctionMetadata
    extends BaseMetadata {
        FunctionMetadata() {
        }

        abstract String signature();

        abstract ImmutableList<ValueParameterMetadata> parameters();

        static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_FunctionMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder signature(String var1);

            abstract ImmutableList.Builder<ValueParameterMetadata> parametersBuilder();

            Builder addParameter(ValueParameterMetadata parameter) {
                this.parametersBuilder().add((Object)parameter);
                return this;
            }

            abstract FunctionMetadata build();
        }
    }

    @AutoValue
    static abstract class ClassMetadata
    extends BaseMetadata {
        ClassMetadata() {
        }

        abstract Optional<String> companionObjectName();

        abstract ImmutableSet<FunctionMetadata> constructors();

        abstract ImmutableMap<String, FunctionMetadata> functionsBySignature();

        abstract ImmutableMap<String, PropertyMetadata> propertiesByFieldSignature();

        static Builder builder() {
            return new AutoValue_KotlinMetadata_ClassMetadata.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder companionObjectName(String var1);

            abstract ImmutableSet.Builder<FunctionMetadata> constructorsBuilder();

            abstract ImmutableMap.Builder<String, FunctionMetadata> functionsBySignatureBuilder();

            abstract ImmutableMap.Builder<String, PropertyMetadata> propertiesByFieldSignatureBuilder();

            Builder addConstructor(FunctionMetadata constructor) {
                this.constructorsBuilder().add((Object)constructor);
                this.functionsBySignatureBuilder().put((Object)constructor.signature(), (Object)constructor);
                return this;
            }

            Builder addFunction(FunctionMetadata function) {
                this.functionsBySignatureBuilder().put((Object)function.signature(), (Object)function);
                return this;
            }

            Builder addProperty(PropertyMetadata property) {
                if (property.fieldSignature().isPresent()) {
                    this.propertiesByFieldSignatureBuilder().put((Object)property.fieldSignature().get(), (Object)property);
                }
                return this;
            }

            abstract ClassMetadata build();
        }
    }

    private static final class ClassVisitor
    extends KmClassVisitor {
        private final ClassMetadata.Builder classMetadata = ClassMetadata.builder();

        private ClassVisitor() {
        }

        static ClassMetadata createClassMetadata(KotlinClassMetadata.Class data) {
            ClassVisitor visitor = new ClassVisitor();
            data.accept((KmClassVisitor)visitor);
            return visitor.classMetadata.build();
        }

        public void visit(int flags, String name) {
            ((ClassMetadata.Builder)this.classMetadata.flags(flags)).name(name);
        }

        public KmConstructorVisitor visitConstructor(final int flags) {
            return new KmConstructorVisitor(){
                private final FunctionMetadata.Builder constructor;
                {
                    this.constructor = FunctionMetadata.builder(flags, "<init>");
                }

                public KmValueParameterVisitor visitValueParameter(int flags2, String name) {
                    this.constructor.addParameter(ValueParameterMetadata.create(flags2, name));
                    return super.visitValueParameter(flags2, name);
                }

                public KmConstructorExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    return kmExtensionType.equals((Object)JvmConstructorExtensionVisitor.TYPE) ? new JvmConstructorExtensionVisitor(){

                        public void visit(JvmMethodSignature jvmMethodSignature) {
                            constructor.signature(jvmMethodSignature.asString());
                        }
                    } : null;
                }

                public void visitEnd() {
                    classMetadata.addConstructor(this.constructor.build());
                }
            };
        }

        public KmFunctionVisitor visitFunction(final int flags, final String name) {
            return new KmFunctionVisitor(){
                private final FunctionMetadata.Builder function;
                {
                    this.function = FunctionMetadata.builder(flags, name);
                }

                public KmValueParameterVisitor visitValueParameter(int flags2, String name2) {
                    this.function.addParameter(ValueParameterMetadata.create(flags2, name2));
                    return super.visitValueParameter(flags2, name2);
                }

                public KmFunctionExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    return kmExtensionType.equals((Object)JvmFunctionExtensionVisitor.TYPE) ? new JvmFunctionExtensionVisitor(){

                        public void visit(JvmMethodSignature jvmMethodSignature) {
                            function.signature(jvmMethodSignature.asString());
                        }
                    } : null;
                }

                public void visitEnd() {
                    classMetadata.addFunction(this.function.build());
                }
            };
        }

        public void visitCompanionObject(String companionObjectName) {
            this.classMetadata.companionObjectName(companionObjectName);
        }

        public KmPropertyVisitor visitProperty(final int flags, final String name, int getterFlags, int setterFlags) {
            return new KmPropertyVisitor(){
                private final PropertyMetadata.Builder property;
                {
                    this.property = PropertyMetadata.builder(flags, name);
                }

                public KmPropertyExtensionVisitor visitExtensions(KmExtensionType kmExtensionType) {
                    if (!kmExtensionType.equals((Object)JvmPropertyExtensionVisitor.TYPE)) {
                        return null;
                    }
                    return new JvmPropertyExtensionVisitor(){

                        public void visit(int jvmFlags, @Nullable JvmFieldSignature jvmFieldSignature, @Nullable JvmMethodSignature jvmGetterSignature, @Nullable JvmMethodSignature jvmSetterSignature) {
                            property.fieldSignature(Optional.ofNullable(jvmFieldSignature).map(JvmFieldSignature::asString));
                            property.getterSignature(Optional.ofNullable(jvmGetterSignature).map(JvmMethodSignature::asString));
                        }

                        public void visitSyntheticMethodForAnnotations(@Nullable JvmMethodSignature methodSignature) {
                            property.methodForAnnotationsSignature(Optional.ofNullable(methodSignature).map(JvmMethodSignature::asString));
                        }
                    };
                }

                public void visitEnd() {
                    classMetadata.addProperty(this.property.build());
                }
            };
        }
    }
}

