/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.viewmodel;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.ImmutableNetwork;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.processor.internal.DaggerModelsKt;
import dagger.spi.model.Binding;
import dagger.spi.model.BindingGraph;
import dagger.spi.model.BindingGraphPlugin;
import dagger.spi.model.BindingKind;
import dagger.spi.model.DaggerAnnotation;
import dagger.spi.model.DaggerElement;
import dagger.spi.model.DaggerType;
import dagger.spi.model.DiagnosticReporter;
import javax.tools.Diagnostic;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Ldagger/hilt/android/processor/internal/viewmodel/ViewModelValidationPlugin;", "Ldagger/spi/model/BindingGraphPlugin;", "()V", "isHiltViewModelBinding", "", "target", "Ldagger/spi/model/Binding;", "isInternalHiltViewModelUsage", "source", "Ldagger/spi/model/BindingGraph$Node;", "visitGraph", "", "bindingGraph", "Ldagger/spi/model/BindingGraph;", "diagnosticReporter", "Ldagger/spi/model/DiagnosticReporter;", "java_dagger_hilt_android_processor_internal_viewmodel-validation_plugin_lib"})
@AutoService(value={BindingGraphPlugin.class})
@SourceDebugExtension(value={"SMAP\nViewModelValidationPlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ViewModelValidationPlugin.kt\ndagger/hilt/android/processor/internal/viewmodel/ViewModelValidationPlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,90:1\n1855#2,2:91\n*S KotlinDebug\n*F\n+ 1 ViewModelValidationPlugin.kt\ndagger/hilt/android/processor/internal/viewmodel/ViewModelValidationPlugin\n*L\n46#1:91,2\n*E\n"})
public final class ViewModelValidationPlugin
implements BindingGraphPlugin {
    public void visitGraph(@NotNull BindingGraph bindingGraph, @NotNull DiagnosticReporter diagnosticReporter) {
        Intrinsics.checkNotNullParameter((Object)bindingGraph, (String)"bindingGraph");
        Intrinsics.checkNotNullParameter((Object)diagnosticReporter, (String)"diagnosticReporter");
        if (bindingGraph.rootComponentNode().isSubcomponent()) {
            return;
        }
        ImmutableNetwork immutableNetwork = bindingGraph.network();
        Intrinsics.checkNotNullExpressionValue((Object)immutableNetwork, (String)"bindingGraph.network()");
        ImmutableNetwork network = immutableNetwork;
        ImmutableSet immutableSet = bindingGraph.dependencyEdges();
        Intrinsics.checkNotNullExpressionValue((Object)immutableSet, (String)"bindingGraph.dependencyEdges()");
        Iterable $this$forEach$iv = (Iterable)immutableSet;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EndpointPair pair;
            BindingGraph.DependencyEdge edge = (BindingGraph.DependencyEdge)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)network.incidentNodes((Object)edge), (String)"network.incidentNodes(edge)");
            Object object = pair.target();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pair.target()");
            BindingGraph.Node target = (BindingGraph.Node)object;
            Object object2 = pair.source();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"pair.source()");
            BindingGraph.Node source = (BindingGraph.Node)object2;
            if (!(target instanceof Binding) || !this.isHiltViewModelBinding((Binding)target) || this.isInternalHiltViewModelUsage(source)) continue;
            diagnosticReporter.reportDependency(Diagnostic.Kind.ERROR, edge, "\nInjection of an @HiltViewModel class is prohibited since it does not create a ViewModel instance correctly.\nAccess the ViewModel via the Android APIs (e.g. ViewModelProvider) instead.\nInjected ViewModel: " + ((Binding)target).key().type() + '\n');
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isHiltViewModelBinding(Binding target) {
        if (target.kind() != BindingKind.INJECTION) return false;
        DaggerType daggerType = target.key().type();
        Intrinsics.checkNotNullExpressionValue((Object)daggerType, (String)"target.key().type()");
        DaggerElement daggerElement = DaggerModelsKt.asElement(daggerType);
        ClassName className = AndroidClassNames.HILT_VIEW_MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)className, (String)"HILT_VIEW_MODEL");
        if (!DaggerModelsKt.hasAnnotation(daggerElement, className)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInternalHiltViewModelUsage(BindingGraph.Node source) {
        if (!(source instanceof Binding)) return false;
        if (!((Binding)source).key().qualifier().isPresent()) return false;
        Object t = ((Binding)source).key().qualifier().get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"source.key().qualifier().get()");
        if (!Intrinsics.areEqual((Object)DaggerModelsKt.getQualifiedName((DaggerAnnotation)t), (Object)AndroidClassNames.HILT_VIEW_MODEL_MAP_QUALIFIER.canonicalName())) return false;
        if (!((Binding)source).key().multibindingContributionIdentifier().isPresent()) return false;
        return true;
    }
}

