/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.BaseProcessingStep;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponentClassesMetadata;
import dagger.hilt.processor.internal.earlyentrypoint.AggregatedEarlyEntryPointMetadata;
import dagger.hilt.processor.internal.generatesrootinput.GeneratesRootInputs;
import dagger.hilt.processor.internal.root.AggregatedRootGenerator;
import dagger.hilt.processor.internal.root.AggregatedRootMetadata;
import dagger.hilt.processor.internal.root.ComponentTreeDepsGenerator;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.ProcessedRootSentinelGenerator;
import dagger.hilt.processor.internal.root.ProcessedRootSentinelMetadata;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootType;
import dagger.hilt.processor.internal.root.TestInjectorGenerator;
import dagger.hilt.processor.internal.root.TestRootMetadata;
import dagger.hilt.processor.internal.root.ir.AggregatedDepsIr;
import dagger.hilt.processor.internal.root.ir.AggregatedEarlyEntryPointIr;
import dagger.hilt.processor.internal.root.ir.AggregatedRootIr;
import dagger.hilt.processor.internal.root.ir.AggregatedRootIrValidator;
import dagger.hilt.processor.internal.root.ir.AggregatedUninstallModulesIr;
import dagger.hilt.processor.internal.root.ir.AliasOfPropagatedDataIr;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIr;
import dagger.hilt.processor.internal.root.ir.ComponentTreeDepsIrCreator;
import dagger.hilt.processor.internal.root.ir.DefineComponentClassesIr;
import dagger.hilt.processor.internal.root.ir.InvalidRootsException;
import dagger.hilt.processor.internal.root.ir.ProcessedRootSentinelIr;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFiler;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Arrays;
import java.util.Set;

public final class RootProcessingStep
extends BaseProcessingStep {
    private boolean processed;
    private GeneratesRootInputs generatesRootInputs = new GeneratesRootInputs(this.processingEnv());

    public RootProcessingStep(XProcessingEnv env) {
        super(env);
    }

    private XFiler.Mode getMode() {
        return HiltCompilerOptions.useAggregatingRootProcessor(this.processingEnv()) ? XFiler.Mode.Aggregating : XFiler.Mode.Isolating;
    }

    @Override
    protected ImmutableSet<ClassName> annotationClassNames() {
        return (ImmutableSet)Arrays.stream(RootType.values()).map(RootType::className).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    public void processEach(ClassName annotation, XElement element) throws Exception {
        XTypeElement rootElement = XElements.asTypeElement((XElement)element);
        RootType rootType = RootType.of(rootElement);
        if (rootType.isTestRoot()) {
            new TestInjectorGenerator(this.processingEnv(), TestRootMetadata.of(this.processingEnv(), (XElement)rootElement)).generate();
        }
        XTypeElement originatingRootElement = Root.create((XElement)rootElement, this.processingEnv()).originatingRootElement();
        new AggregatedRootGenerator(rootElement, originatingRootElement, this.processingEnv().requireTypeElement((TypeName)annotation)).generate();
    }

    @Override
    protected void postProcess(XProcessingEnv env, XRoundEnv roundEnv) throws Exception {
        if (!HiltCompilerOptions.useAggregatingRootProcessor(this.processingEnv())) {
            return;
        }
        ImmutableSet newElements = (ImmutableSet)this.generatesRootInputs.getElementsToWaitFor(roundEnv).stream().collect(DaggerStreams.toImmutableSet());
        if (this.processed) {
            Preconditions.checkState((boolean)newElements.isEmpty(), (String)"Found extra modules after compilation: %s\n(If you are adding an annotation processor that generates root input for hilt, the annotation must be annotated with @dagger.hilt.GeneratesRootInput.\n)", newElements.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
        } else if (newElements.isEmpty()) {
            this.processed = true;
            ImmutableSet<AggregatedRootIr> rootsToProcess = this.rootsToProcess();
            if (rootsToProcess.isEmpty()) {
                return;
            }
            ComponentTreeDepsGenerator componentTreeDepsGenerator = new ComponentTreeDepsGenerator(this.processingEnv(), this.getMode());
            for (ComponentTreeDepsMetadata metadata : this.componentTreeDepsMetadatas(rootsToProcess)) {
                componentTreeDepsGenerator.generate(metadata);
            }
            for (AggregatedRootIr ir : rootsToProcess) {
                XTypeElement rootElement = this.processingEnv().requireTypeElement(ir.getRoot().canonicalName());
                new ProcessedRootSentinelGenerator(rootElement, this.getMode()).generate();
            }
        }
    }

    private ImmutableSet<AggregatedRootIr> rootsToProcess() {
        ImmutableSet processedRoots = (ImmutableSet)ProcessedRootSentinelMetadata.from(this.processingEnv()).stream().map(ProcessedRootSentinelMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedRoots = (ImmutableSet)AggregatedRootMetadata.from(this.processingEnv()).stream().map(AggregatedRootMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        boolean isCrossCompilationRootValidationDisabled = HiltCompilerOptions.isCrossCompilationRootValidationDisabled((ImmutableSet<XTypeElement>)((ImmutableSet)aggregatedRoots.stream().map(ir -> this.processingEnv().requireTypeElement(ir.getRoot().canonicalName())).collect(DaggerStreams.toImmutableSet())), this.processingEnv());
        try {
            return ImmutableSet.copyOf(AggregatedRootIrValidator.rootsToProcess(isCrossCompilationRootValidationDisabled, (Set<ProcessedRootSentinelIr>)processedRoots, (Set<AggregatedRootIr>)aggregatedRoots));
        }
        catch (InvalidRootsException ex) {
            throw new BadInputException(ex.getMessage());
        }
    }

    private ImmutableSet<ComponentTreeDepsMetadata> componentTreeDepsMetadatas(ImmutableSet<AggregatedRootIr> aggregatedRoots) {
        ImmutableSet defineComponentDeps = (ImmutableSet)DefineComponentClassesMetadata.from(this.processingEnv()).stream().map(DefineComponentClassesMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aliasOfDeps = (ImmutableSet)AliasOfPropagatedDataMetadata.from(this.processingEnv()).stream().map(AliasOfPropagatedDataMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedDeps = (ImmutableSet)AggregatedDepsMetadata.from(this.processingEnv()).stream().map(AggregatedDepsMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedUninstallModulesDeps = (ImmutableSet)AggregatedUninstallModulesMetadata.from(this.processingEnv()).stream().map(AggregatedUninstallModulesMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        ImmutableSet aggregatedEarlyEntryPointDeps = (ImmutableSet)AggregatedEarlyEntryPointMetadata.from(this.processingEnv()).stream().map(AggregatedEarlyEntryPointMetadata::toIr).collect(DaggerStreams.toImmutableSet());
        boolean isTest = aggregatedRoots.stream().anyMatch(AggregatedRootIr::isTestRoot);
        Set<ComponentTreeDepsIr> componentTreeDeps = ComponentTreeDepsIrCreator.components(isTest, HiltCompilerOptions.isSharedTestComponentsEnabled(this.processingEnv()), aggregatedRoots, (Set<DefineComponentClassesIr>)defineComponentDeps, (Set<AliasOfPropagatedDataIr>)aliasOfDeps, (Set<AggregatedDepsIr>)aggregatedDeps, (Set<AggregatedUninstallModulesIr>)aggregatedUninstallModulesDeps, (Set<AggregatedEarlyEntryPointIr>)aggregatedEarlyEntryPointDeps);
        return (ImmutableSet)componentTreeDeps.stream().map(it -> ComponentTreeDepsMetadata.from(it, this.processingEnv())).collect(DaggerStreams.toImmutableSet());
    }
}

