/*
 * Copyright (C) 2023 The Dagger Authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package dagger.hilt.processor.internal.originatingelement;

import com.google.auto.service.AutoService;
import com.google.devtools.ksp.processing.SymbolProcessor;
import com.google.devtools.ksp.processing.SymbolProcessorEnvironment;
import com.google.devtools.ksp.processing.SymbolProcessorProvider;
import dagger.hilt.processor.internal.BaseProcessingStep;
import dagger.hilt.processor.internal.KspBaseProcessingStepProcessor;

/**
 * Processes the annotations annotated with {@link dagger.hilt.codegen.OriginatingElement} to check
 * that they're only used on top-level classes and the value passed is also a top-level class.
 */
public final class KspOriginatingElementProcessor extends KspBaseProcessingStepProcessor {
  private KspOriginatingElementProcessor(SymbolProcessorEnvironment symbolProcessorEnvironment) {
    super(symbolProcessorEnvironment);
  }

  @Override
  protected BaseProcessingStep processingStep() {
    return new OriginatingElementProcessingStep(getXProcessingEnv());
  }

  /** Provides the {@link KspOriginatingElemenetProcessor}. */
  @AutoService(SymbolProcessorProvider.class)
  public static final class Provider implements SymbolProcessorProvider {
    @Override
    public SymbolProcessor create(SymbolProcessorEnvironment symbolProcessorEnvironment) {
      return new KspOriginatingElementProcessor(symbolProcessorEnvironment);
    }
  }
}
