/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;

final class AggregatedRootGenerator {
    private final XTypeElement rootElement;
    private final XTypeElement originatingRootElement;
    private final XTypeElement rootAnnotation;

    AggregatedRootGenerator(XTypeElement rootElement, XTypeElement originatingRootElement, XTypeElement rootAnnotation) {
        this.rootElement = rootElement;
        this.originatingRootElement = originatingRootElement;
        this.rootAnnotation = rootAnnotation;
    }

    void generate() {
        AnnotationSpec.Builder aggregatedRootAnnotation = AnnotationSpec.builder((ClassName)ClassNames.AGGREGATED_ROOT).addMember("root", "$S", new Object[]{this.rootElement.getQualifiedName()}).addMember("rootPackage", "$S", new Object[]{this.rootElement.getClassName().packageName()}).addMember("originatingRoot", "$S", new Object[]{this.originatingRootElement.getQualifiedName()}).addMember("originatingRootPackage", "$S", new Object[]{this.originatingRootElement.getClassName().packageName()}).addMember("rootAnnotation", "$T.class", new Object[]{this.rootAnnotation.getClassName()});
        this.rootElement.getClassName().simpleNames().forEach(name -> aggregatedRootAnnotation.addMember("rootSimpleNames", "$S", new Object[]{name}));
        this.originatingRootElement.getClassName().simpleNames().forEach(name -> aggregatedRootAnnotation.addMember("originatingRootSimpleNames", "$S", new Object[]{name}));
        Processors.generateAggregatingClass("dagger.hilt.internal.aggregatedroot.codegen", aggregatedRootAnnotation.build(), this.rootElement, this.getClass());
    }
}

