/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import dagger.hilt.android.plugin.util.FilesKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.ByteArray;
import javassist.bytecode.Bytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J \u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J1\u0010\u001f\u001a\u00020\u001a*\u00020 2#\u0010!\u001a\u001f\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001a0\"\u00a2\u0006\u0002\b$H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006&"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassTransformer;", "", "taskName", "", "allInputs", "", "Ljava/io/File;", "sourceRootOutputDir", "copyNonTransformed", "", "(Ljava/lang/String;Ljava/util/List;Ljava/io/File;Z)V", "classPool", "Ljavassist/ClassPool;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getTaskName", "()Ljava/lang/String;", "transformClass", "clazz", "Ljavassist/CtClass;", "transformClassToOutput", "transformFile", "inputFile", "transformJarContents", "transformOnReceive", "", "entryPointSuperclassName", "transformSuperMethodCalls", "oldSuperclassName", "newSuperclassName", "forEachInstruction", "Ljavassist/bytecode/CodeIterator;", "body", "Lkotlin/Function3;", "", "Lkotlin/ExtensionFunctionType;", "Companion", "plugin"})
public final class AndroidEntryPointClassTransformer {
    private final Logger logger;
    private final ClassPool classPool;
    @NotNull
    private final String taskName;
    private final File sourceRootOutputDir;
    private final boolean copyNonTransformed;
    @NotNull
    private static final Set<String> ANDROID_ENTRY_POINT_ANNOTATIONS;
    @NotNull
    private static final String ON_RECEIVE_METHOD_NAME;
    @NotNull
    private static final String ON_RECEIVE_METHOD_SIGNATURE;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean transformJarContents(@NotNull File inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        boolean bl = FilesKt.isJarFile(inputFile);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid file, '" + inputFile + "' is not a jar.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        bl = !this.copyNonTransformed;
        bl2 = false;
        bl3 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Transforming a jar is not supported with 'copyNonTransformed'.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean transformed = false;
        Closeable closeable = new ZipInputStream(new FileInputStream(inputFile));
        bl3 = false;
        Throwable throwable = null;
        try {
            ZipInputStream input = (ZipInputStream)closeable;
            boolean bl6 = false;
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                if (FilesKt.isClassFile(entry)) {
                    CtClass clazz;
                    CtClass ctClass = clazz = this.classPool.makeClass((InputStream)input, false);
                    Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"clazz");
                    transformed = this.transformClassToOutput(ctClass) || transformed;
                }
                entry = input.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return transformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean transformFile(@NotNull File inputFile) {
        CtClass clazz;
        CtClass ctClass;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        boolean bl = FilesKt.isClassFile(inputFile);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Invalid file, '" + inputFile + "' is not a class.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object object = inputFile;
        bl3 = false;
        object = new FileInputStream((File)object);
        bl3 = false;
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)object;
            boolean bl5 = false;
            ctClass = this.classPool.makeClass((InputStream)it, false);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        CtClass ctClass2 = clazz = ctClass;
        Intrinsics.checkNotNullExpressionValue((Object)ctClass2, (String)"clazz");
        return this.transformClassToOutput(ctClass2);
    }

    private final boolean transformClassToOutput(CtClass clazz) {
        boolean transformed = this.transformClass(clazz);
        if (transformed || this.copyNonTransformed) {
            clazz.writeFile(this.sourceRootOutputDir.getPath());
        }
        return transformed;
    }

    private final boolean transformClass(CtClass clazz) {
        boolean bl;
        String entryPointSuperclassName;
        block7: {
            boolean bl2;
            block6: {
                Iterable $this$none$iv = ANDROID_ENTRY_POINT_ANNOTATIONS;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!clazz.hasAnnotation(it)) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return false;
            }
            ClassFile classFile = clazz.getClassFile();
            Intrinsics.checkNotNullExpressionValue((Object)classFile, (String)"clazz.classFile");
            String superclassName = classFile.getSuperclass();
            StringBuilder stringBuilder = new StringBuilder().append(clazz.getPackageName()).append(".Hilt_");
            String string = clazz.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"clazz.simpleName");
            entryPointSuperclassName = stringBuilder.append(StringsKt.replace$default((String)string, (String)"$", (String)"_", (boolean)false, (int)4, null)).toString();
            this.logger.info('[' + this.taskName + "] Transforming " + clazz.getName() + " to extend " + entryPointSuperclassName + " instead of " + superclassName + '.');
            CtClass entryPointSuperclass = this.classPool.get(entryPointSuperclassName);
            clazz.setSuperclass(entryPointSuperclass);
            String string2 = superclassName;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"superclassName");
            this.transformSuperMethodCalls(clazz, string2, entryPointSuperclassName);
            CtClass ctClass = entryPointSuperclass;
            Intrinsics.checkNotNullExpressionValue((Object)ctClass, (String)"entryPointSuperclass");
            CtField[] ctFieldArray = ctClass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)ctFieldArray, (String)"entryPointSuperclass.declaredFields");
            CtField[] $this$any$iv = ctFieldArray;
            boolean $i$f$any = false;
            CtField[] ctFieldArray2 = $this$any$iv;
            int n = ctFieldArray2.length;
            for (int i = 0; i < n; ++i) {
                CtField element$iv;
                CtField it = element$iv = ctFieldArray2[i];
                boolean bl4 = false;
                CtField ctField = it;
                Intrinsics.checkNotNullExpressionValue((Object)ctField, (String)"it");
                if (!Intrinsics.areEqual((Object)ctField.getName(), (Object)"onReceiveBytecodeInjectionMarker")) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            this.transformOnReceive(clazz, entryPointSuperclassName);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSuperMethodCalls(CtClass clazz, String oldSuperclassName, String newSuperclassName) {
        void $this$filterTo$iv$iv;
        ClassFile classFile = clazz.getClassFile();
        Intrinsics.checkNotNullExpressionValue((Object)classFile, (String)"clazz.classFile");
        ConstPool constantPool = classFile.getConstPool();
        CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)ctMethodArray, (String)"clazz.declaredMethods");
        CtMethod[] $this$filter$iv = ctMethodArray;
        boolean $i$f$filter = false;
        CtMethod[] ctMethodArray2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        void var10_11 = $this$filterTo$iv$iv;
        int n = ((void)var10_11).length;
        for (int i = 0; i < n; ++i) {
            void element$iv$iv;
            void it = element$iv$iv = var10_11[i];
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            MethodInfo methodInfo = v2.getMethodInfo();
            Intrinsics.checkNotNullExpressionValue((Object)methodInfo, (String)"it.methodInfo");
            if (!(methodInfo.isMethod() && !Modifier.isStatic((int)it.getModifiers()) && !Modifier.isAbstract((int)it.getModifiers()) && !Modifier.isNative((int)it.getModifiers()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeAttribute codeAttr;
            CtMethod method = (CtMethod)element$iv;
            boolean bl = false;
            CtMethod ctMethod = method;
            Intrinsics.checkNotNullExpressionValue((Object)ctMethod, (String)"method");
            MethodInfo methodInfo = ctMethod.getMethodInfo();
            Intrinsics.checkNotNullExpressionValue((Object)methodInfo, (String)"method.methodInfo");
            CodeAttribute codeAttribute = codeAttr = methodInfo.getCodeAttribute();
            Intrinsics.checkNotNullExpressionValue((Object)codeAttribute, (String)"codeAttr");
            byte[] code = codeAttribute.getCode();
            CodeIterator codeIterator = codeAttr.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)codeIterator, (String)"codeAttr.iterator()");
            this.forEachInstruction(codeIterator, (Function3<? super CodeIterator, ? super Integer, ? super Integer, Unit>)((Function3)new Function3<CodeIterator, Integer, Integer, Unit>(code, method, this, constantPool, oldSuperclassName, newSuperclassName, clazz){
                final /* synthetic */ byte[] $code;
                final /* synthetic */ CtMethod $method;
                final /* synthetic */ AndroidEntryPointClassTransformer this$0;
                final /* synthetic */ ConstPool $constantPool$inlined;
                final /* synthetic */ String $oldSuperclassName$inlined;
                final /* synthetic */ String $newSuperclassName$inlined;
                final /* synthetic */ CtClass $clazz$inlined;
                {
                    this.$code = byArray;
                    this.$method = ctMethod;
                    this.this$0 = androidEntryPointClassTransformer;
                    this.$constantPool$inlined = constPool;
                    this.$oldSuperclassName$inlined = string;
                    this.$newSuperclassName$inlined = string2;
                    this.$clazz$inlined = ctClass;
                    super(3);
                }

                public final void invoke(@NotNull CodeIterator $this$forEachInstruction, int index, int opcode) {
                    Intrinsics.checkNotNullParameter((Object)$this$forEachInstruction, (String)"$receiver");
                    if (opcode != 183) {
                        return;
                    }
                    int methodRef = ByteArray.readU16bit((byte[])this.$code, (int)(index + 1));
                    String currentClassRef = this.$constantPool$inlined.getMethodrefClassName(methodRef);
                    if (Intrinsics.areEqual((Object)currentClassRef, (Object)this.$oldSuperclassName$inlined) ^ true) {
                        return;
                    }
                    int nameAndTypeRef = this.$constantPool$inlined.getMethodrefNameAndType(methodRef);
                    int newSuperclassRef = this.$constantPool$inlined.addClassInfo(this.$newSuperclassName$inlined);
                    int newMethodRef = this.$constantPool$inlined.addMethodrefInfo(newSuperclassRef, nameAndTypeRef);
                    Logger logger = AndroidEntryPointClassTransformer.access$getLogger$p(this.this$0);
                    StringBuilder stringBuilder = new StringBuilder().append('[').append(this.this$0.getTaskName()).append("] Redirecting an invokespecial in ").append(this.$clazz$inlined.getName()).append('.');
                    CtMethod ctMethod = this.$method;
                    Intrinsics.checkNotNullExpressionValue((Object)ctMethod, (String)"method");
                    StringBuilder stringBuilder2 = stringBuilder.append(ctMethod.getName()).append(':');
                    CtMethod ctMethod2 = this.$method;
                    Intrinsics.checkNotNullExpressionValue((Object)ctMethod2, (String)"method");
                    logger.info(stringBuilder2.append(ctMethod2.getSignature()).append(" at code index ").append(index).append(" from ").append("method ref #").append(methodRef).append(" to #").append(newMethodRef).append('.').toString());
                    ByteArray.write16bit((int)newMethodRef, (byte[])this.$code, (int)(index + 1));
                }
            }));
        }
    }

    private final void forEachInstruction(CodeIterator $this$forEachInstruction, Function3<? super CodeIterator, ? super Integer, ? super Integer, Unit> body) {
        while ($this$forEachInstruction.hasNext()) {
            int index = $this$forEachInstruction.next();
            body.invoke((Object)$this$forEachInstruction, (Object)index, (Object)$this$forEachInstruction.byteAt(index));
        }
    }

    private final void transformOnReceive(CtClass clazz, String entryPointSuperclassName) {
        CodeAttribute currentCodeAttribute;
        CtMethod element$iv;
        int n;
        int n2;
        Bytecode bytecode;
        block2: {
            Bytecode bytecode2 = clazz.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)bytecode2, (String)"clazz.declaredMethods");
            Bytecode $this$first$iv = bytecode2;
            boolean $i$f$first = false;
            bytecode = $this$first$iv;
            n2 = ((CtMethod[])bytecode).length;
            for (n = 0; n < n2; ++n) {
                CtMethod it = element$iv = bytecode[n];
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                CtMethod ctMethod = it;
                Intrinsics.checkNotNullExpressionValue((Object)ctMethod, (String)"it");
                if (!Intrinsics.areEqual((Object)stringBuilder.append(ctMethod.getName()).append(it.getSignature()).toString(), (Object)(ON_RECEIVE_METHOD_NAME + ON_RECEIVE_METHOD_SIGNATURE))) {
                    continue;
                }
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        CtMethod method = element$iv;
        ClassFile classFile = clazz.getClassFile();
        Intrinsics.checkNotNullExpressionValue((Object)classFile, (String)"clazz.classFile");
        ConstPool constantPool = classFile.getConstPool();
        bytecode = new Bytecode(constantPool);
        n2 = 0;
        n = 0;
        Bytecode $this$apply22 = bytecode;
        boolean bl = false;
        $this$apply22.addAload(0);
        $this$apply22.addAload(1);
        $this$apply22.addAload(2);
        $this$apply22.addInvokespecial(entryPointSuperclassName, ON_RECEIVE_METHOD_NAME, ON_RECEIVE_METHOD_SIGNATURE);
        Bytecode newCode = bytecode;
        CodeAttribute newCodeAttribute = newCode.toCodeAttribute();
        CtMethod ctMethod = method;
        Intrinsics.checkNotNullExpressionValue((Object)ctMethod, (String)"method");
        MethodInfo methodInfo = ctMethod.getMethodInfo();
        Intrinsics.checkNotNullExpressionValue((Object)methodInfo, (String)"method.methodInfo");
        CodeAttribute codeAttribute = currentCodeAttribute = methodInfo.getCodeAttribute();
        Intrinsics.checkNotNullExpressionValue((Object)codeAttribute, (String)"currentCodeAttribute");
        CodeAttribute codeAttribute2 = newCodeAttribute;
        Intrinsics.checkNotNullExpressionValue((Object)codeAttribute2, (String)"newCodeAttribute");
        n = codeAttribute2.getMaxStack();
        int $this$apply22 = currentCodeAttribute.getMaxStack();
        boolean bl2 = false;
        codeAttribute.setMaxStack(Math.max(n, $this$apply22));
        n = newCodeAttribute.getMaxLocals();
        $this$apply22 = currentCodeAttribute.getMaxLocals();
        bl2 = false;
        currentCodeAttribute.setMaxLocals(Math.max(n, $this$apply22));
        CodeIterator codeIterator = currentCodeAttribute.iterator();
        int pos = codeIterator.insertEx(newCode.get());
        codeIterator.insert(newCodeAttribute.getExceptionTable(), pos);
        method.getMethodInfo().rebuildStackMap(clazz.getClassPool());
    }

    @NotNull
    public final String getTaskName() {
        return this.taskName;
    }

    /*
     * WARNING - void declaration
     */
    public AndroidEntryPointClassTransformer(@NotNull String taskName, @NotNull List<? extends File> allInputs, @NotNull File sourceRootOutputDir, boolean copyNonTransformed) {
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter(allInputs, (String)"allInputs");
        Intrinsics.checkNotNullParameter((Object)sourceRootOutputDir, (String)"sourceRootOutputDir");
        this.taskName = taskName;
        this.sourceRootOutputDir = sourceRootOutputDir;
        this.copyNonTransformed = copyNonTransformed;
        this.logger = LoggerFactory.getLogger(AndroidEntryPointClassTransformer.class);
        ClassPool classPool = new ClassPool(true);
        boolean bl = false;
        boolean bl2 = false;
        ClassPool classPool2 = classPool;
        AndroidEntryPointClassTransformer androidEntryPointClassTransformer = this;
        boolean bl3 = false;
        Iterable $this$forEach$iv = allInputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void pool;
            File it = (File)element$iv;
            boolean bl4 = false;
            pool.appendClassPath(it.getPath());
        }
        Unit unit = Unit.INSTANCE;
        androidEntryPointClassTransformer.classPool = classPool;
        this.sourceRootOutputDir.mkdirs();
    }

    static {
        Companion = new Companion(null);
        ANDROID_ENTRY_POINT_ANNOTATIONS = SetsKt.setOf((Object[])new String[]{"dagger.hilt.android.AndroidEntryPoint", "dagger.hilt.android.HiltAndroidApp"});
        ON_RECEIVE_METHOD_NAME = "onReceive";
        ON_RECEIVE_METHOD_SIGNATURE = "(Landroid/content/Context;Landroid/content/Intent;)V";
    }

    public static final /* synthetic */ Logger access$getLogger$p(AndroidEntryPointClassTransformer $this) {
        return $this.logger;
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassTransformer$Companion;", "", "()V", "ANDROID_ENTRY_POINT_ANNOTATIONS", "", "", "getANDROID_ENTRY_POINT_ANNOTATIONS", "()Ljava/util/Set;", "ON_RECEIVE_METHOD_NAME", "getON_RECEIVE_METHOD_NAME", "()Ljava/lang/String;", "ON_RECEIVE_METHOD_SIGNATURE", "getON_RECEIVE_METHOD_SIGNATURE", "plugin"})
    public static final class Companion {
        @NotNull
        public final Set<String> getANDROID_ENTRY_POINT_ANNOTATIONS() {
            return ANDROID_ENTRY_POINT_ANNOTATIONS;
        }

        @NotNull
        public final String getON_RECEIVE_METHOD_NAME() {
            return ON_RECEIVE_METHOD_NAME;
        }

        @NotNull
        public final String getON_RECEIVE_METHOD_SIGNATURE() {
            return ON_RECEIVE_METHOD_SIGNATURE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

