/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import com.android.build.api.attributes.BuildTypeAttr;
import com.android.build.api.attributes.ProductFlavorAttr;
import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.api.transform.Transform;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.TestedExtension;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.internal.dsl.AnnotationProcessorOptions;
import com.android.builder.model.BuildType;
import com.android.builder.model.ProductFlavor;
import dagger.hilt.android.plugin.AndroidEntryPointClassVisitor;
import dagger.hilt.android.plugin.AndroidEntryPointTransform;
import dagger.hilt.android.plugin.HiltExtension;
import dagger.hilt.android.plugin.HiltExtensionImpl;
import dagger.hilt.android.plugin.HiltGradlePlugin;
import dagger.hilt.android.plugin.VersionKt;
import dagger.hilt.android.plugin.task.AggregateDepsTask;
import dagger.hilt.android.plugin.task.HiltTransformTestClassesTask;
import dagger.hilt.android.plugin.util.AggregatedPackagesTransform;
import dagger.hilt.android.plugin.util.AndroidComponentsExtensionCompat;
import dagger.hilt.android.plugin.util.ComponentCompat;
import dagger.hilt.android.plugin.util.CopyTransform;
import dagger.hilt.android.plugin.util.FilesKt;
import dagger.hilt.android.plugin.util.SimpleAGPVersion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.ProjectState;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001c\u001a\n \u0013*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J/\u0010!\u001a\u00020\t*\u00020\u00182!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\t0#H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "apply", "", "project", "configureAggregatingTask", "hiltExtension", "Ldagger/hilt/android/plugin/HiltExtension;", "configureBytecodeTransform", "configureBytecodeTransformASM", "configureCompileClasspath", "configureDependencyTransforms", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "kotlin.jvm.PlatformType", "configureHilt", "configureProcessorFlags", "configureVariantAggregatingTask", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "configureVariantCompileClasspath", "getAndroidJar", "Lorg/gradle/api/file/ConfigurableFileCollection;", "compileSdkVersion", "", "verifyDependencies", "forEachRootVariant", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Companion", "plugin"})
public final class HiltGradlePlugin
implements Plugin<Project> {
    @NotNull
    private final ProviderFactory providers;
    private static final Attribute<String> ARTIFACT_TYPE_ATTRIBUTE;
    @NotNull
    public static final String DAGGER_ARTIFACT_TYPE_VALUE = "jar-for-dagger";
    @NotNull
    public static final String AGGREGATED_HILT_ARTIFACT_TYPE_VALUE = "aggregated-jar-for-hilt";
    @NotNull
    public static final String LIBRARY_GROUP = "com.google.dagger";
    @NotNull
    private static final Function1<String, String> missingDepError;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void apply(@NotNull Project project) {
        void configured;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        project.getPlugins().withType(AndroidBasePlugin.class, (Action)new Action<AndroidBasePlugin>(this, (Ref.BooleanRef)configured, project){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Ref.BooleanRef $configured;
            final /* synthetic */ Project $project;

            public final void execute(AndroidBasePlugin it) {
                this.$configured.element = true;
                HiltGradlePlugin.access$configureHilt(this.this$0, this.$project);
            }
            {
                this.this$0 = hiltGradlePlugin;
                this.$configured = booleanRef;
                this.$project = project;
            }
        });
        project.afterEvaluate((Action)new Action<Project>(this, (Ref.BooleanRef)configured){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Ref.BooleanRef $configured;

            public final void execute(Project it) {
                boolean bl = this.$configured.element;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "The Hilt Android Gradle plugin can only be applied to an Android project.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Project project = it;
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"it");
                HiltGradlePlugin.access$verifyDependencies(this.this$0, project);
            }
            {
                this.this$0 = hiltGradlePlugin;
                this.$configured = booleanRef;
            }
        });
    }

    private final void configureHilt(Project project) {
        HiltExtension hiltExtension = (HiltExtension)project.getExtensions().create(HiltExtension.class, "hilt", HiltExtensionImpl.class, new Object[0]);
        this.configureDependencyTransforms(project);
        HiltExtension hiltExtension2 = hiltExtension;
        Intrinsics.checkNotNullExpressionValue((Object)hiltExtension2, (String)"hiltExtension");
        this.configureCompileClasspath(project, hiltExtension2);
        if (SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION().compareTo(new SimpleAGPVersion(4, 2)) < 0) {
            this.configureBytecodeTransform(project, hiltExtension);
        } else {
            this.configureBytecodeTransformASM(project, hiltExtension);
        }
        this.configureAggregatingTask(project, hiltExtension);
        this.configureProcessorFlags(project, hiltExtension);
    }

    private final DependencyHandler configureDependencyTransforms(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        boolean bl = false;
        boolean bl2 = false;
        DependencyHandler $this$apply = dependencyHandler;
        boolean bl3 = false;
        $this$apply.registerTransform(CopyTransform.class, (Action)configureDependencyTransforms.1.1.INSTANCE);
        $this$apply.registerTransform(CopyTransform.class, (Action)configureDependencyTransforms.1.2.INSTANCE);
        $this$apply.registerTransform(AggregatedPackagesTransform.class, (Action)configureDependencyTransforms.1.3.INSTANCE);
        return dependencyHandler;
    }

    private final void configureCompileClasspath(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension == null) {
            String string = "Android BaseExtension not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)baseExtension, (String)"project.extensions.findB\u2026aseExtension not found.\")");
        BaseExtension androidExtension = baseExtension;
        this.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension, androidExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ BaseExtension $androidExtension;

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantCompileClasspath(this.this$0, this.$project, this.$hiltExtension, this.$androidExtension, variant);
            }
            {
                this.this$0 = hiltGradlePlugin;
                this.$project = project;
                this.$hiltExtension = hiltExtension;
                this.$androidExtension = baseExtension;
                super(1);
            }
        }));
    }

    private final void forEachRootVariant(BaseExtension $this$forEachRootVariant, Function1<? super BaseVariant, Unit> block) {
        BaseExtension baseExtension = $this$forEachRootVariant;
        if (baseExtension instanceof AppExtension) {
            ((AppExtension)$this$forEachRootVariant).getApplicationVariants().all((Action)new Action<ApplicationVariant>(block){
                final /* synthetic */ Function1 $block;

                public final void execute(ApplicationVariant it) {
                    ApplicationVariant applicationVariant = it;
                    Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"it");
                    this.$block.invoke((Object)applicationVariant);
                }
                {
                    this.$block = function1;
                }
            });
            ((AppExtension)$this$forEachRootVariant).getTestVariants().all((Action)new Action<TestVariant>(block){
                final /* synthetic */ Function1 $block;

                public final void execute(TestVariant it) {
                    TestVariant testVariant = it;
                    Intrinsics.checkNotNullExpressionValue((Object)testVariant, (String)"it");
                    this.$block.invoke((Object)testVariant);
                }
                {
                    this.$block = function1;
                }
            });
            ((AppExtension)$this$forEachRootVariant).getUnitTestVariants().all((Action)new Action<UnitTestVariant>(block){
                final /* synthetic */ Function1 $block;

                public final void execute(UnitTestVariant it) {
                    UnitTestVariant unitTestVariant = it;
                    Intrinsics.checkNotNullExpressionValue((Object)unitTestVariant, (String)"it");
                    this.$block.invoke((Object)unitTestVariant);
                }
                {
                    this.$block = function1;
                }
            });
        } else if (baseExtension instanceof LibraryExtension) {
            ((LibraryExtension)$this$forEachRootVariant).getTestVariants().all((Action)new Action<TestVariant>(block){
                final /* synthetic */ Function1 $block;

                public final void execute(TestVariant it) {
                    TestVariant testVariant = it;
                    Intrinsics.checkNotNullExpressionValue((Object)testVariant, (String)"it");
                    this.$block.invoke((Object)testVariant);
                }
                {
                    this.$block = function1;
                }
            });
            ((LibraryExtension)$this$forEachRootVariant).getUnitTestVariants().all((Action)new Action<UnitTestVariant>(block){
                final /* synthetic */ Function1 $block;

                public final void execute(UnitTestVariant it) {
                    UnitTestVariant unitTestVariant = it;
                    Intrinsics.checkNotNullExpressionValue((Object)unitTestVariant, (String)"it");
                    this.$block.invoke((Object)unitTestVariant);
                }
                {
                    this.$block = function1;
                }
            });
        } else if (baseExtension instanceof TestExtension) {
            ((TestExtension)$this$forEachRootVariant).getApplicationVariants().all((Action)new Action<ApplicationVariant>(block){
                final /* synthetic */ Function1 $block;

                public final void execute(ApplicationVariant it) {
                    ApplicationVariant applicationVariant = it;
                    Intrinsics.checkNotNullExpressionValue((Object)applicationVariant, (String)"it");
                    this.$block.invoke((Object)applicationVariant);
                }
                {
                    this.$block = function1;
                }
            });
        } else {
            String string = "Hilt plugin does not know how to configure '" + $this$forEachRootVariant + '\'';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    private final void configureVariantCompileClasspath(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        String string;
        Configuration runtimeConfiguration;
        Configuration configuration;
        boolean bl;
        block12: {
            if (!hiltExtension.getEnableExperimentalClasspathAggregation() || hiltExtension.getEnableAggregatingTask()) {
                return;
            }
            if (androidExtension.getLintOptions().isCheckReleaseBuilds() && SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION().compareTo(new SimpleAGPVersion(7, 0)) < 0) {
                String string2 = "Invalid Hilt plugin configuration: When 'enableExperimentalClasspathAggregation' is enabled 'android.lintOptions.checkReleaseBuilds' has to be set to false unless com.android.tools.build:gradle:7.0.0+ is used.";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            Iterable $this$any$iv = CollectionsKt.listOf((Object[])new String[]{"android.injected.build.model.only", "android.injected.build.model.only.advanced", "android.injected.build.model.only.versioned", "android.injected.build.model.feature.full.dependencies", "android.injected.build.model.v2"});
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    Provider provider = this.providers.gradleProperty(it).forUseAtConfigurationTime();
                    Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"providers.gradleProperty\u2026rUseAtConfigurationTime()");
                    if (!provider.isPresent()) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        if (variant instanceof TestVariant) {
            BaseVariant baseVariant = ((TestVariant)variant).getTestedVariant();
            Intrinsics.checkNotNullExpressionValue((Object)baseVariant, (String)"variant.testedVariant");
            configuration = baseVariant.getRuntimeConfiguration();
        } else {
            configuration = variant.getRuntimeConfiguration();
        }
        Configuration configuration2 = runtimeConfiguration = configuration;
        Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"runtimeConfiguration");
        ArtifactView artifactView2 = configuration2.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(project){
            final /* synthetic */ Project $project;

            public final void execute(ArtifactView.ViewConfiguration view) {
                ArtifactView.ViewConfiguration viewConfiguration = view;
                Intrinsics.checkNotNullExpressionValue((Object)viewConfiguration, (String)"view");
                viewConfiguration.getAttributes().attribute(HiltGradlePlugin.Companion.getARTIFACT_TYPE_ATTRIBUTE(), (Object)"jar-for-dagger");
                view.componentFilter((Spec)new Spec<ComponentIdentifier>(this){
                    final /* synthetic */ configureVariantCompileClasspath.artifactView.1 this$0;

                    public final boolean isSatisfiedBy(ComponentIdentifier identifier) {
                        return identifier instanceof ProjectComponentIdentifier ? Intrinsics.areEqual((Object)((ProjectComponentIdentifier)identifier).getProjectName(), (Object)this.this$0.$project.getName()) ^ true : true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$project = project;
            }
        });
        BaseVariant baseVariant = variant;
        if (baseVariant instanceof TestVariant) {
            StringBuilder stringBuilder = new StringBuilder().append("androidTest");
            String string3 = ((TestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"variant.name");
            string = stringBuilder.append(StringsKt.capitalize((String)StringsKt.substringBeforeLast$default((String)string3, (String)"AndroidTest", null, (int)2, null))).append("CompileOnly").toString();
        } else if (baseVariant instanceof UnitTestVariant) {
            StringBuilder stringBuilder = new StringBuilder().append("test");
            String string4 = ((UnitTestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"variant.name");
            string = stringBuilder.append(StringsKt.capitalize((String)StringsKt.substringBeforeLast$default((String)string4, (String)"UnitTest", null, (int)2, null))).append("CompileOnly").toString();
        } else {
            string = variant.getName() + "CompileOnly";
        }
        String compileOnlyConfigName = string;
        DependencyHandler dependencyHandler = project.getDependencies();
        ArtifactView artifactView3 = artifactView2;
        Intrinsics.checkNotNullExpressionValue((Object)artifactView3, (String)"artifactView");
        dependencyHandler.add(compileOnlyConfigName, (Object)artifactView3.getFiles());
    }

    /*
     * WARNING - void declaration
     */
    private final void configureBytecodeTransformASM(Project project, HiltExtension hiltExtension) {
        void warnAboutLocalTestsFlag;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        Function1<ComponentCompat, Unit> $fun$registerTransform$1 = new Function1<ComponentCompat, Unit>(hiltExtension, (Ref.BooleanRef)warnAboutLocalTestsFlag, project){
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ Ref.BooleanRef $warnAboutLocalTestsFlag;
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull ComponentCompat androidComponent) {
                Intrinsics.checkNotNullParameter((Object)androidComponent, (String)"androidComponent");
                if (this.$hiltExtension.getEnableTransformForLocalTests() && !this.$warnAboutLocalTestsFlag.element) {
                    this.$project.getLogger().warn("The Hilt configuration option 'enableTransformForLocalTests' is no longer necessary when com.android.tools.build:gradle:4.2.0+ is used.");
                    this.$warnAboutLocalTestsFlag.element = true;
                }
                androidComponent.transformClassesWith(AndroidEntryPointClassVisitor.Factory.class, InstrumentationScope.PROJECT, (Function1)new Function1<AndroidEntryPointClassVisitor.AndroidEntryPointParams, Unit>(this, androidComponent){
                    final /* synthetic */ configureBytecodeTransformASM.1 this$0;
                    final /* synthetic */ ComponentCompat $androidComponent;

                    public final void invoke(@NotNull AndroidEntryPointClassVisitor.AndroidEntryPointParams params) {
                        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                        File classesDir = new File(this.this$0.$project.getBuildDir(), "intermediates/javac/" + this.$androidComponent.getName() + "/classes");
                        params.getAdditionalClassesDir().set((Object)classesDir);
                    }
                    {
                        this.this$0 = var1_1;
                        this.$androidComponent = componentCompat;
                        super(1);
                    }
                });
                androidComponent.setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
            }
            {
                this.$hiltExtension = hiltExtension;
                this.$warnAboutLocalTestsFlag = booleanRef;
                this.$project = project;
                super(1);
            }
        };
        AndroidComponentsExtensionCompat.Companion.getAndroidComponentsExtension(project).onAllVariants((Function1<? super ComponentCompat, Unit>)((Function1)new Function1<ComponentCompat, Unit>($fun$registerTransform$1){
            final /* synthetic */ configureBytecodeTransformASM.1 $registerTransform$1;

            public final void invoke(@NotNull ComponentCompat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                this.$registerTransform$1.invoke(it);
            }
            {
                this.$registerTransform$1 = var1_1;
                super(1);
            }
        }));
    }

    private final void configureBytecodeTransform(Project project, HiltExtension hiltExtension) {
        block1: {
            BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
            if (baseExtension == null) {
                String string = "Android BaseExtension not found.";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)baseExtension, (String)"project.extensions.findB\u2026aseExtension not found.\")");
            BaseExtension androidExtension = baseExtension;
            androidExtension.registerTransform((Transform)new AndroidEntryPointTransform(), new Object[0]);
            TestedExtension testedExtensions = (TestedExtension)project.getExtensions().findByType(TestedExtension.class);
            TestedExtension testedExtension = testedExtensions;
            if (testedExtension == null || (testedExtension = testedExtension.getUnitTestVariants()) == null) break block1;
            testedExtension.all((Action)new Action<UnitTestVariant>(project, hiltExtension){
                final /* synthetic */ Project $project;
                final /* synthetic */ HiltExtension $hiltExtension;

                public final void execute(UnitTestVariant unitTestVariant) {
                    UnitTestVariant unitTestVariant2 = unitTestVariant;
                    Intrinsics.checkNotNullExpressionValue((Object)unitTestVariant2, (String)"unitTestVariant");
                    HiltTransformTestClassesTask.Companion.create(this.$project, unitTestVariant2, this.$hiltExtension);
                }
                {
                    this.$project = project;
                    this.$hiltExtension = hiltExtension;
                }
            });
        }
    }

    private final void configureAggregatingTask(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension == null) {
            String string = "Android BaseExtension not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)baseExtension, (String)"project.extensions.findB\u2026aseExtension not found.\")");
        BaseExtension androidExtension = baseExtension;
        this.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension, androidExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ BaseExtension $androidExtension;

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantAggregatingTask(this.this$0, this.$project, this.$hiltExtension, this.$androidExtension, variant);
            }
            {
                this.this$0 = hiltGradlePlugin;
                this.$project = project;
                this.$hiltExtension = hiltExtension;
                this.$androidExtension = baseExtension;
                super(1);
            }
        }));
    }

    private final void configureVariantAggregatingTask(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        if (!hiltExtension.getEnableAggregatingTask()) {
            return;
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        StringBuilder stringBuilder = new StringBuilder().append("hiltCompileOnly");
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        Object object = configurationContainer.create(stringBuilder.append(StringsKt.capitalize((String)string)).toString());
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$apply = (Configuration)object;
        boolean bl3 = false;
        if (variant instanceof TestVariant) {
            Configuration[] configurationArray = new Configuration[1];
            BaseVariant baseVariant = ((TestVariant)variant).getTestedVariant();
            Intrinsics.checkNotNullExpressionValue((Object)baseVariant, (String)"variant.testedVariant");
            configurationArray[0] = baseVariant.getRuntimeConfiguration();
            $this$apply.extendsFrom(configurationArray);
        }
        $this$apply.extendsFrom(new Configuration[]{variant.getRuntimeConfiguration()});
        $this$apply.setCanBeConsumed(false);
        $this$apply.setCanBeResolved(true);
        $this$apply.attributes((Action)new Action<AttributeContainer>(variant, project){
            final /* synthetic */ BaseVariant $variant$inlined;
            final /* synthetic */ Project $project$inlined;
            {
                this.$variant$inlined = baseVariant;
                this.$project$inlined = project;
            }

            public final void execute(AttributeContainer attrContainer) {
                attrContainer.attribute(Usage.USAGE_ATTRIBUTE, (Object)this.$project$inlined.getObjects().named(Usage.class, "java-runtime"));
                ObjectFactory objectFactory = this.$project$inlined.getObjects();
                BuildType buildType = this.$variant$inlined.getBuildType();
                Intrinsics.checkNotNullExpressionValue((Object)buildType, (String)"variant.buildType");
                attrContainer.attribute(BuildTypeAttr.ATTRIBUTE, (Object)objectFactory.named(BuildTypeAttr.class, buildType.getName()));
                List list = this.$variant$inlined.getProductFlavors();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"variant.productFlavors");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    ProductFlavor flavor = (ProductFlavor)element$iv;
                    boolean bl = false;
                    String string = flavor.getDimension();
                    Intrinsics.checkNotNull((Object)string);
                    Attribute attribute = Attribute.of((String)string, ProductFlavorAttr.class);
                    ObjectFactory objectFactory2 = this.$project$inlined.getObjects();
                    ProductFlavor productFlavor = flavor;
                    Intrinsics.checkNotNullExpressionValue((Object)productFlavor, (String)"flavor");
                    attrContainer.attribute(attribute, (Object)objectFactory2.named(ProductFlavorAttr.class, productFlavor.getName()));
                }
            }
        });
        Configuration hiltCompileConfiguration = (Configuration)object;
        DependencyHandler dependencyHandler = project.getDependencies();
        Configuration configuration = hiltCompileConfiguration;
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"hiltCompileConfiguration");
        dependencyHandler.add(configuration.getName(), (Object)project.files(new Object[]{variant.getJavaCompileProvider().map((Transformer)configureVariantAggregatingTask.1.INSTANCE)}));
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(new Object[]{variant.getJavaCompileProvider().map((Transformer)configureVariantAggregatingTask.2.INSTANCE)}));
        Function1<String, FileCollection> $fun$getInputClasspath$3 = new Function1<String, FileCollection>(hiltCompileConfiguration){
            final /* synthetic */ Configuration $hiltCompileConfiguration;

            public final FileCollection invoke(@NotNull String artifactAttributeValue) {
                Intrinsics.checkNotNullParameter((Object)artifactAttributeValue, (String)"artifactAttributeValue");
                Configuration configuration = this.$hiltCompileConfiguration;
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"hiltCompileConfiguration");
                ArtifactView artifactView2 = configuration.getIncoming().artifactView((Action)new Action<ArtifactView.ViewConfiguration>(artifactAttributeValue){
                    final /* synthetic */ String $artifactAttributeValue;

                    public final void execute(ArtifactView.ViewConfiguration view) {
                        ArtifactView.ViewConfiguration viewConfiguration = view;
                        Intrinsics.checkNotNullExpressionValue((Object)viewConfiguration, (String)"view");
                        viewConfiguration.getAttributes().attribute(HiltGradlePlugin.Companion.getARTIFACT_TYPE_ATTRIBUTE(), (Object)this.$artifactAttributeValue);
                    }
                    {
                        this.$artifactAttributeValue = string;
                    }
                });
                Intrinsics.checkNotNullExpressionValue((Object)artifactView2, (String)"hiltCompileConfiguration\u2026ctAttributeValue)\n      }");
                return artifactView2.getFiles();
            }
            {
                this.$hiltCompileConfiguration = configuration;
                super(1);
            }
        };
        TaskContainer taskContainer = project.getTasks();
        StringBuilder stringBuilder2 = new StringBuilder().append("hiltAggregateDeps");
        String string2 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
        TaskProvider aggregatingTask2 = taskContainer.register(stringBuilder2.append(StringsKt.capitalize((String)string2)).toString(), AggregateDepsTask.class, (Action)new Action<AggregateDepsTask>($fun$getInputClasspath$3, project, variant, hiltExtension){
            final /* synthetic */ configureVariantAggregatingTask.3 $getInputClasspath$3;
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ HiltExtension $hiltExtension;

            public final void execute(AggregateDepsTask it) {
                it.getCompileClasspath().setFrom((Iterable)this.$getInputClasspath$3.invoke("aggregated-jar-for-hilt"));
                DirectoryProperty directoryProperty = it.getOutputDir();
                File file = this.$project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                directoryProperty.set(this.$project.file((Object)kotlin.io.FilesKt.resolve((File)file, (String)("generated/hilt/component_trees/" + this.$variant.getName() + '/'))));
                it.getTestEnvironment().set((Object)(this.$variant instanceof TestVariant || this.$variant instanceof UnitTestVariant ? 1 : 0));
                it.getCrossCompilationRootValidationDisabled().set((Object)this.$hiltExtension.getDisableCrossCompilationRootValidation());
            }
            {
                this.$getInputClasspath$3 = var1_1;
                this.$project = project;
                this.$variant = baseVariant;
                this.$hiltExtension = hiltExtension;
            }
        });
        Object[] objectArray = new Object[1];
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        objectArray[0] = kotlin.io.FilesKt.resolve((File)file, (String)("intermediates/hilt/component_classes/" + variant.getName() + '/'));
        ConfigurableFileCollection componentClasses = project.files(objectArray);
        TaskContainer taskContainer2 = project.getTasks();
        StringBuilder stringBuilder3 = new StringBuilder().append("hiltJavaCompile");
        String string3 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"variant.name");
        TaskProvider componentsJavaCompileTask2 = taskContainer2.register(stringBuilder3.append(StringsKt.capitalize((String)string3)).toString(), JavaCompile.class, (Action)new Action<JavaCompile>(aggregatingTask2, variant, project, androidExtension, $fun$getInputClasspath$3, componentClasses){
            final /* synthetic */ TaskProvider $aggregatingTask;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseExtension $androidExtension;
            final /* synthetic */ configureVariantAggregatingTask.3 $getInputClasspath$3;
            final /* synthetic */ ConfigurableFileCollection $componentClasses;

            /*
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            public final void execute(JavaCompile compileTask) {
                v0 = compileTask;
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"compileTask");
                v0.setSource((FileTree)this.$aggregatingTask.map((Transformer)configureVariantAggregatingTask.componentsJavaCompileTask.1.INSTANCE).get());
                mainBootstrapClasspath = (FileCollection)this.$variant.getJavaCompileProvider().map((Transformer)new Transformer<FileCollection, JavaCompile>(this){
                    final /* synthetic */ configureVariantAggregatingTask.componentsJavaCompileTask.1 this$0;

                    public final FileCollection transform(JavaCompile it) {
                        JavaCompile javaCompile = it;
                        Intrinsics.checkNotNullExpressionValue((Object)javaCompile, (String)"it");
                        CompileOptions compileOptions = javaCompile.getOptions();
                        Intrinsics.checkNotNullExpressionValue((Object)compileOptions, (String)"it.options");
                        FileCollection fileCollection = compileOptions.getBootstrapClasspath();
                        if (fileCollection == null) {
                            fileCollection = (FileCollection)this.this$0.$project.files(new Object[0]);
                        }
                        return fileCollection;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).get();
                v1 = JavaVersion.current();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"JavaVersion.current()");
                if (!v1.isJava9Compatible()) ** GOTO lbl-1000
                v2 = this.$androidExtension.getCompileOptions().getTargetCompatibility();
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"androidExtension.compile\u2026tions.targetCompatibility");
                if (v2.isJava9Compatible()) {
                    compileTask.setClasspath(this.$getInputClasspath$3.invoke("jar-for-dagger").plus(mainBootstrapClasspath));
                    var3_3 = this.$variant.getJavaCompileProvider().get();
                    var4_4 = false;
                    var5_5 = false;
                    originalCompileTask = (JavaCompile)var3_3;
                    $i$a$-let-HiltGradlePlugin$configureVariantAggregatingTask$componentsJavaCompileTask$1$2 = false;
                    v3 = originalCompileTask;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"originalCompileTask");
                    v4 = v3.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"originalCompileTask.options");
                    v5 = v4.getCompilerArgumentProviders();
                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"originalCompileTask.opti\u2026compilerArgumentProviders");
                    $this$forEach$iv = v5;
                    $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        it = (CommandLineArgumentProvider)element$iv /* !! */ ;
                        $i$a$-forEach-HiltGradlePlugin$configureVariantAggregatingTask$componentsJavaCompileTask$1$2$1 = false;
                        v6 = compileTask.getOptions();
                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"compileTask.options");
                        v6.getCompilerArgumentProviders().add(it);
                    }
                    v7 = compileTask.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"compileTask.options");
                    v7.getCompilerArgs().add("-XDstringConcat=inline");
                } else lbl-1000:
                // 2 sources

                {
                    compileTask.setClasspath(this.$getInputClasspath$3.invoke("jar-for-dagger"));
                    v8 = compileTask.getOptions();
                    Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"compileTask.options");
                    v8.setBootstrapClasspath(mainBootstrapClasspath);
                }
                v9 = this.$componentClasses;
                Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"componentClasses");
                compileTask.setDestinationDir(v9.getSingleFile());
                var3_3 = compileTask.getOptions();
                var4_4 = false;
                var5_5 = false;
                $this$apply = var3_3;
                $i$a$-apply-HiltGradlePlugin$configureVariantAggregatingTask$componentsJavaCompileTask$1$3 = false;
                v10 = this.$project.getConfigurations();
                v11 = new StringBuilder().append("hiltAnnotationProcessor");
                v12 = this.$variant.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"variant.name");
                var8_8 = v10.create(v11.append(StringsKt.capitalize((String)v12)).toString());
                var9_9 = false;
                var10_11 = false;
                element$iv /* !! */  = (Configuration)var8_8;
                var12_13 = $this$apply;
                $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$componentsJavaCompileTask$1$3$1 = false;
                v13 = this.$project.getDependencies();
                v14 = config;
                Intrinsics.checkNotNullExpressionValue((Object)v14, (String)"config");
                v13.add(v14.getName(), (Object)("com.google.dagger:hilt-compiler:" + VersionKt.getHILT_VERSION()));
                var14_15 = Unit.INSTANCE;
                var12_13.setAnnotationProcessorPath((FileCollection)var8_8);
                v15 = this.$project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"project.buildDir");
                $this$apply.setAnnotationProcessorGeneratedSourcesDirectory(this.$project.file((Object)kotlin.io.FilesKt.resolve((File)v15, (String)("generated/hilt/component_sources/" + this.$variant.getName() + '/'))));
                v16 = JavaVersion.current();
                Intrinsics.checkNotNullExpressionValue((Object)v16, (String)"JavaVersion.current()");
                if (v16.isJava8Compatible()) {
                    v17 = this.$androidExtension.getCompileOptions().getTargetCompatibility();
                    Intrinsics.checkNotNullExpressionValue((Object)v17, (String)"androidExtension.compile\u2026tions.targetCompatibility");
                    if (v17.isJava8Compatible()) {
                        $this$apply.getCompilerArgs().add("-parameters");
                    }
                }
                $this$apply.getCompilerArgs().add("-Adagger.fastInit=enabled");
                $this$apply.getCompilerArgs().add("-Adagger.hilt.shareTestComponents=true");
                $this$apply.getCompilerArgs().add("-Adagger.hilt.internal.useAggregatingRootProcessor=false");
                $this$apply.getCompilerArgs().add("-Adagger.hilt.android.internal.disableAndroidSuperclassValidation=true");
                $this$apply.setEncoding(this.$androidExtension.getCompileOptions().getEncoding());
                compileTask.setSourceCompatibility(this.$androidExtension.getCompileOptions().getSourceCompatibility().toString());
                compileTask.setTargetCompatibility(this.$androidExtension.getCompileOptions().getTargetCompatibility().toString());
            }
            {
                this.$aggregatingTask = taskProvider;
                this.$variant = baseVariant;
                this.$project = project;
                this.$androidExtension = baseExtension;
                this.$getInputClasspath$3 = var5_5;
                this.$componentClasses = configurableFileCollection;
            }
        });
        componentClasses.builtBy(new Object[]{componentsJavaCompileTask2});
        variant.registerPostJavacGeneratedBytecode((FileCollection)componentClasses);
    }

    private final ConfigurableFileCollection getAndroidJar(Project project, String compileSdkVersion) {
        return project.files(new Object[]{new File(FilesKt.getSdkPath(project), "platforms/" + compileSdkVersion + "/android.jar")});
    }

    private final void configureProcessorFlags(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension == null) {
            String string = "Android BaseExtension not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)baseExtension, (String)"project.extensions.findB\u2026aseExtension not found.\")");
        BaseExtension androidExtension = baseExtension;
        AnnotationProcessorOptions annotationProcessorOptions = androidExtension.getDefaultConfig().getJavaCompileOptions().getAnnotationProcessorOptions();
        boolean bl = false;
        boolean bl2 = false;
        AnnotationProcessorOptions $this$apply = annotationProcessorOptions;
        boolean bl3 = false;
        $this$apply.argument("dagger.fastInit", "enabled");
        $this$apply.argument("dagger.hilt.android.internal.disableAndroidSuperclassValidation", "true");
        $this$apply.compilerArgumentProvider(new CommandLineArgumentProvider(hiltExtension){
            final /* synthetic */ HiltExtension $hiltExtension$inlined;
            {
                this.$hiltExtension$inlined = hiltExtension;
            }

            public final Iterable<String> asArguments() {
                boolean bl = false;
                List list = new ArrayList<E>();
                boolean bl2 = false;
                boolean bl3 = false;
                List $this$apply = list;
                boolean bl4 = false;
                if (this.$hiltExtension$inlined.getEnableAggregatingTask()) {
                    $this$apply.add("-Adagger.hilt.internal.useAggregatingRootProcessor=false");
                }
                if (this.$hiltExtension$inlined.getDisableCrossCompilationRootValidation()) {
                    $this$apply.add("-Adagger.hilt.disableCrossCompilationRootValidation=true");
                }
                return list;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyDependencies(Project project) {
        boolean bl;
        Object object;
        void $this$flatMapTo$iv$iv;
        ProjectState projectState = project.getState();
        Intrinsics.checkNotNullExpressionValue((Object)projectState, (String)"project.state");
        if (projectState.getFailure() != null) {
            return;
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)configurationContainer, (String)"project.configurations");
        Iterable $this$flatMap$iv = (Iterable)configurationContainer;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Configuration configuration = (Configuration)element$iv$iv;
            boolean bl2 = false;
            Configuration configuration2 = configuration;
            Intrinsics.checkNotNullExpressionValue((Object)configuration2, (String)"configuration");
            DependencySet dependencySet = configuration2.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configuration.dependencies");
            Iterable $this$map$iv = (Iterable)dependencySet;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void dependency;
                Dependency dependency2 = (Dependency)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                void v4 = dependency;
                Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"dependency");
                Pair pair = TuplesKt.to((Object)v4.getGroup(), (Object)dependency.getName());
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List dependencies = (List)destination$iv$iv;
        if (!dependencies.contains(TuplesKt.to((Object)LIBRARY_GROUP, (Object)"hilt-android"))) {
            object = missingDepError.invoke((Object)"com.google.dagger:hilt-android");
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        if (!dependencies.contains(TuplesKt.to((Object)LIBRARY_GROUP, (Object)"hilt-android-compiler")) && !dependencies.contains(TuplesKt.to((Object)LIBRARY_GROUP, (Object)"hilt-compiler"))) {
            object = missingDepError.invoke((Object)"com.google.dagger:hilt-compiler");
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
    }

    @NotNull
    public final ProviderFactory getProviders() {
        return this.providers;
    }

    @Inject
    public HiltGradlePlugin(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.providers = providers;
    }

    static {
        Companion = new Companion(null);
        ARTIFACT_TYPE_ATTRIBUTE = Attribute.of((String)"artifactType", String.class);
        missingDepError = Companion.missingDepError.1.INSTANCE;
    }

    public static final /* synthetic */ void access$configureHilt(HiltGradlePlugin $this, Project project) {
        $this.configureHilt(project);
    }

    public static final /* synthetic */ void access$verifyDependencies(HiltGradlePlugin $this, Project project) {
        $this.verifyDependencies(project);
    }

    public static final /* synthetic */ void access$configureVariantCompileClasspath(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        $this.configureVariantCompileClasspath(project, hiltExtension, androidExtension, variant);
    }

    public static final /* synthetic */ void access$configureVariantAggregatingTask(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        $this.configureVariantAggregatingTask(project, hiltExtension, androidExtension, variant);
    }

    @Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R5\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin$Companion;", "", "()V", "AGGREGATED_HILT_ARTIFACT_TYPE_VALUE", "", "ARTIFACT_TYPE_ATTRIBUTE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "getARTIFACT_TYPE_ATTRIBUTE", "()Lorg/gradle/api/attributes/Attribute;", "DAGGER_ARTIFACT_TYPE_VALUE", "LIBRARY_GROUP", "missingDepError", "Lkotlin/Function1;", "getMissingDepError", "()Lkotlin/jvm/functions/Function1;", "plugin"})
    public static final class Companion {
        public final Attribute<String> getARTIFACT_TYPE_ATTRIBUTE() {
            return ARTIFACT_TYPE_ATTRIBUTE;
        }

        @NotNull
        public final Function1<String, String> getMissingDepError() {
            return missingDepError;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

