/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.TestedExtension;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import dagger.hilt.android.plugin.AndroidEntryPointClassVisitor;
import dagger.hilt.android.plugin.AndroidEntryPointTransform;
import dagger.hilt.android.plugin.HiltExtension;
import dagger.hilt.android.plugin.HiltExtensionImpl;
import dagger.hilt.android.plugin.HiltGradlePlugin;
import dagger.hilt.android.plugin.VersionKt;
import dagger.hilt.android.plugin.task.AggregateDepsTask;
import dagger.hilt.android.plugin.task.HiltTransformTestClassesTask;
import dagger.hilt.android.plugin.util.AggregatedPackagesTransform;
import dagger.hilt.android.plugin.util.AndroidComponentsExtensionCompat;
import dagger.hilt.android.plugin.util.ComponentCompat;
import dagger.hilt.android.plugin.util.CopyTransform;
import dagger.hilt.android.plugin.util.FilesKt;
import dagger.hilt.android.plugin.util.SimpleAGPVersion;
import dagger.hilt.android.plugin.util.StringsKt;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.DependencySet;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.transform.TransformSpec;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001&B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0018\u0010\u000b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u00122\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J(\u0010\u001b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u0010\u001c\u001a\n \u0013*\u0004\u0018\u00010\u001d0\u001d2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0002J/\u0010!\u001a\u00020\t*\u00020\u00182!\u0010\"\u001a\u001d\u0012\u0013\u0012\u00110\u001a\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(\u0019\u0012\u0004\u0012\u00020\t0#H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006'"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "getProviders", "()Lorg/gradle/api/provider/ProviderFactory;", "apply", "", "project", "configureAggregatingTask", "hiltExtension", "Ldagger/hilt/android/plugin/HiltExtension;", "configureBytecodeTransform", "configureBytecodeTransformASM", "configureCompileClasspath", "configureDependencyTransforms", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "kotlin.jvm.PlatformType", "configureHilt", "configureProcessorFlags", "configureVariantAggregatingTask", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "configureVariantCompileClasspath", "getAndroidJar", "Lorg/gradle/api/file/ConfigurableFileCollection;", "compileSdkVersion", "", "verifyDependencies", "forEachRootVariant", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Companion", "plugin"})
public final class HiltGradlePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providers;
    private static final Attribute<String> ARTIFACT_TYPE_ATTRIBUTE = Attribute.of((String)"artifactType", String.class);
    @NotNull
    public static final String DAGGER_ARTIFACT_TYPE_VALUE = "jar-for-dagger";
    @NotNull
    public static final String AGGREGATED_HILT_ARTIFACT_TYPE_VALUE = "aggregated-jar-for-hilt";
    @NotNull
    public static final String LIBRARY_GROUP = "com.google.dagger";
    @NotNull
    private static final Function1<String, String> missingDepError = Companion.missingDepError.1.INSTANCE;

    @Inject
    public HiltGradlePlugin(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.providers = providers;
    }

    @NotNull
    public final ProviderFactory getProviders() {
        return this.providers;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.BooleanRef configured = new Ref.BooleanRef();
        project.getPlugins().withType(AndroidBasePlugin.class, arg_0 -> HiltGradlePlugin.apply$lambda-0(configured, this, project, arg_0));
        project.afterEvaluate(arg_0 -> HiltGradlePlugin.apply$lambda-2(configured, this, arg_0));
    }

    private final void configureHilt(Project project) {
        HiltExtension hiltExtension = (HiltExtension)project.getExtensions().create(HiltExtension.class, "hilt", HiltExtensionImpl.class, new Object[0]);
        this.configureDependencyTransforms(project);
        Intrinsics.checkNotNullExpressionValue((Object)hiltExtension, (String)"hiltExtension");
        this.configureCompileClasspath(project, hiltExtension);
        if (SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION().compareTo(new SimpleAGPVersion(4, 2)) < 0) {
            this.configureBytecodeTransform(project, hiltExtension);
        } else {
            this.configureBytecodeTransformASM(project, hiltExtension);
        }
        this.configureAggregatingTask(project, hiltExtension);
        this.configureProcessorFlags(project, hiltExtension);
    }

    private final DependencyHandler configureDependencyTransforms(Project project) {
        DependencyHandler dependencyHandler = project.getDependencies();
        boolean bl = false;
        boolean bl2 = false;
        DependencyHandler $this$configureDependencyTransforms_u24lambda_u2d6 = dependencyHandler;
        boolean bl3 = false;
        $this$configureDependencyTransforms_u24lambda_u2d6.registerTransform(CopyTransform.class, HiltGradlePlugin::configureDependencyTransforms$lambda-6$lambda-3);
        $this$configureDependencyTransforms_u24lambda_u2d6.registerTransform(CopyTransform.class, HiltGradlePlugin::configureDependencyTransforms$lambda-6$lambda-4);
        $this$configureDependencyTransforms_u24lambda_u2d6.registerTransform(AggregatedPackagesTransform.class, HiltGradlePlugin::configureDependencyTransforms$lambda-6$lambda-5);
        return dependencyHandler;
    }

    private final void configureCompileClasspath(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension;
        BaseExtension baseExtension2 = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension2 == null) {
            String string = "Android BaseExtension not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BaseExtension androidExtension = baseExtension = baseExtension2;
        this.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension, androidExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ BaseExtension $androidExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$hiltExtension = $hiltExtension;
                this.$androidExtension = $androidExtension;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantCompileClasspath(this.this$0, this.$project, this.$hiltExtension, this.$androidExtension, variant);
            }
        }));
    }

    private final void forEachRootVariant(BaseExtension $this$forEachRootVariant, Function1<? super BaseVariant, Unit> block) {
        BaseExtension baseExtension = $this$forEachRootVariant;
        if (baseExtension instanceof AppExtension) {
            ((AppExtension)$this$forEachRootVariant).getApplicationVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda-7(block, arg_0));
            ((AppExtension)$this$forEachRootVariant).getTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda-8(block, arg_0));
            ((AppExtension)$this$forEachRootVariant).getUnitTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda-9(block, arg_0));
        } else if (baseExtension instanceof LibraryExtension) {
            ((LibraryExtension)$this$forEachRootVariant).getTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda-10(block, arg_0));
            ((LibraryExtension)$this$forEachRootVariant).getUnitTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda-11(block, arg_0));
        } else if (baseExtension instanceof TestExtension) {
            ((TestExtension)$this$forEachRootVariant).getApplicationVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda-12(block, arg_0));
        } else {
            String string = "Hilt plugin does not know how to configure '" + $this$forEachRootVariant + '\'';
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureVariantCompileClasspath(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        String string;
        String string2;
        boolean bl;
        block10: {
            void $this$any$iv;
            if (!hiltExtension.getEnableExperimentalClasspathAggregation() || hiltExtension.getEnableAggregatingTask()) {
                return;
            }
            if (androidExtension.getLintOptions().isCheckReleaseBuilds() && SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION().compareTo(new SimpleAGPVersion(7, 0)) < 0) {
                String string3 = "Invalid Hilt plugin configuration: When 'enableExperimentalClasspathAggregation' is enabled 'android.lintOptions.checkReleaseBuilds' has to be set to false unless com.android.tools.build:gradle:7.0.0+ is used.";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string3.toString());
            }
            Object object = new String[]{"android.injected.build.model.only", "android.injected.build.model.only.advanced", "android.injected.build.model.only.versioned", "android.injected.build.model.feature.full.dependencies", "android.injected.build.model.v2"};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl3 = false;
                    if (!this.getProviders().gradleProperty(it).forUseAtConfigurationTime().isPresent()) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Configuration runtimeConfiguration = variant instanceof TestVariant ? ((TestVariant)variant).getTestedVariant().getRuntimeConfiguration() : variant.getRuntimeConfiguration();
        ArtifactView artifactView = runtimeConfiguration.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda-15(project, arg_0));
        BaseVariant baseVariant = variant;
        if (baseVariant instanceof TestVariant) {
            StringBuilder stringBuilder = new StringBuilder().append("androidTest");
            string2 = ((TestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
            string = stringBuilder.append(StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string2, (String)"AndroidTest", null, (int)2, null), null, 1, null)).append("CompileOnly").toString();
        } else if (baseVariant instanceof UnitTestVariant) {
            StringBuilder stringBuilder = new StringBuilder().append("test");
            string2 = ((UnitTestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
            string = stringBuilder.append(StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string2, (String)"UnitTest", null, (int)2, null), null, 1, null)).append("CompileOnly").toString();
        } else {
            string = Intrinsics.stringPlus((String)variant.getName(), (Object)"CompileOnly");
        }
        String compileOnlyConfigName = string;
        project.getDependencies().add(compileOnlyConfigName, (Object)artifactView.getFiles());
    }

    private final void configureBytecodeTransformASM(Project project, HiltExtension hiltExtension) {
        Ref.BooleanRef warnAboutLocalTestsFlag = new Ref.BooleanRef();
        AndroidComponentsExtensionCompat.Companion.getAndroidComponentsExtension(project).onAllVariants((Function1<? super ComponentCompat, Unit>)((Function1)new Function1<ComponentCompat, Unit>(hiltExtension, warnAboutLocalTestsFlag, project){
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ Ref.BooleanRef $warnAboutLocalTestsFlag;
            final /* synthetic */ Project $project;
            {
                this.$hiltExtension = $hiltExtension;
                this.$warnAboutLocalTestsFlag = $warnAboutLocalTestsFlag;
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull ComponentCompat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HiltGradlePlugin.access$configureBytecodeTransformASM$registerTransform(this.$hiltExtension, this.$warnAboutLocalTestsFlag, this.$project, it);
            }
        }));
    }

    private final void configureBytecodeTransform(Project project, HiltExtension hiltExtension) {
        DomainObjectSet domainObjectSet;
        TestedExtension testedExtensions;
        Class[] classArray = (Class[])project.getExtensions().findByType(BaseExtension.class);
        if (classArray == null) {
            String string = "Android BaseExtension not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Object[] objectArray = classArray;
        Class[] androidExtension = objectArray;
        objectArray = new Class[]{Class.forName("com.android.build.api.transform.Transform"), Object[].class};
        Method method = androidExtension.getClass().getMethod("registerTransform", (Class<?>[])objectArray);
        objectArray = new Object[2];
        objectArray[0] = new AndroidEntryPointTransform();
        boolean $i$f$emptyArray = false;
        objectArray[1] = new Object[0];
        method.invoke((Object)androidExtension, objectArray);
        TestedExtension testedExtension = testedExtensions = (TestedExtension)project.getExtensions().findByType(TestedExtension.class);
        if (testedExtension != null && (domainObjectSet = testedExtension.getUnitTestVariants()) != null) {
            domainObjectSet.all(arg_0 -> HiltGradlePlugin.configureBytecodeTransform$lambda-16(project, hiltExtension, arg_0));
        }
    }

    private final void configureAggregatingTask(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension;
        BaseExtension baseExtension2 = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension2 == null) {
            String string = "Android BaseExtension not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BaseExtension androidExtension = baseExtension = baseExtension2;
        this.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension, androidExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ BaseExtension $androidExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$hiltExtension = $hiltExtension;
                this.$androidExtension = $androidExtension;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantAggregatingTask(this.this$0, this.$project, this.$hiltExtension, this.$androidExtension, variant);
            }
        }));
    }

    private final void configureVariantAggregatingTask(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        if (!hiltExtension.getEnableAggregatingTask()) {
            return;
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        Object[] objectArray = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"variant.name");
        objectArray = configurationContainer.create(Intrinsics.stringPlus((String)"hiltCompileOnly", (Object)StringsKt.capitalize$default((String)objectArray, null, 1, null)));
        boolean bl = false;
        boolean bl2 = false;
        Configuration $this$configureVariantAggregatingTask_u24lambda_u2d17 = (Configuration)objectArray;
        boolean bl3 = false;
        $this$configureVariantAggregatingTask_u24lambda_u2d17.setCanBeConsumed(false);
        $this$configureVariantAggregatingTask_u24lambda_u2d17.setCanBeResolved(true);
        Configuration hiltCompileConfiguration = (Configuration)objectArray;
        objectArray = new Object[]{variant.getJavaCompileProvider().map(HiltGradlePlugin::configureVariantAggregatingTask$lambda-18)};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        objectArray = new Object[]{variant.getJavaCompileProvider().map(HiltGradlePlugin::configureVariantAggregatingTask$lambda-19)};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        TaskContainer taskContainer = project.getTasks();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        TaskProvider aggregatingTask = taskContainer.register(Intrinsics.stringPlus((String)"hiltAggregateDeps", (Object)StringsKt.capitalize$default(string, null, 1, null)), AggregateDepsTask.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda-24(project, variant, hiltExtension, hiltCompileConfiguration, arg_0));
        Object[] objectArray2 = new Object[1];
        Object[] objectArray3 = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"project.buildDir");
        objectArray2[0] = kotlin.io.FilesKt.resolve((File)objectArray3, (String)("intermediates/hilt/component_classes/" + variant.getName() + '/'));
        ConfigurableFileCollection componentClasses = project.files(objectArray2);
        TaskContainer taskContainer2 = project.getTasks();
        objectArray3 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray3, (String)"variant.name");
        TaskProvider componentsJavaCompileTask = taskContainer2.register(Intrinsics.stringPlus((String)"hiltJavaCompile", (Object)StringsKt.capitalize$default((String)objectArray3, null, 1, null)), JavaCompile.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda-31(aggregatingTask, variant, androidExtension, componentClasses, project, hiltCompileConfiguration, arg_0));
        objectArray3 = new Object[]{componentsJavaCompileTask};
        componentClasses.builtBy(objectArray3);
        variant.registerPostJavacGeneratedBytecode((FileCollection)componentClasses);
    }

    private final ConfigurableFileCollection getAndroidJar(Project project, String compileSdkVersion) {
        Object[] objectArray = new Object[]{new File(FilesKt.getSdkPath(project), "platforms/" + compileSdkVersion + "/android.jar")};
        return project.files(objectArray);
    }

    private final void configureProcessorFlags(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension;
        BaseExtension baseExtension2 = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension2 == null) {
            String string = "Android BaseExtension not found.";
            boolean bl = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        BaseExtension androidExtension = baseExtension = baseExtension2;
        baseExtension = androidExtension.getDefaultConfig().getJavaCompileOptions().getAnnotationProcessorOptions();
        boolean bl = false;
        boolean bl2 = false;
        BaseExtension $this$configureProcessorFlags_u24lambda_u2d32 = baseExtension;
        boolean bl3 = false;
        $this$configureProcessorFlags_u24lambda_u2d32.argument("dagger.fastInit", "enabled");
        $this$configureProcessorFlags_u24lambda_u2d32.argument("dagger.hilt.android.internal.disableAndroidSuperclassValidation", "true");
        $this$configureProcessorFlags_u24lambda_u2d32.compilerArgumentProvider(new CommandLineArgumentProvider(hiltExtension){
            final /* synthetic */ HiltExtension $hiltExtension;
            {
                this.$hiltExtension = $hiltExtension;
            }

            @NotNull
            public List<String> asArguments() {
                boolean bl = false;
                List list = new ArrayList<E>();
                HiltExtension hiltExtension = this.$hiltExtension;
                boolean bl2 = false;
                boolean bl3 = false;
                List $this$asArguments_u24lambda_u2d0 = list;
                boolean bl4 = false;
                if (hiltExtension.getEnableAggregatingTask()) {
                    $this$asArguments_u24lambda_u2d0.add("-Adagger.hilt.internal.useAggregatingRootProcessor=false");
                }
                if (hiltExtension.getDisableCrossCompilationRootValidation()) {
                    $this$asArguments_u24lambda_u2d0.add("-Adagger.hilt.disableCrossCompilationRootValidation=true");
                }
                return list;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final void verifyDependencies(Project project) {
        boolean bl;
        void $this$flatMapTo$iv$iv;
        if (project.getState().getFailure() != null) {
            return;
        }
        Object object = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.configurations");
        Iterable $this$flatMap$iv = (Iterable)object;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            void $this$mapTo$iv$iv;
            Configuration configuration = (Configuration)element$iv$iv;
            boolean bl2 = false;
            DependencySet dependencySet = configuration.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)dependencySet, (String)"configuration.dependencies");
            Iterable $this$map$iv = (Iterable)dependencySet;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void dependency;
                Dependency dependency2 = (Dependency)item$iv$iv;
                Collection collection = destination$iv$iv2;
                boolean bl3 = false;
                Pair pair = TuplesKt.to((Object)dependency.getGroup(), (Object)dependency.getName());
                collection.add(pair);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List dependencies = (List)destination$iv$iv;
        if (!dependencies.contains(TuplesKt.to((Object)LIBRARY_GROUP, (Object)"hilt-android"))) {
            object = missingDepError.invoke((Object)"com.google.dagger:hilt-android");
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        if (!dependencies.contains(TuplesKt.to((Object)LIBRARY_GROUP, (Object)"hilt-android-compiler")) && !dependencies.contains(TuplesKt.to((Object)LIBRARY_GROUP, (Object)"hilt-compiler"))) {
            object = missingDepError.invoke((Object)"com.google.dagger:hilt-compiler");
            bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
    }

    private static final void apply$lambda-0(Ref.BooleanRef $configured, HiltGradlePlugin this$0, Project $project, AndroidBasePlugin it) {
        Intrinsics.checkNotNullParameter((Object)$configured, (String)"$configured");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        $configured.element = true;
        this$0.configureHilt($project);
    }

    private static final void apply$lambda-2(Ref.BooleanRef $configured, HiltGradlePlugin this$0, Project it) {
        Intrinsics.checkNotNullParameter((Object)$configured, (String)"$configured");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        boolean bl = $configured.element;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The Hilt Android Gradle plugin can only be applied to an Android project.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        this$0.verifyDependencies(it);
    }

    private static final void configureDependencyTransforms$lambda-6$lambda-3(TransformSpec spec) {
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)"jar");
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)"android-classes");
        spec.getTo().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
    }

    private static final void configureDependencyTransforms$lambda-6$lambda-4(TransformSpec spec) {
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)"directory");
        spec.getTo().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
    }

    private static final void configureDependencyTransforms$lambda-6$lambda-5(TransformSpec spec) {
        spec.getFrom().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
        spec.getTo().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)AGGREGATED_HILT_ARTIFACT_TYPE_VALUE);
    }

    private static final void forEachRootVariant$lambda-7(Function1 $block, ApplicationVariant it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $block.invoke((Object)it);
    }

    private static final void forEachRootVariant$lambda-8(Function1 $block, TestVariant it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $block.invoke((Object)it);
    }

    private static final void forEachRootVariant$lambda-9(Function1 $block, UnitTestVariant it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $block.invoke((Object)it);
    }

    private static final void forEachRootVariant$lambda-10(Function1 $block, TestVariant it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $block.invoke((Object)it);
    }

    private static final void forEachRootVariant$lambda-11(Function1 $block, UnitTestVariant it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $block.invoke((Object)it);
    }

    private static final void forEachRootVariant$lambda-12(Function1 $block, ApplicationVariant it) {
        Intrinsics.checkNotNullParameter((Object)$block, (String)"$block");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        $block.invoke((Object)it);
    }

    private static final boolean configureVariantCompileClasspath$lambda-15$lambda-14(Project $project, ComponentIdentifier identifier) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        return identifier instanceof ProjectComponentIdentifier ? !Intrinsics.areEqual((Object)((ProjectComponentIdentifier)identifier).getProjectName(), (Object)$project.getName()) : true;
    }

    private static final void configureVariantCompileClasspath$lambda-15(Project $project, ArtifactView.ViewConfiguration view) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        view.getAttributes().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)DAGGER_ARTIFACT_TYPE_VALUE);
        view.componentFilter(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda-15$lambda-14($project, arg_0));
    }

    private static final void configureBytecodeTransformASM$registerTransform(HiltExtension $hiltExtension, Ref.BooleanRef warnAboutLocalTestsFlag, Project $project, ComponentCompat androidComponent) {
        if ($hiltExtension.getEnableTransformForLocalTests() && !warnAboutLocalTestsFlag.element) {
            $project.getLogger().warn("The Hilt configuration option 'enableTransformForLocalTests' is no longer necessary when com.android.tools.build:gradle:4.2.0+ is used.");
            warnAboutLocalTestsFlag.element = true;
        }
        androidComponent.transformClassesWith(AndroidEntryPointClassVisitor.Factory.class, InstrumentationScope.PROJECT, (Function1)new Function1<AndroidEntryPointClassVisitor.AndroidEntryPointParams, Unit>($project, androidComponent){
            final /* synthetic */ Project $project;
            final /* synthetic */ ComponentCompat $androidComponent;
            {
                this.$project = $project;
                this.$androidComponent = $androidComponent;
                super(1);
            }

            public final void invoke(@NotNull AndroidEntryPointClassVisitor.AndroidEntryPointParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                File classesDir = new File(this.$project.getBuildDir(), "intermediates/javac/" + this.$androidComponent.getName() + "/classes");
                params.getAdditionalClassesDir().set((Object)classesDir);
            }
        });
        androidComponent.setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
    }

    private static final void configureBytecodeTransform$lambda-16(Project $project, HiltExtension $hiltExtension, UnitTestVariant unitTestVariant) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$hiltExtension, (String)"$hiltExtension");
        Intrinsics.checkNotNullExpressionValue((Object)unitTestVariant, (String)"unitTestVariant");
        HiltTransformTestClassesTask.Companion.create($project, unitTestVariant, $hiltExtension);
    }

    private static final FileCollection configureVariantAggregatingTask$lambda-18(JavaCompile it) {
        return it.getClasspath();
    }

    private static final Directory configureVariantAggregatingTask$lambda-19(JavaCompile it) {
        return (Directory)it.getDestinationDirectory().get();
    }

    private static final void configureVariantAggregatingTask$getInputClasspath$lambda-22$lambda-21(String $artifactAttributeValue, ArtifactView.ViewConfiguration view) {
        Intrinsics.checkNotNullParameter((Object)$artifactAttributeValue, (String)"$artifactAttributeValue");
        view.getAttributes().attribute(ARTIFACT_TYPE_ATTRIBUTE, (Object)$artifactAttributeValue);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfigurableFileCollection configureVariantAggregatingTask$getInputClasspath(BaseVariant $variant, Configuration hiltCompileConfiguration, Project $project, String artifactAttributeValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object object;
        boolean bl = false;
        Iterable iterable = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2d20 = iterable;
        boolean bl4 = false;
        if ($variant instanceof TestVariant) {
            object = ((TestVariant)$variant).getTestedVariant().getRuntimeConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.testedVariant.runtimeConfiguration");
            $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2d20.add(object);
        }
        object = $variant.getRuntimeConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.runtimeConfiguration");
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2d20.add(object);
        Intrinsics.checkNotNullExpressionValue((Object)hiltCompileConfiguration, (String)"hiltCompileConfiguration");
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2d20.add(hiltCompileConfiguration);
        iterable = iterable;
        boolean $i$f$map = false;
        void var6_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void configuration;
            Configuration configuration2 = (Configuration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl5 = false;
            FileCollection fileCollection = configuration.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath$lambda-22$lambda-21(artifactAttributeValue, arg_0)).getFiles();
            collection.add(fileCollection);
        }
        iterable = (List)destination$iv$iv;
        bl2 = false;
        boolean bl6 = false;
        Iterable it = iterable;
        boolean bl7 = false;
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileCollection[] fileCollectionArray = thisCollection$iv.toArray(new FileCollection[0]);
        if (fileCollectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        FileCollection[] fileCollectionArray2 = fileCollectionArray;
        return $project.files((Object[])Arrays.copyOf(fileCollectionArray2, fileCollectionArray2.length));
    }

    private static final void configureVariantAggregatingTask$lambda-24(Project $project, BaseVariant $variant, HiltExtension $hiltExtension, Configuration $hiltCompileConfiguration, AggregateDepsTask it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$hiltExtension, (String)"$hiltExtension");
        it.getCompileClasspath().setFrom((Iterable)HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, $hiltCompileConfiguration, $project, AGGREGATED_HILT_ARTIFACT_TYPE_VALUE));
        DirectoryProperty directoryProperty = it.getOutputDir();
        File file = $project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        directoryProperty.set($project.file((Object)kotlin.io.FilesKt.resolve((File)file, (String)("generated/hilt/component_trees/" + $variant.getName() + '/'))));
        it.getTestEnvironment().set((Object)($variant instanceof TestVariant || $variant instanceof UnitTestVariant ? 1 : 0));
        it.getCrossCompilationRootValidationDisabled().set((Object)$hiltExtension.getDisableCrossCompilationRootValidation());
    }

    private static final FileTree configureVariantAggregatingTask$lambda-31$lambda-25(AggregateDepsTask it) {
        return it.getOutputDir().getAsFileTree();
    }

    private static final FileCollection configureVariantAggregatingTask$lambda-31$lambda-26(Project $project, JavaCompile it) {
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        FileCollection fileCollection = it.getOptions().getBootstrapClasspath();
        return fileCollection == null ? (FileCollection)$project.files(new Object[0]) : fileCollection;
    }

    /*
     * WARNING - void declaration
     */
    private static final void configureVariantAggregatingTask$lambda-31(TaskProvider $aggregatingTask, BaseVariant $variant, BaseExtension $androidExtension, ConfigurableFileCollection $componentClasses, Project $project, Configuration $hiltCompileConfiguration, JavaCompile compileTask) {
        void config;
        Object element$iv2;
        Object object;
        boolean bl;
        boolean bl2;
        Object object2;
        Intrinsics.checkNotNullParameter((Object)$variant, (String)"$variant");
        Intrinsics.checkNotNullParameter((Object)$androidExtension, (String)"$androidExtension");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        compileTask.setSource((FileTree)$aggregatingTask.map(HiltGradlePlugin::configureVariantAggregatingTask$lambda-31$lambda-25).get());
        FileCollection mainBootstrapClasspath = (FileCollection)$variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda-31$lambda-26($project, arg_0)).get();
        if (JavaVersion.current().isJava9Compatible() && $androidExtension.getCompileOptions().getTargetCompatibility().isJava9Compatible()) {
            compileTask.setClasspath(HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, $hiltCompileConfiguration, $project, DAGGER_ARTIFACT_TYPE_VALUE).plus(mainBootstrapClasspath));
            object2 = $variant.getJavaCompileProvider().get();
            bl2 = false;
            bl = false;
            JavaCompile originalCompileTask = (JavaCompile)object2;
            boolean bl3 = false;
            object = originalCompileTask.getOptions().getCompilerArgumentProviders();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"originalCompileTask.opti\u2026compilerArgumentProviders");
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv2 : $this$forEach$iv) {
                CommandLineArgumentProvider it = (CommandLineArgumentProvider)element$iv2;
                boolean bl4 = false;
                compileTask.getOptions().getCompilerArgumentProviders().add(it);
            }
            compileTask.getOptions().getCompilerArgs().add("-XDstringConcat=inline");
        } else {
            compileTask.setClasspath((FileCollection)HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, $hiltCompileConfiguration, $project, DAGGER_ARTIFACT_TYPE_VALUE));
            compileTask.getOptions().setBootstrapClasspath(mainBootstrapClasspath);
        }
        compileTask.getDestinationDirectory().set($componentClasses.getSingleFile());
        object2 = compileTask.getOptions();
        bl2 = false;
        bl = false;
        Object $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30 = object2;
        boolean bl5 = false;
        ConfigurationContainer configurationContainer = $project.getConfigurations();
        object = $variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"variant.name");
        object = configurationContainer.create(Intrinsics.stringPlus((String)"hiltAnnotationProcessor", (Object)StringsKt.capitalize$default((String)object, null, 1, null)));
        boolean bl6 = false;
        boolean bl7 = false;
        element$iv2 = (Configuration)object;
        Object object3 = $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30;
        boolean bl8 = false;
        $project.getDependencies().add(config.getName(), (Object)Intrinsics.stringPlus((String)"com.google.dagger:hilt-compiler:", (Object)VersionKt.getHILT_VERSION()));
        Unit unit = Unit.INSTANCE;
        object3.setAnnotationProcessorPath((FileCollection)object);
        DirectoryProperty directoryProperty = $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30.getGeneratedSourceOutputDirectory();
        object = $project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.buildDir");
        directoryProperty.set($project.file((Object)kotlin.io.FilesKt.resolve((File)object, (String)("generated/hilt/component_sources/" + $variant.getName() + '/'))));
        if (JavaVersion.current().isJava8Compatible() && $androidExtension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
            $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30.getCompilerArgs().add("-parameters");
        }
        $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30.getCompilerArgs().add("-Adagger.fastInit=enabled");
        $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30.getCompilerArgs().add("-Adagger.hilt.internal.useAggregatingRootProcessor=false");
        $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30.getCompilerArgs().add("-Adagger.hilt.android.internal.disableAndroidSuperclassValidation=true");
        $this$configureVariantAggregatingTask_u24lambda_u2d31_u24lambda_u2d30.setEncoding($androidExtension.getCompileOptions().getEncoding());
        compileTask.setSourceCompatibility($androidExtension.getCompileOptions().getSourceCompatibility().toString());
        compileTask.setTargetCompatibility($androidExtension.getCompileOptions().getTargetCompatibility().toString());
    }

    public static final /* synthetic */ void access$configureVariantCompileClasspath(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        $this.configureVariantCompileClasspath(project, hiltExtension, androidExtension, variant);
    }

    public static final /* synthetic */ void access$configureBytecodeTransformASM$registerTransform(HiltExtension $hiltExtension, Ref.BooleanRef warnAboutLocalTestsFlag, Project $project, ComponentCompat androidComponent) {
        HiltGradlePlugin.configureBytecodeTransformASM$registerTransform($hiltExtension, warnAboutLocalTestsFlag, $project, androidComponent);
    }

    public static final /* synthetic */ void access$configureVariantAggregatingTask(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        $this.configureVariantAggregatingTask(project, hiltExtension, androidExtension, variant);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R5\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00060\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin$Companion;", "", "()V", "AGGREGATED_HILT_ARTIFACT_TYPE_VALUE", "", "ARTIFACT_TYPE_ATTRIBUTE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "getARTIFACT_TYPE_ATTRIBUTE", "()Lorg/gradle/api/attributes/Attribute;", "DAGGER_ARTIFACT_TYPE_VALUE", "LIBRARY_GROUP", "missingDepError", "Lkotlin/Function1;", "getMissingDepError", "()Lkotlin/jvm/functions/Function1;", "plugin"})
    public static final class Companion {
        private Companion() {
        }

        public final Attribute<String> getARTIFACT_TYPE_ATTRIBUTE() {
            return ARTIFACT_TYPE_ATTRIBUTE;
        }

        @NotNull
        public final Function1<String, String> getMissingDepError() {
            return missingDepError;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

