/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin.task;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.UnitTestVariant;
import dagger.hilt.android.plugin.AndroidEntryPointClassTransformer;
import dagger.hilt.android.plugin.HiltExtension;
import dagger.hilt.android.plugin.task.HiltTransformTestClassesTask;
import dagger.hilt.android.plugin.util.FilesKt;
import dagger.hilt.android.plugin.util.StringsKt;
import dagger.hilt.android.plugin.util.TasksKt;
import java.io.File;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.testing.Test;
import org.gradle.workers.WorkAction;
import org.gradle.workers.WorkParameters;
import org.gradle.workers.WorkerExecutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.plugin.KotlinBasePluginWrapper;
import org.jetbrains.kotlin.gradle.tasks.KotlinCompile;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u000f2\u00020\u0001:\u0004\u000f\u0010\u0011\u0012B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\u000eH\u0007R\u0014\u0010\u0005\u001a\u00020\u00068gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8gX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/task/HiltTransformTestClassesTask;", "Lorg/gradle/api/DefaultTask;", "workerExecutor", "Lorg/gradle/workers/WorkerExecutor;", "(Lorg/gradle/workers/WorkerExecutor;)V", "compiledClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompiledClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;", "transformClasses", "", "Companion", "ConfigAction", "Parameters", "WorkerAction"})
public abstract class HiltTransformTestClassesTask
extends DefaultTask {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final WorkerExecutor workerExecutor;
    @NotNull
    private static final String TASK_PREFIX = "hiltTransformFor";

    @Inject
    public HiltTransformTestClassesTask(@NotNull WorkerExecutor workerExecutor) {
        Intrinsics.checkNotNullParameter((Object)workerExecutor, (String)"workerExecutor");
        this.workerExecutor = workerExecutor;
    }

    @Classpath
    @NotNull
    public abstract ConfigurableFileCollection getCompiledClasses();

    @OutputDirectory
    @NotNull
    public abstract DirectoryProperty getOutputDir();

    @TaskAction
    public final void transformClasses() {
        this.workerExecutor.noIsolation().submit(WorkerAction.class, arg_0 -> HiltTransformTestClassesTask.transformClasses$lambda$0((Function1)new Function1<Parameters, Unit>(this){
            final /* synthetic */ HiltTransformTestClassesTask this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Parameters it) {
                Object[] objectArray = new Object[]{this.this$0.getCompiledClasses()};
                it.getCompiledClasses().from(objectArray);
                it.getOutputDir().set((Provider)this.this$0.getOutputDir());
                it.getName().set((Object)this.this$0.getName());
            }
        }, arg_0));
    }

    private static final void transformClasses$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016"}, d2={"Ldagger/hilt/android/plugin/task/HiltTransformTestClassesTask$WorkerAction;", "Lorg/gradle/workers/WorkAction;", "Ldagger/hilt/android/plugin/task/HiltTransformTestClassesTask$Parameters;", "()V", "execute", ""})
    @SourceDebugExtension(value={"SMAP\nHiltTransformTestClassesTask.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiltTransformTestClassesTask.kt\ndagger/hilt/android/plugin/task/HiltTransformTestClassesTask$WorkerAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,171:1\n1849#2:172\n1850#2:175\n1290#3,2:173\n*S KotlinDebug\n*F\n+ 1 HiltTransformTestClassesTask.kt\ndagger/hilt/android/plugin/task/HiltTransformTestClassesTask$WorkerAction\n*L\n77#1:172\n77#1:175\n79#1:173,2\n*E\n"})
    public static abstract class WorkerAction
    implements WorkAction<Parameters> {
        public void execute() {
            File outputDir = (File)((Parameters)this.getParameters()).getOutputDir().getAsFile().get();
            Intrinsics.checkNotNullExpressionValue((Object)outputDir, (String)"outputDir");
            kotlin.io.FilesKt.deleteRecursively((File)outputDir);
            outputDir.mkdirs();
            Set set = ((Parameters)this.getParameters()).getCompiledClasses().getFiles();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"parameters.compiledClasses.files");
            List allInputs = CollectionsKt.toList((Iterable)set);
            Object object = ((Parameters)this.getParameters()).getName().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"parameters.name.get()");
            AndroidEntryPointClassTransformer classTransformer = new AndroidEntryPointClassTransformer((String)object, allInputs, outputDir, false);
            Iterable $this$forEach$iv = CollectionsKt.reversed((Iterable)allInputs);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                File it = (File)element$iv;
                boolean bl = false;
                if (it.isDirectory()) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    Sequence $this$forEach$iv2 = (Sequence)kotlin.io.FilesKt.walkTopDown((File)it);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        File file = (File)element$iv2;
                        boolean bl2 = false;
                        if (!FilesKt.isClassFile(file)) continue;
                        classTransformer.transformFile(file);
                    }
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!FilesKt.isJarFile(it)) continue;
                classTransformer.transformJarContents(it);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/task/HiltTransformTestClassesTask$Companion;", "", "()V", "TASK_PREFIX", "", "create", "", "project", "Lorg/gradle/api/Project;", "unitTestVariant", "Lcom/android/build/gradle/api/UnitTestVariant;", "extension", "Ldagger/hilt/android/plugin/HiltExtension;"})
    public static final class Companion {
        private Companion() {
        }

        public final void create(@NotNull Project project, @NotNull UnitTestVariant unitTestVariant, @NotNull HiltExtension extension) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)unitTestVariant, (String)"unitTestVariant");
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            if (!extension.getEnableTransformForLocalTests()) {
                return;
            }
            Object[] objectArray = new Object[]{unitTestVariant.getCompileClasspath(null)};
            ConfigurableFileCollection inputClasspath = project.files(objectArray);
            TaskProvider testCompileTaskProvider = unitTestVariant.getJavaCompileProvider();
            Object[] objectArray2 = new Object[]{testCompileTaskProvider.map(arg_0 -> Companion.create$lambda$0(create.1.INSTANCE, arg_0))};
            inputClasspath.from(objectArray2);
            project.getPlugins().withType(KotlinBasePluginWrapper.class, arg_0 -> Companion.create$lambda$1((Function1)new Function1<KotlinBasePluginWrapper, Unit>(unitTestVariant, project, inputClasspath){
                final /* synthetic */ UnitTestVariant $unitTestVariant;
                final /* synthetic */ Project $project;
                final /* synthetic */ ConfigurableFileCollection $inputClasspath;
                {
                    this.$unitTestVariant = $unitTestVariant;
                    this.$project = $project;
                    this.$inputClasspath = $inputClasspath;
                    super(1);
                }

                public final void invoke(KotlinBasePluginWrapper it) {
                    TaskProvider<KotlinCompile> kotlinCompileTaskProvider = TasksKt.getCompileKotlin((BaseVariant)this.$unitTestVariant, this.$project);
                    Object[] objectArray = new Object[]{kotlinCompileTaskProvider.map(arg_0 -> create.2.invoke$lambda$0(Companion.create.1.INSTANCE, arg_0))};
                    this.$inputClasspath.from(objectArray);
                }

                private static final DirectoryProperty invoke$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (DirectoryProperty)$tmp0.invoke(p0);
                }
            }, arg_0));
            File file = project.getBuildDir();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
            File outputDir = kotlin.io.FilesKt.resolve((File)file, (String)("intermediates/hilt/" + unitTestVariant.getDirName() + "Output"));
            TaskContainer taskContainer = project.getTasks();
            String string = unitTestVariant.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"unitTestVariant.name");
            String string2 = HiltTransformTestClassesTask.TASK_PREFIX + StringsKt.capitalize$default(string, null, 1, null);
            Intrinsics.checkNotNullExpressionValue((Object)inputClasspath, (String)"inputClasspath");
            TaskProvider hiltTransformProvider = taskContainer.register(string2, HiltTransformTestClassesTask.class, (Action)new ConfigAction(outputDir, (FileCollection)inputClasspath));
            Object[] objectArray3 = new Object[]{hiltTransformProvider.map(arg_0 -> Companion.create$lambda$2(create.outputFileCollection.1.INSTANCE, arg_0))};
            ConfigurableFileCollection outputFileCollection2 = project.files(objectArray3);
            TaskContainer taskContainer2 = project.getTasks();
            String string3 = unitTestVariant.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"unitTestVariant.name");
            TaskProvider taskProvider = taskContainer2.named("test" + StringsKt.capitalize$default(string3, null, 1, null));
            Intrinsics.checkNotNull((Object)taskProvider, (String)"null cannot be cast to non-null type org.gradle.api.tasks.TaskProvider<org.gradle.api.tasks.testing.Test>");
            TaskProvider testTaskProvider = taskProvider;
            testTaskProvider.configure(arg_0 -> Companion.create$lambda$3((Function1)new Function1<Test, Unit>(outputFileCollection2){
                final /* synthetic */ ConfigurableFileCollection $outputFileCollection;
                {
                    this.$outputFileCollection = $outputFileCollection;
                    super(1);
                }

                public final void invoke(Test it) {
                    it.setClasspath(this.$outputFileCollection.plus(it.getClasspath()));
                }
            }, arg_0));
        }

        private static final DirectoryProperty create$lambda$0(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (DirectoryProperty)$tmp0.invoke(p0);
        }

        private static final void create$lambda$1(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        private static final DirectoryProperty create$lambda$2(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (DirectoryProperty)$tmp0.invoke(p0);
        }

        private static final void create$lambda$3(Function1 $tmp0, Object p0) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b`\u0018\u00002\u00020\u0001R\u0012\u0010\u0002\u001a\u00020\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0018\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0012\u0010\u000b\u001a\u00020\fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e"}, d2={"Ldagger/hilt/android/plugin/task/HiltTransformTestClassesTask$Parameters;", "Lorg/gradle/workers/WorkParameters;", "compiledClasses", "Lorg/gradle/api/file/ConfigurableFileCollection;", "getCompiledClasses", "()Lorg/gradle/api/file/ConfigurableFileCollection;", "name", "Lorg/gradle/api/provider/Property;", "", "getName", "()Lorg/gradle/api/provider/Property;", "outputDir", "Lorg/gradle/api/file/DirectoryProperty;", "getOutputDir", "()Lorg/gradle/api/file/DirectoryProperty;"})
    public static interface Parameters
    extends WorkParameters {
        @NotNull
        public Property<String> getName();

        @NotNull
        public ConfigurableFileCollection getCompiledClasses();

        @NotNull
        public DirectoryProperty getOutputDir();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/task/HiltTransformTestClassesTask$ConfigAction;", "Lorg/gradle/api/Action;", "Ldagger/hilt/android/plugin/task/HiltTransformTestClassesTask;", "outputDir", "Ljava/io/File;", "inputClasspath", "Lorg/gradle/api/file/FileCollection;", "(Ljava/io/File;Lorg/gradle/api/file/FileCollection;)V", "execute", "", "transformTask"})
    public static final class ConfigAction
    implements Action<HiltTransformTestClassesTask> {
        @NotNull
        private final File outputDir;
        @NotNull
        private final FileCollection inputClasspath;

        public ConfigAction(@NotNull File outputDir, @NotNull FileCollection inputClasspath) {
            Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
            Intrinsics.checkNotNullParameter((Object)inputClasspath, (String)"inputClasspath");
            this.outputDir = outputDir;
            this.inputClasspath = inputClasspath;
        }

        public void execute(@NotNull HiltTransformTestClassesTask transformTask) {
            Intrinsics.checkNotNullParameter((Object)((Object)transformTask), (String)"transformTask");
            transformTask.setDescription("Transforms AndroidEntryPoint annotated classes for JUnit tests.");
            transformTask.getOutputDir().set(this.outputDir);
            Object[] objectArray = new Object[]{this.inputClasspath};
            transformTask.getCompiledClasses().from(objectArray);
        }
    }
}

