/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import dagger.hilt.android.plugin.util.FilesKt;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.bytecode.ByteArray;
import javassist.bytecode.Bytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000 %2\u00020\u0001:\u0001%B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0006J\u000e\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u0006J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0003H\u0002J \u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u0003H\u0002J1\u0010\u001f\u001a\u00020\u001a*\u00020 2#\u0010!\u001a\u001f\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020\u001a0\"\u00a2\u0006\u0002\b$H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassTransformer;", "", "taskName", "", "allInputs", "", "Ljava/io/File;", "sourceRootOutputDir", "copyNonTransformed", "", "(Ljava/lang/String;Ljava/util/List;Ljava/io/File;Z)V", "classPool", "Ljavassist/ClassPool;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getTaskName", "()Ljava/lang/String;", "transformClass", "clazz", "Ljavassist/CtClass;", "transformClassToOutput", "transformFile", "inputFile", "transformJarContents", "transformOnReceive", "", "entryPointSuperclassName", "transformSuperMethodCalls", "oldSuperclassName", "newSuperclassName", "forEachInstruction", "Ljavassist/bytecode/CodeIterator;", "body", "Lkotlin/Function3;", "", "Lkotlin/ExtensionFunctionType;", "Companion"})
@SourceDebugExtension(value={"SMAP\nAndroidEntryPointClassTransformer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AndroidEntryPointClassTransformer.kt\ndagger/hilt/android/plugin/AndroidEntryPointClassTransformer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,260:1\n1849#2,2:261\n2468#2,3:264\n1849#2,2:272\n1#3:263\n12701#4,2:267\n3785#4:269\n4300#4,2:270\n1102#4,2:274\n*S KotlinDebug\n*F\n+ 1 AndroidEntryPointClassTransformer.kt\ndagger/hilt/android/plugin/AndroidEntryPointClassTransformer\n*L\n52#1:261,2\n118#1:264,3\n178#1:272,2\n137#1:267,2\n172#1:269\n172#1:270,2\n226#1:274,2\n*E\n"})
public final class AndroidEntryPointClassTransformer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String taskName;
    @NotNull
    private final File sourceRootOutputDir;
    private final boolean copyNonTransformed;
    private final Logger logger;
    @NotNull
    private final ClassPool classPool;
    @NotNull
    private static final Set<String> ANDROID_ENTRY_POINT_ANNOTATIONS;
    @NotNull
    private static final String ON_RECEIVE_METHOD_NAME;
    @NotNull
    private static final String ON_RECEIVE_METHOD_SIGNATURE;

    /*
     * WARNING - void declaration
     */
    public AndroidEntryPointClassTransformer(@NotNull String taskName, @NotNull List<? extends File> allInputs, @NotNull File sourceRootOutputDir, boolean copyNonTransformed) {
        ClassPool classPool;
        Intrinsics.checkNotNullParameter((Object)taskName, (String)"taskName");
        Intrinsics.checkNotNullParameter(allInputs, (String)"allInputs");
        Intrinsics.checkNotNullParameter((Object)sourceRootOutputDir, (String)"sourceRootOutputDir");
        this.taskName = taskName;
        this.sourceRootOutputDir = sourceRootOutputDir;
        this.copyNonTransformed = copyNonTransformed;
        this.logger = LoggerFactory.getLogger(AndroidEntryPointClassTransformer.class);
        ClassPool classPool2 = classPool = new ClassPool(true);
        AndroidEntryPointClassTransformer androidEntryPointClassTransformer = this;
        boolean bl = false;
        Iterable $this$forEach$iv = allInputs;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void pool;
            File it = (File)element$iv;
            boolean bl2 = false;
            pool.appendClassPath(it.getPath());
        }
        androidEntryPointClassTransformer.classPool = classPool;
        this.sourceRootOutputDir.mkdirs();
    }

    @NotNull
    public final String getTaskName() {
        return this.taskName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean transformJarContents(@NotNull File inputFile) {
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        boolean bl = FilesKt.isJarFile(inputFile);
        if (!bl) {
            boolean $i$a$-require-AndroidEntryPointClassTransformer$transformJarContents$22 = false;
            String $i$a$-require-AndroidEntryPointClassTransformer$transformJarContents$22 = "Invalid file, '" + inputFile + "' is not a jar.";
            throw (Throwable)new IllegalArgumentException($i$a$-require-AndroidEntryPointClassTransformer$transformJarContents$22.toString());
        }
        boolean bl2 = bl = !this.copyNonTransformed;
        if (!bl) {
            boolean bl3 = false;
            String string = "Transforming a jar is not supported with 'copyNonTransformed'.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        boolean transformed = false;
        Closeable closeable = new ZipInputStream(new FileInputStream(inputFile));
        Throwable throwable = null;
        try {
            ZipInputStream input = (ZipInputStream)closeable;
            boolean bl4 = false;
            ZipEntry entry = input.getNextEntry();
            while (entry != null) {
                if (FilesKt.isClassFile(entry)) {
                    CtClass clazz = this.classPool.makeClass((InputStream)input, false);
                    Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"clazz");
                    transformed = this.transformClassToOutput(clazz) || transformed;
                    clazz.detach();
                }
                entry = input.getNextEntry();
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return transformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean transformFile(@NotNull File inputFile) {
        CtClass ctClass;
        Intrinsics.checkNotNullParameter((Object)inputFile, (String)"inputFile");
        boolean bl = FilesKt.isClassFile(inputFile);
        if (!bl) {
            boolean $i$a$-check-AndroidEntryPointClassTransformer$transformFile$22 = false;
            String $i$a$-check-AndroidEntryPointClassTransformer$transformFile$22 = "Invalid file, '" + inputFile + "' is not a class.";
            throw (Throwable)new IllegalStateException($i$a$-check-AndroidEntryPointClassTransformer$transformFile$22.toString());
        }
        Closeable $i$a$-check-AndroidEntryPointClassTransformer$transformFile$22 = new FileInputStream(inputFile);
        Throwable throwable = null;
        try {
            FileInputStream it = (FileInputStream)$i$a$-check-AndroidEntryPointClassTransformer$transformFile$22;
            boolean bl2 = false;
            ctClass = this.classPool.makeClass((InputStream)it, false);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$a$-check-AndroidEntryPointClassTransformer$transformFile$22, (Throwable)throwable);
        }
        CtClass clazz = ctClass;
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"clazz");
        boolean transformed = this.transformClassToOutput(clazz);
        clazz.detach();
        return transformed;
    }

    private final boolean transformClassToOutput(CtClass clazz) {
        boolean transformed = this.transformClass(clazz);
        if (transformed || this.copyNonTransformed) {
            clazz.writeFile(this.sourceRootOutputDir.getPath());
        }
        return transformed;
    }

    private final boolean transformClass(CtClass clazz) {
        boolean bl;
        String entryPointSuperclassName;
        block7: {
            boolean bl2;
            block6: {
                Iterable $this$none$iv = ANDROID_ENTRY_POINT_ANNOTATIONS;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl2 = true;
                } else {
                    for (Object element$iv : $this$none$iv) {
                        String it = (String)element$iv;
                        boolean bl3 = false;
                        if (!clazz.hasAnnotation(it)) continue;
                        bl2 = false;
                        break block6;
                    }
                    bl2 = true;
                }
            }
            if (bl2) {
                return false;
            }
            String superclassName = clazz.getClassFile().getSuperclass();
            String string = clazz.getPackageName();
            String string2 = clazz.getSimpleName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"clazz.simpleName");
            entryPointSuperclassName = string + ".Hilt_" + StringsKt.replace$default((String)string2, (String)"$", (String)"_", (boolean)false, (int)4, null);
            this.logger.info("[" + this.taskName + "] Transforming " + clazz.getName() + " to extend " + entryPointSuperclassName + " instead of " + superclassName + ".");
            CtClass entryPointSuperclass = this.classPool.get(entryPointSuperclassName);
            clazz.setSuperclass(entryPointSuperclass);
            Intrinsics.checkNotNullExpressionValue((Object)superclassName, (String)"superclassName");
            this.transformSuperMethodCalls(clazz, superclassName, entryPointSuperclassName);
            CtField[] ctFieldArray = entryPointSuperclass.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)ctFieldArray, (String)"entryPointSuperclass.declaredFields");
            Object[] $this$any$iv = ctFieldArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                CtField it = (CtField)element$iv;
                boolean bl4 = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)"onReceiveBytecodeInjectionMarker")) continue;
                bl = true;
                break block7;
            }
            bl = false;
        }
        if (bl) {
            this.transformOnReceive(clazz, entryPointSuperclassName);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final void transformSuperMethodCalls(CtClass clazz, String oldSuperclassName, String newSuperclassName) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        ConstPool constantPool = clazz.getClassFile().getConstPool();
        CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
        Intrinsics.checkNotNullExpressionValue((Object)ctMethodArray, (String)"clazz.declaredMethods");
        Object[] objectArray = ctMethodArray;
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (void element$iv$iv : $this$filterTo$iv$iv) {
            CtMethod it = (CtMethod)element$iv$iv;
            boolean bl = false;
            boolean bl2 = it.getMethodInfo().isMethod() && !Modifier.isStatic((int)it.getModifiers()) && !Modifier.isAbstract((int)it.getModifiers()) && !Modifier.isNative((int)it.getModifiers());
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CtMethod method = (CtMethod)element$iv;
            boolean bl = false;
            CodeAttribute codeAttr = method.getMethodInfo().getCodeAttribute();
            byte[] code = codeAttr.getCode();
            CodeIterator codeIterator = codeAttr.iterator();
            Intrinsics.checkNotNullExpressionValue((Object)codeIterator, (String)"codeAttr.iterator()");
            this.forEachInstruction(codeIterator, (Function3<? super CodeIterator, ? super Integer, ? super Integer, Unit>)((Function3)new Function3<CodeIterator, Integer, Integer, Unit>(code, constantPool, oldSuperclassName, newSuperclassName, this, clazz, method){
                final /* synthetic */ byte[] $code;
                final /* synthetic */ ConstPool $constantPool;
                final /* synthetic */ String $oldSuperclassName;
                final /* synthetic */ String $newSuperclassName;
                final /* synthetic */ AndroidEntryPointClassTransformer this$0;
                final /* synthetic */ CtClass $clazz;
                final /* synthetic */ CtMethod $method;
                {
                    this.$code = $code;
                    this.$constantPool = $constantPool;
                    this.$oldSuperclassName = $oldSuperclassName;
                    this.$newSuperclassName = $newSuperclassName;
                    this.this$0 = $receiver;
                    this.$clazz = $clazz;
                    this.$method = $method;
                    super(3);
                }

                public final void invoke(@NotNull CodeIterator $this$forEachInstruction, int index, int opcode) {
                    Intrinsics.checkNotNullParameter((Object)$this$forEachInstruction, (String)"$this$forEachInstruction");
                    if (opcode != 183) {
                        return;
                    }
                    int methodRef = ByteArray.readU16bit((byte[])this.$code, (int)(index + 1));
                    String currentClassRef = this.$constantPool.getMethodrefClassName(methodRef);
                    if (!Intrinsics.areEqual((Object)currentClassRef, (Object)this.$oldSuperclassName)) {
                        return;
                    }
                    String methodRefName = this.$constantPool.getMethodrefName(methodRef);
                    if (Intrinsics.areEqual((Object)methodRefName, (Object)"<init>")) {
                        return;
                    }
                    int nameAndTypeRef = this.$constantPool.getMethodrefNameAndType(methodRef);
                    int newSuperclassRef = this.$constantPool.addClassInfo(this.$newSuperclassName);
                    int newMethodRef = this.$constantPool.addMethodrefInfo(newSuperclassRef, nameAndTypeRef);
                    AndroidEntryPointClassTransformer.access$getLogger$p(this.this$0).info("[" + this.this$0.getTaskName() + "] Redirecting an invokespecial in " + this.$clazz.getName() + "." + this.$method.getName() + ":" + this.$method.getSignature() + " at code index " + index + " from method ref #" + methodRef + " to #" + newMethodRef + ".");
                    ByteArray.write16bit((int)newMethodRef, (byte[])this.$code, (int)(index + 1));
                }
            }));
        }
    }

    private final void forEachInstruction(CodeIterator $this$forEachInstruction, Function3<? super CodeIterator, ? super Integer, ? super Integer, Unit> body) {
        while ($this$forEachInstruction.hasNext()) {
            int index = $this$forEachInstruction.next();
            body.invoke((Object)$this$forEachInstruction, (Object)index, (Object)$this$forEachInstruction.byteAt(index));
        }
    }

    private final void transformOnReceive(CtClass clazz, String entryPointSuperclassName) {
        Object element$iv;
        Bytecode bytecode;
        block2: {
            CtMethod[] ctMethodArray = clazz.getDeclaredMethods();
            Intrinsics.checkNotNullExpressionValue((Object)ctMethodArray, (String)"clazz.declaredMethods");
            Bytecode $this$first$iv = (Bytecode)ctMethodArray;
            boolean $i$f$first = false;
            bytecode = $this$first$iv;
            int n = ((Object[])bytecode).length;
            for (int i = 0; i < n; ++i) {
                element$iv = bytecode[i];
                CtMethod it = (CtMethod)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)(it.getName() + it.getSignature()), (Object)(ON_RECEIVE_METHOD_NAME + ON_RECEIVE_METHOD_SIGNATURE))) {
                    continue;
                }
                break block2;
            }
            throw (Throwable)new NoSuchElementException("Array contains no element matching the predicate.");
        }
        CtMethod method = (CtMethod)element$iv;
        ConstPool constantPool = clazz.getClassFile().getConstPool();
        Bytecode $this$transformOnReceive_u24lambda_u2412 = bytecode = new Bytecode(constantPool);
        boolean bl = false;
        $this$transformOnReceive_u24lambda_u2412.addAload(0);
        $this$transformOnReceive_u24lambda_u2412.addAload(1);
        $this$transformOnReceive_u24lambda_u2412.addAload(2);
        $this$transformOnReceive_u24lambda_u2412.addInvokespecial(entryPointSuperclassName, ON_RECEIVE_METHOD_NAME, ON_RECEIVE_METHOD_SIGNATURE);
        Bytecode newCode = bytecode;
        CodeAttribute newCodeAttribute = newCode.toCodeAttribute();
        CodeAttribute currentCodeAttribute = method.getMethodInfo().getCodeAttribute();
        currentCodeAttribute.setMaxStack(Math.max(newCodeAttribute.getMaxStack(), currentCodeAttribute.getMaxStack()));
        currentCodeAttribute.setMaxLocals(Math.max(newCodeAttribute.getMaxLocals(), currentCodeAttribute.getMaxLocals()));
        CodeIterator codeIterator = currentCodeAttribute.iterator();
        int pos = codeIterator.insertEx(newCode.get());
        codeIterator.insert(newCodeAttribute.getExceptionTable(), pos);
        method.getMethodInfo().rebuildStackMap(clazz.getClassPool());
    }

    public static final /* synthetic */ Logger access$getLogger$p(AndroidEntryPointClassTransformer $this) {
        return $this.logger;
    }

    static {
        Object[] objectArray = new String[]{"dagger.hilt.android.AndroidEntryPoint", "dagger.hilt.android.HiltAndroidApp"};
        ANDROID_ENTRY_POINT_ANNOTATIONS = SetsKt.setOf((Object[])objectArray);
        ON_RECEIVE_METHOD_NAME = "onReceive";
        ON_RECEIVE_METHOD_SIGNATURE = "(Landroid/content/Context;Landroid/content/Intent;)V";
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u0005X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n"}, d2={"Ldagger/hilt/android/plugin/AndroidEntryPointClassTransformer$Companion;", "", "()V", "ANDROID_ENTRY_POINT_ANNOTATIONS", "", "", "getANDROID_ENTRY_POINT_ANNOTATIONS", "()Ljava/util/Set;", "ON_RECEIVE_METHOD_NAME", "getON_RECEIVE_METHOD_NAME", "()Ljava/lang/String;", "ON_RECEIVE_METHOD_SIGNATURE", "getON_RECEIVE_METHOD_SIGNATURE"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<String> getANDROID_ENTRY_POINT_ANNOTATIONS() {
            return ANDROID_ENTRY_POINT_ANNOTATIONS;
        }

        @NotNull
        public final String getON_RECEIVE_METHOD_NAME() {
            return ON_RECEIVE_METHOD_NAME;
        }

        @NotNull
        public final String getON_RECEIVE_METHOD_SIGNATURE() {
            return ON_RECEIVE_METHOD_SIGNATURE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

