/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import com.android.build.api.instrumentation.FramesComputationMode;
import com.android.build.api.instrumentation.InstrumentationScope;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.api.AndroidBasePlugin;
import com.android.build.gradle.api.ApplicationVariant;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.tasks.JdkImageInput;
import dagger.hilt.android.plugin.AndroidEntryPointClassVisitor;
import dagger.hilt.android.plugin.HiltCommandLineArgumentProvider;
import dagger.hilt.android.plugin.HiltExtension;
import dagger.hilt.android.plugin.HiltExtensionImpl;
import dagger.hilt.android.plugin.HiltGradlePlugin;
import dagger.hilt.android.plugin.VersionKt;
import dagger.hilt.android.plugin.task.AggregateDepsTask;
import dagger.hilt.android.plugin.util.AGPVersionCompatKt;
import dagger.hilt.android.plugin.util.AggregatedPackagesTransform;
import dagger.hilt.android.plugin.util.ComponentCompat;
import dagger.hilt.android.plugin.util.ConfigurationsKt;
import dagger.hilt.android.plugin.util.CopyTransform;
import dagger.hilt.android.plugin.util.SimpleAGPVersion;
import dagger.hilt.android.plugin.util.StringsKt;
import dagger.hilt.android.plugin.util.TasksKt;
import dagger.hilt.processor.internal.optionvalues.GradleProjectType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001 B\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\r\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u000e\u001a\n \u0010*\u0004\u0018\u00010\u000f0\u000f2\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0018\u0010\u0012\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J(\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J(\u0010\u0018\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u000e\u0010\u001a\u001a\u0004\u0018\u00010\u0015*\u00020\u0002H\u0002J/\u0010\u001b\u001a\u00020\u0007*\u00020\u00152!\u0010\u001c\u001a\u001d\u0012\u0013\u0012\u00110\u0017\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u0016\u0012\u0004\u0012\u00020\u00070\u001dH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "apply", "", "project", "configureAggregatingTask", "hiltExtension", "Ldagger/hilt/android/plugin/HiltExtension;", "configureBytecodeTransformASM", "configureCompileClasspath", "configureDependencyTransforms", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "kotlin.jvm.PlatformType", "configureHilt", "configureProcessorFlags", "configureVariantAggregatingTask", "androidExtension", "Lcom/android/build/gradle/BaseExtension;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "configureVariantCompileClasspath", "verifyDependencies", "baseExtension", "forEachRootVariant", "block", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "Companion"})
@SourceDebugExtension(value={"SMAP\nHiltGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,497:1\n1741#2,3:498\n817#2:503\n845#2,2:504\n1358#2:506\n1444#2,2:507\n1547#2:509\n1618#2,3:510\n1446#2,3:513\n1547#2:516\n1618#2,3:517\n37#3,2:501\n37#3,2:520\n*S KotlinDebug\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin\n*L\n189#1:498,3\n465#1:503\n465#1:504,2\n470#1:506\n470#1:507,2\n471#1:509\n471#1:510,3\n470#1:513,3\n338#1:516\n338#1:517,3\n325#1:501,2\n343#1:520,2\n*E\n"})
public final class HiltGradlePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providers;
    private static final Attribute<String> ARTIFACT_TYPE_ATTRIBUTE = Attribute.of((String)"artifactType", String.class);
    @NotNull
    public static final String DAGGER_ARTIFACT_TYPE_VALUE = "jar-for-dagger";
    @NotNull
    public static final String AGGREGATED_HILT_ARTIFACT_TYPE_VALUE = "aggregated-jar-for-hilt";
    @NotNull
    public static final String LIBRARY_GROUP = "com.google.dagger";

    @Inject
    public HiltGradlePlugin(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.providers = providers;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.BooleanRef configured = new Ref.BooleanRef();
        project.getPlugins().withType(AndroidBasePlugin.class, arg_0 -> HiltGradlePlugin.apply$lambda$0((Function1)new Function1<AndroidBasePlugin, Unit>(configured, this, project){
            final /* synthetic */ Ref.BooleanRef $configured;
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.$configured = $configured;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(AndroidBasePlugin it) {
                this.$configured.element = true;
                HiltGradlePlugin.access$configureHilt(this.this$0, this.$project);
            }
        }, arg_0));
        project.afterEvaluate(arg_0 -> HiltGradlePlugin.apply$lambda$1((Function1)new Function1<Project, Unit>(configured, this){
            final /* synthetic */ Ref.BooleanRef $configured;
            final /* synthetic */ HiltGradlePlugin this$0;
            {
                this.$configured = $configured;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Project it) {
                boolean bl = this.$configured.element;
                if (!bl) {
                    boolean bl2 = false;
                    String string = "The Hilt Android Gradle plugin can only be applied to an Android project.";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                HiltGradlePlugin.access$verifyDependencies(this.this$0, it);
            }
        }, arg_0));
    }

    private final void configureHilt(Project project) {
        HiltExtension hiltExtension = (HiltExtension)project.getExtensions().create(HiltExtension.class, "hilt", HiltExtensionImpl.class, new Object[0]);
        if (SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION().compareTo(new SimpleAGPVersion(7, 0)) < 0) {
            throw (Throwable)new IllegalStateException(("The Hilt Android Gradle plugin is only compatible with Android Gradle plugin (AGP) version 7.0 or higher (found " + SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION() + ").").toString());
        }
        this.configureDependencyTransforms(project);
        Intrinsics.checkNotNullExpressionValue((Object)hiltExtension, (String)"hiltExtension");
        this.configureCompileClasspath(project, hiltExtension);
        this.configureBytecodeTransformASM(project);
        this.configureAggregatingTask(project, hiltExtension);
        this.configureProcessorFlags(project, hiltExtension);
    }

    private final DependencyHandler configureDependencyTransforms(Project project) {
        DependencyHandler dependencyHandler;
        DependencyHandler $this$configureDependencyTransforms_u24lambda_u245 = dependencyHandler = project.getDependencies();
        boolean bl = false;
        $this$configureDependencyTransforms_u24lambda_u245.registerTransform(CopyTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$5$lambda$2(configureDependencyTransforms.1.1.INSTANCE, arg_0));
        $this$configureDependencyTransforms_u24lambda_u245.registerTransform(CopyTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$5$lambda$3(configureDependencyTransforms.1.2.INSTANCE, arg_0));
        $this$configureDependencyTransforms_u24lambda_u245.registerTransform(AggregatedPackagesTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$5$lambda$4(configureDependencyTransforms.1.3.INSTANCE, arg_0));
        return dependencyHandler;
    }

    private final void configureCompileClasspath(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = this.baseExtension(project);
        if (baseExtension == null) {
            throw (Throwable)new IllegalStateException("Android BaseExtension not found.".toString());
        }
        BaseExtension androidExtension = baseExtension;
        this.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension, androidExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ BaseExtension $androidExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$hiltExtension = $hiltExtension;
                this.$androidExtension = $androidExtension;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantCompileClasspath(this.this$0, this.$project, this.$hiltExtension, this.$androidExtension, variant);
            }
        }));
    }

    private final void forEachRootVariant(BaseExtension $this$forEachRootVariant, Function1<? super BaseVariant, Unit> block) {
        BaseExtension baseExtension = $this$forEachRootVariant;
        if (baseExtension instanceof AppExtension) {
            ((AppExtension)$this$forEachRootVariant).getApplicationVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda$6((Function1)new Function1<ApplicationVariant, Unit>(block){
                final /* synthetic */ Function1<BaseVariant, Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(ApplicationVariant it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$block.invoke((Object)it);
                }
            }, arg_0));
            ((AppExtension)$this$forEachRootVariant).getTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda$7((Function1)new Function1<TestVariant, Unit>(block){
                final /* synthetic */ Function1<BaseVariant, Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(TestVariant it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$block.invoke((Object)it);
                }
            }, arg_0));
            ((AppExtension)$this$forEachRootVariant).getUnitTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda$8((Function1)new Function1<UnitTestVariant, Unit>(block){
                final /* synthetic */ Function1<BaseVariant, Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(UnitTestVariant it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$block.invoke((Object)it);
                }
            }, arg_0));
        } else if (baseExtension instanceof LibraryExtension) {
            ((LibraryExtension)$this$forEachRootVariant).getTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda$9((Function1)new Function1<TestVariant, Unit>(block){
                final /* synthetic */ Function1<BaseVariant, Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(TestVariant it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$block.invoke((Object)it);
                }
            }, arg_0));
            ((LibraryExtension)$this$forEachRootVariant).getUnitTestVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda$10((Function1)new Function1<UnitTestVariant, Unit>(block){
                final /* synthetic */ Function1<BaseVariant, Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(UnitTestVariant it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$block.invoke((Object)it);
                }
            }, arg_0));
        } else if (baseExtension instanceof TestExtension) {
            ((TestExtension)$this$forEachRootVariant).getApplicationVariants().all(arg_0 -> HiltGradlePlugin.forEachRootVariant$lambda$11((Function1)new Function1<ApplicationVariant, Unit>(block){
                final /* synthetic */ Function1<BaseVariant, Unit> $block;
                {
                    this.$block = $block;
                    super(1);
                }

                public final void invoke(ApplicationVariant it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    this.$block.invoke((Object)it);
                }
            }, arg_0));
        } else {
            throw (Throwable)new IllegalStateException(("Hilt plugin does not know how to configure '" + $this$forEachRootVariant + "'").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void configureVariantCompileClasspath(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        String string;
        boolean bl;
        block10: {
            void $this$any$iv;
            if (!hiltExtension.getEnableExperimentalClasspathAggregation() || hiltExtension.getEnableAggregatingTask()) {
                return;
            }
            if (androidExtension.getLintOptions().isCheckReleaseBuilds() && SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION().compareTo(new SimpleAGPVersion(7, 0)) < 0) {
                throw (Throwable)new IllegalStateException("Invalid Hilt plugin configuration: When 'enableExperimentalClasspathAggregation' is enabled 'android.lintOptions.checkReleaseBuilds' has to be set to false unless com.android.tools.build:gradle:7.0.0+ is used.".toString());
            }
            Object object = new String[]{"android.injected.build.model.only", "android.injected.build.model.only.advanced", "android.injected.build.model.only.versioned", "android.injected.build.model.feature.full.dependencies", "android.injected.build.model.v2"};
            object = CollectionsKt.listOf((Object[])object);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    boolean bl3 = GradleVersion.version((String)project.getGradle().getGradleVersion()).compareTo(GradleVersion.version((String)"7.4.0")) < 0 ? this.providers.gradleProperty(it).forUseAtConfigurationTime().isPresent() : this.providers.gradleProperty(it).isPresent();
                    if (!bl3) continue;
                    bl = true;
                    break block10;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Configuration runtimeConfiguration = variant instanceof TestVariant ? ((TestVariant)variant).getTestedVariant().getRuntimeConfiguration() : variant.getRuntimeConfiguration();
        ArtifactView artifactView2 = runtimeConfiguration.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda$13((Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(ArtifactView.ViewConfiguration view) {
                view.getAttributes().attribute(HiltGradlePlugin.access$getARTIFACT_TYPE_ATTRIBUTE$cp(), (Object)"jar-for-dagger");
                view.componentFilter(arg_0 -> configureVariantCompileClasspath.artifactView.1.invoke$lambda$0((Function1)new Function1<ComponentIdentifier, Boolean>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(ComponentIdentifier identifier) {
                        return identifier instanceof ProjectComponentIdentifier ? !Intrinsics.areEqual((Object)((ProjectComponentIdentifier)identifier).getProjectName(), (Object)this.$project.getName()) : true;
                    }
                }, arg_0));
            }

            private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }, arg_0));
        BaseVariant baseVariant = variant;
        if (baseVariant instanceof TestVariant) {
            String string2 = ((TestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
            string = "androidTest" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string2, (String)"AndroidTest", null, (int)2, null), null, 1, null) + "CompileOnly";
        } else if (baseVariant instanceof UnitTestVariant) {
            String string3 = ((UnitTestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"variant.name");
            string = "test" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string3, (String)"UnitTest", null, (int)2, null), null, 1, null) + "CompileOnly";
        } else {
            string = variant.getName() + "CompileOnly";
        }
        String compileOnlyConfigName = string;
        project.getDependencies().add(compileOnlyConfigName, (Object)artifactView2.getFiles());
    }

    private final void configureBytecodeTransformASM(Project project) {
        AGPVersionCompatKt.getAndroidComponentsExtension(project).onAllVariants((Function1<? super ComponentCompat, Unit>)((Function1)new Function1<ComponentCompat, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(@NotNull ComponentCompat it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                HiltGradlePlugin.access$configureBytecodeTransformASM$registerTransform(this.$project, it);
            }
        }));
    }

    private final void configureAggregatingTask(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = this.baseExtension(project);
        if (baseExtension == null) {
            throw (Throwable)new IllegalStateException("Android BaseExtension not found.".toString());
        }
        BaseExtension androidExtension = baseExtension;
        this.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension, androidExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ BaseExtension $androidExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$hiltExtension = $hiltExtension;
                this.$androidExtension = $androidExtension;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantAggregatingTask(this.this$0, this.$project, this.$hiltExtension, this.$androidExtension, variant);
            }
        }));
    }

    private final void configureVariantAggregatingTask(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        if (!hiltExtension.getEnableAggregatingTask()) {
            return;
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"variant.name");
        Object[] objectArray = configurationContainer.create("hiltCompileOnly" + StringsKt.capitalize$default(string, null, 1, null));
        Object $this$configureVariantAggregatingTask_u24lambda_u2414 = (Configuration)objectArray;
        boolean bl = false;
        $this$configureVariantAggregatingTask_u24lambda_u2414.setDescription("Hilt aggregated compile only dependencies for '" + variant.getName() + "'");
        $this$configureVariantAggregatingTask_u24lambda_u2414.setCanBeConsumed(false);
        $this$configureVariantAggregatingTask_u24lambda_u2414.setCanBeResolved(true);
        $this$configureVariantAggregatingTask_u24lambda_u2414.setVisible(false);
        Configuration hiltCompileConfiguration = (Configuration)objectArray;
        objectArray = new Object[]{variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$15(configureVariantAggregatingTask.1.INSTANCE, arg_0))};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        objectArray = new Object[]{variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$16(configureVariantAggregatingTask.2.INSTANCE, arg_0))};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        ConfigurationContainer configurationContainer2 = project.getConfigurations();
        String string2 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
        Object config = $this$configureVariantAggregatingTask_u24lambda_u2414 = configurationContainer2.create("hiltAnnotationProcessor" + StringsKt.capitalize$default(string2, null, 1, null));
        boolean $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22 = false;
        config.setDescription("Hilt annotation processor classpath for '" + variant.getName() + "'");
        config.setCanBeConsumed(false);
        config.setCanBeResolved(true);
        config.setVisible(false);
        Object[] objectArray2 = CollectionsKt.createListBuilder();
        Configuration[] $this$configureVariantAggregatingTask_u24lambda_u2420_u24lambda_u2419 = objectArray2;
        boolean bl2 = false;
        Configuration configuration = variant.getAnnotationProcessorConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"variant.annotationProcessorConfiguration");
        $this$configureVariantAggregatingTask_u24lambda_u2420_u24lambda_u2419.add(configuration);
        project.getPlugins().withId("kotlin-kapt", arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$20$lambda$19$lambda$17((Function1)new Function1<Plugin<?>, Unit>(project, variant, (List<Configuration>)$this$configureVariantAggregatingTask_u24lambda_u2420_u24lambda_u2419){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ List<Configuration> $this_buildList;
            {
                this.$project = $project;
                this.$variant = $variant;
                this.$this_buildList = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                block0: {
                    Configuration configuration = (Configuration)this.$project.getConfigurations().findByName(ConfigurationsKt.getKaptConfigName(this.$variant));
                    if (configuration == null) break block0;
                    Configuration configuration2 = configuration;
                    List<Configuration> list = this.$this_buildList;
                    Configuration it2 = configuration2;
                    boolean bl = false;
                    list.add(it2);
                }
            }
        }, arg_0));
        project.getPlugins().withId("com.google.devtools.ksp", arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$20$lambda$19$lambda$18((Function1)new Function1<Plugin<?>, Unit>(project, variant, (List<Configuration>)$this$configureVariantAggregatingTask_u24lambda_u2420_u24lambda_u2419){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ List<Configuration> $this_buildList;
            {
                this.$project = $project;
                this.$variant = $variant;
                this.$this_buildList = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                block1: {
                    Configuration it2;
                    List<Configuration> list;
                    Configuration configuration;
                    Configuration configuration2 = (Configuration)this.$project.getConfigurations().findByName("ksp");
                    if (configuration2 != null) {
                        configuration = configuration2;
                        list = this.$this_buildList;
                        it2 = configuration;
                        boolean bl = false;
                        list.add(it2);
                    }
                    Configuration configuration3 = (Configuration)this.$project.getConfigurations().findByName(ConfigurationsKt.getKspConfigName(this.$variant));
                    if (configuration3 == null) break block1;
                    configuration = configuration3;
                    list = this.$this_buildList;
                    it2 = configuration;
                    boolean bl = false;
                    list.add(it2);
                }
            }
        }, arg_0));
        List apConfigurations2 = CollectionsKt.build((List)objectArray2);
        Collection $this$toTypedArray$iv = apConfigurations2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Configuration[] configurationArray = thisCollection$iv.toArray(new Configuration[0]);
        if (configurationArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        objectArray2 = configurationArray;
        config.extendsFrom(Arrays.copyOf(objectArray2, objectArray2.length));
        project.getDependencies().add(config.getName(), (Object)("com.google.dagger:hilt-compiler:" + VersionKt.getHILT_VERSION()));
        Object hiltAnnotationProcessorConfiguration2 = $this$configureVariantAggregatingTask_u24lambda_u2414;
        TaskContainer taskContainer = project.getTasks();
        String string3 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"variant.name");
        TaskProvider aggregatingTask2 = taskContainer.register("hiltAggregateDeps" + StringsKt.capitalize$default(string3, null, 1, null), AggregateDepsTask.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$25((Function1)new Function1<AggregateDepsTask, Unit>(project, variant, androidExtension, hiltExtension, hiltCompileConfiguration){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ BaseExtension $androidExtension;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ Configuration $hiltCompileConfiguration;
            {
                this.$project = $project;
                this.$variant = $variant;
                this.$androidExtension = $androidExtension;
                this.$hiltExtension = $hiltExtension;
                this.$hiltCompileConfiguration = $hiltCompileConfiguration;
                super(1);
            }

            public final void invoke(AggregateDepsTask it) {
                it.getCompileClasspath().setFrom((Iterable)HiltGradlePlugin.access$configureVariantAggregatingTask$getInputClasspath(this.$variant, this.$hiltCompileConfiguration, this.$project, "aggregated-jar-for-hilt"));
                DirectoryProperty directoryProperty = it.getOutputDir();
                File file = this.$project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                directoryProperty.set(this.$project.file((Object)FilesKt.resolve((File)file, (String)("generated/hilt/component_trees/" + this.$variant.getName() + "/"))));
                it.getTestEnvironment().set((Object)(this.$variant instanceof TestVariant || this.$variant instanceof UnitTestVariant || this.$androidExtension instanceof TestExtension ? 1 : 0));
                it.getCrossCompilationRootValidationDisabled().set((Object)this.$hiltExtension.getDisableCrossCompilationRootValidation());
                if (SimpleAGPVersion.Companion.getANDROID_GRADLE_PLUGIN_VERSION().compareTo(new SimpleAGPVersion(7, 1)) >= 0) {
                    it.getAsmApiVersion().set((Object)589824);
                }
            }
        }, arg_0));
        Object[] $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22 = new Object[1];
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22[0] = FilesKt.resolve((File)file, (String)("intermediates/hilt/component_classes/" + variant.getName() + "/"));
        ConfigurableFileCollection componentClasses = project.files($i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22);
        TaskContainer taskContainer2 = project.getTasks();
        String string4 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"variant.name");
        TaskProvider componentsJavaCompileTask2 = taskContainer2.register("hiltJavaCompile" + StringsKt.capitalize$default(string4, null, 1, null), JavaCompile.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$26((Function1)new Function1<JavaCompile, Unit>((TaskProvider<AggregateDepsTask>)aggregatingTask2, variant, androidExtension, componentClasses, project, hiltCompileConfiguration, hiltAnnotationProcessorConfiguration2){
            final /* synthetic */ TaskProvider<AggregateDepsTask> $aggregatingTask;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ BaseExtension $androidExtension;
            final /* synthetic */ ConfigurableFileCollection $componentClasses;
            final /* synthetic */ Project $project;
            final /* synthetic */ Configuration $hiltCompileConfiguration;
            final /* synthetic */ Configuration $hiltAnnotationProcessorConfiguration;
            {
                this.$aggregatingTask = $aggregatingTask;
                this.$variant = $variant;
                this.$androidExtension = $androidExtension;
                this.$componentClasses = $componentClasses;
                this.$project = $project;
                this.$hiltCompileConfiguration = $hiltCompileConfiguration;
                this.$hiltAnnotationProcessorConfiguration = $hiltAnnotationProcessorConfiguration;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(JavaCompile compileTask) {
                Object object;
                Object object2;
                compileTask.setSource((FileTree)this.$aggregatingTask.map(arg_0 -> configureVariantAggregatingTask.componentsJavaCompileTask.1.invoke$lambda$0(configureVariantAggregatingTask.componentsJavaCompileTask.1.INSTANCE, arg_0)).get());
                FileCollection mainBootstrapClasspath2 = (FileCollection)this.$variant.getJavaCompileProvider().map(arg_0 -> configureVariantAggregatingTask.componentsJavaCompileTask.1.invoke$lambda$1((Function1)new Function1<JavaCompile, FileCollection>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    public final FileCollection invoke(JavaCompile it) {
                        FileCollection fileCollection = it.getOptions().getBootstrapClasspath();
                        if (fileCollection == null) {
                            fileCollection = (FileCollection)this.$project.files(new Object[0]);
                        }
                        return fileCollection;
                    }
                }, arg_0)).get();
                if (JavaVersion.current().isJava9Compatible() && this.$androidExtension.getCompileOptions().getTargetCompatibility().isJava9Compatible()) {
                    void $this$forEach$iv;
                    Iterator<T> $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    compileTask.setClasspath(HiltGradlePlugin.access$configureVariantAggregatingTask$getInputClasspath(this.$variant, this.$hiltCompileConfiguration, this.$project, "jar-for-dagger").plus(mainBootstrapClasspath2));
                    object2 = this.$variant.getJavaCompileProvider().get();
                    JavaCompile originalCompileTask = (JavaCompile)object2;
                    boolean bl = false;
                    List list = originalCompileTask.getOptions().getCompilerArgumentProviders();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"originalCompileTask.opti\u2026compilerArgumentProviders");
                    object = list;
                    boolean $i$f$filter = false;
                    void var8_10 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    Iterator<T> iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv = iterator.next();
                        CommandLineArgumentProvider it = (CommandLineArgumentProvider)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it instanceof HiltCommandLineArgumentProvider || it instanceof JdkImageInput)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        CommandLineArgumentProvider it = (CommandLineArgumentProvider)element$iv;
                        boolean bl3 = false;
                        compileTask.getOptions().getCompilerArgumentProviders().add(it);
                    }
                    compileTask.getOptions().getCompilerArgs().add("-XDstringConcat=inline");
                } else {
                    compileTask.setClasspath((FileCollection)HiltGradlePlugin.access$configureVariantAggregatingTask$getInputClasspath(this.$variant, this.$hiltCompileConfiguration, this.$project, "jar-for-dagger"));
                    compileTask.getOptions().setBootstrapClasspath(mainBootstrapClasspath2);
                }
                compileTask.getDestinationDirectory().set(this.$componentClasses.getSingleFile());
                object2 = compileTask.getOptions();
                Configuration configuration = this.$hiltAnnotationProcessorConfiguration;
                Project project = this.$project;
                object = this.$variant;
                BaseExtension baseExtension = this.$androidExtension;
                Object $this$invoke_u24lambda_u245 = object2;
                boolean bl = false;
                $this$invoke_u24lambda_u245.setAnnotationProcessorPath((FileCollection)configuration);
                DirectoryProperty directoryProperty = $this$invoke_u24lambda_u245.getGeneratedSourceOutputDirectory();
                File file = project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
                directoryProperty.set(project.file((Object)FilesKt.resolve((File)file, (String)("generated/hilt/component_sources/" + object.getName() + "/"))));
                if (JavaVersion.current().isJava8Compatible() && baseExtension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                    $this$invoke_u24lambda_u245.getCompilerArgs().add("-parameters");
                }
                $this$invoke_u24lambda_u245.getCompilerArgs().add("-Adagger.fastInit=enabled");
                $this$invoke_u24lambda_u245.getCompilerArgs().add("-Adagger.hilt.internal.useAggregatingRootProcessor=false");
                $this$invoke_u24lambda_u245.getCompilerArgs().add("-Adagger.hilt.android.internal.disableAndroidSuperclassValidation=true");
                $this$invoke_u24lambda_u245.setEncoding(baseExtension.getCompileOptions().getEncoding());
                compileTask.setSourceCompatibility(this.$androidExtension.getCompileOptions().getSourceCompatibility().toString());
                compileTask.setTargetCompatibility(this.$androidExtension.getCompileOptions().getTargetCompatibility().toString());
            }

            private static final FileTree invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (FileTree)$tmp0.invoke(p0);
            }

            private static final FileCollection invoke$lambda$1(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (FileCollection)$tmp0.invoke(p0);
            }
        }, arg_0));
        objectArray2 = new Object[]{componentsJavaCompileTask2};
        componentClasses.builtBy(objectArray2);
        variant.registerPostJavacGeneratedBytecode((FileCollection)componentClasses);
    }

    private final void configureProcessorFlags(Project project, HiltExtension hiltExtension) {
        GradleProjectType gradleProjectType;
        BaseExtension baseExtension = this.baseExtension(project);
        if (baseExtension == null) {
            throw (Throwable)new IllegalStateException("Android BaseExtension not found.".toString());
        }
        BaseExtension androidExtension = baseExtension;
        BaseExtension baseExtension2 = androidExtension;
        if (baseExtension2 instanceof AppExtension) {
            gradleProjectType = GradleProjectType.APP;
        } else if (baseExtension2 instanceof LibraryExtension) {
            gradleProjectType = GradleProjectType.LIBRARY;
        } else if (baseExtension2 instanceof TestExtension) {
            gradleProjectType = GradleProjectType.TEST;
        } else {
            throw (Throwable)new IllegalStateException(("Hilt plugin does not know how to configure '" + this + "'").toString());
        }
        GradleProjectType projectType = gradleProjectType;
        AGPVersionCompatKt.getAndroidComponentsExtension(project).onAllVariants((Function1<? super ComponentCompat, Unit>)((Function1)new Function1<ComponentCompat, Unit>(project, projectType, hiltExtension){
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleProjectType $projectType;
            final /* synthetic */ HiltExtension $hiltExtension;
            {
                this.$project = $project;
                this.$projectType = $projectType;
                this.$hiltExtension = $hiltExtension;
                super(1);
            }

            public final void invoke(@NotNull ComponentCompat component) {
                Intrinsics.checkNotNullParameter((Object)component, (String)"component");
                Function1 argsProducer2 = (Function1)new Function1<Task, HiltCommandLineArgumentProvider>(this.$projectType, this.$hiltExtension){
                    final /* synthetic */ GradleProjectType $projectType;
                    final /* synthetic */ HiltExtension $hiltExtension;
                    {
                        this.$projectType = $projectType;
                        this.$hiltExtension = $hiltExtension;
                        super(1);
                    }

                    @NotNull
                    public final HiltCommandLineArgumentProvider invoke(@NotNull Task task) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        return new HiltCommandLineArgumentProvider(TasksKt.isKspTask(task), this.$projectType, this.$hiltExtension.getEnableAggregatingTask(), this.$hiltExtension.getDisableCrossCompilationRootValidation());
                    }
                };
                TasksKt.addJavaTaskProcessorOptions(this.$project, component, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer2);
                TasksKt.addKaptTaskProcessorOptions(this.$project, component, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer2);
                TasksKt.addKspTaskProcessorOptions(this.$project, component, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer2);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private final void verifyDependencies(Project project) {
        if (project.getState().getFailure() != null) {
            return;
        }
        v0 = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"project.configurations");
        $this$filterNot$iv = (Iterable)v0;
        $i$f$filterNot = false;
        var5_4 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Configuration)element$iv$iv;
            $i$a$-filterNot-HiltGradlePlugin$verifyDependencies$dependencies$1 = false;
            v1 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"it.name");
            if (kotlin.text.StringsKt.startsWith$default((String)v1, (String)"hiltAnnotationProcessor", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it.name");
            if (kotlin.text.StringsKt.startsWith$default((String)v2, (String)"hiltCompileOnly", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            configuration = (Configuration)element$iv$iv;
            $i$a$-flatMap-HiltGradlePlugin$verifyDependencies$dependencies$2 = false;
            v4 = configuration.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"configuration.dependencies");
            $this$map$iv = (Iterable)v4;
            $i$f$map = false;
            var14_13 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var19_18 = (Dependency)item$iv$iv;
                var20_19 = destination$iv$iv;
                $i$a$-map-HiltGradlePlugin$verifyDependencies$dependencies$2$1 = false;
                var20_19.add(TuplesKt.to((Object)dependency.getGroup(), (Object)dependency.getName()));
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        dependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-android"))) {
            throw (Throwable)new IllegalStateException(HiltGradlePlugin.verifyDependencies$getMissingDepMsg("com.google.dagger:hilt-android").toString());
        }
        if (!dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-android-compiler")) && !dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-compiler"))) {
            throw (Throwable)new IllegalStateException(HiltGradlePlugin.verifyDependencies$getMissingDepMsg("com.google.dagger:hilt-compiler").toString());
        }
    }

    private final BaseExtension baseExtension(Project $this$baseExtension) {
        return (BaseExtension)$this$baseExtension.getExtensions().findByType(BaseExtension.class);
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDependencyTransforms$lambda$5$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDependencyTransforms$lambda$5$lambda$3(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDependencyTransforms$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void forEachRootVariant$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void forEachRootVariant$lambda$7(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void forEachRootVariant$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void forEachRootVariant$lambda$9(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void forEachRootVariant$lambda$10(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void forEachRootVariant$lambda$11(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantCompileClasspath$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureBytecodeTransformASM$registerTransform(Project $project, ComponentCompat androidComponent) {
        androidComponent.transformClassesWith(AndroidEntryPointClassVisitor.Factory.class, InstrumentationScope.PROJECT, (Function1)new Function1<AndroidEntryPointClassVisitor.AndroidEntryPointParams, Unit>($project, androidComponent){
            final /* synthetic */ Project $project;
            final /* synthetic */ ComponentCompat $androidComponent;
            {
                this.$project = $project;
                this.$androidComponent = $androidComponent;
                super(1);
            }

            public final void invoke(@NotNull AndroidEntryPointClassVisitor.AndroidEntryPointParams params) {
                Intrinsics.checkNotNullParameter((Object)params, (String)"params");
                File classesDir = new File(this.$project.getBuildDir(), "intermediates/javac/" + this.$androidComponent.getName() + "/classes");
                params.getAdditionalClassesDir().set((Object)classesDir);
            }
        });
        androidComponent.setAsmFramesComputationMode(FramesComputationMode.COMPUTE_FRAMES_FOR_INSTRUMENTED_METHODS);
    }

    private static final FileCollection configureVariantAggregatingTask$lambda$15(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileCollection)$tmp0.invoke(p0);
    }

    private static final Directory configureVariantAggregatingTask$lambda$16(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Directory)$tmp0.invoke(p0);
    }

    private static final void configureVariantAggregatingTask$lambda$20$lambda$19$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantAggregatingTask$lambda$20$lambda$19$lambda$18(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantAggregatingTask$getInputClasspath$lambda$23$lambda$22(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfigurableFileCollection configureVariantAggregatingTask$getInputClasspath(BaseVariant $variant, Configuration hiltCompileConfiguration, Project $project, String artifactAttributeValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable;
        List $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2421 = iterable = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-HiltGradlePlugin$configureVariantAggregatingTask$getInputClasspath$22 = false;
        if ($variant instanceof TestVariant) {
            Configuration configuration = ((TestVariant)$variant).getTestedVariant().getRuntimeConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"variant.testedVariant.runtimeConfiguration");
            $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2421.add(configuration);
        }
        Configuration configuration = $variant.getRuntimeConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"variant.runtimeConfiguration");
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2421.add(configuration);
        Intrinsics.checkNotNullExpressionValue((Object)hiltCompileConfiguration, (String)"hiltCompileConfiguration");
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2421.add(hiltCompileConfiguration);
        iterable = CollectionsKt.build((List)iterable);
        boolean $i$f$map = false;
        void $i$a$-buildList-HiltGradlePlugin$configureVariantAggregatingTask$getInputClasspath$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void configuration2;
            Configuration configuration3 = (Configuration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(configuration2.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath$lambda$23$lambda$22((Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(artifactAttributeValue){
                final /* synthetic */ String $artifactAttributeValue;
                {
                    this.$artifactAttributeValue = $artifactAttributeValue;
                    super(1);
                }

                public final void invoke(ArtifactView.ViewConfiguration view) {
                    view.getAttributes().attribute(HiltGradlePlugin.access$getARTIFACT_TYPE_ATTRIBUTE$cp(), (Object)this.$artifactAttributeValue);
                }
            }, arg_0)).getFiles());
        }
        Iterable it = iterable = (List)destination$iv$iv;
        boolean bl = false;
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileCollection[] fileCollectionArray = thisCollection$iv.toArray(new FileCollection[0]);
        if (fileCollectionArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        FileCollection[] fileCollectionArray2 = fileCollectionArray;
        return $project.files((Object[])Arrays.copyOf(fileCollectionArray2, fileCollectionArray2.length));
    }

    private static final void configureVariantAggregatingTask$lambda$25(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantAggregatingTask$lambda$26(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String verifyDependencies$getMissingDepMsg(String depCoordinate) {
        return "The Hilt Android Gradle plugin is applied but no " + depCoordinate + " dependency was found.";
    }

    public static final /* synthetic */ void access$configureHilt(HiltGradlePlugin $this, Project project) {
        $this.configureHilt(project);
    }

    public static final /* synthetic */ void access$verifyDependencies(HiltGradlePlugin $this, Project project) {
        $this.verifyDependencies(project);
    }

    public static final /* synthetic */ void access$configureVariantCompileClasspath(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        $this.configureVariantCompileClasspath(project, hiltExtension, androidExtension, variant);
    }

    public static final /* synthetic */ Attribute access$getARTIFACT_TYPE_ATTRIBUTE$cp() {
        return ARTIFACT_TYPE_ATTRIBUTE;
    }

    public static final /* synthetic */ void access$configureBytecodeTransformASM$registerTransform(Project $project, ComponentCompat androidComponent) {
        HiltGradlePlugin.configureBytecodeTransformASM$registerTransform($project, androidComponent);
    }

    public static final /* synthetic */ void access$configureVariantAggregatingTask(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        $this.configureVariantAggregatingTask(project, hiltExtension, androidExtension, variant);
    }

    public static final /* synthetic */ ConfigurableFileCollection access$configureVariantAggregatingTask$getInputClasspath(BaseVariant $variant, Configuration hiltCompileConfiguration, Project $project, String artifactAttributeValue) {
        return HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, hiltCompileConfiguration, $project, artifactAttributeValue);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin$Companion;", "", "()V", "AGGREGATED_HILT_ARTIFACT_TYPE_VALUE", "", "ARTIFACT_TYPE_ATTRIBUTE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "DAGGER_ARTIFACT_TYPE_VALUE", "LIBRARY_GROUP"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

