/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin.util;

import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import dagger.hilt.android.plugin.util.StringsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0001H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000"}, d2={"getConfigName", "", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "prefix", "getKaptConfigName", "getKspConfigName"})
public final class ConfigurationsKt {
    @NotNull
    public static final String getKaptConfigName(@NotNull BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return ConfigurationsKt.getConfigName(variant, "kapt");
    }

    @NotNull
    public static final String getKspConfigName(@NotNull BaseVariant variant) {
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        return ConfigurationsKt.getConfigName(variant, "ksp");
    }

    @NotNull
    public static final String getConfigName(@NotNull BaseVariant variant, @NotNull String prefix) {
        String string;
        Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        BaseVariant baseVariant = variant;
        if (baseVariant instanceof TestVariant) {
            String string2 = ((TestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"variant.name");
            string = prefix + "AndroidTest" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string2, (String)"AndroidTest", null, (int)2, null), null, 1, null);
        } else if (baseVariant instanceof UnitTestVariant) {
            String string3 = ((UnitTestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"variant.name");
            string = prefix + "Test" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string3, (String)"UnitTest", null, (int)2, null), null, 1, null);
        } else {
            String string4 = variant.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"variant.name");
            string = prefix + StringsKt.capitalize$default(string4, null, 1, null);
        }
        return string;
    }
}

