/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.plugin;

import com.android.build.api.AndroidPluginVersion;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.ApplicationAndroidComponentsExtension;
import com.android.build.api.variant.Component;
import com.android.build.api.variant.ComponentIdentity;
import com.android.build.api.variant.LibraryAndroidComponentsExtension;
import com.android.build.api.variant.TestAndroidComponentsExtension;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.TestExtension;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import com.android.build.gradle.api.UnitTestVariant;
import com.android.build.gradle.tasks.JdkImageInput;
import dagger.hilt.android.plugin.HiltCommandLineArgumentProvider;
import dagger.hilt.android.plugin.HiltExtension;
import dagger.hilt.android.plugin.HiltExtensionImpl;
import dagger.hilt.android.plugin.HiltGradlePlugin;
import dagger.hilt.android.plugin.VersionKt;
import dagger.hilt.android.plugin.task.AggregateDepsTask;
import dagger.hilt.android.plugin.transform.AggregatedPackagesTransform;
import dagger.hilt.android.plugin.transform.CopyTransform;
import dagger.hilt.android.plugin.util.ConfigurationsKt;
import dagger.hilt.android.plugin.util.StringsKt;
import dagger.hilt.android.plugin.util.TasksKt;
import dagger.hilt.android.plugin.util.VariantsKt;
import dagger.hilt.processor.internal.optionvalues.GradleProjectType;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.gradle.api.JavaVersion;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.ArtifactView;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.api.tasks.compile.JavaCompile;
import org.gradle.process.CommandLineArgumentProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u000f\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0018\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\f\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00112\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\u0013\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J,\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0012\u0010\r\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000eH\u0002J(\u0010\u0015\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010\u0019\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "providers", "Lorg/gradle/api/provider/ProviderFactory;", "(Lorg/gradle/api/provider/ProviderFactory;)V", "apply", "", "project", "configureAggregatingTask", "hiltExtension", "Ldagger/hilt/android/plugin/HiltExtension;", "configureBytecodeTransformASM", "androidExtension", "Lcom/android/build/api/variant/AndroidComponentsExtension;", "configureCompileClasspath", "configureDependencyTransforms", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "kotlin.jvm.PlatformType", "configureHilt", "configureProcessorFlags", "configureVariantAggregatingTask", "Lcom/android/build/gradle/BaseExtension;", "variant", "Lcom/android/build/gradle/api/BaseVariant;", "configureVariantCompileClasspath", "verifyDependencies", "Companion"})
@SourceDebugExtension(value={"SMAP\nHiltGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,461:1\n1#2:462\n37#3,2:463\n37#3,2:482\n819#4:465\n847#4,2:466\n1360#4:468\n1446#4,2:469\n1549#4:471\n1620#4,3:472\n1448#4,3:475\n1549#4:478\n1620#4,3:479\n*S KotlinDebug\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin\n*L\n276#1:463,2\n297#1:482,2\n419#1:465\n419#1:466,2\n423#1:468\n423#1:469,2\n424#1:471\n424#1:472,3\n423#1:475,3\n290#1:478\n290#1:479,3\n*E\n"})
public final class HiltGradlePlugin
implements Plugin<Project> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProviderFactory providers;
    private static final Attribute<String> ARTIFACT_TYPE_ATTRIBUTE = Attribute.of((String)"artifactType", String.class);
    @NotNull
    public static final String DAGGER_ARTIFACT_TYPE_VALUE = "jar-for-dagger";
    @NotNull
    public static final String AGGREGATED_HILT_ARTIFACT_TYPE_VALUE = "aggregated-jar-for-hilt";
    @NotNull
    public static final String LIBRARY_GROUP = "com.google.dagger";
    @NotNull
    private static final Lazy<List<String>> gradleSyncProps$delegate = LazyKt.lazy((Function0)Companion.gradleSyncProps.2.INSTANCE);

    @Inject
    public HiltGradlePlugin(@NotNull ProviderFactory providers) {
        Intrinsics.checkNotNullParameter((Object)providers, (String)"providers");
        this.providers = providers;
    }

    public void apply(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Ref.BooleanRef configured = new Ref.BooleanRef();
        project.getPlugins().withId("com.android.base", arg_0 -> HiltGradlePlugin.apply$lambda$0((Function1)new Function1<Plugin<?>, Unit>(configured, this, project){
            final /* synthetic */ Ref.BooleanRef $configured;
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            {
                this.$configured = $configured;
                this.this$0 = $receiver;
                this.$project = $project;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                this.$configured.element = true;
                HiltGradlePlugin.access$configureHilt(this.this$0, this.$project);
            }
        }, arg_0));
        project.afterEvaluate(arg_0 -> HiltGradlePlugin.apply$lambda$1((Function1)new Function1<Project, Unit>(configured, this){
            final /* synthetic */ Ref.BooleanRef $configured;
            final /* synthetic */ HiltGradlePlugin this$0;
            {
                this.$configured = $configured;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Project it) {
                if (!this.$configured.element) {
                    boolean bl = false;
                    String string = "The Hilt Android Gradle plugin can only be applied to an Android project.";
                    throw new IllegalStateException(string.toString());
                }
                Intrinsics.checkNotNull((Object)it);
                HiltGradlePlugin.access$verifyDependencies(this.this$0, it);
            }
        }, arg_0));
    }

    private final void configureHilt(Project project) {
        HiltExtension hiltExtension = (HiltExtension)project.getExtensions().create(HiltExtension.class, "hilt", HiltExtensionImpl.class, new Object[0]);
        AndroidComponentsExtension androidExtension = (AndroidComponentsExtension)project.getExtensions().findByType(AndroidComponentsExtension.class);
        if (!(androidExtension != null)) {
            boolean $i$a$-check-HiltGradlePlugin$configureHilt$32 = false;
            String $i$a$-check-HiltGradlePlugin$configureHilt$32 = "Could not find the Android Gradle Plugin (AGP) extension.";
            throw new IllegalStateException($i$a$-check-HiltGradlePlugin$configureHilt$32.toString());
        }
        if (!(androidExtension.getPluginVersion().compareTo(new AndroidPluginVersion(8, 1)) >= 0)) {
            boolean bl = false;
            String string = "The Hilt Android Gradle plugin is only compatible with Android Gradle plugin (AGP) version 8.1.0 or higher (found " + androidExtension.getPluginVersion() + ").";
            throw new IllegalStateException(string.toString());
        }
        this.configureDependencyTransforms(project);
        Intrinsics.checkNotNull((Object)hiltExtension);
        this.configureCompileClasspath(project, hiltExtension);
        this.configureBytecodeTransformASM(androidExtension);
        this.configureAggregatingTask(project, hiltExtension);
        this.configureProcessorFlags(project, hiltExtension, androidExtension);
    }

    private final DependencyHandler configureDependencyTransforms(Project project) {
        DependencyHandler dependencyHandler;
        DependencyHandler $this$configureDependencyTransforms_u24lambda_u247 = dependencyHandler = project.getDependencies();
        boolean bl = false;
        $this$configureDependencyTransforms_u24lambda_u247.registerTransform(CopyTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$7$lambda$4(configureDependencyTransforms.1.1.INSTANCE, arg_0));
        $this$configureDependencyTransforms_u24lambda_u247.registerTransform(CopyTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$7$lambda$5(configureDependencyTransforms.1.2.INSTANCE, arg_0));
        $this$configureDependencyTransforms_u24lambda_u247.registerTransform(AggregatedPackagesTransform.class, arg_0 -> HiltGradlePlugin.configureDependencyTransforms$lambda$7$lambda$6(configureDependencyTransforms.1.3.INSTANCE, arg_0));
        return dependencyHandler;
    }

    private final void configureCompileClasspath(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension == null) {
            throw new IllegalStateException("Android BaseExtension not found.".toString());
        }
        BaseExtension androidExtension = baseExtension;
        VariantsKt.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$hiltExtension = $hiltExtension;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantCompileClasspath(this.this$0, this.$project, this.$hiltExtension, variant);
            }
        }));
    }

    private final void configureVariantCompileClasspath(Project project, HiltExtension hiltExtension, BaseVariant variant) {
        String string;
        if (!hiltExtension.getEnableExperimentalClasspathAggregation() || hiltExtension.getEnableAggregatingTask()) {
            return;
        }
        if (HiltGradlePlugin.Companion.isGradleSyncRunning(project)) {
            return;
        }
        Configuration runtimeConfiguration = variant instanceof TestVariant ? ((TestVariant)variant).getTestedVariant().getRuntimeConfiguration() : variant.getRuntimeConfiguration();
        ArtifactView artifactView2 = runtimeConfiguration.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantCompileClasspath$lambda$8((Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(project){
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(1);
            }

            public final void invoke(ArtifactView.ViewConfiguration view) {
                view.getAttributes().attribute(HiltGradlePlugin.access$getARTIFACT_TYPE_ATTRIBUTE$cp(), (Object)"jar-for-dagger");
                view.componentFilter(arg_0 -> configureVariantCompileClasspath.artifactView.1.invoke$lambda$0((Function1)new Function1<ComponentIdentifier, Boolean>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(ComponentIdentifier identifier) {
                        return identifier instanceof ProjectComponentIdentifier ? !Intrinsics.areEqual((Object)((ProjectComponentIdentifier)identifier).getProjectName(), (Object)this.$project.getName()) : true;
                    }
                }, arg_0));
            }

            private static final boolean invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }, arg_0));
        BaseVariant baseVariant = variant;
        if (baseVariant instanceof TestVariant) {
            String string2 = ((TestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            string = "androidTest" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string2, (String)"AndroidTest", null, (int)2, null), null, 1, null) + "CompileOnly";
        } else if (baseVariant instanceof UnitTestVariant) {
            String string3 = ((UnitTestVariant)variant).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
            string = "test" + StringsKt.capitalize$default(kotlin.text.StringsKt.substringBeforeLast$default((String)string3, (String)"UnitTest", null, (int)2, null), null, 1, null) + "CompileOnly";
        } else {
            string = variant.getName() + "CompileOnly";
        }
        String compileOnlyConfigName = string;
        project.getDependencies().add(compileOnlyConfigName, (Object)artifactView2.getFiles());
    }

    private final void configureBytecodeTransformASM(AndroidComponentsExtension<?, ?, ?> androidExtension) {
        VariantsKt.onAllVariants(androidExtension, (Function1<? super Component, Unit>)((Function1)configureBytecodeTransformASM.1.INSTANCE));
    }

    private final void configureAggregatingTask(Project project, HiltExtension hiltExtension) {
        BaseExtension baseExtension = (BaseExtension)project.getExtensions().findByType(BaseExtension.class);
        if (baseExtension == null) {
            throw new IllegalStateException("Android BaseExtension not found.".toString());
        }
        BaseExtension androidExtension = baseExtension;
        VariantsKt.forEachRootVariant(androidExtension, (Function1<? super BaseVariant, Unit>)((Function1)new Function1<BaseVariant, Unit>(this, project, hiltExtension, androidExtension){
            final /* synthetic */ HiltGradlePlugin this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ BaseExtension $androidExtension;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$hiltExtension = $hiltExtension;
                this.$androidExtension = $androidExtension;
                super(1);
            }

            public final void invoke(@NotNull BaseVariant variant) {
                Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
                HiltGradlePlugin.access$configureVariantAggregatingTask(this.this$0, this.$project, this.$hiltExtension, this.$androidExtension, variant);
            }
        }));
    }

    private final void configureVariantAggregatingTask(Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        if (!hiltExtension.getEnableAggregatingTask()) {
            return;
        }
        ConfigurationContainer configurationContainer = project.getConfigurations();
        String string = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        Object[] objectArray = configurationContainer.create("hiltCompileOnly" + StringsKt.capitalize$default(string, null, 1, null));
        Object $this$configureVariantAggregatingTask_u24lambda_u249 = (Configuration)objectArray;
        boolean bl = false;
        $this$configureVariantAggregatingTask_u24lambda_u249.setDescription("Hilt aggregated compile only dependencies for '" + variant.getName() + "'");
        $this$configureVariantAggregatingTask_u24lambda_u249.setCanBeConsumed(false);
        $this$configureVariantAggregatingTask_u24lambda_u249.setCanBeResolved(true);
        $this$configureVariantAggregatingTask_u24lambda_u249.setVisible(false);
        Configuration hiltCompileConfiguration = (Configuration)objectArray;
        objectArray = new Object[]{variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$10(configureVariantAggregatingTask.1.INSTANCE, arg_0))};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        objectArray = new Object[]{variant.getJavaCompileProvider().map(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$11(configureVariantAggregatingTask.2.INSTANCE, arg_0))};
        project.getDependencies().add(hiltCompileConfiguration.getName(), (Object)project.files(objectArray));
        ConfigurationContainer configurationContainer2 = project.getConfigurations();
        String string2 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        Object config = $this$configureVariantAggregatingTask_u24lambda_u249 = configurationContainer2.create("hiltAnnotationProcessor" + StringsKt.capitalize$default(string2, null, 1, null));
        boolean $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22 = false;
        config.setDescription("Hilt annotation processor classpath for '" + variant.getName() + "'");
        config.setCanBeConsumed(false);
        config.setCanBeResolved(true);
        config.setVisible(false);
        Object[] objectArray2 = CollectionsKt.createListBuilder();
        Configuration[] $this$configureVariantAggregatingTask_u24lambda_u2415_u24lambda_u2414 = objectArray2;
        boolean bl2 = false;
        Configuration configuration = variant.getAnnotationProcessorConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getAnnotationProcessorConfiguration(...)");
        $this$configureVariantAggregatingTask_u24lambda_u2415_u24lambda_u2414.add(configuration);
        project.getPlugins().withId("kotlin-kapt", arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$15$lambda$14$lambda$12((Function1)new Function1<Plugin<?>, Unit>(project, variant, (List<Configuration>)$this$configureVariantAggregatingTask_u24lambda_u2415_u24lambda_u2414){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ List<Configuration> $this_buildList;
            {
                this.$project = $project;
                this.$variant = $variant;
                this.$this_buildList = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                block0: {
                    Configuration configuration = (Configuration)this.$project.getConfigurations().findByName(ConfigurationsKt.getKaptConfigName(this.$variant));
                    if (configuration == null) break block0;
                    Configuration configuration2 = configuration;
                    List<Configuration> list = this.$this_buildList;
                    Configuration it2 = configuration2;
                    boolean bl = false;
                    list.add(it2);
                }
            }
        }, arg_0));
        project.getPlugins().withId("com.google.devtools.ksp", arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$15$lambda$14$lambda$13((Function1)new Function1<Plugin<?>, Unit>(project, variant, (List<Configuration>)$this$configureVariantAggregatingTask_u24lambda_u2415_u24lambda_u2414){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ List<Configuration> $this_buildList;
            {
                this.$project = $project;
                this.$variant = $variant;
                this.$this_buildList = $receiver;
                super(1);
            }

            public final void invoke(Plugin<?> it) {
                block1: {
                    Configuration it2;
                    List<Configuration> list;
                    Configuration configuration;
                    Configuration configuration2 = (Configuration)this.$project.getConfigurations().findByName("ksp");
                    if (configuration2 != null) {
                        configuration = configuration2;
                        list = this.$this_buildList;
                        it2 = configuration;
                        boolean bl = false;
                        list.add(it2);
                    }
                    Configuration configuration3 = (Configuration)this.$project.getConfigurations().findByName(ConfigurationsKt.getKspConfigName(this.$variant));
                    if (configuration3 == null) break block1;
                    configuration = configuration3;
                    list = this.$this_buildList;
                    it2 = configuration;
                    boolean bl = false;
                    list.add(it2);
                }
            }
        }, arg_0));
        List apConfigurations2 = CollectionsKt.build((List)objectArray2);
        Collection $this$toTypedArray$iv = apConfigurations2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        objectArray2 = thisCollection$iv.toArray(new Configuration[0]);
        config.extendsFrom(Arrays.copyOf(objectArray2, objectArray2.length));
        project.getDependencies().add(config.getName(), (Object)("com.google.dagger:hilt-compiler:" + VersionKt.getHILT_VERSION()));
        Object hiltAnnotationProcessorConfiguration2 = $this$configureVariantAggregatingTask_u24lambda_u249;
        TaskContainer taskContainer = project.getTasks();
        String string3 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getName(...)");
        TaskProvider aggregatingTask2 = taskContainer.register("hiltAggregateDeps" + StringsKt.capitalize$default(string3, null, 1, null), AggregateDepsTask.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$20((Function1)new Function1<AggregateDepsTask, Unit>(project, variant, androidExtension, hiltExtension, hiltCompileConfiguration){
            final /* synthetic */ Project $project;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ BaseExtension $androidExtension;
            final /* synthetic */ HiltExtension $hiltExtension;
            final /* synthetic */ Configuration $hiltCompileConfiguration;
            {
                this.$project = $project;
                this.$variant = $variant;
                this.$androidExtension = $androidExtension;
                this.$hiltExtension = $hiltExtension;
                this.$hiltCompileConfiguration = $hiltCompileConfiguration;
                super(1);
            }

            public final void invoke(AggregateDepsTask it) {
                it.getCompileClasspath().setFrom((Iterable)HiltGradlePlugin.access$configureVariantAggregatingTask$getInputClasspath(this.$variant, this.$hiltCompileConfiguration, this.$project, "aggregated-jar-for-hilt"));
                DirectoryProperty directoryProperty = it.getOutputDir();
                File file = this.$project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
                directoryProperty.set(this.$project.file((Object)FilesKt.resolve((File)file, (String)("generated/hilt/component_trees/" + this.$variant.getName() + "/"))));
                it.getTestEnvironment().set((Object)(this.$variant instanceof TestVariant || this.$variant instanceof UnitTestVariant || this.$androidExtension instanceof TestExtension ? 1 : 0));
                it.getCrossCompilationRootValidationDisabled().set((Object)this.$hiltExtension.getDisableCrossCompilationRootValidation());
                it.getAsmApiVersion().set((Object)589824);
            }
        }, arg_0));
        Object[] $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22 = new Object[1];
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
        $i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22[0] = FilesKt.resolve((File)file, (String)("intermediates/hilt/component_classes/" + variant.getName() + "/"));
        ConfigurableFileCollection componentClasses = project.files($i$a$-also-HiltGradlePlugin$configureVariantAggregatingTask$hiltAnnotationProcessorConfiguration$22);
        TaskContainer taskContainer2 = project.getTasks();
        String string4 = variant.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getName(...)");
        TaskProvider componentsJavaCompileTask2 = taskContainer2.register("hiltJavaCompile" + StringsKt.capitalize$default(string4, null, 1, null), JavaCompile.class, arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$lambda$21((Function1)new Function1<JavaCompile, Unit>((TaskProvider<AggregateDepsTask>)aggregatingTask2, variant, androidExtension, componentClasses, project, hiltCompileConfiguration, hiltAnnotationProcessorConfiguration2){
            final /* synthetic */ TaskProvider<AggregateDepsTask> $aggregatingTask;
            final /* synthetic */ BaseVariant $variant;
            final /* synthetic */ BaseExtension $androidExtension;
            final /* synthetic */ ConfigurableFileCollection $componentClasses;
            final /* synthetic */ Project $project;
            final /* synthetic */ Configuration $hiltCompileConfiguration;
            final /* synthetic */ Configuration $hiltAnnotationProcessorConfiguration;
            {
                this.$aggregatingTask = $aggregatingTask;
                this.$variant = $variant;
                this.$androidExtension = $androidExtension;
                this.$componentClasses = $componentClasses;
                this.$project = $project;
                this.$hiltCompileConfiguration = $hiltCompileConfiguration;
                this.$hiltAnnotationProcessorConfiguration = $hiltAnnotationProcessorConfiguration;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke(JavaCompile compileTask) {
                Object object;
                compileTask.setSource((FileTree)this.$aggregatingTask.map(arg_0 -> configureVariantAggregatingTask.componentsJavaCompileTask.1.invoke$lambda$0(configureVariantAggregatingTask.componentsJavaCompileTask.1.INSTANCE, arg_0)).get());
                FileCollection mainBootstrapClasspath2 = (FileCollection)this.$variant.getJavaCompileProvider().map(arg_0 -> configureVariantAggregatingTask.componentsJavaCompileTask.1.invoke$lambda$1((Function1)new Function1<JavaCompile, FileCollection>(this.$project){
                    final /* synthetic */ Project $project;
                    {
                        this.$project = $project;
                        super(1);
                    }

                    @NotNull
                    public final FileCollection invoke(JavaCompile it) {
                        FileCollection fileCollection = it.getOptions().getBootstrapClasspath();
                        if (fileCollection == null) {
                            fileCollection = (FileCollection)this.$project.files(new Object[0]);
                        }
                        return fileCollection;
                    }
                }, arg_0)).get();
                if (JavaVersion.current().isJava9Compatible() && this.$androidExtension.getCompileOptions().getTargetCompatibility().isJava9Compatible()) {
                    void $this$forEach$iv;
                    Iterator<T> $this$filterTo$iv$iv;
                    Iterable $this$filter$iv;
                    compileTask.setClasspath(HiltGradlePlugin.access$configureVariantAggregatingTask$getInputClasspath(this.$variant, this.$hiltCompileConfiguration, this.$project, "jar-for-dagger").plus(mainBootstrapClasspath2));
                    JavaCompile originalCompileTask = (JavaCompile)this.$variant.getJavaCompileProvider().get();
                    boolean bl = false;
                    List list = originalCompileTask.getOptions().getCompilerArgumentProviders();
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCompilerArgumentProviders(...)");
                    object = list;
                    boolean $i$f$filter = false;
                    void var8_9 = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    Iterator<T> iterator = $this$filterTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        T element$iv$iv = iterator.next();
                        CommandLineArgumentProvider it = (CommandLineArgumentProvider)element$iv$iv;
                        boolean bl2 = false;
                        if (!(it instanceof HiltCommandLineArgumentProvider || it instanceof JdkImageInput)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        CommandLineArgumentProvider it = (CommandLineArgumentProvider)element$iv;
                        boolean bl3 = false;
                        compileTask.getOptions().getCompilerArgumentProviders().add(it);
                    }
                    compileTask.getOptions().getCompilerArgs().add("-XDstringConcat=inline");
                } else {
                    compileTask.setClasspath((FileCollection)HiltGradlePlugin.access$configureVariantAggregatingTask$getInputClasspath(this.$variant, this.$hiltCompileConfiguration, this.$project, "jar-for-dagger"));
                    compileTask.getOptions().setBootstrapClasspath(mainBootstrapClasspath2);
                }
                compileTask.getDestinationDirectory().set(this.$componentClasses.getSingleFile());
                CompileOptions compileOptions = compileTask.getOptions();
                Configuration configuration = this.$hiltAnnotationProcessorConfiguration;
                Project project = this.$project;
                object = this.$variant;
                BaseExtension baseExtension = this.$androidExtension;
                CompileOptions $this$invoke_u24lambda_u245 = compileOptions;
                boolean bl = false;
                $this$invoke_u24lambda_u245.setAnnotationProcessorPath((FileCollection)configuration);
                DirectoryProperty directoryProperty = $this$invoke_u24lambda_u245.getGeneratedSourceOutputDirectory();
                File file = project.getBuildDir();
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getBuildDir(...)");
                directoryProperty.set(project.file((Object)FilesKt.resolve((File)file, (String)("generated/hilt/component_sources/" + object.getName() + "/"))));
                if (JavaVersion.current().isJava8Compatible() && baseExtension.getCompileOptions().getTargetCompatibility().isJava8Compatible()) {
                    $this$invoke_u24lambda_u245.getCompilerArgs().add("-parameters");
                }
                $this$invoke_u24lambda_u245.getCompilerArgs().add("-Adagger.fastInit=enabled");
                $this$invoke_u24lambda_u245.getCompilerArgs().add("-Adagger.hilt.internal.useAggregatingRootProcessor=false");
                $this$invoke_u24lambda_u245.getCompilerArgs().add("-Adagger.hilt.android.internal.disableAndroidSuperclassValidation=true");
                $this$invoke_u24lambda_u245.setEncoding(baseExtension.getCompileOptions().getEncoding());
                compileTask.setSourceCompatibility(this.$androidExtension.getCompileOptions().getSourceCompatibility().toString());
                compileTask.setTargetCompatibility(this.$androidExtension.getCompileOptions().getTargetCompatibility().toString());
            }

            private static final FileTree invoke$lambda$0(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (FileTree)$tmp0.invoke(in);
            }

            private static final FileCollection invoke$lambda$1(Function1 $tmp0, Object in) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (FileCollection)$tmp0.invoke(in);
            }
        }, arg_0));
        objectArray2 = new Object[]{componentsJavaCompileTask2};
        componentClasses.builtBy(objectArray2);
        variant.registerPostJavacGeneratedBytecode((FileCollection)componentClasses);
    }

    private final void configureProcessorFlags(Project project, HiltExtension hiltExtension, AndroidComponentsExtension<?, ?, ?> androidExtension) {
        GradleProjectType gradleProjectType;
        AndroidComponentsExtension<?, ?, ?> androidComponentsExtension = androidExtension;
        if (androidComponentsExtension instanceof ApplicationAndroidComponentsExtension) {
            gradleProjectType = GradleProjectType.APP;
        } else if (androidComponentsExtension instanceof LibraryAndroidComponentsExtension) {
            gradleProjectType = GradleProjectType.LIBRARY;
        } else if (androidComponentsExtension instanceof TestAndroidComponentsExtension) {
            gradleProjectType = GradleProjectType.TEST;
        } else {
            throw new IllegalStateException(("Hilt plugin does not know how to configure '" + this + "'").toString());
        }
        GradleProjectType projectType = gradleProjectType;
        VariantsKt.onAllVariants(androidExtension, (Function1<? super Component, Unit>)((Function1)new Function1<Component, Unit>(project, projectType, hiltExtension){
            final /* synthetic */ Project $project;
            final /* synthetic */ GradleProjectType $projectType;
            final /* synthetic */ HiltExtension $hiltExtension;
            {
                this.$project = $project;
                this.$projectType = $projectType;
                this.$hiltExtension = $hiltExtension;
                super(1);
            }

            public final void invoke(@NotNull Component variantComponent) {
                Intrinsics.checkNotNullParameter((Object)variantComponent, (String)"variantComponent");
                Function1 argsProducer2 = (Function1)new Function1<Task, HiltCommandLineArgumentProvider>(this.$projectType, this.$hiltExtension){
                    final /* synthetic */ GradleProjectType $projectType;
                    final /* synthetic */ HiltExtension $hiltExtension;
                    {
                        this.$projectType = $projectType;
                        this.$hiltExtension = $hiltExtension;
                        super(1);
                    }

                    @NotNull
                    public final HiltCommandLineArgumentProvider invoke(@NotNull Task task) {
                        Intrinsics.checkNotNullParameter((Object)task, (String)"task");
                        return new HiltCommandLineArgumentProvider(TasksKt.isKspTask(task), this.$projectType, this.$hiltExtension.getEnableAggregatingTask(), this.$hiltExtension.getDisableCrossCompilationRootValidation());
                    }
                };
                TasksKt.addJavaTaskProcessorOptions(this.$project, (ComponentIdentity)variantComponent, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer2);
                TasksKt.addKaptTaskProcessorOptions(this.$project, (ComponentIdentity)variantComponent, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer2);
                TasksKt.addKspTaskProcessorOptions(this.$project, (ComponentIdentity)variantComponent, (Function1<? super Task, ? extends CommandLineArgumentProvider>)argsProducer2);
            }
        }));
    }

    /*
     * Unable to fully structure code
     */
    private final void verifyDependencies(Project project) {
        if (project.getState().getFailure() != null) {
            return;
        }
        v0 = project.getConfigurations();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getConfigurations(...)");
        $this$filterNot$iv = (Iterable)v0;
        $i$f$filterNot = false;
        var5_4 = $this$filterNot$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterNotTo = false;
        for (T element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Configuration)element$iv$iv;
            $i$a$-filterNot-HiltGradlePlugin$verifyDependencies$dependencies$1 = false;
            v1 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
            if (kotlin.text.StringsKt.startsWith$default((String)v1, (String)"hiltAnnotationProcessor", (boolean)false, (int)2, null)) ** GOTO lbl-1000
            v2 = it.getName();
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
            if (kotlin.text.StringsKt.startsWith$default((String)v2, (String)"hiltCompileOnly", (boolean)false, (int)2, null)) lbl-1000:
            // 2 sources

            {
                v3 = true;
            } else {
                v3 = false;
            }
            if (v3) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        $i$f$flatMap = false;
        $this$filterNotTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$flatMapTo = false;
        for (T element$iv$iv : $this$flatMapTo$iv$iv) {
            configuration = (Configuration)element$iv$iv;
            $i$a$-flatMap-HiltGradlePlugin$verifyDependencies$dependencies$2 = false;
            v4 = configuration.getDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getDependencies(...)");
            $this$map$iv = (Iterable)v4;
            $i$f$map = false;
            var14_13 = $this$map$iv;
            destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (T item$iv$iv : $this$mapTo$iv$iv) {
                var19_18 = (Dependency)item$iv$iv;
                var20_19 = destination$iv$iv;
                $i$a$-map-HiltGradlePlugin$verifyDependencies$dependencies$2$1 = false;
                var20_19.add(TuplesKt.to((Object)dependency.getGroup(), (Object)dependency.getName()));
            }
            list$iv$iv = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        dependencies = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-android"))) {
            throw new IllegalStateException(HiltGradlePlugin.verifyDependencies$getMissingDepMsg("com.google.dagger:hilt-android").toString());
        }
        if (!dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-android-compiler")) && !dependencies.contains(TuplesKt.to((Object)"com.google.dagger", (Object)"hilt-compiler"))) {
            throw new IllegalStateException(HiltGradlePlugin.verifyDependencies$getMissingDepMsg("com.google.dagger:hilt-compiler").toString());
        }
    }

    private static final void apply$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void apply$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDependencyTransforms$lambda$7$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDependencyTransforms$lambda$7$lambda$5(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureDependencyTransforms$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantCompileClasspath$lambda$8(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final FileCollection configureVariantAggregatingTask$lambda$10(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (FileCollection)$tmp0.invoke(in);
    }

    private static final Directory configureVariantAggregatingTask$lambda$11(Function1 $tmp0, Object in) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Directory)$tmp0.invoke(in);
    }

    private static final void configureVariantAggregatingTask$lambda$15$lambda$14$lambda$12(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantAggregatingTask$lambda$15$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantAggregatingTask$getInputClasspath$lambda$18$lambda$17(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConfigurableFileCollection configureVariantAggregatingTask$getInputClasspath(BaseVariant $variant, Configuration hiltCompileConfiguration, Project $project, String artifactAttributeValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable;
        List $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2416 = iterable = CollectionsKt.createListBuilder();
        boolean $i$a$-buildList-HiltGradlePlugin$configureVariantAggregatingTask$getInputClasspath$22 = false;
        if ($variant instanceof TestVariant) {
            Configuration configuration = ((TestVariant)$variant).getTestedVariant().getRuntimeConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getRuntimeConfiguration(...)");
            $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2416.add(configuration);
        }
        Configuration configuration = $variant.getRuntimeConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getRuntimeConfiguration(...)");
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2416.add(configuration);
        Intrinsics.checkNotNull((Object)hiltCompileConfiguration);
        $this$configureVariantAggregatingTask_u24getInputClasspath_u24lambda_u2416.add(hiltCompileConfiguration);
        iterable = CollectionsKt.build((List)iterable);
        boolean $i$f$map = false;
        void $i$a$-buildList-HiltGradlePlugin$configureVariantAggregatingTask$getInputClasspath$22 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void configuration2;
            Configuration configuration3 = (Configuration)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(configuration2.getIncoming().artifactView(arg_0 -> HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath$lambda$18$lambda$17((Function1)new Function1<ArtifactView.ViewConfiguration, Unit>(artifactAttributeValue){
                final /* synthetic */ String $artifactAttributeValue;
                {
                    this.$artifactAttributeValue = $artifactAttributeValue;
                    super(1);
                }

                public final void invoke(ArtifactView.ViewConfiguration view) {
                    view.getAttributes().attribute(HiltGradlePlugin.access$getARTIFACT_TYPE_ATTRIBUTE$cp(), (Object)this.$artifactAttributeValue);
                }
            }, arg_0)).getFiles());
        }
        List it = (List)destination$iv$iv;
        boolean bl = false;
        Collection $this$toTypedArray$iv = it;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        FileCollection[] fileCollectionArray = thisCollection$iv.toArray(new FileCollection[0]);
        return $project.files((Object[])Arrays.copyOf(fileCollectionArray, fileCollectionArray.length));
    }

    private static final void configureVariantAggregatingTask$lambda$20(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void configureVariantAggregatingTask$lambda$21(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final String verifyDependencies$getMissingDepMsg(String depCoordinate) {
        return "The Hilt Android Gradle plugin is applied but no " + depCoordinate + " dependency was found.";
    }

    public static final /* synthetic */ void access$configureHilt(HiltGradlePlugin $this, Project project) {
        $this.configureHilt(project);
    }

    public static final /* synthetic */ void access$verifyDependencies(HiltGradlePlugin $this, Project project) {
        $this.verifyDependencies(project);
    }

    public static final /* synthetic */ void access$configureVariantCompileClasspath(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseVariant variant) {
        $this.configureVariantCompileClasspath(project, hiltExtension, variant);
    }

    public static final /* synthetic */ Attribute access$getARTIFACT_TYPE_ATTRIBUTE$cp() {
        return ARTIFACT_TYPE_ATTRIBUTE;
    }

    public static final /* synthetic */ void access$configureVariantAggregatingTask(HiltGradlePlugin $this, Project project, HiltExtension hiltExtension, BaseExtension androidExtension, BaseVariant variant) {
        $this.configureVariantAggregatingTask(project, hiltExtension, androidExtension, variant);
    }

    public static final /* synthetic */ ConfigurableFileCollection access$configureVariantAggregatingTask$getInputClasspath(BaseVariant $variant, Configuration hiltCompileConfiguration, Project $project, String artifactAttributeValue) {
        return HiltGradlePlugin.configureVariantAggregatingTask$getInputClasspath($variant, hiltCompileConfiguration, $project, artifactAttributeValue);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\u0018\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0010\u001a\u00020\u0011*\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R2\u0010\u0005\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00040\u0004\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R!\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00040\u000b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r"}, d2={"Ldagger/hilt/android/plugin/HiltGradlePlugin$Companion;", "", "()V", "AGGREGATED_HILT_ARTIFACT_TYPE_VALUE", "", "ARTIFACT_TYPE_ATTRIBUTE", "Lorg/gradle/api/attributes/Attribute;", "kotlin.jvm.PlatformType", "DAGGER_ARTIFACT_TYPE_VALUE", "LIBRARY_GROUP", "gradleSyncProps", "", "getGradleSyncProps", "()Ljava/util/List;", "gradleSyncProps$delegate", "Lkotlin/Lazy;", "isGradleSyncRunning", "", "Lorg/gradle/api/Project;"})
    @SourceDebugExtension(value={"SMAP\nHiltGradlePlugin.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,461:1\n1747#2,3:462\n*S KotlinDebug\n*F\n+ 1 HiltGradlePlugin.kt\ndagger/hilt/android/plugin/HiltGradlePlugin$Companion\n*L\n448#1:462,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isGradleSyncRunning(Project $this$isGradleSyncRunning) {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.getGradleSyncProps();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String property = (String)element$iv;
                        boolean bl2 = false;
                        Object object = $this$isGradleSyncRunning.getProviders().gradleProperty(property).map(arg_0 -> Companion.isGradleSyncRunning$lambda$1$lambda$0(isGradleSyncRunning.1.1.INSTANCE, arg_0)).orElse((Object)false).get();
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
                        if (!((Boolean)object).booleanValue()) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        private final List<String> getGradleSyncProps() {
            Lazy lazy = gradleSyncProps$delegate;
            return (List)lazy.getValue();
        }

        private static final Boolean isGradleSyncRunning$lambda$1$lambda$0(Function1 $tmp0, Object in) {
            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
            return (Boolean)$tmp0.invoke(in);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

