/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.SetMultimap;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.BadInputException;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_ComponentDependencies;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_ComponentDependencies_AggregatedDepMetadata;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_ComponentDependencies_Dependencies;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_ComponentDependencies_TestDepKey;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

@AutoValue
public abstract class ComponentDependencies {
    private static Builder builder() {
        return new AutoValue_ComponentDependencies.Builder();
    }

    public abstract Dependencies modules();

    public abstract Dependencies entryPoints();

    public abstract Dependencies componentEntryPoints();

    public static ComponentDependencies from(ImmutableSet<ComponentDescriptor> descriptors, Elements elements) {
        ImmutableMap<String, ComponentDescriptor> descriptorLookup = ComponentDependencies.descriptorLookupMap(descriptors);
        ImmutableList metadatas = (ImmutableList)ComponentDependencies.getAggregatedDeps(elements).stream().map(deps -> AggregatedDepMetadata.create(deps, descriptorLookup, elements)).collect(DaggerStreams.toImmutableList());
        Builder componentDependencies = ComponentDependencies.builder();
        for (AggregatedDepMetadata metadata2 : metadatas) {
            Dependencies.Builder builder = null;
            switch (metadata2.dependencyType()) {
                case MODULE: {
                    builder = componentDependencies.modulesBuilder();
                    break;
                }
                case ENTRY_POINT: {
                    builder = componentDependencies.entryPointsBuilder();
                    break;
                }
                case COMPONENT_ENTRY_POINT: {
                    builder = componentDependencies.componentEntryPointsBuilder();
                }
            }
            for (ComponentDescriptor componentDescriptor : metadata2.componentDescriptors()) {
                ClassName component = componentDescriptor.component();
                if (metadata2.testElement().isPresent()) {
                    ClassName test = ClassName.get((TypeElement)metadata2.testElement().get());
                    builder.testDepsBuilder().put((Object)TestDepKey.of(component, test), (Object)metadata2.dependency());
                    builder.uninstalledTestDepsBuilder().putAll((Object)test, metadata2.replacedDependencies());
                    continue;
                }
                if (!metadata2.replacedDependencies().isEmpty()) {
                    builder.globalTestDepsBuilder().put((Object)component, (Object)metadata2.dependency());
                    builder.globalUninstalledTestDepsBuilder().addAll(metadata2.replacedDependencies());
                    continue;
                }
                builder.globalDepsBuilder().put((Object)component, (Object)metadata2.dependency());
            }
        }
        metadatas.stream().filter(metadata -> metadata.testElement().isPresent()).map(metadata -> metadata.testElement().get()).distinct().filter(testElement -> Processors.hasAnnotation((Element)testElement, ClassNames.IGNORE_MODULES)).forEach(testElement -> componentDependencies.modulesBuilder().uninstalledTestDepsBuilder().putAll((Object)ClassName.get((TypeElement)testElement), ComponentDependencies.getUninstalledModules(testElement, elements)));
        return componentDependencies.build(elements);
    }

    private static ImmutableMap<String, ComponentDescriptor> descriptorLookupMap(ImmutableSet<ComponentDescriptor> descriptors) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ComponentDescriptor descriptor : descriptors) {
            if (descriptor.component().equals((Object)ClassNames.SINGLETON_COMPONENT)) {
                builder.put((Object)ClassNames.LEGACY_APPLICATION_COMPONENT.toString(), (Object)descriptor);
            }
            builder.put((Object)descriptor.component().toString(), (Object)descriptor);
        }
        return builder.build();
    }

    private static Dependencies validateModules(Dependencies moduleDeps, Elements elements) {
        HashMultimap invalidTestModules = HashMultimap.create();
        moduleDeps.testDeps().entries().stream().filter(e -> moduleDeps.uninstalledTestDeps().containsEntry((Object)((TestDepKey)e.getKey()).test(), e.getValue())).forEach(arg_0 -> ComponentDependencies.lambda$validateModules$6((SetMultimap)invalidTestModules, arg_0));
        Optional invalidTest = invalidTestModules.keySet().stream().min((test1, test2) -> test1.toString().compareTo(test2.toString()));
        if (invalidTest.isPresent()) {
            throw new BadInputException(String.format("@UninstallModules on test, %s, should not containing test modules, but found: %s", invalidTest.get(), invalidTestModules.get((Object)((ClassName)invalidTest.get())).stream().sorted((test1, test2) -> test1.toString().compareTo(test2.toString())).collect(DaggerStreams.toImmutableList())), elements.getTypeElement(((ClassName)invalidTest.get()).toString()));
        }
        return moduleDeps;
    }

    private static ImmutableSet<TypeElement> getUninstalledModules(TypeElement testElement, Elements elements) {
        ImmutableList<TypeElement> userUninstallModules = Processors.getAnnotationClassValues(elements, Processors.getAnnotationMirror((Element)testElement, ClassNames.IGNORE_MODULES), "value");
        return (ImmutableSet)userUninstallModules.stream().map(uninstallModule -> ComponentDependencies.getPublicDependency(uninstallModule, elements)).collect(DaggerStreams.toImmutableSet());
    }

    private static TypeElement getPublicDependency(TypeElement dependency, Elements elements) {
        return PkgPrivateMetadata.of(elements, dependency, ClassNames.MODULE).map(metadata -> elements.getTypeElement(metadata.generatedClassName().toString())).orElse(dependency);
    }

    private static ImmutableList<AnnotationMirror> getAggregatedDeps(Elements elements) {
        PackageElement packageElement = elements.getPackageElement("hilt_aggregated_deps");
        Preconditions.checkState((packageElement != null ? 1 : 0) != 0, (String)"Couldn't find package %s. Did you mark your @Module classes with @InstallIn annotations?", (Object)"hilt_aggregated_deps");
        List<? extends Element> aggregatedDepsElements = packageElement.getEnclosedElements();
        Preconditions.checkState((!aggregatedDepsElements.isEmpty() ? 1 : 0) != 0, (Object)"No dependencies found. Did you mark your @Module classes with @InstallIn annotations?");
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element : aggregatedDepsElements) {
            ProcessorErrors.checkState(element.getKind() == ElementKind.CLASS, element, "Only classes may be in package %s. Did you add custom code in the package?", "hilt_aggregated_deps");
            AnnotationMirror aggregatedDeps = Processors.getAnnotationMirror(element, ClassNames.AGGREGATED_DEPS);
            ProcessorErrors.checkState(aggregatedDeps != null, element, "Classes in package %s must be annotated with @AggregatedDeps: %s. Found: %s.", "hilt_aggregated_deps", element.getSimpleName(), element.getAnnotationMirrors());
            builder.add((Object)aggregatedDeps);
        }
        return builder.build();
    }

    private static /* synthetic */ void lambda$validateModules$6(SetMultimap invalidTestModules, Map.Entry e) {
        invalidTestModules.put((Object)((TestDepKey)e.getKey()).test(), (Object)((TypeElement)e.getValue()));
    }

    @AutoValue
    static abstract class AggregatedDepMetadata {
        AggregatedDepMetadata() {
        }

        static AggregatedDepMetadata create(AnnotationMirror aggregatedDeps, Map<String, ComponentDescriptor> descriptorLookup, Elements elements) {
            ImmutableMap<String, AnnotationValue> aggregatedDepsValues = Processors.getAnnotationValues(elements, aggregatedDeps);
            return new AutoValue_ComponentDependencies_AggregatedDepMetadata(AggregatedDepMetadata.getTestElement((AnnotationValue)aggregatedDepsValues.get((Object)"test"), elements), AggregatedDepMetadata.getComponents((AnnotationValue)aggregatedDepsValues.get((Object)"components"), descriptorLookup), AggregatedDepMetadata.getDependencyType((AnnotationValue)aggregatedDepsValues.get((Object)"modules"), (AnnotationValue)aggregatedDepsValues.get((Object)"entryPoints"), (AnnotationValue)aggregatedDepsValues.get((Object)"componentEntryPoints")), AggregatedDepMetadata.getDependency((AnnotationValue)aggregatedDepsValues.get((Object)"modules"), (AnnotationValue)aggregatedDepsValues.get((Object)"entryPoints"), (AnnotationValue)aggregatedDepsValues.get((Object)"componentEntryPoints"), elements), AggregatedDepMetadata.getReplacedDependencies((AnnotationValue)aggregatedDepsValues.get((Object)"replaces"), elements));
        }

        abstract Optional<TypeElement> testElement();

        abstract ImmutableList<ComponentDescriptor> componentDescriptors();

        abstract DependencyType dependencyType();

        abstract TypeElement dependency();

        abstract ImmutableSet<TypeElement> replacedDependencies();

        private static Optional<TypeElement> getTestElement(AnnotationValue testValue, Elements elements) {
            Preconditions.checkNotNull((Object)testValue);
            String test = AnnotationValues.getString(testValue);
            return test.isEmpty() ? Optional.empty() : Optional.of(elements.getTypeElement(test));
        }

        private static ImmutableList<ComponentDescriptor> getComponents(AnnotationValue componentsValue, Map<String, ComponentDescriptor> descriptorLookup) {
            Preconditions.checkNotNull((Object)componentsValue);
            ImmutableList componentNames = (ImmutableList)AnnotationValues.getAnnotationValues(componentsValue).stream().map(AnnotationValues::getString).collect(DaggerStreams.toImmutableList());
            Preconditions.checkState((!componentNames.isEmpty() ? 1 : 0) != 0);
            ImmutableList.Builder components = ImmutableList.builder();
            for (String componentName : componentNames) {
                Preconditions.checkState((boolean)descriptorLookup.containsKey(componentName), (String)"%s is not a valid Component. Did you add or remove code in package %s?", (Object)componentName, (Object)"hilt_aggregated_deps");
                components.add((Object)descriptorLookup.get(componentName));
            }
            return components.build();
        }

        private static DependencyType getDependencyType(AnnotationValue modulesValue, AnnotationValue entryPointsValue, AnnotationValue componentEntryPointsValue) {
            Preconditions.checkNotNull((Object)modulesValue);
            Preconditions.checkNotNull((Object)entryPointsValue);
            Preconditions.checkNotNull((Object)componentEntryPointsValue);
            ImmutableSet.Builder dependencyTypes = ImmutableSet.builder();
            if (!AnnotationValues.getAnnotationValues(modulesValue).isEmpty()) {
                dependencyTypes.add((Object)DependencyType.MODULE);
            }
            if (!AnnotationValues.getAnnotationValues(entryPointsValue).isEmpty()) {
                dependencyTypes.add((Object)DependencyType.ENTRY_POINT);
            }
            if (!AnnotationValues.getAnnotationValues(componentEntryPointsValue).isEmpty()) {
                dependencyTypes.add((Object)DependencyType.COMPONENT_ENTRY_POINT);
            }
            return (DependencyType)((Object)Iterables.getOnlyElement((Iterable)dependencyTypes.build()));
        }

        private static TypeElement getDependency(AnnotationValue modulesValue, AnnotationValue entryPointsValue, AnnotationValue componentEntryPointsValue, Elements elements) {
            Preconditions.checkNotNull((Object)modulesValue);
            Preconditions.checkNotNull((Object)entryPointsValue);
            Preconditions.checkNotNull((Object)componentEntryPointsValue);
            return elements.getTypeElement(AnnotationValues.getString((AnnotationValue)Iterables.getOnlyElement((Iterable)ImmutableList.builder().addAll(AnnotationValues.getAnnotationValues(modulesValue)).addAll(AnnotationValues.getAnnotationValues(entryPointsValue)).addAll(AnnotationValues.getAnnotationValues(componentEntryPointsValue)).build())));
        }

        private static ImmutableSet<TypeElement> getReplacedDependencies(AnnotationValue replacedDependenciesValue, Elements elements) {
            return replacedDependenciesValue == null ? ImmutableSet.of() : (ImmutableSet)AnnotationValues.getAnnotationValues(replacedDependenciesValue).stream().map(AnnotationValues::getString).map(elements::getTypeElement).map(replacedDep -> ComponentDependencies.getPublicDependency(replacedDep, elements)).collect(DaggerStreams.toImmutableSet());
        }

        static enum DependencyType {
            MODULE,
            ENTRY_POINT,
            COMPONENT_ENTRY_POINT;

        }
    }

    @AutoValue
    public static abstract class Dependencies {
        static Builder builder() {
            return new AutoValue_ComponentDependencies_Dependencies.Builder();
        }

        abstract ImmutableSetMultimap<ClassName, TypeElement> globalDeps();

        abstract ImmutableSetMultimap<ClassName, TypeElement> globalTestDeps();

        abstract ImmutableSetMultimap<TestDepKey, TypeElement> testDeps();

        abstract ImmutableSetMultimap<ClassName, TypeElement> uninstalledTestDeps();

        abstract ImmutableSet<TypeElement> globalUninstalledTestDeps();

        public ImmutableSet<TypeElement> get(ClassName component, ClassName root, boolean isTestRoot) {
            if (!isTestRoot) {
                return this.globalDeps().get((Object)component);
            }
            ImmutableSet uninstalledTestDepsForRoot = this.uninstalledTestDeps().get((Object)root);
            return ImmutableSet.builder().addAll((Iterable)this.globalDeps().get((Object)component).stream().filter(dep -> !uninstalledTestDepsForRoot.contains(dep)).filter(dep -> !this.globalUninstalledTestDeps().contains(dep)).collect(DaggerStreams.toImmutableSet())).addAll((Iterable)this.globalTestDeps().get((Object)component)).addAll((Iterable)this.testDeps().get((Object)TestDepKey.of(component, root))).build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract ImmutableSetMultimap.Builder<ClassName, TypeElement> globalDepsBuilder();

            abstract ImmutableSetMultimap.Builder<ClassName, TypeElement> globalTestDepsBuilder();

            abstract ImmutableSetMultimap.Builder<TestDepKey, TypeElement> testDepsBuilder();

            abstract ImmutableSetMultimap.Builder<ClassName, TypeElement> uninstalledTestDepsBuilder();

            abstract ImmutableSet.Builder<TypeElement> globalUninstalledTestDepsBuilder();

            abstract Dependencies build();
        }
    }

    @AutoValue
    static abstract class TestDepKey {
        TestDepKey() {
        }

        static TestDepKey of(ClassName component, ClassName test) {
            return new AutoValue_ComponentDependencies_TestDepKey(component, test);
        }

        abstract ClassName component();

        abstract ClassName test();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Dependencies.Builder modulesBuilder();

        abstract Dependencies.Builder entryPointsBuilder();

        abstract Dependencies.Builder componentEntryPointsBuilder();

        abstract ComponentDependencies autoBuild();

        ComponentDependencies build(Elements elements) {
            ComponentDependencies.validateModules(this.modulesBuilder().build(), elements);
            return this.autoBuild();
        }
    }
}

