/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aliasof;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import java.util.Collection;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class AliasOfs {
    static final String AGGREGATING_PACKAGE = AliasOfs.class.getPackage().getName() + ".codegen";
    private final ProcessingEnvironment processingEnvironment;
    private final ImmutableSet<ClassName> defineComponentScopes;
    private final Supplier<ImmutableMultimap<ClassName, ClassName>> aliases = Suppliers.memoize(() -> this.getAliases());

    public AliasOfs(ProcessingEnvironment processingEnvironment, ImmutableSet<ClassName> defineComponentScopes) {
        this.defineComponentScopes = defineComponentScopes;
        this.processingEnvironment = processingEnvironment;
    }

    public ImmutableSet<ClassName> getAliasesFor(ClassName defineComponentScope) {
        return ImmutableSet.copyOf((Collection)((ImmutableMultimap)this.aliases.get()).get((Object)defineComponentScope));
    }

    private ImmutableMultimap<ClassName, ClassName> getAliases() {
        Elements elements = this.processingEnvironment.getElementUtils();
        PackageElement packageElement = elements.getPackageElement(AGGREGATING_PACKAGE);
        if (packageElement == null) {
            return ImmutableMultimap.of();
        }
        List<? extends Element> scopeAliasElements = packageElement.getEnclosedElements();
        Preconditions.checkState((!scopeAliasElements.isEmpty() ? 1 : 0) != 0, (String)"No scope aliases Found in package %s.", (Object)packageElement);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Element element : scopeAliasElements) {
            ProcessorErrors.checkState(element.getKind() == ElementKind.CLASS, element, "Only classes may be in package %s. Did you add custom code in the package?", packageElement);
            AnnotationMirror annotationMirror = Processors.getAnnotationMirror(element, ClassNames.ALIAS_OF_PROPAGATED_DATA);
            ProcessorErrors.checkState(annotationMirror != null, element, "Classes in package %s must be annotated with @%s: %s. Found: %s. Files in this package are generated, did you add custom code in the package? ", packageElement, ClassNames.ALIAS_OF_PROPAGATED_DATA, element.getSimpleName(), element.getAnnotationMirrors());
            TypeElement defineComponentScope = Processors.getAnnotationClassValue(elements, annotationMirror, "defineComponentScope");
            TypeElement alias = Processors.getAnnotationClassValue(elements, annotationMirror, "alias");
            Preconditions.checkState((boolean)this.defineComponentScopes.contains((Object)ClassName.get((TypeElement)defineComponentScope)), (String)"The scope %s cannot be an alias for %s. You can only have aliases of a scope defined directly on a @DefineComponent type.", (Object)ClassName.get((TypeElement)alias), (Object)ClassName.get((TypeElement)defineComponentScope));
            builder.put((Object)ClassName.get((TypeElement)defineComponentScope), (Object)ClassName.get((TypeElement)alias));
        }
        return builder.build();
    }
}

