/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.MutableGraph;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.AnnotationMirrors;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.AnnotationValues;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ComponentTree;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.AutoValue_DefineComponents_AggregatedMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponentBuilderMetadatas;
import dagger.hilt.processor.internal.definecomponent.DefineComponentMetadatas;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class DefineComponents {
    static final String AGGREGATING_PACKAGE = DefineComponents.class.getPackage().getName() + ".codegen";
    private final Map<Element, ComponentDescriptor> componentDescriptors = new HashMap<Element, ComponentDescriptor>();
    private final DefineComponentMetadatas componentMetadatas = DefineComponentMetadatas.create();
    private final DefineComponentBuilderMetadatas componentBuilderMetadatas = DefineComponentBuilderMetadatas.create(this.componentMetadatas);

    public static DefineComponents create() {
        return new DefineComponents();
    }

    private DefineComponents() {
    }

    public ComponentDescriptor componentDescriptor(Element element) {
        if (!this.componentDescriptors.containsKey(element)) {
            this.componentDescriptors.put(element, this.uncachedComponentDescriptor(element));
        }
        return this.componentDescriptors.get(element);
    }

    private ComponentDescriptor uncachedComponentDescriptor(Element element) {
        DefineComponentMetadatas.DefineComponentMetadata metadata = this.componentMetadatas.get(element);
        ComponentDescriptor.Builder builder = ComponentDescriptor.builder().component(ClassName.get((TypeElement)metadata.component())).scopes((ImmutableSet<ClassName>)((ImmutableSet)metadata.scopes().stream().map(ClassName::get).collect(DaggerStreams.toImmutableSet())));
        metadata.parentMetadata().map(DefineComponentMetadatas.DefineComponentMetadata::component).map(this::componentDescriptor).ifPresent(builder::parent);
        return builder.build();
    }

    public ComponentTree getComponentTree(Elements elements) {
        AggregatedMetadata aggregatedMetadata = AggregatedMetadata.from(elements, this.componentMetadatas, this.componentBuilderMetadatas);
        ArrayListMultimap builderMultimap = ArrayListMultimap.create();
        aggregatedMetadata.builders().forEach(arg_0 -> DefineComponents.lambda$getComponentTree$0((ListMultimap)builderMultimap, arg_0));
        for (DefineComponentMetadatas.DefineComponentMetadata componentMetadata2 : builderMultimap.keySet()) {
            TypeElement component = componentMetadata2.component();
            ProcessorErrors.checkState(builderMultimap.get((Object)componentMetadata2).size() <= 1, component, "Multiple @%s declarations are not allowed for @%s type, %s. Found: %s", ClassNames.DEFINE_COMPONENT_BUILDER, ClassNames.DEFINE_COMPONENT, component, builderMultimap.get((Object)componentMetadata2).stream().map(DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata::builder).map(Object::toString).sorted().collect(DaggerStreams.toImmutableList()));
        }
        LinkedHashMap builderMap = new LinkedHashMap();
        builderMultimap.entries().forEach(e -> builderMap.put((DefineComponentMetadatas.DefineComponentMetadata)e.getKey(), (DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata)e.getValue()));
        Set filteredDescriptors = (Set)aggregatedMetadata.components().stream().map(componentMetadata -> DefineComponents.toComponentDescriptor(componentMetadata, builderMap)).filter(descriptor -> descriptor.isRoot() || descriptor.creator().isPresent()).collect(DaggerStreams.toImmutableSet());
        Graph<ComponentDescriptor> filteredGraph = DefineComponents.buildGraph(filteredDescriptors);
        Set roots = (Set)filteredDescriptors.stream().filter(ComponentDescriptor::isRoot).collect(DaggerStreams.toImmutableSet());
        Preconditions.checkState((roots.size() == 1 ? 1 : 0) != 0, (String)"Expected exactly 1 root component to be found but found instead %s", (Object)roots);
        return new ComponentTree((ImmutableGraph<ComponentDescriptor>)ImmutableGraph.copyOf(DefineComponents.buildGraph(Graphs.reachableNodes(filteredGraph, (Object)((ComponentDescriptor)Iterables.getOnlyElement((Iterable)roots))))));
    }

    private static Graph<ComponentDescriptor> buildGraph(Set<ComponentDescriptor> descriptors) {
        MutableGraph graph = GraphBuilder.directed().allowsSelfLoops(false).build();
        descriptors.forEach(descriptor -> {
            graph.addNode(descriptor);
            descriptor.parent().ifPresent(parent -> graph.putEdge(parent, descriptor));
        });
        return graph;
    }

    private static ComponentDescriptor toComponentDescriptor(DefineComponentMetadatas.DefineComponentMetadata componentMetadata, Map<DefineComponentMetadatas.DefineComponentMetadata, DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata> builderMap) {
        ComponentDescriptor.Builder builder = ComponentDescriptor.builder().component(ClassName.get((TypeElement)componentMetadata.component())).scopes((ImmutableSet<ClassName>)((ImmutableSet)componentMetadata.scopes().stream().map(ClassName::get).collect(DaggerStreams.toImmutableSet())));
        if (builderMap.containsKey(componentMetadata)) {
            builder.creator(ClassName.get((TypeElement)builderMap.get(componentMetadata).builder()));
        }
        componentMetadata.parentMetadata().map(parent -> DefineComponents.toComponentDescriptor(parent, builderMap)).ifPresent(builder::parent);
        return builder.build();
    }

    private static /* synthetic */ void lambda$getComponentTree$0(ListMultimap builderMultimap, DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata builder) {
        builderMultimap.put((Object)builder.componentMetadata(), (Object)builder);
    }

    @AutoValue
    static abstract class AggregatedMetadata {
        AggregatedMetadata() {
        }

        abstract ImmutableList<DefineComponentMetadatas.DefineComponentMetadata> components();

        abstract ImmutableList<DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata> builders();

        static AggregatedMetadata from(Elements elements, DefineComponentMetadatas componentMetadatas, DefineComponentBuilderMetadatas componentBuilderMetadatas) {
            PackageElement packageElement = elements.getPackageElement(AGGREGATING_PACKAGE);
            if (packageElement == null) {
                return new AutoValue_DefineComponents_AggregatedMetadata((ImmutableList<DefineComponentMetadatas.DefineComponentMetadata>)ImmutableList.of(), (ImmutableList<DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata>)ImmutableList.of());
            }
            ImmutableList.Builder components = ImmutableList.builder();
            ImmutableList.Builder builders = ImmutableList.builder();
            for (Element element : packageElement.getEnclosedElements()) {
                ProcessorErrors.checkState(MoreElements.isType(element), element, "Only types may be in package %s. Did you add custom code in the package?", packageElement);
                TypeElement typeElement = MoreElements.asType(element);
                ProcessorErrors.checkState(Processors.hasAnnotation((Element)typeElement, ClassNames.DEFINE_COMPONENT_CLASSES), typeElement, "Class, %s, must be annotated with @%s. Found: %s.", typeElement, ClassNames.DEFINE_COMPONENT_CLASSES.simpleName(), typeElement.getAnnotationMirrors());
                Optional<TypeElement> component = AggregatedMetadata.defineComponentClass(elements, typeElement, "component");
                Optional<TypeElement> builder = AggregatedMetadata.defineComponentClass(elements, typeElement, "builder");
                ProcessorErrors.checkState(component.isPresent() || builder.isPresent(), typeElement, (Object)"@DefineComponentClasses missing both `component` and `builder` members.");
                component.map(componentMetadatas::get).ifPresent(arg_0 -> ((ImmutableList.Builder)components).add(arg_0));
                builder.map(componentBuilderMetadatas::get).ifPresent(arg_0 -> ((ImmutableList.Builder)builders).add(arg_0));
            }
            return new AutoValue_DefineComponents_AggregatedMetadata((ImmutableList<DefineComponentMetadatas.DefineComponentMetadata>)components.build(), (ImmutableList<DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata>)builders.build());
        }

        private static Optional<TypeElement> defineComponentClass(Elements elements, Element element, String annotationMember) {
            AnnotationMirror mirror = Processors.getAnnotationMirror(element, ClassNames.DEFINE_COMPONENT_CLASSES);
            AnnotationValue value = AnnotationMirrors.getAnnotationElementAndValue(mirror, annotationMember).getValue();
            String className = AnnotationValues.getString(value);
            if (className.isEmpty()) {
                return Optional.empty();
            }
            TypeElement type = elements.getTypeElement(className);
            ProcessorErrors.checkState(type != null, element, "%s.%s(), has invalid value: `%s`.", ClassNames.DEFINE_COMPONENT_CLASSES.simpleName(), annotationMember, className);
            return Optional.of(type);
        }
    }
}

