/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ComponentGenerator;
import dagger.hilt.processor.internal.ComponentNames;
import dagger.hilt.processor.internal.ComponentTree;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootFileFormatter;
import dagger.hilt.processor.internal.root.RootMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import java.io.IOException;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;

final class RootGenerator {
    private final RootMetadata metadata;
    private final ProcessingEnvironment env;
    private final Root root;

    static void generate(RootMetadata metadata, ProcessingEnvironment env) throws IOException {
        new RootGenerator(metadata, env).generateComponents();
    }

    private RootGenerator(RootMetadata metadata, ProcessingEnvironment env) {
        this.metadata = metadata;
        this.env = env;
        this.root = metadata.root();
    }

    private void generateComponents() throws IOException {
        TypeSpec.Builder componentsWrapper = TypeSpec.classBuilder((ClassName)this.getComponentsWrapperClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addMethod(MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PRIVATE}).build());
        Processors.addGeneratedAnnotation(componentsWrapper, this.env, ClassNames.ROOT_PROCESSOR.toString());
        ImmutableMap<ComponentDescriptor, ClassName> subcomponentBuilderModules = this.subcomponentBuilderModules(componentsWrapper);
        ComponentTree componentTree = this.metadata.componentTree();
        for (ComponentDescriptor componentDescriptor : componentTree.getComponentDescriptors()) {
            ImmutableSet modules = ImmutableSet.builder().addAll(Processors.toClassNames(this.metadata.modules(componentDescriptor.component()))).addAll((Iterable)componentTree.childrenOf(componentDescriptor).stream().map(arg_0 -> subcomponentBuilderModules.get(arg_0)).collect(DaggerStreams.toImmutableSet())).build();
            componentsWrapper.addType(new ComponentGenerator(this.env, this.getComponentClassName(componentDescriptor), this.root.element(), Optional.empty(), (Set<? extends ClassName>)modules, (Set<? extends TypeName>)this.metadata.entryPoints(componentDescriptor.component()), (ImmutableCollection<ClassName>)this.metadata.scopes(componentDescriptor.component()), (ImmutableList<AnnotationSpec>)ImmutableList.of(), this.componentAnnotation(componentDescriptor), this.componentBuilder(componentDescriptor)).generate().toBuilder().addModifiers(new Modifier[]{Modifier.STATIC}).build());
        }
        RootFileFormatter.write(JavaFile.builder((String)this.root.classname().packageName(), (TypeSpec)componentsWrapper.build()).build(), this.env.getFiler());
    }

    private ImmutableMap<ComponentDescriptor, ClassName> subcomponentBuilderModules(TypeSpec.Builder componentsWrapper) throws IOException {
        ImmutableMap.Builder modules = ImmutableMap.builder();
        for (ComponentDescriptor descriptor : this.metadata.componentTree().getComponentDescriptors()) {
            if (descriptor.isRoot() || !descriptor.creator().isPresent()) continue;
            ClassName component = this.getComponentClassName(descriptor);
            ClassName builder = descriptor.creator().get();
            ClassName module = component.peerClass(component.simpleName() + "BuilderModule");
            componentsWrapper.addType(this.subcomponentBuilderModule(component, builder, module));
            modules.put((Object)descriptor, (Object)module);
        }
        return modules.build();
    }

    private TypeSpec subcomponentBuilderModule(ClassName componentName, ClassName builderName, ClassName moduleName) throws IOException {
        TypeSpec.Builder subcomponentBuilderModule = TypeSpec.interfaceBuilder((ClassName)moduleName).addOriginatingElement((Element)this.root.element()).addModifiers(new Modifier[]{Modifier.ABSTRACT}).addAnnotation(AnnotationSpec.builder((ClassName)ClassNames.MODULE).addMember("subcomponents", "$T.class", new Object[]{componentName}).build()).addAnnotation(ClassNames.DISABLE_INSTALL_IN_CHECK).addMethod(MethodSpec.methodBuilder((String)"bind").addModifiers(new Modifier[]{Modifier.ABSTRACT, Modifier.PUBLIC}).addAnnotation(ClassNames.BINDS).returns((TypeName)builderName).addParameter((TypeName)componentName.nestedClass("Builder"), "builder", new Modifier[0]).build());
        Processors.addGeneratedAnnotation(subcomponentBuilderModule, this.env, ClassNames.ROOT_PROCESSOR.toString());
        return subcomponentBuilderModule.build();
    }

    private Optional<TypeSpec> componentBuilder(ComponentDescriptor descriptor) {
        return descriptor.creator().map(creator -> TypeSpec.interfaceBuilder((String)"Builder").addOriginatingElement((Element)this.root.element()).addModifiers(new Modifier[]{Modifier.STATIC, Modifier.ABSTRACT}).addSuperinterface((TypeName)creator).addAnnotation(this.componentBuilderAnnotation(descriptor)).build());
    }

    private ClassName componentAnnotation(ComponentDescriptor componentDescriptor) {
        if (!componentDescriptor.isRoot()) {
            return ClassNames.SUBCOMPONENT;
        }
        return ClassNames.COMPONENT;
    }

    private ClassName componentBuilderAnnotation(ComponentDescriptor componentDescriptor) {
        if (componentDescriptor.isRoot()) {
            return ClassNames.COMPONENT_BUILDER;
        }
        return ClassNames.SUBCOMPONENT_BUILDER;
    }

    private ClassName getPartialRootModuleClassName() {
        return this.getComponentsWrapperClassName().nestedClass("PartialRootModule");
    }

    private ClassName getComponentsWrapperClassName() {
        return ComponentNames.generatedComponentsWrapper(this.root.classname());
    }

    private ClassName getComponentClassName(ComponentDescriptor componentDescriptor) {
        return ComponentNames.generatedComponent(this.root.classname(), componentDescriptor.component());
    }
}

