/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.generatesrootinput;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public final class GeneratesRootInputs {
    static final String AGGREGATING_PACKAGE = GeneratesRootInputs.class.getPackage().getName() + ".codegen";
    private final Elements elements;
    private final Supplier<ImmutableList<ClassName>> generatesRootInputAnnotations = Suppliers.memoize(() -> this.getAnnotationList());

    public GeneratesRootInputs(ProcessingEnvironment processingEnvironment) {
        this.elements = processingEnvironment.getElementUtils();
    }

    public ImmutableSet<Element> getElementsToWaitFor(RoundEnvironment roundEnv) {
        return (ImmutableSet)((ImmutableList)this.generatesRootInputAnnotations.get()).stream().map(className -> this.elements.getTypeElement(className.toString())).filter(element -> element != null).flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream()).collect(DaggerStreams.toImmutableSet());
    }

    private ImmutableList<ClassName> getAnnotationList() {
        PackageElement packageElement = this.elements.getPackageElement(AGGREGATING_PACKAGE);
        if (packageElement == null) {
            return ImmutableList.of();
        }
        List<? extends Element> annotationElements = packageElement.getEnclosedElements();
        Preconditions.checkState((!annotationElements.isEmpty() ? 1 : 0) != 0, (String)"No elements Found in package %s.", (Object)packageElement);
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Element element : annotationElements) {
            ProcessorErrors.checkState(element.getKind() == ElementKind.CLASS, element, "Only classes may be in package %s. Did you add custom code in the package?", packageElement);
            AnnotationMirror annotationMirror = Processors.getAnnotationMirror(element, ClassNames.GENERATES_ROOT_INPUT_PROPAGATED_DATA);
            ProcessorErrors.checkState(annotationMirror != null, element, "Classes in package %s must be annotated with @%s: %s. Found: %s. Files in this package are generated, did you add custom code in the package? ", packageElement, ClassNames.GENERATES_ROOT_INPUT_PROPAGATED_DATA, element.getSimpleName(), element.getAnnotationMirrors());
            TypeElement annotation = Processors.getAnnotationClassValue(this.elements, annotationMirror, "value");
            builder.add((Object)ClassName.get((TypeElement)annotation));
        }
        builder.add((Object)ClassNames.PRODUCTION_COMPONENT);
        return builder.build();
    }
}

