/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.uninstallmodules;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import dagger.hilt.android.shaded.auto.common.MoreElements;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesGenerator;
import dagger.internal.codegen.extension.DaggerStreams;
import java.util.Set;
import javax.annotation.processing.Processor;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@AutoService(value={Processor.class})
public final class UninstallModulesProcessor
extends BaseProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.UNINSTALL_MODULES.toString());
    }

    @Override
    public void processEach(TypeElement annotation, Element element) throws Exception {
        ProcessorErrors.checkState(MoreElements.isType(element) && Processors.hasAnnotation(element, ClassNames.HILT_ANDROID_TEST), element, "@%s should only be used on test classes annotated with @%s, but found: %s", annotation.getSimpleName(), ClassNames.HILT_ANDROID_TEST.simpleName(), element);
        TypeElement testElement = MoreElements.asType(element);
        ImmutableList<TypeElement> uninstallModules = Processors.getAnnotationClassValues(this.getElementUtils(), Processors.getAnnotationMirror((Element)testElement, ClassNames.UNINSTALL_MODULES), "value");
        this.checkModulesHaveInstallIn(testElement, uninstallModules);
        this.checkModulesDontOriginateFromTest(testElement, uninstallModules);
        new AggregatedUninstallModulesGenerator(testElement, uninstallModules, this.getProcessingEnv()).generate();
    }

    private void checkModulesHaveInstallIn(TypeElement testElement, ImmutableList<TypeElement> uninstallModules) {
        ImmutableList invalidModules = (ImmutableList)uninstallModules.stream().filter(module -> !Processors.hasAnnotation((Element)module, ClassNames.MODULE) || !Processors.hasAnnotation((Element)module, ClassNames.INSTALL_IN)).collect(DaggerStreams.toImmutableList());
        ProcessorErrors.checkState(invalidModules.isEmpty(), testElement, "@UninstallModules should only include modules annotated with both @Module and @InstallIn, but found: %s.", invalidModules);
    }

    private void checkModulesDontOriginateFromTest(TypeElement testElement, ImmutableList<TypeElement> uninstallModules) {
        ImmutableList invalidModules = (ImmutableList)uninstallModules.stream().filter(module -> Processors.getOriginatingTestElement(module, this.getElementUtils()).isPresent()).map(ClassName::get).collect(DaggerStreams.toImmutableList());
        ProcessorErrors.checkState(invalidModules.isEmpty(), testElement, "@UninstallModules should not contain test modules, but found: %s", invalidModules);
    }
}

