/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.android.processor.internal.androidentrypoint;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.android.processor.internal.AndroidClassNames;
import dagger.hilt.android.processor.internal.androidentrypoint.ActivityGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.ApplicationGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.BroadcastReceiverGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.FragmentGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.InjectorEntryPointGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.ServiceGenerator;
import dagger.hilt.android.processor.internal.androidentrypoint.ViewGenerator;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.optionvalues.GradleProjectType;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Set;
import javax.annotation.processing.Processor;

@AutoService(value={Processor.class})
public final class AndroidEntryPointProcessor
extends BaseProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)AndroidClassNames.ANDROID_ENTRY_POINT.toString(), (Object)AndroidClassNames.HILT_ANDROID_APP.toString());
    }

    @Override
    public boolean delayErrors() {
        return true;
    }

    @Override
    public void processEach(XTypeElement annotation, XElement element) throws Exception {
        AndroidEntryPointMetadata metadata = AndroidEntryPointMetadata.of(element);
        new InjectorEntryPointGenerator(this.processingEnv(), metadata).generate();
        switch (metadata.androidType()) {
            case APPLICATION: {
                GradleProjectType projectType = HiltCompilerOptions.getGradleProjectType(this.processingEnv());
                if (projectType != GradleProjectType.UNSET) {
                    ProcessorErrors.checkState(projectType == GradleProjectType.APP, element, "Application class, %s, annotated with @HiltAndroidApp must be defined in a Gradle android application module (i.e. contains a build.gradle file with `plugins { id 'com.android.application' }`).", metadata.element().getQualifiedName());
                }
                if (HiltCompilerOptions.useAggregatingRootProcessor(this.processingEnv())) {
                    new ApplicationGenerator(this.processingEnv(), metadata).generate();
                    break;
                }
                ProcessorErrors.checkState(metadata.requiresBytecodeInjection(), (XElement)metadata.element(), "'enableAggregatingTask=true' cannot be used when the application directly references the generated Hilt class, %s. Either extend %s directly (relying on the Gradle plugin described in https://dagger.dev/hilt/gradle-setup#why-use-the-plugin or set 'enableAggregatingTask=false'.", metadata.generatedClassName(), metadata.baseClassName());
                break;
            }
            case ACTIVITY: {
                new ActivityGenerator(this.processingEnv(), metadata).generate();
                break;
            }
            case BROADCAST_RECEIVER: {
                new BroadcastReceiverGenerator(this.processingEnv(), metadata).generate();
                break;
            }
            case FRAGMENT: {
                new FragmentGenerator(this.processingEnv(), metadata).generate();
                break;
            }
            case SERVICE: {
                new ServiceGenerator(this.processingEnv(), metadata).generate();
                break;
            }
            case VIEW: {
                new ViewGenerator(this.processingEnv(), metadata).generate();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown Hilt type: " + (Object)((Object)metadata.androidType()));
            }
        }
    }
}

