/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.processor.internal.AutoValue_BaseProcessor_ProcessingState;
import dagger.hilt.processor.internal.ErrorTypeException;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrorHandler;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnvConfig;
import dagger.spi.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public abstract class BaseProcessor
extends AbstractProcessor {
    private static final XProcessingEnvConfig PROCESSING_ENV_CONFIG = new XProcessingEnvConfig.Builder().disableAnnotatedElementValidation(true).build();
    private final Set<ProcessingState> stateToReprocess = new LinkedHashSet<ProcessingState>();
    private XProcessingEnv env;
    private ProcessorErrorHandler errorHandler;

    public final ImmutableSet<String> getSupportedOptions() {
        return ImmutableSet.builder().addAll(HiltCompilerOptions.getProcessorOptions()).addAll(this.additionalProcessingOptions()).build();
    }

    protected Set<String> additionalProcessingOptions() {
        return ImmutableSet.of();
    }

    protected void preRoundProcess(XRoundEnv roundEnv) {
    }

    protected void processEach(XTypeElement annotation, XElement element) throws Exception {
    }

    protected void postRoundProcess(XRoundEnv roundEnv) throws Exception {
    }

    protected boolean delayErrors() {
        return false;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.env = XProcessingEnv.create((ProcessingEnvironment)processingEnvironment, (XProcessingEnvConfig)PROCESSING_ENV_CONFIG);
        this.errorHandler = new ProcessorErrorHandler(this.env);
        HiltCompilerOptions.checkWrongAndDeprecatedOptions(this.env);
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.process((ImmutableList<XTypeElement>)((ImmutableList)annotations.stream().map(annotation -> XConverters.toXProcessing((TypeElement)annotation, (XProcessingEnv)this.env)).collect(DaggerStreams.toImmutableList())), XRoundEnv.create((XProcessingEnv)this.env, (RoundEnvironment)roundEnv, (boolean)roundEnv.processingOver()));
        return false;
    }

    private void process(ImmutableList<XTypeElement> annotations, XRoundEnv roundEnv) {
        this.preRoundProcess(roundEnv);
        boolean roundError = false;
        LinkedHashMultimap elementMultiMap = LinkedHashMultimap.create();
        for (ProcessingState processingState : this.stateToReprocess) {
            elementMultiMap.put((Object)processingState.annotation(this.env), (Object)processingState.element(this.env));
        }
        for (XTypeElement annotation : annotations) {
            elementMultiMap.putAll((Object)annotation, (Iterable)roundEnv.getElementsAnnotatedWith(annotation.getQualifiedName()));
        }
        this.stateToReprocess.clear();
        for (Map.Entry entry : elementMultiMap.asMap().entrySet()) {
            XTypeElement annotation = (XTypeElement)entry.getKey();
            for (XElement element : (Collection)entry.getValue()) {
                try {
                    this.processEach(annotation, element);
                }
                catch (Exception e) {
                    if (e instanceof ErrorTypeException && !roundEnv.isProcessingOver()) {
                        this.stateToReprocess.add(ProcessingState.of(annotation, element));
                        continue;
                    }
                    this.errorHandler.recordError(e);
                    roundError = true;
                }
            }
        }
        if (!roundError) {
            try {
                this.postRoundProcess(roundEnv);
            }
            catch (Exception e) {
                this.errorHandler.recordError(e);
            }
        }
        if (!this.delayErrors() || roundEnv.isProcessingOver()) {
            this.errorHandler.checkErrors();
        }
    }

    public final XProcessingEnv processingEnv() {
        return this.env;
    }

    public final ProcessingEnvironment getProcessingEnv() {
        return XConverters.toJavac((XProcessingEnv)this.env);
    }

    public final Elements getElementUtils() {
        return XConverters.toJavac((XProcessingEnv)this.env).getElementUtils();
    }

    @AutoValue
    static abstract class ProcessingState {
        ProcessingState() {
        }

        private static ProcessingState of(XTypeElement annotation, XElement element) {
            Preconditions.checkState((boolean)XElementKt.isTypeElement((XElement)element));
            Preconditions.checkState((boolean)element.hasAnnotation(annotation.getClassName()));
            return new AutoValue_BaseProcessor_ProcessingState(annotation.getClassName(), XElements.asTypeElement((XElement)element).getClassName());
        }

        abstract ClassName annotationClassName();

        abstract ClassName elementClassName();

        XTypeElement annotation(XProcessingEnv processingEnv) {
            return processingEnv.requireTypeElement((TypeName)this.annotationClassName());
        }

        XTypeElement element(XProcessingEnv processingEnv) {
            return processingEnv.requireTypeElement((TypeName)this.elementClassName());
        }
    }
}

