/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Components;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsGenerator;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateEntryPointGenerator;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateModuleGenerator;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XExecutableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XHasModifiers;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.Processor;

@AutoService(value={Processor.class})
public final class AggregatedDepsProcessor
extends BaseProcessor {
    private static final ImmutableSet<ClassName> ENTRY_POINT_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.ENTRY_POINT, (Object)ClassNames.EARLY_ENTRY_POINT, (Object)ClassNames.GENERATED_ENTRY_POINT, (Object)ClassNames.COMPONENT_ENTRY_POINT);
    private static final ImmutableSet<ClassName> MODULE_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.MODULE);
    private static final ImmutableSet<ClassName> INSTALL_IN_ANNOTATIONS = ImmutableSet.of((Object)ClassNames.INSTALL_IN, (Object)ClassNames.TEST_INSTALL_IN);
    private final Set<XElement> seen = new HashSet<XElement>();

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return (Set)ImmutableSet.builder().addAll(INSTALL_IN_ANNOTATIONS).addAll(MODULE_ANNOTATIONS).addAll(ENTRY_POINT_ANNOTATIONS).build().stream().map(Object::toString).collect(DaggerStreams.toImmutableSet());
    }

    @Override
    public void processEach(XTypeElement annotation, XElement element) throws Exception {
        if (!this.seen.add(element)) {
            return;
        }
        Optional<ClassName> installInAnnotation = AggregatedDepsProcessor.getAnnotation(element, INSTALL_IN_ANNOTATIONS);
        Optional<ClassName> entryPointAnnotation = AggregatedDepsProcessor.getAnnotation(element, ENTRY_POINT_ANNOTATIONS);
        Optional<ClassName> moduleAnnotation = AggregatedDepsProcessor.getAnnotation(element, MODULE_ANNOTATIONS);
        boolean hasInstallIn = installInAnnotation.isPresent();
        boolean isEntryPoint = entryPointAnnotation.isPresent();
        boolean isModule = moduleAnnotation.isPresent();
        ProcessorErrors.checkState(!hasInstallIn || isEntryPoint || isModule, element, "@%s-annotated classes must also be annotated with @Module or @EntryPoint: %s", installInAnnotation.map(ClassName::simpleName).orElse("@InstallIn"), XElements.toStableString((XElement)element));
        ProcessorErrors.checkState(!isEntryPoint || !isModule, element, "@%s and @%s cannot be used on the same interface: %s", moduleAnnotation.map(ClassName::simpleName).orElse("@Module"), entryPointAnnotation.map(ClassName::simpleName).orElse("@EntryPoint"), XElements.toStableString((XElement)element));
        if (isModule) {
            this.processModule(element, installInAnnotation, moduleAnnotation.get());
        } else if (isEntryPoint) {
            this.processEntryPoint(element, installInAnnotation, entryPointAnnotation.get());
        } else {
            throw new AssertionError();
        }
    }

    private void processModule(XElement element, Optional<ClassName> installInAnnotation, ClassName moduleAnnotation) throws Exception {
        ProcessorErrors.checkState(installInAnnotation.isPresent() || AggregatedDepsProcessor.isDaggerGeneratedModule(element) || this.installInCheckDisabled(element), element, "%s is missing an @InstallIn annotation. If this was intentional, see https://dagger.dev/hilt/flags#disable-install-in-check for how to disable this check.", XElements.toStableString((XElement)element));
        if (!installInAnnotation.isPresent()) {
            return;
        }
        ProcessorErrors.checkState(XElementKt.isTypeElement((XElement)element), element, "Only classes and interfaces can be annotated with @Module: %s", XElements.toStableString((XElement)element));
        XTypeElement module = XElements.asTypeElement((XElement)element);
        ProcessorErrors.checkState(module.isClass() || module.isInterface() || module.isKotlinObject(), (XElement)module, "Only classes and interfaces can be annotated with @Module: %s", XElements.toStableString((XElement)module));
        ProcessorErrors.checkState(Processors.isTopLevel((XElement)module) || module.isStatic() || module.isAbstract() || module.getEnclosingElement().hasAnnotation(ClassNames.HILT_ANDROID_TEST), (XElement)module, "Nested @%s modules must be static unless they are directly nested within a test. Found: %s", installInAnnotation.get().simpleName(), XElements.toStableString((XElement)module));
        ProcessorErrors.checkState(ClassNames.APPLICATION_CONTEXT_MODULE.equals((Object)module.getClassName()) || !Processors.requiresModuleInstance(module) || Processors.hasVisibleEmptyConstructor(module), (XElement)module, (Object)"Modules that need to be instantiated by Hilt must have a visible, empty constructor.");
        ImmutableList abstractMethodsWithMissingBinds = (ImmutableList)module.getDeclaredMethods().stream().filter(XHasModifiers::isAbstract).filter(method -> !Processors.hasDaggerAbstractMethodAnnotation((XExecutableElement)method)).collect(DaggerStreams.toImmutableList());
        ProcessorErrors.checkState(abstractMethodsWithMissingBinds.isEmpty(), (XElement)module, "Found unimplemented abstract methods, %s, in an abstract module, %s. Did you forget to add a Dagger binding annotation (e.g. @Binds)?", abstractMethodsWithMissingBinds.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()), XElements.toStableString((XElement)module));
        ImmutableList<XTypeElement> replacedModules = ImmutableList.of();
        if (module.hasAnnotation(ClassNames.TEST_INSTALL_IN)) {
            Optional<XTypeElement> originatingTestElement = Processors.getOriginatingTestElement((XElement)module);
            ProcessorErrors.checkState(!originatingTestElement.isPresent(), (XElement)module, "@TestInstallIn modules cannot be nested in (or originate from) a @HiltAndroidTest-annotated class:  %s", originatingTestElement.map(XTypeElement::getQualifiedName).orElse(""));
            XAnnotation testInstallIn = module.getAnnotation(ClassNames.TEST_INSTALL_IN);
            replacedModules = Processors.getAnnotationClassValues(testInstallIn, "replaces");
            ProcessorErrors.checkState(!replacedModules.isEmpty(), (XElement)module, (Object)"@TestInstallIn#replaces() cannot be empty. Use @InstallIn instead.");
            ImmutableList nonInstallInModules = (ImmutableList)replacedModules.stream().filter(replacedModule -> !replacedModule.hasAnnotation(ClassNames.INSTALL_IN)).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(nonInstallInModules.isEmpty(), (XElement)module, "@TestInstallIn#replaces() can only contain @InstallIn modules, but found: %s", nonInstallInModules.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
            ImmutableList hiltWrapperModules = (ImmutableList)replacedModules.stream().filter(replacedModule -> replacedModule.getClassName().simpleName().startsWith("HiltWrapper_")).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(hiltWrapperModules.isEmpty(), (XElement)module, "@TestInstallIn#replaces() cannot contain Hilt generated public wrapper modules, but found: %s. ", hiltWrapperModules.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
            if (!module.getPackageName().startsWith("dagger.hilt")) {
                ImmutableList hiltInternalModules = (ImmutableList)replacedModules.stream().filter(replacedModule -> replacedModule.getPackageName().startsWith("dagger.hilt")).collect(DaggerStreams.toImmutableList());
                ProcessorErrors.checkState(hiltInternalModules.isEmpty(), (XElement)module, "@TestInstallIn#replaces() cannot contain internal Hilt modules, but found: %s. ", hiltInternalModules.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
            }
            ImmutableList replacedTestSpecificInstallIn = (ImmutableList)replacedModules.stream().filter(replacedModule -> Processors.getOriginatingTestElement((XElement)replacedModule).isPresent()).collect(DaggerStreams.toImmutableList());
            ProcessorErrors.checkState(replacedTestSpecificInstallIn.isEmpty(), (XElement)module, "@TestInstallIn#replaces() cannot replace test specific @InstallIn modules, but found: %s. Please remove the @InstallIn module manually rather than replacing it.", replacedTestSpecificInstallIn.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
        }
        this.generateAggregatedDeps("modules", module, moduleAnnotation, (ImmutableSet<ClassName>)((ImmutableSet)replacedModules.stream().map(XTypeElement::getClassName).collect(DaggerStreams.toImmutableSet())));
    }

    private void processEntryPoint(XElement element, Optional<ClassName> installInAnnotation, ClassName entryPointAnnotation) throws Exception {
        ProcessorErrors.checkState(installInAnnotation.isPresent(), element, "@%s %s must also be annotated with @InstallIn", entryPointAnnotation.simpleName(), XElements.toStableString((XElement)element));
        ProcessorErrors.checkState(!element.hasAnnotation(ClassNames.TEST_INSTALL_IN), element, (Object)"@TestInstallIn can only be used with modules");
        ProcessorErrors.checkState(XElementKt.isTypeElement((XElement)element) && XElements.asTypeElement((XElement)element).isInterface(), element, "Only interfaces can be annotated with @%s: %s", entryPointAnnotation.simpleName(), XElements.toStableString((XElement)element));
        XTypeElement entryPoint = XElements.asTypeElement((XElement)element);
        if (entryPointAnnotation.equals((Object)ClassNames.EARLY_ENTRY_POINT)) {
            ImmutableSet<ClassName> components = Components.getComponents(element);
            ProcessorErrors.checkState(components.equals((Object)ImmutableSet.of((Object)ClassNames.SINGLETON_COMPONENT)), element, "@EarlyEntryPoint can only be installed into the SingletonComponent. Found: %s", components);
            Optional<XTypeElement> optionalTestElement = Processors.getOriginatingTestElement(element);
            ProcessorErrors.checkState(!optionalTestElement.isPresent(), element, "@EarlyEntryPoint-annotated entry point, %s, cannot be nested in (or originate from) a @HiltAndroidTest-annotated class, %s. This requirement is to avoid confusion with other, test-specific entry points.", entryPoint.getQualifiedName(), optionalTestElement.map(testElement -> testElement.getQualifiedName()).orElse(""));
        }
        this.generateAggregatedDeps(entryPointAnnotation.equals((Object)ClassNames.COMPONENT_ENTRY_POINT) ? "componentEntryPoints" : "entryPoints", entryPoint, entryPointAnnotation, (ImmutableSet<ClassName>)ImmutableSet.of());
    }

    private void generateAggregatedDeps(String key, XTypeElement element, ClassName annotation, ImmutableSet<ClassName> replacedModules) throws Exception {
        ImmutableSet<ClassName> components = Components.getComponents((XElement)element);
        if (AggregatedDepsProcessor.isValidKind((XElement)element)) {
            Optional<PkgPrivateMetadata> pkgPrivateMetadata = PkgPrivateMetadata.of(element, annotation);
            if (pkgPrivateMetadata.isPresent()) {
                if (key.contentEquals("modules")) {
                    new PkgPrivateModuleGenerator(this.processingEnv(), pkgPrivateMetadata.get()).generate();
                } else {
                    new PkgPrivateEntryPointGenerator(this.processingEnv(), pkgPrivateMetadata.get()).generate();
                }
            } else {
                Optional<ClassName> testName = Processors.getOriginatingTestElement((XElement)element).map(XTypeElement::getClassName);
                new AggregatedDepsGenerator(key, element, testName, components, replacedModules).generate();
            }
        }
    }

    private static Optional<ClassName> getAnnotation(XElement element, ImmutableSet<ClassName> annotations) {
        ImmutableSet usedAnnotations = (ImmutableSet)annotations.stream().filter(arg_0 -> ((XElement)element).hasAnnotation(arg_0)).collect(DaggerStreams.toImmutableSet());
        if (usedAnnotations.isEmpty()) {
            return Optional.empty();
        }
        ProcessorErrors.checkState(usedAnnotations.size() == 1, element, "Only one of the following annotations can be used on %s: %s", XElements.toStableString((XElement)element), usedAnnotations);
        return Optional.of((ClassName)Iterables.getOnlyElement((Iterable)usedAnnotations));
    }

    private static boolean isValidKind(XElement element) {
        return !XElements.asTypeElement((XElement)element).getType().isError();
    }

    private boolean installInCheckDisabled(XElement element) {
        return HiltCompilerOptions.isModuleInstallInCheckDisabled(this.processingEnv()) || element.hasAnnotation(ClassNames.DISABLE_INSTALL_IN_CHECK);
    }

    private static boolean isDaggerGeneratedModule(XElement element) {
        if (!element.hasAnnotation(ClassNames.MODULE)) {
            return false;
        }
        return element.getAllAnnotations().stream().filter(annotation -> AggregatedDepsProcessor.isGenerated(annotation)).map(annotation -> (String)Iterables.getOnlyElement((Iterable)annotation.getAsStringList("value"))).anyMatch(value -> value.startsWith("dagger"));
    }

    private static boolean isGenerated(XAnnotation annotation) {
        String name = annotation.getTypeElement().getQualifiedName();
        return name.equals("javax.annotation.Generated") || name.equals("javax.annotation.processing.Generated");
    }
}

