/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.definecomponent;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.definecomponent.DefineComponentBuilderMetadatas;
import dagger.hilt.processor.internal.definecomponent.DefineComponentMetadatas;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import javax.annotation.processing.Processor;

@AutoService(value={Processor.class})
public final class DefineComponentProcessor
extends BaseProcessor {
    private DefineComponentMetadatas componentMetadatas;
    private DefineComponentBuilderMetadatas componentBuilderMetadatas;

    @Override
    public void preRoundProcess(XRoundEnv roundEnv) {
        this.componentMetadatas = DefineComponentMetadatas.create();
        this.componentBuilderMetadatas = DefineComponentBuilderMetadatas.create(this.componentMetadatas);
    }

    @Override
    public void postRoundProcess(XRoundEnv roundEnv) {
        this.componentMetadatas = null;
        this.componentBuilderMetadatas = null;
    }

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.DEFINE_COMPONENT.toString(), (Object)ClassNames.DEFINE_COMPONENT_BUILDER.toString());
    }

    @Override
    public void processEach(XTypeElement annotation, XElement element) throws Exception {
        if (annotation.getClassName().equals((Object)ClassNames.DEFINE_COMPONENT)) {
            DefineComponentMetadatas.DefineComponentMetadata metadata = this.componentMetadatas.get(element);
            this.generateFile("component", metadata.component());
        } else if (annotation.getClassName().equals((Object)ClassNames.DEFINE_COMPONENT_BUILDER)) {
            DefineComponentBuilderMetadatas.DefineComponentBuilderMetadata metadata = this.componentBuilderMetadatas.get(element);
            this.generateFile("builder", metadata.builder());
        } else {
            throw new AssertionError((Object)("Unhandled annotation type: " + annotation.getQualifiedName()));
        }
    }

    private void generateFile(String member, XTypeElement typeElement) {
        Processors.generateAggregatingClass("dagger.hilt.processor.internal.definecomponent.codegen", AnnotationSpec.builder((ClassName)ClassNames.DEFINE_COMPONENT_CLASSES).addMember(member, "$S", new Object[]{typeElement.getQualifiedName()}).build(), typeElement, this.getClass());
    }
}

