/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.kotlin;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ElementDescriptors;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_ClassMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_FunctionMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_MethodForAnnotations;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_PropertyMetadata;
import dagger.hilt.processor.internal.kotlin.AutoValue_KotlinMetadata_ValueParameterMetadata;
import dagger.internal.codegen.extension.DaggerCollectors;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.AnnotationValues;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.kotlinx.metadata.Flag;
import dagger.spi.shaded.kotlinx.metadata.KmClass;
import dagger.spi.shaded.kotlinx.metadata.KmConstructor;
import dagger.spi.shaded.kotlinx.metadata.KmFunction;
import dagger.spi.shaded.kotlinx.metadata.KmProperty;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmExtensionsKt;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmFieldSignature;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmMetadataUtil;
import dagger.spi.shaded.kotlinx.metadata.jvm.JvmMethodSignature;
import dagger.spi.shaded.kotlinx.metadata.jvm.KotlinClassMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.ElementFilter;
import kotlin.Metadata;

@AutoValue
abstract class KotlinMetadata {
    private static final String DELEGATED_PROPERTY_NAME_SUFFIX = "$delegate";
    private final Map<VariableElement, Optional<MethodForAnnotations>> elementFieldAnnotationMethodMap = new HashMap<VariableElement, Optional<MethodForAnnotations>>();
    private final Map<VariableElement, Optional<ExecutableElement>> elementFieldGetterMethodMap = new HashMap<VariableElement, Optional<ExecutableElement>>();

    KotlinMetadata() {
    }

    abstract TypeElement typeElement();

    abstract ClassMetadata classMetadata();

    @Memoized
    ImmutableMap<String, ExecutableElement> methodDescriptors() {
        return (ImmutableMap)ElementFilter.methodsIn(this.typeElement().getEnclosedElements()).stream().collect(DaggerStreams.toImmutableMap(ElementDescriptors::getMethodDescriptor, Function.identity()));
    }

    @Memoized
    boolean containsConstructorWithDefaultParam() {
        return this.classMetadata().constructors().stream().flatMap(constructor -> constructor.parameters().stream()).anyMatch(parameter -> parameter.flags(Flag.ValueParameter.DECLARES_DEFAULT_VALUE));
    }

    Optional<ExecutableElement> getSyntheticAnnotationMethod(VariableElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> {
            if (methodForAnnotations == MethodForAnnotations.MISSING) {
                throw new IllegalStateException("Method for annotations is missing for " + fieldElement);
            }
            return methodForAnnotations.method();
        });
    }

    boolean isMissingSyntheticAnnotationMethod(VariableElement fieldElement) {
        return this.getAnnotationMethod(fieldElement).map(methodForAnnotations -> methodForAnnotations == MethodForAnnotations.MISSING).orElse(false);
    }

    boolean isMissingSyntheticAnnotationMethod(XFieldElement fieldElement) {
        return this.isMissingSyntheticAnnotationMethod(XConverters.toJavac((XVariableElement)fieldElement));
    }

    private Optional<MethodForAnnotations> getAnnotationMethod(VariableElement fieldElement) {
        return this.elementFieldAnnotationMethodMap.computeIfAbsent(fieldElement, this::getAnnotationMethodUncached);
    }

    private Optional<MethodForAnnotations> getAnnotationMethodUncached(VariableElement fieldElement) {
        return this.findProperty(fieldElement).methodForAnnotationsSignature().map(signature -> Optional.ofNullable((ExecutableElement)this.methodDescriptors().get(signature)).map(MethodForAnnotations::create).orElse(MethodForAnnotations.MISSING));
    }

    Optional<ExecutableElement> getPropertyGetter(VariableElement fieldElement) {
        return this.elementFieldGetterMethodMap.computeIfAbsent(fieldElement, this::getPropertyGetterUncached);
    }

    private Optional<ExecutableElement> getPropertyGetterUncached(VariableElement fieldElement) {
        return this.findProperty(fieldElement).getterSignature().flatMap(signature -> Optional.ofNullable((ExecutableElement)this.methodDescriptors().get(signature)));
    }

    private PropertyMetadata findProperty(VariableElement field) {
        String fieldDescriptor = ElementDescriptors.getFieldDescriptor(field);
        if (this.classMetadata().propertiesByFieldSignature().containsKey((Object)fieldDescriptor)) {
            return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().get((Object)fieldDescriptor);
        }
        String propertyName = KotlinMetadata.getPropertyNameFromField(field);
        return (PropertyMetadata)this.classMetadata().propertiesByFieldSignature().values().stream().filter(property -> propertyName.contentEquals(property.name())).collect(DaggerCollectors.onlyElement());
    }

    private static String getPropertyNameFromField(VariableElement field) {
        String name = field.getSimpleName().toString();
        if (name.endsWith(DELEGATED_PROPERTY_NAME_SUFFIX)) {
            return name.substring(0, name.length() - DELEGATED_PROPERTY_NAME_SUFFIX.length());
        }
        return name;
    }

    FunctionMetadata getFunctionMetadata(ExecutableElement method) {
        return (FunctionMetadata)this.classMetadata().functionsBySignature().get((Object)ElementDescriptors.getMethodDescriptor(method));
    }

    static KotlinMetadata from(TypeElement typeElement) {
        return new AutoValue_KotlinMetadata(typeElement, ClassMetadata.create(KotlinMetadata.metadataOf(typeElement)));
    }

    private static KotlinClassMetadata.Class metadataOf(TypeElement typeElement) {
        AnnotationMirror annotationMirror = (AnnotationMirror)MoreElements.getAnnotationMirror((Element)typeElement, (String)ClassNames.KOTLIN_METADATA.canonicalName()).get();
        Metadata metadataAnnotation = JvmMetadataUtil.Metadata((Integer)KotlinMetadata.getIntValue(annotationMirror, "k"), (int[])KotlinMetadata.getIntArrayValue(annotationMirror, "mv"), (String[])KotlinMetadata.getStringArrayValue(annotationMirror, "d1"), (String[])KotlinMetadata.getStringArrayValue(annotationMirror, "d2"), (String)KotlinMetadata.getStringValue(annotationMirror, "xs"), (String)KotlinMetadata.getOptionalStringValue(annotationMirror, "pn").orElse(null), (Integer)KotlinMetadata.getOptionalIntValue(annotationMirror, "xi").orElse(null));
        KotlinClassMetadata metadata = KotlinClassMetadata.read((Metadata)metadataAnnotation);
        if (metadata == null) {
            throw new IllegalStateException("Unable to read Kotlin metadata due to unsupported metadata version.");
        }
        if (metadata instanceof KotlinClassMetadata.Class) {
            return (KotlinClassMetadata.Class)metadata;
        }
        throw new IllegalStateException("Unsupported metadata type: " + metadata);
    }

    private static int getIntValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.getInt((AnnotationValue)AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)valueName));
    }

    private static Optional<Integer> getOptionalIntValue(AnnotationMirror annotation, String valueName) {
        return KotlinMetadata.isValuePresent(annotation, valueName) ? Optional.of(KotlinMetadata.getIntValue(annotation, valueName)) : Optional.empty();
    }

    private static int[] getIntArrayValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.getAnnotationValues((AnnotationValue)AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)valueName)).stream().mapToInt(AnnotationValues::getInt).toArray();
    }

    private static String getStringValue(AnnotationMirror annotation, String valueName) {
        return AnnotationValues.getString((AnnotationValue)AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)valueName));
    }

    private static Optional<String> getOptionalStringValue(AnnotationMirror annotation, String valueName) {
        return KotlinMetadata.isValuePresent(annotation, valueName) ? Optional.of(KotlinMetadata.getStringValue(annotation, valueName)) : Optional.empty();
    }

    private static String[] getStringArrayValue(AnnotationMirror annotation, String valueName) {
        return (String[])AnnotationValues.getAnnotationValues((AnnotationValue)AnnotationMirrors.getAnnotationValue((AnnotationMirror)annotation, (String)valueName)).stream().map(AnnotationValues::getString).toArray(String[]::new);
    }

    private static boolean isValuePresent(AnnotationMirror annotation, String valueName) {
        return AnnotationMirrors.getAnnotationValuesWithDefaults((AnnotationMirror)annotation).keySet().stream().anyMatch(member -> member.getSimpleName().contentEquals(valueName));
    }

    @AutoValue
    static abstract class MethodForAnnotations {
        static final MethodForAnnotations MISSING = MethodForAnnotations.create(null);

        MethodForAnnotations() {
        }

        static MethodForAnnotations create(ExecutableElement method) {
            return new AutoValue_KotlinMetadata_MethodForAnnotations(method);
        }

        @Nullable
        abstract ExecutableElement method();
    }

    static abstract class BaseMetadata {
        BaseMetadata() {
        }

        abstract int flags();

        boolean flags(Flag flag) {
            return flag.invoke(this.flags());
        }

        abstract String name();

        static interface Builder<BuilderT> {
            public BuilderT flags(int var1);

            public BuilderT name(String var1);
        }
    }

    @AutoValue
    static abstract class ValueParameterMetadata
    extends BaseMetadata {
        ValueParameterMetadata() {
        }

        private static ValueParameterMetadata create(int flags, String name) {
            return new AutoValue_KotlinMetadata_ValueParameterMetadata(flags, name);
        }
    }

    @AutoValue
    static abstract class PropertyMetadata
    extends BaseMetadata {
        PropertyMetadata() {
        }

        abstract Optional<String> fieldSignature();

        abstract Optional<String> getterSignature();

        abstract Optional<String> methodForAnnotationsSignature();

        static PropertyMetadata create(KmProperty metadata) {
            Builder builder = PropertyMetadata.builder(metadata.getFlags(), metadata.getName());
            builder.fieldSignature(Optional.ofNullable(JvmExtensionsKt.getFieldSignature((KmProperty)metadata)).map(JvmFieldSignature::asString));
            builder.getterSignature(Optional.ofNullable(JvmExtensionsKt.getGetterSignature((KmProperty)metadata)).map(JvmMethodSignature::asString));
            builder.methodForAnnotationsSignature(Optional.ofNullable(JvmExtensionsKt.getSyntheticMethodForAnnotations((KmProperty)metadata)).map(JvmMethodSignature::asString));
            return builder.build();
        }

        private static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_PropertyMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static interface Builder
        extends BaseMetadata.Builder<Builder> {
            public Builder fieldSignature(Optional<String> var1);

            public Builder getterSignature(Optional<String> var1);

            public Builder methodForAnnotationsSignature(Optional<String> var1);

            public PropertyMetadata build();
        }
    }

    @AutoValue
    static abstract class FunctionMetadata
    extends BaseMetadata {
        FunctionMetadata() {
        }

        abstract String signature();

        abstract ImmutableList<ValueParameterMetadata> parameters();

        static FunctionMetadata create(KmConstructor metadata) {
            Builder builder = FunctionMetadata.builder(metadata.getFlags(), "<init>");
            metadata.getValueParameters().forEach(it -> builder.addParameter(ValueParameterMetadata.create(it.getFlags(), it.getName())));
            builder.signature(Objects.requireNonNull(JvmExtensionsKt.getSignature((KmConstructor)metadata)).asString());
            return builder.build();
        }

        static FunctionMetadata create(KmFunction metadata) {
            Builder builder = FunctionMetadata.builder(metadata.getFlags(), metadata.getName());
            metadata.getValueParameters().forEach(it -> builder.addParameter(ValueParameterMetadata.create(it.getFlags(), it.getName())));
            builder.signature(Objects.requireNonNull(JvmExtensionsKt.getSignature((KmFunction)metadata)).asString());
            return builder.build();
        }

        private static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_FunctionMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder signature(String var1);

            abstract ImmutableList.Builder<ValueParameterMetadata> parametersBuilder();

            Builder addParameter(ValueParameterMetadata parameter) {
                this.parametersBuilder().add((Object)parameter);
                return this;
            }

            abstract FunctionMetadata build();
        }
    }

    @AutoValue
    static abstract class ClassMetadata
    extends BaseMetadata {
        ClassMetadata() {
        }

        abstract Optional<String> companionObjectName();

        abstract ImmutableSet<FunctionMetadata> constructors();

        abstract ImmutableMap<String, FunctionMetadata> functionsBySignature();

        abstract ImmutableMap<String, PropertyMetadata> propertiesByFieldSignature();

        static ClassMetadata create(KotlinClassMetadata.Class metadata) {
            KmClass kmClass = metadata.toKmClass();
            Builder builder = ClassMetadata.builder(kmClass.getFlags(), kmClass.getName());
            builder.companionObjectName(Optional.ofNullable(kmClass.getCompanionObject()));
            kmClass.getConstructors().forEach(it -> builder.addConstructor(FunctionMetadata.create(it)));
            kmClass.getFunctions().forEach(it -> builder.addFunction(FunctionMetadata.create(it)));
            kmClass.getProperties().forEach(it -> builder.addProperty(PropertyMetadata.create(it)));
            return builder.build();
        }

        private static Builder builder(int flags, String name) {
            return (Builder)new AutoValue_KotlinMetadata_ClassMetadata.Builder().flags(flags).name(name);
        }

        @AutoValue.Builder
        static abstract class Builder
        implements BaseMetadata.Builder<Builder> {
            Builder() {
            }

            abstract Builder companionObjectName(Optional<String> var1);

            abstract ImmutableSet.Builder<FunctionMetadata> constructorsBuilder();

            abstract ImmutableMap.Builder<String, FunctionMetadata> functionsBySignatureBuilder();

            abstract ImmutableMap.Builder<String, PropertyMetadata> propertiesByFieldSignatureBuilder();

            Builder addConstructor(FunctionMetadata constructor) {
                this.constructorsBuilder().add((Object)constructor);
                this.functionsBySignatureBuilder().put((Object)constructor.signature(), (Object)constructor);
                return this;
            }

            Builder addFunction(FunctionMetadata function) {
                this.functionsBySignatureBuilder().put((Object)function.signature(), (Object)function);
                return this;
            }

            Builder addProperty(PropertyMetadata property) {
                if (property.fieldSignature().isPresent()) {
                    this.propertiesByFieldSignatureBuilder().put((Object)property.fieldSignature().get(), (Object)property);
                }
                return this;
            }

            abstract ClassMetadata build();
        }
    }
}

