/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.kotlin;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableList;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.kotlin.KotlinMetadataFactory;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XFieldElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XMethodElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XVariableElement;
import dagger.spi.shaded.androidx.room.compiler.processing.compat.XConverters;
import dagger.spi.shaded.auto.common.AnnotationMirrors;
import dagger.spi.shaded.auto.common.MoreElements;
import dagger.spi.shaded.kotlinx.metadata.Flag;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import kotlin.Metadata;

public final class KotlinMetadataUtil {
    private final KotlinMetadataFactory metadataFactory;

    @Inject
    KotlinMetadataUtil(KotlinMetadataFactory metadataFactory) {
        this.metadataFactory = metadataFactory;
    }

    public boolean hasMetadata(Element element) {
        return MoreElements.isAnnotationPresent((Element)KotlinMetadataUtil.closestEnclosingTypeElement(element), Metadata.class);
    }

    public boolean hasMetadata(XElement element) {
        return this.hasMetadata(XConverters.toJavac((XElement)element));
    }

    public ImmutableList<AnnotationMirror> getAnnotationsAnnotatedWith(Element element, ClassName annotationName) {
        return (ImmutableList)this.getAnnotations(element).stream().filter(annotation -> this.hasAnnotation((AnnotationMirror)annotation, annotationName)).collect(DaggerStreams.toImmutableList());
    }

    public ImmutableList<XAnnotation> getAnnotationsAnnotatedWith(XElement element, ClassName annotationName) {
        return (ImmutableList)this.getAnnotationsAnnotatedWith(XConverters.toJavac((XElement)element), annotationName).stream().map(annotationMirror -> XConverters.toXProcessing((AnnotationMirror)annotationMirror, (XProcessingEnv)XConverters.getProcessingEnv((XElement)element))).collect(DaggerStreams.toImmutableList());
    }

    private ImmutableList<AnnotationMirror> getAnnotations(Element element) {
        if (element.getKind() != ElementKind.FIELD || element.getModifiers().contains((Object)Modifier.STATIC)) {
            return ImmutableList.copyOf(element.getAnnotationMirrors());
        }
        return (ImmutableList)Stream.concat(element.getAnnotationMirrors().stream(), this.getSyntheticPropertyAnnotations(MoreElements.asVariable((Element)element)).stream()).map(arg_0 -> ((Equivalence)AnnotationMirrors.equivalence()).wrap(arg_0)).distinct().map(Equivalence.Wrapper::get).collect(DaggerStreams.toImmutableList());
    }

    private boolean hasAnnotation(AnnotationMirror annotation, ClassName annotationName) {
        return MoreElements.isAnnotationPresent((Element)annotation.getAnnotationType().asElement(), (String)annotationName.canonicalName());
    }

    private ImmutableList<AnnotationMirror> getSyntheticPropertyAnnotations(VariableElement field) {
        return this.hasMetadata(field) ? this.metadataFactory.create(field).getSyntheticAnnotationMethod(field).map(Element::getAnnotationMirrors).map(annotations -> ImmutableList.copyOf((Collection)annotations)).orElse(ImmutableList.of()) : ImmutableList.of();
    }

    public boolean isMissingSyntheticPropertyForAnnotations(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).isMissingSyntheticAnnotationMethod(fieldElement);
    }

    public boolean isObjectClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_OBJECT);
    }

    public boolean isCompanionObjectClass(XTypeElement typeElement) {
        return this.isCompanionObjectClass(XConverters.toJavac((XTypeElement)typeElement));
    }

    public boolean isCompanionObjectClass(TypeElement typeElement) {
        return this.hasMetadata(typeElement) && this.metadataFactory.create(typeElement).classMetadata().flags(Flag.Class.IS_COMPANION_OBJECT);
    }

    public boolean isObjectOrCompanionObjectClass(TypeElement typeElement) {
        return this.isObjectClass(typeElement) || this.isCompanionObjectClass(typeElement);
    }

    public boolean isVisibilityInternal(TypeElement type) {
        return this.hasMetadata(type) && this.metadataFactory.create(type).classMetadata().flags(Flag.IS_INTERNAL);
    }

    public boolean isVisibilityInternal(ExecutableElement method) {
        return this.hasMetadata(method) && this.metadataFactory.create(method).getFunctionMetadata(method).flags(Flag.IS_INTERNAL);
    }

    public Optional<ExecutableElement> getPropertyGetter(VariableElement fieldElement) {
        return this.metadataFactory.create(fieldElement).getPropertyGetter(fieldElement);
    }

    public Optional<XMethodElement> getPropertyGetter(XFieldElement fieldElement) {
        return this.getPropertyGetter(XConverters.toJavac((XVariableElement)fieldElement)).map(element -> (XMethodElement)XConverters.toXProcessing((ExecutableElement)element, (XProcessingEnv)XConverters.getProcessingEnv((XElement)fieldElement)));
    }

    public boolean containsConstructorWithDefaultParam(XTypeElement typeElement) {
        return this.hasMetadata((XElement)typeElement) && this.metadataFactory.create((XElement)typeElement).containsConstructorWithDefaultParam();
    }

    static TypeElement closestEnclosingTypeElement(Element element) {
        for (Element current = element; current != null; current = current.getEnclosingElement()) {
            if (!MoreElements.isType((Element)current)) continue;
            return MoreElements.asType((Element)current);
        }
        throw new IllegalStateException("There is no enclosing TypeElement for: " + element);
    }
}

