/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.root;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import dagger.hilt.android.processor.internal.androidentrypoint.AndroidEntryPointMetadata;
import dagger.hilt.android.processor.internal.androidentrypoint.ApplicationGenerator;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ComponentDescriptor;
import dagger.hilt.processor.internal.ComponentNames;
import dagger.hilt.processor.internal.HiltCompilerOptions;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.aggregateddeps.AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aggregateddeps.ComponentDependencies;
import dagger.hilt.processor.internal.aliasof.AliasOfPropagatedDataMetadata;
import dagger.hilt.processor.internal.aliasof.AliasOfs;
import dagger.hilt.processor.internal.definecomponent.DefineComponentClassesMetadata;
import dagger.hilt.processor.internal.definecomponent.DefineComponents;
import dagger.hilt.processor.internal.earlyentrypoint.AggregatedEarlyEntryPointMetadata;
import dagger.hilt.processor.internal.root.AggregatedRootMetadata;
import dagger.hilt.processor.internal.root.ComponentTree;
import dagger.hilt.processor.internal.root.ComponentTreeDepsMetadata;
import dagger.hilt.processor.internal.root.EarlySingletonComponentCreatorGenerator;
import dagger.hilt.processor.internal.root.Root;
import dagger.hilt.processor.internal.root.RootGenerator;
import dagger.hilt.processor.internal.root.RootMetadata;
import dagger.hilt.processor.internal.root.TestComponentDataGenerator;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesMetadata;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XRoundEnv;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Processor;

@AutoService(value={Processor.class})
public final class ComponentTreeDepsProcessor
extends BaseProcessor {
    private final Set<ClassName> componentTreeDepNames = new HashSet<ClassName>();
    private final Set<ClassName> processed = new HashSet<ClassName>();

    public ImmutableSet<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.COMPONENT_TREE_DEPS.toString());
    }

    @Override
    public void processEach(XTypeElement annotation, XElement element) {
        this.componentTreeDepNames.add(XElements.asTypeElement((XElement)element).getClassName());
    }

    @Override
    public void postRoundProcess(XRoundEnv roundEnv) throws Exception {
        ImmutableSet componentTreeDepsToProcess = (ImmutableSet)this.componentTreeDepNames.stream().filter(className -> !this.processed.contains(className)).map(className -> this.processingEnv().requireTypeElement((TypeName)className)).map(element -> ComponentTreeDepsMetadata.from(element, this.processingEnv())).collect(DaggerStreams.toImmutableSet());
        DefineComponents defineComponents = DefineComponents.create();
        for (ComponentTreeDepsMetadata metadata : componentTreeDepsToProcess) {
            this.processComponentTreeDeps(metadata, defineComponents);
        }
    }

    private void processComponentTreeDeps(ComponentTreeDepsMetadata metadata, DefineComponents defineComponents) throws IOException {
        XTypeElement metadataElement = this.processingEnv().requireTypeElement((TypeName)metadata.name());
        try {
            ClassName renamedRoot = Processors.removeNameSuffix(metadataElement, "_ComponentTreeDeps");
            ComponentNames componentNames = ComponentNames.withRenaming(rootName -> renamedRoot);
            boolean isDefaultRoot = ClassNames.DEFAULT_ROOT.equals((Object)renamedRoot);
            ImmutableSet roots = (ImmutableSet)AggregatedRootMetadata.from(metadata.aggregatedRootDeps(), this.processingEnv()).stream().map(AggregatedRootMetadata::rootElement).map(rootElement -> Root.create((XElement)rootElement, this.processingEnv())).collect(DaggerStreams.toImmutableSet());
            Root root = isDefaultRoot ? Root.createDefaultRoot(this.processingEnv()) : (Root)Iterables.getOnlyElement((Iterable)roots);
            ImmutableSet<ComponentDescriptor> componentDescriptors = defineComponents.getComponentDescriptors(DefineComponentClassesMetadata.from(metadata.defineComponentDeps()));
            ComponentTree tree = ComponentTree.from(componentDescriptors);
            ComponentDependencies deps = ComponentDependencies.from(componentDescriptors, AggregatedDepsMetadata.from(metadata.aggregatedDeps()), AggregatedUninstallModulesMetadata.from(metadata.aggregatedUninstallModulesDeps()), AggregatedEarlyEntryPointMetadata.from(metadata.aggregatedEarlyEntryPointDeps()), this.processingEnv());
            AliasOfs aliasOfs = AliasOfs.create(AliasOfPropagatedDataMetadata.from(metadata.aliasOfDeps()), componentDescriptors);
            RootMetadata rootMetadata = RootMetadata.create(root, tree, deps, aliasOfs, this.processingEnv());
            this.generateComponents(metadata, rootMetadata, componentNames);
            if (isDefaultRoot && !metadata.aggregatedEarlyEntryPointDeps().isEmpty()) {
                EarlySingletonComponentCreatorGenerator.generate(this.processingEnv());
            }
            if (root.isTestRoot()) {
                ImmutableList rootMetadatas = (ImmutableList)roots.stream().map(test -> RootMetadata.create(test, tree, deps, aliasOfs, this.processingEnv())).collect(DaggerStreams.toImmutableList());
                this.generateTestComponentData(metadataElement, (ImmutableList<RootMetadata>)rootMetadatas, componentNames);
            } else {
                this.generateApplication(root.element());
            }
            this.setProcessingState(metadata, root);
        }
        catch (Exception e) {
            this.processed.add(metadata.name());
            throw e;
        }
    }

    private void setProcessingState(ComponentTreeDepsMetadata metadata, Root root) {
        this.processed.add(metadata.name());
    }

    private void generateComponents(ComponentTreeDepsMetadata metadata, RootMetadata rootMetadata, ComponentNames componentNames) throws IOException {
        RootGenerator.generate(metadata, rootMetadata, componentNames, this.processingEnv());
    }

    private void generateTestComponentData(XTypeElement metadataElement, ImmutableList<RootMetadata> rootMetadatas, ComponentNames componentNames) throws IOException {
        for (RootMetadata rootMetadata : rootMetadatas) {
            XTypeElement testElement = rootMetadata.testRootMetadata().testElement();
            ProcessorErrors.checkState(testElement.isPublic(), (XElement)testElement, "Hilt tests must be public, but found: %s", XElements.toStableString((XElement)testElement));
            new TestComponentDataGenerator(this.processingEnv(), metadataElement, rootMetadata, componentNames).generate();
        }
    }

    private void generateApplication(XTypeElement rootElement) throws IOException {
        if (!HiltCompilerOptions.useAggregatingRootProcessor(this.processingEnv())) {
            AndroidEntryPointMetadata metadata = AndroidEntryPointMetadata.of((XElement)rootElement);
            new ApplicationGenerator(this.processingEnv(), metadata).generate();
        }
    }
}

