/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.uninstallmodules;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import dagger.hilt.processor.internal.BaseProcessor;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.ProcessorErrors;
import dagger.hilt.processor.internal.Processors;
import dagger.hilt.processor.internal.uninstallmodules.AggregatedUninstallModulesGenerator;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.internal.codegen.xprocessing.XAnnotations;
import dagger.internal.codegen.xprocessing.XElements;
import dagger.spi.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.shaded.androidx.room.compiler.processing.XElementKt;
import dagger.spi.shaded.androidx.room.compiler.processing.XTypeElement;
import java.util.Set;
import javax.annotation.processing.Processor;

@AutoService(value={Processor.class})
public final class UninstallModulesProcessor
extends BaseProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return ImmutableSet.of((Object)ClassNames.UNINSTALL_MODULES.toString());
    }

    @Override
    public void processEach(XTypeElement annotation, XElement element) throws Exception {
        ProcessorErrors.checkState(XElementKt.isTypeElement((XElement)element) && element.hasAnnotation(ClassNames.HILT_ANDROID_TEST), element, "@%s should only be used on test classes annotated with @%s, but found: %s", annotation.getClassName().simpleName(), ClassNames.HILT_ANDROID_TEST.simpleName(), element);
        XTypeElement testElement = XElements.asTypeElement((XElement)element);
        ImmutableList uninstallModules = XAnnotations.getAsTypeElementList((XAnnotation)testElement.getAnnotation(ClassNames.UNINSTALL_MODULES), (String)"value");
        this.checkModulesHaveInstallIn(testElement, (ImmutableList<XTypeElement>)uninstallModules);
        this.checkModulesDontOriginateFromTest(testElement, (ImmutableList<XTypeElement>)uninstallModules);
        new AggregatedUninstallModulesGenerator(testElement, (ImmutableList<XTypeElement>)uninstallModules).generate();
    }

    private void checkModulesHaveInstallIn(XTypeElement testElement, ImmutableList<XTypeElement> uninstallModules) {
        ImmutableList invalidModules = (ImmutableList)uninstallModules.stream().filter(module -> !module.hasAnnotation(ClassNames.MODULE) || !module.hasAnnotation(ClassNames.INSTALL_IN)).collect(DaggerStreams.toImmutableList());
        ProcessorErrors.checkState(invalidModules.isEmpty(), (XElement)testElement, "@UninstallModules should only include modules annotated with both @Module and @InstallIn, but found: %s.", invalidModules.stream().map(XElements::toStableString).collect(DaggerStreams.toImmutableList()));
    }

    private void checkModulesDontOriginateFromTest(XTypeElement testElement, ImmutableList<XTypeElement> uninstallModules) {
        ImmutableList invalidModules = (ImmutableList)uninstallModules.stream().filter(module -> Processors.getOriginatingTestElement((XElement)module).isPresent()).map(XTypeElement::getClassName).collect(DaggerStreams.toImmutableList());
        ProcessorErrors.checkState(invalidModules.isEmpty(), (XElement)testElement, "@UninstallModules should not contain test modules, but found: %s", invalidModules);
    }
}

