/*
 * Decompiled with CFR 0.152.
 */
package dagger.hilt.processor.internal.aggregateddeps;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.squareup.javapoet.ClassName;
import dagger.hilt.processor.internal.AggregatedElements;
import dagger.hilt.processor.internal.ClassNames;
import dagger.hilt.processor.internal.aggregateddeps.AutoValue_AggregatedDepsMetadata;
import dagger.hilt.processor.internal.aggregateddeps.PkgPrivateMetadata;
import dagger.hilt.processor.internal.root.ir.AggregatedDepsIr;
import dagger.internal.codegen.extension.DaggerStreams;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotation;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XAnnotationValue;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XProcessingEnv;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.XTypeElement;
import dagger.spi.internal.shaded.androidx.room.compiler.processing.compat.XConverters;
import java.util.Optional;
import java.util.stream.Collectors;

@AutoValue
public abstract class AggregatedDepsMetadata {
    private static final String AGGREGATED_DEPS_PACKAGE = "hilt_aggregated_deps";

    public abstract XTypeElement aggregatingElement();

    public abstract Optional<XTypeElement> testElement();

    public abstract ImmutableSet<XTypeElement> componentElements();

    abstract DependencyType dependencyType();

    public abstract XTypeElement dependency();

    public abstract ImmutableSet<XTypeElement> replacedDependencies();

    public boolean isModule() {
        return this.dependencyType() == DependencyType.MODULE;
    }

    public static ImmutableSet<AggregatedDepsMetadata> from(XProcessingEnv env) {
        return AggregatedDepsMetadata.from(AggregatedElements.from(AGGREGATED_DEPS_PACKAGE, ClassNames.AGGREGATED_DEPS, env));
    }

    public static ImmutableSet<AggregatedDepsMetadata> from(ImmutableSet<XTypeElement> aggregatedElements) {
        return (ImmutableSet)aggregatedElements.stream().map(aggregatedElement -> AggregatedDepsMetadata.create(aggregatedElement, XConverters.getProcessingEnv((XElement)aggregatedElement))).collect(DaggerStreams.toImmutableSet());
    }

    public static AggregatedDepsIr toIr(AggregatedDepsMetadata metadata) {
        return new AggregatedDepsIr(metadata.aggregatingElement().getClassName(), metadata.componentElements().stream().map(XTypeElement::getClassName).map(ClassName::canonicalName).collect(Collectors.toList()), metadata.testElement().map(XTypeElement::getClassName).map(ClassName::canonicalName).orElse(null), metadata.replacedDependencies().stream().map(XTypeElement::getClassName).map(ClassName::canonicalName).collect(Collectors.toList()), metadata.dependencyType() == DependencyType.MODULE ? metadata.dependency().getClassName().canonicalName() : null, metadata.dependencyType() == DependencyType.ENTRY_POINT ? metadata.dependency().getClassName().canonicalName() : null, metadata.dependencyType() == DependencyType.COMPONENT_ENTRY_POINT ? metadata.dependency().getClassName().canonicalName() : null);
    }

    private static AggregatedDepsMetadata create(XTypeElement element, XProcessingEnv env) {
        Preconditions.checkState((boolean)element.hasAnnotation(ClassNames.AGGREGATED_DEPS), (String)"Missing @AggregatedDeps annotation on %s", (Object)element.getClassName().canonicalName());
        XAnnotation annotation = element.getAnnotation(ClassNames.AGGREGATED_DEPS);
        return new AutoValue_AggregatedDepsMetadata(element, AggregatedDepsMetadata.getTestElement(annotation.getAnnotationValue("test"), env), AggregatedDepsMetadata.getComponents(annotation.getAnnotationValue("components"), env), AggregatedDepsMetadata.getDependencyType(annotation.getAnnotationValue("modules"), annotation.getAnnotationValue("entryPoints"), annotation.getAnnotationValue("componentEntryPoints")), AggregatedDepsMetadata.getDependency(annotation.getAnnotationValue("modules"), annotation.getAnnotationValue("entryPoints"), annotation.getAnnotationValue("componentEntryPoints"), env), AggregatedDepsMetadata.getReplacedDependencies(annotation.getAnnotationValue("replaces"), env));
    }

    private static Optional<XTypeElement> getTestElement(XAnnotationValue testValue, XProcessingEnv env) {
        Preconditions.checkNotNull((Object)testValue);
        String test = testValue.asString();
        return test.isEmpty() ? Optional.empty() : Optional.of(env.findTypeElement(test));
    }

    private static ImmutableSet<XTypeElement> getComponents(XAnnotationValue componentsValue, XProcessingEnv env) {
        Preconditions.checkNotNull((Object)componentsValue);
        ImmutableSet componentNames = (ImmutableSet)componentsValue.asStringList().stream().map(componentName -> componentName.contentEquals("dagger.hilt.android.components.ApplicationComponent") ? ClassNames.SINGLETON_COMPONENT.canonicalName() : componentName).map(arg_0 -> ((XProcessingEnv)env).requireTypeElement(arg_0)).collect(DaggerStreams.toImmutableSet());
        Preconditions.checkState((!componentNames.isEmpty() ? 1 : 0) != 0);
        return componentNames;
    }

    private static DependencyType getDependencyType(XAnnotationValue modulesValue, XAnnotationValue entryPointsValue, XAnnotationValue componentEntryPointsValue) {
        Preconditions.checkNotNull((Object)modulesValue);
        Preconditions.checkNotNull((Object)entryPointsValue);
        Preconditions.checkNotNull((Object)componentEntryPointsValue);
        ImmutableSet.Builder dependencyTypes = ImmutableSet.builder();
        if (!modulesValue.asAnnotationValueList().isEmpty()) {
            dependencyTypes.add((Object)DependencyType.MODULE);
        }
        if (!entryPointsValue.asAnnotationValueList().isEmpty()) {
            dependencyTypes.add((Object)DependencyType.ENTRY_POINT);
        }
        if (!componentEntryPointsValue.asAnnotationValueList().isEmpty()) {
            dependencyTypes.add((Object)DependencyType.COMPONENT_ENTRY_POINT);
        }
        return (DependencyType)((Object)Iterables.getOnlyElement((Iterable)dependencyTypes.build()));
    }

    private static XTypeElement getDependency(XAnnotationValue modulesValue, XAnnotationValue entryPointsValue, XAnnotationValue componentEntryPointsValue, XProcessingEnv env) {
        Preconditions.checkNotNull((Object)modulesValue);
        Preconditions.checkNotNull((Object)entryPointsValue);
        Preconditions.checkNotNull((Object)componentEntryPointsValue);
        String dependencyName = ((XAnnotationValue)Iterables.getOnlyElement((Iterable)ImmutableSet.builder().addAll((Iterable)modulesValue.asAnnotationValueList()).addAll((Iterable)entryPointsValue.asAnnotationValueList()).addAll((Iterable)componentEntryPointsValue.asAnnotationValueList()).build())).asString();
        XTypeElement dependency = env.findTypeElement(dependencyName);
        Preconditions.checkNotNull((Object)dependency, (String)"Could not get element for %s", (Object)dependencyName);
        return dependency;
    }

    private static ImmutableSet<XTypeElement> getReplacedDependencies(XAnnotationValue replacedDependenciesValue, XProcessingEnv env) {
        return replacedDependenciesValue == null ? ImmutableSet.of() : (ImmutableSet)replacedDependenciesValue.asStringList().stream().map(arg_0 -> ((XProcessingEnv)env).requireTypeElement(arg_0)).map(replacedDep -> AggregatedDepsMetadata.getPublicDependency(replacedDep, env)).collect(DaggerStreams.toImmutableSet());
    }

    private static XTypeElement getPublicDependency(XTypeElement dependency, XProcessingEnv env) {
        return PkgPrivateMetadata.of(dependency, ClassNames.MODULE).map(metadata -> env.requireTypeElement(metadata.generatedClassName().toString())).orElse(dependency);
    }

    static enum DependencyType {
        MODULE,
        ENTRY_POINT,
        COMPONENT_ENTRY_POINT;

    }
}

