/*
 * Decompiled with CFR 0.152.
 */
package ksp.com.intellij.psi.impl.source.tree.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.openapi.util.text.StringUtil;
import ksp.com.intellij.psi.JavaElementVisitor;
import ksp.com.intellij.psi.JavaPsiFacade;
import ksp.com.intellij.psi.JavaTokenType;
import ksp.com.intellij.psi.PsiAnnotation;
import ksp.com.intellij.psi.PsiAnnotationMemberValue;
import ksp.com.intellij.psi.PsiAnnotationOwner;
import ksp.com.intellij.psi.PsiAnnotationParameterList;
import ksp.com.intellij.psi.PsiAnonymousClass;
import ksp.com.intellij.psi.PsiArrayType;
import ksp.com.intellij.psi.PsiClassType;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiElementVisitor;
import ksp.com.intellij.psi.PsiField;
import ksp.com.intellij.psi.PsiJavaCodeReferenceElement;
import ksp.com.intellij.psi.PsiLocalVariable;
import ksp.com.intellij.psi.PsiMethod;
import ksp.com.intellij.psi.PsiMethodReferenceExpression;
import ksp.com.intellij.psi.PsiNameHelper;
import ksp.com.intellij.psi.PsiNewExpression;
import ksp.com.intellij.psi.PsiParameter;
import ksp.com.intellij.psi.PsiReferenceExpression;
import ksp.com.intellij.psi.PsiReferenceList;
import ksp.com.intellij.psi.PsiType;
import ksp.com.intellij.psi.PsiTypeElement;
import ksp.com.intellij.psi.PsiVariable;
import ksp.com.intellij.psi.impl.PsiImplUtil;
import ksp.com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import ksp.com.intellij.psi.impl.java.stubs.PsiAnnotationStub;
import ksp.com.intellij.psi.impl.source.JavaStubPsiElement;
import ksp.com.intellij.psi.impl.source.PsiClassReferenceType;
import ksp.com.intellij.psi.impl.source.PsiTypeElementImpl;
import ksp.com.intellij.psi.impl.source.tree.JavaSharedImplUtil;
import ksp.com.intellij.psi.stubs.IStubElementType;
import ksp.com.intellij.psi.util.PsiTreeUtil;
import ksp.com.intellij.psi.util.PsiUtil;
import ksp.com.intellij.util.ObjectUtils;
import ksp.com.intellij.util.PairFunction;
import ksp.org.jetbrains.annotations.NonNls;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

public class PsiAnnotationImpl
extends JavaStubPsiElement<PsiAnnotationStub>
implements PsiAnnotation {
    private static final PairFunction<Project, String, PsiAnnotation> ANNOTATION_CREATOR = (project, text) -> JavaPsiFacade.getElementFactory(project).createAnnotationFromText((String)text, null);

    public PsiAnnotationImpl(PsiAnnotationStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANNOTATION);
    }

    public PsiAnnotationImpl(ASTNode node) {
        super(node);
    }

    @Override
    public PsiJavaCodeReferenceElement getNameReferenceElement() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        return PsiTreeUtil.getChildOfType(stub != null ? stub.getPsiElement() : this, PsiJavaCodeReferenceElement.class);
    }

    @Override
    public PsiAnnotationMemberValue findAttributeValue(String attributeName) {
        return PsiImplUtil.findAttributeValue(this, attributeName);
    }

    @Override
    @Nullable
    public PsiAnnotationMemberValue findDeclaredAttributeValue(@NonNls String attributeName) {
        return PsiImplUtil.findDeclaredAttributeValue(this, attributeName);
    }

    @Override
    public <T extends PsiAnnotationMemberValue> T setDeclaredAttributeValue(@NonNls String attributeName, @Nullable T value2) {
        PsiAnnotationMemberValue t2 = PsiImplUtil.setDeclaredAttributeValue(this, attributeName, value2, ANNOTATION_CREATOR);
        return (T)t2;
    }

    @Override
    public String toString() {
        return "PsiAnnotation";
    }

    @Override
    @NotNull
    public PsiAnnotationParameterList getParameterList() {
        PsiAnnotationParameterList psiAnnotationParameterList = this.getRequiredStubOrPsiChild(JavaStubElementTypes.ANNOTATION_PARAMETER_LIST);
        if (psiAnnotationParameterList == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(0);
        }
        return psiAnnotationParameterList;
    }

    @Override
    @Nullable
    public String getQualifiedName() {
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        if (nameRef == null) {
            return null;
        }
        return nameRef.getCanonicalText();
    }

    @Nullable
    private String getShortName() {
        PsiAnnotationStub stub = (PsiAnnotationStub)this.getStub();
        if (stub != null) {
            return PsiAnnotationImpl.getAnnotationShortName(stub.getText());
        }
        PsiJavaCodeReferenceElement nameRef = this.getNameReferenceElement();
        return nameRef == null ? null : nameRef.getReferenceName();
    }

    @Override
    public boolean hasQualifiedName(@NotNull String qualifiedName2) {
        if (qualifiedName2 == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(1);
        }
        return StringUtil.getShortName(qualifiedName2).equals(this.getShortName()) && PsiAnnotation.super.hasQualifiedName(qualifiedName2);
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(2);
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitAnnotation(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @Nullable
    public PsiAnnotationOwner getOwner() {
        PsiElement ctx;
        PsiElement parent2 = this.getParent();
        if (parent2 instanceof PsiTypeElementImpl) {
            PsiType type2 = ((PsiTypeElement)parent2).getType();
            if (type2 instanceof PsiClassType) {
                PsiJavaCodeReferenceElement origRef;
                PsiJavaCodeReferenceElement ref = origRef = ((PsiTypeElement)parent2).getInnermostComponentReferenceElement();
                while (ref != null && ref.isQualified()) {
                    ref = ObjectUtils.tryCast(ref.getQualifier(), PsiJavaCodeReferenceElement.class);
                }
                if (ref != null && ref != origRef) {
                    return new PsiClassReferenceType(ref, null).annotate(type2.getAnnotationProvider());
                }
            } else if (type2 instanceof PsiArrayType) {
                for (PsiElement sibling = this.getPrevSibling(); sibling != null; sibling = sibling.getPrevSibling()) {
                    if (!PsiUtil.isJavaToken(sibling, JavaTokenType.LBRACKET)) continue;
                    type2 = ((PsiArrayType)type2).getComponentType();
                }
            }
            return type2;
        }
        if (parent2 instanceof PsiAnnotationOwner) {
            return (PsiAnnotationOwner)((Object)parent2);
        }
        if (parent2 instanceof PsiNewExpression) {
            return ((PsiNewExpression)parent2).getOwner(this);
        }
        if (parent2 instanceof PsiReferenceExpression ? (ctx = parent2.getParent()) instanceof PsiMethodReferenceExpression : parent2 instanceof PsiJavaCodeReferenceElement && ((ctx = PsiTreeUtil.skipParentsOfType(parent2, PsiJavaCodeReferenceElement.class)) instanceof PsiReferenceList || ctx instanceof PsiNewExpression || ctx instanceof PsiTypeElement || ctx instanceof PsiAnonymousClass)) {
            return new PsiClassReferenceType((PsiJavaCodeReferenceElement)parent2, null);
        }
        PsiTypeElement typeElement = null;
        PsiElement anchor = null;
        if (parent2 instanceof PsiMethod) {
            typeElement = ((PsiMethod)parent2).getReturnTypeElement();
            anchor = ((PsiMethod)parent2).getParameterList();
        } else if (parent2 instanceof PsiField || parent2 instanceof PsiParameter || parent2 instanceof PsiLocalVariable) {
            typeElement = ((PsiVariable)parent2).getTypeElement();
            anchor = ((PsiVariable)parent2).getNameIdentifier();
        }
        if (typeElement != null && anchor != null) {
            return JavaSharedImplUtil.getType(typeElement, anchor, this);
        }
        return null;
    }

    @NotNull
    public static String getAnnotationShortName(@NotNull String annoText) {
        if (annoText == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(3);
        }
        int at = annoText.indexOf(64);
        int paren = annoText.indexOf(40);
        String qualified = PsiNameHelper.getQualifiedClassName(annoText.substring(at + 1, paren > 0 ? paren : annoText.length()), true);
        String string2 = StringUtil.getShortName(qualified);
        if (string2 == null) {
            PsiAnnotationImpl.$$$reportNull$$$0(4);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ksp/com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifiedName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annoText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterList";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "ksp/com/intellij/psi/impl/source/tree/java/PsiAnnotationImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationShortName";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasQualifiedName";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getAnnotationShortName";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

