package com.google.devtools.ksp.standalone

import ksp.com.intellij.openapi.project.Project
import ksp.com.intellij.psi.search.GlobalSearchScope
import ksp.org.jetbrains.kotlin.analysis.api.platform.packages.KotlinCompositePackageProvider
import ksp.org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProvider
import ksp.org.jetbrains.kotlin.analysis.api.platform.packages.KotlinPackageProviderFactory
import ksp.org.jetbrains.kotlin.analysis.api.standalone.base.packages.KotlinStandalonePackageProviderFactory
import ksp.org.jetbrains.kotlin.psi.KtFile

class IncrementalKotlinPackageProviderFactory(
    private val project: Project,
) : KotlinPackageProviderFactory {
    private val staticFactories: MutableList<KotlinStandalonePackageProviderFactory> = mutableListOf()

    override fun createPackageProvider(searchScope: GlobalSearchScope): KotlinPackageProvider {
        val providers = staticFactories.map { it.createPackageProvider(searchScope) }
        return KotlinCompositePackageProvider.create(providers)
    }

    fun update(files: Collection<KtFile>) {
        val staticFactory = KotlinStandalonePackageProviderFactory(project, files)
        staticFactories.add(staticFactory)
    }
}
