// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.core;

import ksp.com.intellij.codeInsight.ContainerProvider;
import ksp.com.intellij.codeInsight.JavaContainerProvider;
import ksp.com.intellij.codeInsight.folding.JavaCodeFoldingSettings;
import ksp.com.intellij.codeInsight.folding.impl.JavaCodeFoldingSettingsBase;
import ksp.com.intellij.codeInsight.folding.impl.JavaFoldingBuilderBase;
import ksp.com.intellij.ide.highlighter.ArchiveFileType;
import ksp.com.intellij.ide.highlighter.JavaClassFileType;
import ksp.com.intellij.ide.highlighter.JavaFileType;
import ksp.com.intellij.lang.LanguageASTFactory;
import ksp.com.intellij.lang.folding.LanguageFolding;
import ksp.com.intellij.lang.java.JavaLanguage;
import ksp.com.intellij.lang.java.JavaParserDefinition;
import ksp.com.intellij.navigation.ItemPresentationProviders;
import ksp.com.intellij.openapi.Disposable;
import ksp.com.intellij.openapi.fileTypes.BinaryFileTypeDecompilers;
import ksp.com.intellij.openapi.fileTypes.PlainTextFileType;
import ksp.com.intellij.openapi.fileTypes.PlainTextLanguage;
import ksp.com.intellij.openapi.fileTypes.PlainTextParserDefinition;
import ksp.com.intellij.openapi.projectRoots.JavaVersionService;
import ksp.com.intellij.psi.*;
import ksp.com.intellij.psi.compiled.ClassFileDecompilers;
import ksp.com.intellij.psi.impl.LanguageConstantExpressionEvaluator;
import ksp.com.intellij.psi.impl.PsiExpressionEvaluator;
import ksp.com.intellij.psi.impl.PsiSubstitutorFactoryImpl;
import ksp.com.intellij.psi.impl.compiled.ClassFileStubBuilder;
import ksp.com.intellij.psi.impl.compiled.ClsDecompilerImpl;
import ksp.com.intellij.psi.impl.file.PsiPackageImplementationHelper;
import ksp.com.intellij.psi.impl.search.MethodSuperSearcher;
import ksp.com.intellij.psi.impl.source.tree.JavaASTFactory;
import ksp.com.intellij.psi.impl.source.tree.PlainTextASTFactory;
import ksp.com.intellij.psi.presentation.java.*;
import ksp.com.intellij.psi.search.searches.SuperMethodsSearch;
import ksp.com.intellij.psi.stubs.BinaryFileStubBuilders;
import ksp.com.intellij.util.QueryExecutor;
import ksp.org.jetbrains.annotations.NotNull;


@SuppressWarnings("UnusedDeclaration") // Used in Kotlin Compiler
public class JavaCoreApplicationEnvironment extends CoreApplicationEnvironment {
  public JavaCoreApplicationEnvironment(@NotNull Disposable parentDisposable) {
    this(parentDisposable, true);
  }

  public JavaCoreApplicationEnvironment(@NotNull Disposable parentDisposable, boolean unitTestMode) {
    super(parentDisposable, unitTestMode);

    registerFileType(JavaClassFileType.INSTANCE, "class");
    registerFileType(JavaFileType.INSTANCE, "java");
    registerFileType(ArchiveFileType.INSTANCE, "jar;zip");
    registerFileType(PlainTextFileType.INSTANCE, "txt;sh;bat;cmd;policy;log;cgi;MF;jad;jam;htaccess");

    addExplicitExtension(LanguageASTFactory.INSTANCE, PlainTextLanguage.INSTANCE, new PlainTextASTFactory());
    registerParserDefinition(new PlainTextParserDefinition());

    addExplicitExtension(FileTypeFileViewProviders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileViewProviderFactory());
    addExplicitExtension(BinaryFileStubBuilders.INSTANCE, JavaClassFileType.INSTANCE, new ClassFileStubBuilder());

    addExplicitExtension(LanguageASTFactory.INSTANCE, JavaLanguage.INSTANCE, new JavaASTFactory());
    registerParserDefinition(new JavaParserDefinition());
    addExplicitExtension(LanguageConstantExpressionEvaluator.INSTANCE, JavaLanguage.INSTANCE, new PsiExpressionEvaluator());

    registerApplicationExtensionPoint(ContainerProvider.EP_NAME, ContainerProvider.class);
    addExtension(ContainerProvider.EP_NAME, new JavaContainerProvider());

    application.registerService(PsiPackageImplementationHelper.class, new CorePsiPackageImplementationHelper());

    application.registerService(PsiSubstitutorFactory.class, new PsiSubstitutorFactoryImpl());
    application.registerService(JavaDirectoryService.class, createJavaDirectoryService());
    application.registerService(JavaVersionService.class, new JavaVersionService());

    addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiPackage.class, new PackagePresentationProvider());
    addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiClass.class, new ClassPresentationProvider());
    addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiMethod.class, new MethodPresentationProvider());
    addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiField.class, new FieldPresentationProvider());
    addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiLocalVariable.class, new VariablePresentationProvider());
    addExplicitExtension(ItemPresentationProviders.INSTANCE, PsiParameter.class, new VariablePresentationProvider());

    registerApplicationService(JavaCodeFoldingSettings.class, new JavaCodeFoldingSettingsBase());
    addExplicitExtension(LanguageFolding.INSTANCE, JavaLanguage.INSTANCE, new JavaFoldingBuilderBase() {
      @Override
      protected boolean shouldShowExplicitLambdaType(@NotNull PsiAnonymousClass anonymousClass, @NotNull PsiNewExpression expression) {
        return false;
      }

      @Override
      protected boolean isBelowRightMargin(@NotNull PsiFile file, int lineLength) {
        return false;
      }
    });

    registerApplicationExtensionPoint(SuperMethodsSearch.EP_NAME, QueryExecutor.class);
    addExtension(SuperMethodsSearch.EP_NAME, new MethodSuperSearcher());

    registerApplicationDynamicExtensionPoint("com.intellij.filetype.decompiler", BinaryFileTypeDecompilers.class);
    registerApplicationDynamicExtensionPoint("com.intellij.psi.classFileDecompiler", ClassFileDecompilers.Decompiler.class);
    addExtension(ClassFileDecompilers.getInstance().EP_NAME, new ClsDecompilerImpl());
  }

  // overridden in upsource
  protected CoreJavaDirectoryService createJavaDirectoryService() {
    return new CoreJavaDirectoryService();
  }
}