// Copyright 2000-2023 JetBrains s.r.o. and contributors. Use of this source code is governed by the Apache 2.0 license.
package ksp.com.intellij.ide;

import ksp.com.intellij.openapi.extensions.ExtensionPointName;
import ksp.com.intellij.openapi.util.Iconable;
import ksp.com.intellij.psi.PsiElement;
import ksp.org.jetbrains.annotations.NotNull;
import ksp.org.jetbrains.annotations.Nullable;

import javax.swing.*;

/**
 * Customize icons for {@link PsiElement}s.
 *
 * @see FileIconProvider
 */
public abstract class IconProvider {
  public static final ExtensionPointName<IconProvider> EXTENSION_POINT_NAME = new ExtensionPointName<>("com.intellij.iconProvider");

  /**
   * @param element for which icon is shown
   * @param flags   used for customizing the icon appearance. Flags are listed in {@link Iconable}
   * @return {@code null} if this provider cannot provide icon for given element.
   * @see Iconable
   */
  public abstract @Nullable Icon getIcon(@NotNull PsiElement element, @Iconable.IconFlags int flags);
}
