// Copyright 2000-2021 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.ide.plugins

import ksp.com.intellij.openapi.components.ComponentConfig
import ksp.com.intellij.openapi.components.ServiceDescriptor
import ksp.com.intellij.openapi.extensions.ExtensionDescriptor
import ksp.com.intellij.openapi.extensions.ExtensionPointDescriptor
import ksp.com.intellij.util.messages.ListenerDescriptor
import ksp.org.jetbrains.annotations.ApiStatus
import java.util.*

@ApiStatus.Internal
class ContainerDescriptor {
  private var _services: MutableList<ServiceDescriptor>? = null
  val services: List<ServiceDescriptor>
    get() = _services ?: Collections.emptyList()

  @JvmField var components: MutableList<ComponentConfig>? = null
  @JvmField var listeners: MutableList<ListenerDescriptor>? = null

  @JvmField var extensionPoints: MutableList<ExtensionPointDescriptor>? = null

  @Transient var distinctExtensionPointCount: Int = -1
  @Transient @JvmField var extensions: Map<String, MutableList<ExtensionDescriptor>>? = null

  fun addService(serviceDescriptor: ServiceDescriptor) {
    if (_services == null) {
      _services = ArrayList()
    }
    _services!!.add(serviceDescriptor)
  }

  internal fun getComponentListToAdd(): MutableList<ComponentConfig> {
    var result = components
    if (result == null) {
      result = ArrayList()
      components = result
    }
    return result
  }

  override fun toString(): String {
    if (_services == null && components == null && extensionPoints == null && extensions == null && listeners == null) {
      return "ContainerDescriptor(empty)"
    }
    else {
      return "ContainerDescriptor(" +
             "services=$_services, components=$components, " +
             "extensionPoints=$extensionPoints, extensions=$extensions, listeners=$listeners" +
             ")"
    }
  }
}