// Copyright 2000-2020 JetBrains s.r.o. Use of this source code is governed by the Apache 2.0 license that can be found in the LICENSE file.
package ksp.com.intellij.lang.java;

import ksp.com.intellij.lang.ASTNode;
import ksp.com.intellij.lang.PsiBuilder;
import ksp.com.intellij.lang.PsiParser;
import ksp.com.intellij.lang.java.parser.JShellParser;
import ksp.com.intellij.lang.java.parser.JavaParserUtil;
import ksp.com.intellij.openapi.project.Project;
import ksp.com.intellij.pom.java.LanguageLevel;
import ksp.com.intellij.psi.FileViewProvider;
import ksp.com.intellij.psi.PsiElement;
import ksp.com.intellij.psi.PsiFile;
import ksp.com.intellij.psi.impl.source.JShellFileImpl;
import ksp.com.intellij.psi.impl.source.tree.IJShellElementType;
import ksp.com.intellij.psi.tree.IElementType;
import ksp.com.intellij.psi.tree.IFileElementType;
import ksp.org.jetbrains.annotations.NotNull;

/**
 * @author Eugene Zhuravlev
 */
public class JShellParserDefinition extends JavaParserDefinition {
  public static final IFileElementType FILE_ELEMENT_TYPE = new IFileElementType("JSHELL_FILE", JShellLanguage.INSTANCE);

  private static final PsiParser PARSER = new PsiParser() {
    @NotNull
    @Override
    public ASTNode parse(@NotNull IElementType rootElement, @NotNull PsiBuilder builder) {
      JavaParserUtil.setLanguageLevel(builder, LanguageLevel.HIGHEST);
      final PsiBuilder.Marker r = builder.mark();
      JShellParser.INSTANCE.getFileParser().parse(builder);
      r.done(rootElement);
      return builder.getTreeBuilt();
    }
  };

  @Override
  public @NotNull PsiFile createFile(@NotNull FileViewProvider viewProvider) {
    return new JShellFileImpl(viewProvider);
  }

  @Override
  public @NotNull IFileElementType getFileNodeType() {
    return FILE_ELEMENT_TYPE;
  }

  @NotNull
  @Override
  public PsiElement createElement(ASTNode node) {
    final IElementType type = node.getElementType();
    if (type instanceof IJShellElementType) {
      return ((IJShellElementType)type).createPsi(node);
    }
    return super.createElement(node);
  }

  @NotNull
  @Override
  public PsiParser createParser(Project project) {
    return PARSER;
  }
}
